/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u00193\u0001uBQa\u0013\u0001\u0005\u00021CqA\u0014\u0001A\u0002\u0013%q\nC\u0004T\u0001\u0001\u0007I\u0011\u0002+\t\ri\u0003\u0001\u0015)\u0003Q\u0011%Y\u0006\u00011AA\u0002\u0013%A\fC\u0005d\u0001\u0001\u0007\t\u0019!C\u0005I\"Ia\r\u0001a\u0001\u0002\u0003\u0006K!\u0018\u0005\nO\u0002\u0001\r\u00111A\u0005\nqC\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011B5\t\u0013-\u0004\u0001\u0019!A!B\u0013i\u0006\"\u00037\u0001\u0001\u0004\u0005\r\u0011\"\u0003]\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005q\u0001\u0001\u0007\t\u0011)Q\u0005;\"I\u0011\u000f\u0001a\u0001\u0002\u0004%I\u0001\u0018\u0005\ne\u0002\u0001\r\u00111A\u0005\nMD\u0011\"\u001e\u0001A\u0002\u0003\u0005\u000b\u0015B/\t\u000fY\u0004\u0001\u0019!C\u0005o\"91\u0010\u0001a\u0001\n\u0013a\bB\u0002@\u0001A\u0003&\u0001\u0010\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\n\u0001\u0001\u000b\u0015\u00021\t\u0013\u0005-\u0001\u00011A\u0005\n\u0005\u0005\u0001\"CA\u0007\u0001\u0001\u0007I\u0011BA\b\u0011\u001d\t\u0019\u0002\u0001Q!\n\u0001D!\"!\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003]\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%I!!\u0007\t\u0015\u0005u\u0001\u00011A\u0001B\u0003&Q\fC\u0006\u0002 \u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0002bCA\u0013\u0001\u0001\u0007\t\u0019!C\u0005\u0003OA1\"a\u000b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002$!Q\u0011Q\u0006\u0001A\u0002\u0003\u0007I\u0011\u0002/\t\u0017\u0005=\u0002\u00011AA\u0002\u0013%\u0011\u0011\u0007\u0005\u000b\u0003k\u0001\u0001\u0019!A!B\u0013i\u0006BCA\u001c\u0001\u0001\u0007\t\u0019!C\u00059\"Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u0011)\ty\u0004\u0001a\u0001\u0002\u0003\u0006K!\u0018\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011!\t\t\u0005\u0001C\u0001m\u0005%\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011IA@\u0011\u001d\t\u0019\t\u0001C!\u0003\u007fBa!a\"\u0001\t\u0003:\bbBAF\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u001f\u0003A\u0011IA@\u0011\u001d\t\u0019\n\u0001C!\u0003\u007fBq!a&\u0001\t\u0003\ny\bC\u0004\u0002 \u0002!\t%a \u000395+H\u000e^5wCJL\u0017\r^3P]2Lg.Z*v[6\f'/\u001b>fe*\u00111\u0007N\u0001\u0005gR\fGO\u0003\u00026m\u0005)Q\u000e\u001c7jE*\u0011q\u0007O\u0001\u0006gB\f'o\u001b\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qD\t\u0013\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00153U\"\u0001\u001a\n\u0005\u001d\u0013$AH'vYRLg/\u0019:jCR,7\u000b^1uSN$\u0018nY1m'VlW.\u0019:z!\ty\u0014*\u0003\u0002K\u0001\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012!\u0014\t\u0003\u000b\u0002\t\u0011A\\\u000b\u0002!B\u0011q(U\u0005\u0003%\u0002\u00131!\u00138u\u0003\u0015qw\fJ3r)\t)\u0006\f\u0005\u0002@-&\u0011q\u000b\u0011\u0002\u0005+:LG\u000fC\u0004Z\u0007\u0005\u0005\t\u0019\u0001)\u0002\u0007a$\u0013'\u0001\u0002oA\u0005A1-\u001e:s\u001b\u0016\fg.F\u0001^!\ryd\fY\u0005\u0003?\u0002\u0013Q!\u0011:sCf\u0004\"aP1\n\u0005\t\u0004%A\u0002#pk\ndW-\u0001\u0007dkJ\u0014X*Z1o?\u0012*\u0017\u000f\u0006\u0002VK\"9\u0011LBA\u0001\u0002\u0004i\u0016!C2veJlU-\u00198!\u0003\u001d\u0019WO\u001d:Ne9\f1bY;se6\u0013dn\u0018\u0013fcR\u0011QK\u001b\u0005\b3&\t\t\u00111\u0001^\u0003!\u0019WO\u001d:Ne9\u0004\u0013AB2veJl%'\u0001\u0006dkJ\u0014XJM0%KF$\"!V8\t\u000fec\u0011\u0011!a\u0001;\u000691-\u001e:s\u001bJ\u0002\u0013AB2veJd\u0015'\u0001\u0006dkJ\u0014H*M0%KF$\"!\u0016;\t\u000fe{\u0011\u0011!a\u0001;\u000691-\u001e:s\u0019F\u0002\u0013\u0001\u0003;pi\u0006d7I\u001c;\u0016\u0003a\u0004\"aP=\n\u0005i\u0004%\u0001\u0002'p]\u001e\fA\u0002^8uC2\u001ce\u000e^0%KF$\"!V?\t\u000fe\u0013\u0012\u0011!a\u0001q\u0006IAo\u001c;bY\u000esG\u000fI\u0001\u000fi>$\u0018\r\\,fS\u001eDGoU;n+\u0005\u0001\u0017A\u0005;pi\u0006dw+Z5hQR\u001cV/\\0%KF$2!VA\u0004\u0011\u001dIV#!AA\u0002\u0001\fq\u0002^8uC2<V-[4iiN+X\u000eI\u0001\u0010o\u0016Lw\r\u001b;TcV\f'/Z*v[\u0006\u0019r/Z5hQR\u001c\u0016/^1sKN+Xn\u0018\u0013fcR\u0019Q+!\u0005\t\u000feC\u0012\u0011!a\u0001A\u0006\u0001r/Z5hQR\u001c\u0016/^1sKN+X\u000eI\u0001\no\u0016Lw\r\u001b;Tk6\fQb^3jO\"$8+^7`I\u0015\fHcA+\u0002\u001c!9\u0011lGA\u0001\u0002\u0004i\u0016AC<fS\u001eDGoU;nA\u0005\u0019aN\u001c>\u0016\u0005\u0005\r\u0002cA _q\u00069aN\u001c>`I\u0015\fHcA+\u0002*!A\u0011LHA\u0001\u0002\u0004\t\u0019#\u0001\u0003o]j\u0004\u0013aB2veJl\u0015\r_\u0001\fGV\u0014(/T1y?\u0012*\u0017\u000fF\u0002V\u0003gAq!W\u0011\u0002\u0002\u0003\u0007Q,\u0001\u0005dkJ\u0014X*\u0019=!\u0003\u001d\u0019WO\u001d:NS:\f1bY;se6Kgn\u0018\u0013fcR\u0019Q+!\u0010\t\u000fe#\u0013\u0011!a\u0001;\u0006A1-\u001e:s\u001b&t\u0007%A\u0002bI\u0012$B!!\u0012\u0002H5\t\u0001\u0001C\u0004\u0002J\u0019\u0002\r!a\u0013\u0002\rM\fW\u000e\u001d7f!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)i\u00051A.\u001b8bY\u001eLA!!\u0016\u0002P\t1a+Z2u_JDSAJA-\u0003K\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?2\u0014AC1o]>$\u0018\r^5p]&!\u00111MA/\u0005\u0015\u0019\u0016N\\2fC\t\t9'A\u00032]Er\u0003\u0007\u0006\u0004\u0002F\u0005-\u0014q\u000e\u0005\b\u0003[:\u0003\u0019AA&\u0003!Ign\u001d;b]\u000e,\u0007BBA9O\u0001\u0007\u0001-\u0001\u0004xK&<\u0007\u000e^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005\u0003\u000b\n9\b\u0003\u0004\u0002z!\u0002\r!T\u0001\u0006_RDWM\u001d\u0015\u0006Q\u0005e\u0013QM\u0001\u0005[\u0016\fg.\u0006\u0002\u0002L!*\u0011&!\u0017\u0002f\u0005Aa/\u0019:jC:\u001cW\rK\u0003+\u00033\n)'A\u0003d_VtG\u000fK\u0003,\u00033\n)'A\u0006ok6tuN\u001c>fe>\u001c\b&\u0002\u0017\u0002Z\u0005\u0015\u0014aA7bq\"*Q&!\u0017\u0002f\u0005\u0019Q.\u001b8)\u000b9\nI&!\u001a\u0002\r9|'/\u001c'3Q\u0015y\u0013\u0011LANC\t\ti*A\u00032]Ir\u0003'\u0001\u0004o_JlG*\r\u0015\u0006a\u0005e\u00131\u0014\u0015\u0004\u0001\u0005\u0015\u0006\u0003BA.\u0003OKA!!+\u0002^\taA)\u001a<fY>\u0004XM]!qS\"*\u0001!!\u0017\u0002f\u0001")
public class MultivariateOnlineSummarizer
implements MultivariateStatisticalSummary,
scala.Serializable {
    private int n = 0;
    private double[] currMean;
    private double[] currM2n;
    private double[] currM2;
    private double[] currL1;
    private long totalCnt = 0L;
    private double totalWeightSum = 0.0;
    private double weightSquareSum = 0.0;
    private double[] weightSum;
    private long[] nnz;
    private double[] currMax;
    private double[] currMin;

    private int n() {
        return this.n;
    }

    private void n_$eq(int x$1) {
        this.n = x$1;
    }

    private double[] currMean() {
        return this.currMean;
    }

    private void currMean_$eq(double[] x$1) {
        this.currMean = x$1;
    }

    private double[] currM2n() {
        return this.currM2n;
    }

    private void currM2n_$eq(double[] x$1) {
        this.currM2n = x$1;
    }

    private double[] currM2() {
        return this.currM2;
    }

    private void currM2_$eq(double[] x$1) {
        this.currM2 = x$1;
    }

    private double[] currL1() {
        return this.currL1;
    }

    private void currL1_$eq(double[] x$1) {
        this.currL1 = x$1;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double totalWeightSum() {
        return this.totalWeightSum;
    }

    private void totalWeightSum_$eq(double x$1) {
        this.totalWeightSum = x$1;
    }

    private double weightSquareSum() {
        return this.weightSquareSum;
    }

    private void weightSquareSum_$eq(double x$1) {
        this.weightSquareSum = x$1;
    }

    private double[] weightSum() {
        return this.weightSum;
    }

    private void weightSum_$eq(double[] x$1) {
        this.weightSum = x$1;
    }

    private long[] nnz() {
        return this.nnz;
    }

    private void nnz_$eq(long[] x$1) {
        this.nnz = x$1;
    }

    private double[] currMax() {
        return this.currMax;
    }

    private void currMax_$eq(double[] x$1) {
        this.currMax = x$1;
    }

    private double[] currMin() {
        return this.currMin;
    }

    private void currMin_$eq(double[] x$1) {
        this.currMin = x$1;
    }

    public MultivariateOnlineSummarizer add(Vector sample) {
        return this.add(sample, 1.0);
    }

    public MultivariateOnlineSummarizer add(Vector instance, double weight) {
        Predef$.MODULE$.require(weight >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("sample weight, ").append(weight).append(" has to be >= 0.0").toString());
        if (weight == 0.0) {
            return this;
        }
        if (this.n() == 0) {
            Predef$.MODULE$.require(instance.size() > 0, (Function0 & Serializable & scala.Serializable)() -> "Vector should have dimension larger than zero.");
            this.n_$eq(instance.size());
            this.currMean_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currM2n_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currM2_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currL1_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.weightSum_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.nnz_$eq((long[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Long()));
            this.currMax_$eq((double[])Array$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double$.MODULE$.MinValue(), ClassTag$.MODULE$.Double()));
            this.currMin_$eq((double[])Array$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.MAX_VALUE, ClassTag$.MODULE$.Double()));
        }
        Predef$.MODULE$.require(this.n() == instance.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Dimensions mismatch when adding new sample.").append(" Expecting ").append(this.n()).append(" but got ").append(instance.size()).append(".").toString());
        double[] localCurrMean = this.currMean();
        double[] localCurrM2n = this.currM2n();
        double[] localCurrM2 = this.currM2();
        double[] localCurrL1 = this.currL1();
        double[] localWeightSum = this.weightSum();
        long[] localNumNonzeros = this.nnz();
        double[] localCurrMax = this.currMax();
        double[] localCurrMin = this.currMin();
        instance.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
            block2: {
                if (value == 0.0) break block2;
                if (localCurrMax[index] < value) {
                    localCurrMax$1[index] = value;
                }
                if (localCurrMin[index] > value) {
                    localCurrMin$1[index] = value;
                }
                double prevMean = localCurrMean[index];
                double diff = value - prevMean;
                localCurrMean$1[index] = prevMean + weight * diff / (localWeightSum[index] + weight);
                localCurrM2n$1[index] = localCurrM2n[index] + weight * (value - localCurrMean[index]) * diff;
                localCurrM2$1[index] = localCurrM2[index] + weight * value * value;
                localCurrL1$1[index] = localCurrL1[index] + weight * package$.MODULE$.abs(value);
                localWeightSum$1[index] = localWeightSum[index] + weight;
                localNumNonzeros$1[index] = localNumNonzeros[index] + 1L;
            }
        });
        this.totalWeightSum_$eq(this.totalWeightSum() + weight);
        this.weightSquareSum_$eq(this.weightSquareSum() + weight * weight);
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public MultivariateOnlineSummarizer merge(MultivariateOnlineSummarizer other) {
        block3: {
            block2: {
                if (this.totalWeightSum() == 0.0 || other.totalWeightSum() == 0.0) break block2;
                Predef$.MODULE$.require(this.n() == other.n(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Dimensions mismatch when merging with another summarizer. ").append("Expecting ").append(this.n()).append(" but got ").append(other.n()).append(".").toString());
                this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
                this.totalWeightSum_$eq(this.totalWeightSum() + other.totalWeightSum());
                this.weightSquareSum_$eq(this.weightSquareSum() + other.weightSquareSum());
                for (int i = 0; i < this.n(); ++i) {
                    double thisNnz = this.weightSum()[i];
                    double otherNnz = other.weightSum()[i];
                    double totalNnz = thisNnz + otherNnz;
                    long totalCnnz = this.nnz()[i] + other.nnz()[i];
                    if (totalNnz != 0.0) {
                        double deltaMean = other.currMean()[i] - this.currMean()[i];
                        double[] dArray = this.currMean();
                        int n = i;
                        dArray[n] = dArray[n] + deltaMean * otherNnz / totalNnz;
                        double[] dArray2 = this.currM2n();
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + (other.currM2n()[i] + deltaMean * deltaMean * thisNnz * otherNnz / totalNnz);
                        double[] dArray3 = this.currM2();
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + other.currM2()[i];
                        double[] dArray4 = this.currL1();
                        int n4 = i;
                        dArray4[n4] = dArray4[n4] + other.currL1()[i];
                        this.currMax()[i] = package$.MODULE$.max(this.currMax()[i], other.currMax()[i]);
                        this.currMin()[i] = package$.MODULE$.min(this.currMin()[i], other.currMin()[i]);
                    }
                    this.weightSum()[i] = totalNnz;
                    this.nnz()[i] = totalCnnz;
                }
                break block3;
            }
            if (this.totalWeightSum() != 0.0 || other.totalWeightSum() == 0.0) break block3;
            this.n_$eq(other.n());
            this.currMean_$eq((double[])other.currMean().clone());
            this.currM2n_$eq((double[])other.currM2n().clone());
            this.currM2_$eq((double[])other.currM2().clone());
            this.currL1_$eq((double[])other.currL1().clone());
            this.totalCnt_$eq(other.totalCnt());
            this.totalWeightSum_$eq(other.totalWeightSum());
            this.weightSquareSum_$eq(other.weightSquareSum());
            this.weightSum_$eq((double[])other.weightSum().clone());
            this.nnz_$eq((long[])other.nnz().clone());
            this.currMax_$eq((double[])other.currMax().clone());
            this.currMin_$eq((double[])other.currMin().clone());
        }
        return this;
    }

    @Override
    public Vector mean() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realMean = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.n(); ++i) {
            realMean[i] = this.currMean()[i] * (this.weightSum()[i] / this.totalWeightSum());
        }
        return Vectors$.MODULE$.dense(realMean);
    }

    @Override
    public Vector variance() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realVariance = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        double denominator = this.totalWeightSum() - this.weightSquareSum() / this.totalWeightSum();
        if (denominator > 0.0) {
            double[] deltaMean = this.currMean();
            int len = this.currM2n().length;
            for (int i = 0; i < len; ++i) {
                realVariance[i] = package$.MODULE$.max((this.currM2n()[i] + deltaMean[i] * deltaMean[i] * this.weightSum()[i] * (this.totalWeightSum() - this.weightSum()[i]) / this.totalWeightSum()) / denominator, 0.0);
            }
        }
        return Vectors$.MODULE$.dense(realVariance);
    }

    @Override
    public long count() {
        return this.totalCnt();
    }

    @Override
    public Vector numNonzeros() {
        Predef$.MODULE$.require(this.totalCnt() > 0L, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        return Vectors$.MODULE$.dense((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.nnz())).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public Vector max() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        for (int i = 0; i < this.n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMax()[i] < 0.0)) continue;
            this.currMax()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMax());
    }

    @Override
    public Vector min() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        for (int i = 0; i < this.n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMin()[i] > 0.0)) continue;
            this.currMin()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMin());
    }

    @Override
    public Vector normL2() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realMagnitude = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        int len = this.currM2().length;
        for (int i = 0; i < len; ++i) {
            realMagnitude[i] = package$.MODULE$.sqrt(this.currM2()[i]);
        }
        return Vectors$.MODULE$.dense(realMagnitude);
    }

    @Override
    public Vector normL1() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        return Vectors$.MODULE$.dense(this.currL1());
    }
}

