/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LinearSVC$;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.HingeAggregator;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t%\u000f\u0005\t!\u0002\u0011\t\u0011)A\u0005u!)!\u000b\u0001C\u0001'\")!\u000b\u0001C\u0001/\")\u0011\f\u0001C\u00015\")1\r\u0001C\u0001I\")!\u000e\u0001C\u0001W\")\u0011\u000f\u0001C\u0001e\")Q\u000f\u0001C\u0001m\")\u0011\u0010\u0001C\u0001u\")Q\u0010\u0001C\u0001}\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003C\u0001A\u0011KA\u0012\u000f\u001d\ty%\u0006E\u0001\u0003#2a\u0001F\u000b\t\u0002\u0005M\u0003B\u0002*\u0011\t\u0003\t9\u0007C\u0004\u0002jA!\t%a\u001b\t\u0013\u0005M\u0004#!A\u0005\n\u0005U$!\u0003'j]\u0016\f'o\u0015,D\u0015\t1r#\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005aI\u0012AA7m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0005z#\u0007E\u0003#G\u0015ZC&D\u0001\u0016\u0013\t!SC\u0001\u0006DY\u0006\u001c8/\u001b4jKJ\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001K\f\u0002\r1Lg.\u00197h\u0013\tQsE\u0001\u0004WK\u000e$xN\u001d\t\u0003E\u0001\u0001\"AI\u0017\n\u00059*\"A\u0004'j]\u0016\f'o\u0015,D\u001b>$W\r\u001c\t\u0003EAJ!!M\u000b\u0003\u001f1Kg.Z1s'Z\u001b\u0005+\u0019:b[N\u0004\"a\r\u001c\u000e\u0003QR!!N\f\u0002\tU$\u0018\u000e\\\u0005\u0003oQ\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012A\u000f\t\u0003w\u0011s!\u0001\u0010\"\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}z\u0012A\u0002\u001fs_>$hHC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"AQ\r\t\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017f\t!\"\u00198o_R\fG/[8o\u0013\ti%JA\u0003TS:\u001cW-I\u0001P\u0003\u0015\u0011dF\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\tAe*\u0001\u0004=S:LGO\u0010\u000b\u0003WQCQ\u0001O\u0002A\u0002iB3\u0001\u0016%OQ\r\u0019\u0001J\u0014\u000b\u0002W!\u001aA\u0001\u0013(\u0002\u0017M,GOU3h!\u0006\u0014\u0018-\u001c\u000b\u00037rk\u0011\u0001\u0001\u0005\u0006;\u0016\u0001\rAX\u0001\u0006m\u0006dW/\u001a\t\u0003?\u0002l\u0011\u0001Q\u0005\u0003C\u0002\u0013a\u0001R8vE2,\u0007fA\u0003I\u001d\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005m+\u0007\"B/\u0007\u0001\u00041\u0007CA0h\u0013\tA\u0007IA\u0002J]RD3A\u0002%O\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HCA.m\u0011\u0015iv\u00011\u0001n!\tyf.\u0003\u0002p\u0001\n9!i\\8mK\u0006t\u0007fA\u0004I\u001d\u000611/\u001a;U_2$\"aW:\t\u000buC\u0001\u0019\u00010)\u0007!Ae*\u0001\ntKR\u001cF/\u00198eCJ$\u0017N_1uS>tGCA.x\u0011\u0015i\u0016\u00021\u0001nQ\rI\u0001JT\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u00037nDQ!\u0018\u0006A\u0002iB3A\u0003%O\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\tYv\u0010C\u0003^\u0017\u0001\u0007a\fK\u0002\f\u0011:\u000b1c]3u\u0003\u001e<'/Z4bi&|g\u000eR3qi\"$2aWA\u0004\u0011\u0015iF\u00021\u0001gQ\ra\u0001JT\u0001\u0005G>\u0004\u0018\u0010F\u0002,\u0003\u001fAq!!\u0005\u000e\u0001\u0004\t\u0019\"A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbF\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003;\t9B\u0001\u0005QCJ\fW.T1qQ\ri\u0001JT\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004Y\u0005\u0015\u0002bBA\u0014\u001d\u0001\u0007\u0011\u0011F\u0001\bI\u0006$\u0018m]3ua\u0011\tY#a\u000f\u0011\r\u00055\u00121GA\u001c\u001b\t\tyCC\u0002\u00022e\t1a]9m\u0013\u0011\t)$a\f\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011HA\u001e\u0019\u0001!A\"!\u0010\u0002&\u0005\u0005\t\u0011!B\u0001\u0003\u007f\u00111a\u0018\u00132#\u0011\t\t%a\u0012\u0011\u0007}\u000b\u0019%C\u0002\u0002F\u0001\u0013qAT8uQ&tw\rE\u0002`\u0003\u0013J1!a\u0013A\u0005\r\te.\u001f\u0015\u0004\u0001!s\u0015!\u0003'j]\u0016\f'o\u0015,D!\t\u0011\u0003cE\u0004\u0011\u0003+\nY&!\u0019\u0011\u0007}\u000b9&C\u0002\u0002Z\u0001\u0013a!\u00118z%\u00164\u0007\u0003B\u001a\u0002^-J1!a\u00185\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042aXA2\u0013\r\t)\u0007\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003#\nA\u0001\\8bIR\u00191&!\u001c\t\r\u0005=$\u00031\u0001;\u0003\u0011\u0001\u0018\r\u001e5)\u0007IAe*A\u0006sK\u0006$'+Z:pYZ,GCAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA\u0001\\1oO*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006m$AB(cU\u0016\u001cG\u000fK\u0002\u0011\u0011:C3a\u0004%O\u0001")
public class LinearSVC
extends Classifier<Vector, LinearSVC, LinearSVCModel>
implements LinearSVCParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam threshold;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    public static LinearSVC load(String string) {
        return LinearSVC$.MODULE$.load(string);
    }

    public static MLReader<LinearSVC> read() {
        return LinearSVC$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearSVC setRegParam(double value) {
        return (LinearSVC)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setMaxIter(int value) {
        return (LinearSVC)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setFitIntercept(boolean value) {
        return (LinearSVC)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setTol(double value) {
        return (LinearSVC)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setStandardization(boolean value) {
        return (LinearSVC)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setWeightCol(String value) {
        return (LinearSVC)this.set(this.weightCol(), value);
    }

    public LinearSVC setThreshold(double value) {
        return (LinearSVC)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setAggregationDepth(int value) {
        return (LinearSVC)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public LinearSVC copy(ParamMap extra) {
        return (LinearSVC)this.defaultCopy(extra);
    }

    @Override
    public LinearSVCModel train(Dataset<?> dataset) {
        return (LinearSVCModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            None$ none$;
            int n;
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD<Instance> instances = this.extractInstances(dataset);
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.regParam(), this.maxIter(), this.fitIntercept(), this.tol(), this.standardization(), this.threshold(), this.aggregationDepth()}));
            Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)Summarizer$.MODULE$.createSummarizerBuffer((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"})), (Object)new MultiClassSummarizer()), (Function2 & Serializable & scala.Serializable)(c, instance) -> new Tuple2((Object)((SummarizerBuffer)c._1()).add(instance.features(), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight())), (Function2 & Serializable & scala.Serializable)(c1, c2) -> new Tuple2((Object)((SummarizerBuffer)c1._1()).merge((SummarizerBuffer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2())), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            Tuple2 tuple23 = tuple22;
            SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            instr.logNumExamples(summarizer2.count());
            instr.logNamedValue("lowestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).min((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logNamedValue("highestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).max((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logSumOfWeights(summarizer2.weightSum());
            double[] histogram = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numFeatures = summarizer2.mean().size();
            int numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
            Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
            if (option instanceof Some) {
                Some some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                int n3 = n2;
                Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Specified number of classes ").append(n3).append(" was ").append("less than the number of unique labels ").append(histogram.length).append(".").toString());
                n = n3;
            } else if (None$.MODULE$.equals(option)) {
                n = histogram.length;
            } else {
                throw new MatchError(option);
            }
            int numClasses = n;
            Predef$.MODULE$.require(numClasses == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("LinearSVC only supports binary classification.").append(" ").append(numClasses).append(" classes detected in ").append(this.labelCol()).toString());
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                String msg = new StringBuilder(66).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").append("Found ").append(numInvalid).append(" invalid labels.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] featuresStd = summarizer2.std().toArray();
            JFunction1.mcDI.sp & Serializable & scala.Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> featuresStd[j];
            double regParamL2 = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            if (regParamL2 != 0.0) {
                JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> idx >= 0 && idx < numFeatures;
                none$ = new Some((Object)new L2Regularization(regParamL2, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
            } else {
                none$ = None$.MODULE$;
            }
            None$ regularization = none$;
            Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$2 -> new HingeAggregator((Broadcast<double[]>)bcFeaturesStd, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<Vector>)x$2);
            RDDLossFunction costFun = new RDDLossFunction(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(HingeAggregator.class));
            OWLQN optimizer = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearSVC.regParamL1Fun$1(), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
            Vector initialCoefWithIntercept = Vectors$.MODULE$.zeros(numFeaturesPlusIntercept);
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialCoefWithIntercept.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder scaledObjectiveHistory = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                scaledObjectiveHistory.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            bcFeaturesStd.destroy();
            if (state == null) {
                String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] rawCoefficients = ((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double());
            double[] coefficientArray = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> featuresStd[i] != 0.0 ? rawCoefficients[i] / featuresStd[i] : 0.0, ClassTag$.MODULE$.Double());
            double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? rawCoefficients[numFeaturesPlusIntercept - 1] : 0.0;
            Tuple3 tuple3 = new Tuple3((Object)Vectors$.MODULE$.dense(coefficientArray), (Object)BoxesRunTime.boxToDouble((double)intercept), scaledObjectiveHistory.result());
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Vector coefficientVector = (Vector)tuple3._1();
            double interceptVector = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double[] objectiveHistory = (double[])tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)coefficientVector, (Object)BoxesRunTime.boxToDouble((double)interceptVector), (Object)objectiveHistory);
            Tuple3 tuple33 = tuple32;
            Vector coefficientVector2 = (Vector)tuple33._1();
            double interceptVector2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            double[] objectiveHistory2 = (double[])tuple33._3();
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            return this.copyValues(new LinearSVCModel(this.uid(), coefficientVector2, interceptVector2), this.copyValues$default$2());
        });
    }

    private static final Function1 regParamL1Fun$1() {
        return (JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> 0.0;
    }

    public LinearSVC(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public LinearSVC() {
        this(Identifiable$.MODULE$.randomUID("linearsvc"));
    }
}

