/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.python;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.Pickler;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.python.MLSerDe$;
import org.apache.spark.mllib.api.python.SerDeBase;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rtA\u0002\u000e\u001c\u0011\u0003yRE\u0002\u0004(7!\u0005q\u0004\u000b\u0005\u0006q\u0005!\tA\u000f\u0005\bw\u0005\u0011\r\u0011\"\u0011=\u0011\u0019)\u0015\u0001)A\u0005{\u0019)a)\u0001\u0001\u001c\u000f\")\u0001(\u0002C\u0001%\")A+\u0002C\u0001+\")!/\u0002C\u0001g\u001a)\u00110\u0001\u0001\u001cu\")\u0001(\u0003C\u0001\u007f\"1A+\u0003C\u0001\u0003\u0007AaA]\u0005\u0005\u0002\u0005-aaBA\b\u0003\u0001Y\u0012\u0011\u0003\u0005\u0007q5!\t!a\u0007\t\rQkA\u0011AA\u0010\u0011\u0019\u0011X\u0002\"\u0001\u0002(\u00199\u00111F\u0001\u00017\u00055\u0002B\u0002\u001d\u0012\t\u0003\t9\u0004\u0003\u0004U#\u0011\u0005\u00111\b\u0005\u0007eF!\t!a\u0011\t\u0013\u0005\u001d\u0013\u00011A\u0005\u0002\u0005%\u0003\"CA)\u0003\u0001\u0007I\u0011AA*\u0011!\tI&\u0001Q!\n\u0005-\u0003bBA.\u0003\u0011\u0005\u0013Q\f\u0005\n\u0003?\n\u0011\u0011!C\u0005\u0003C\nq!\u0014'TKJ$UM\u0003\u0002\u001d;\u00051\u0001/\u001f;i_:T!AH\u0010\u0002\u00055d'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0011\u0005\u0019\nQ\"A\u000e\u0003\u000f5c5+\u001a:EKN\u0019\u0011!\u000b\u001a\u0011\u0005)\u0002T\"A\u0016\u000b\u0005qa#BA\u0017/\u0003\r\t\u0007/\u001b\u0006\u0003_}\tQ!\u001c7mS\nL!!M\u0016\u0003\u0013M+'\u000fR3CCN,\u0007CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0015\nq\u0002U-T!\u0006\u00136j\u0018)B\u0007.\u000bu)R\u000b\u0002{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005Y\u0006twMC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$AB*ue&tw-\u0001\tQ3N\u0003\u0016IU&`!\u0006\u001b5*Q$FA\t\u0011B)\u001a8tKZ+7\r^8s!&\u001c7\u000e\\3s'\t)\u0001\nE\u0002J\u00152k\u0011!A\u0005\u0003\u0017B\u00121BQ1tKBK7m\u001b7feB\u0011Q\nU\u0007\u0002\u001d*\u0011q*H\u0001\u0007Y&t\u0017\r\\4\n\u0005Es%a\u0003#f]N,g+Z2u_J$\u0012a\u0015\t\u0003\u0013\u0016\t\u0011b]1wKN#\u0018\r^3\u0015\tYKfL\u001a\t\u0003g]K!\u0001\u0017\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u00065\u001e\u0001\raW\u0001\u0004_\nT\u0007C\u0001 ]\u0013\tivH\u0001\u0004PE*,7\r\u001e\u0005\u0006?\u001e\u0001\r\u0001Y\u0001\u0004_V$\bCA1e\u001b\u0005\u0011'BA2B\u0003\tIw.\u0003\u0002fE\naq*\u001e;qkR\u001cFO]3b[\")qm\u0002a\u0001Q\u00069\u0001/[2lY\u0016\u0014\bCA5q\u001b\u0005Q'BA6m\u0003\u0019\u0001\u0018nY6mK*\u0011QN\\\u0001\ne\u0006TxN\u001d<j]\u0016T\u0011a\\\u0001\u0004]\u0016$\u0018BA9k\u0005\u001d\u0001\u0016nY6mKJ\f\u0011bY8ogR\u0014Xo\u0019;\u0015\u0005m#\b\"B;\t\u0001\u00041\u0018\u0001B1sON\u00042aM<\\\u0013\tAHGA\u0003BeJ\f\u0017P\u0001\nEK:\u001cX-T1ue&D\b+[2lY\u0016\u00148CA\u0005|!\rI%\n \t\u0003\u001bvL!A (\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u000b\u0003\u0003\u0003\u0001\"!S\u0005\u0015\u000fY\u000b)!a\u0002\u0002\n!)!l\u0003a\u00017\")ql\u0003a\u0001A\")qm\u0003a\u0001QR\u00191,!\u0004\t\u000bUd\u0001\u0019\u0001<\u0003'M\u0003\u0018M]:f\u001b\u0006$(/\u001b=QS\u000e\\G.\u001a:\u0014\u00075\t\u0019\u0002\u0005\u0003J\u0015\u0006U\u0001cA'\u0002\u0018%\u0019\u0011\u0011\u0004(\u0003\u0019M\u0003\u0018M]:f\u001b\u0006$(/\u001b=\u0015\u0005\u0005u\u0001CA%\u000e)\u001d1\u0016\u0011EA\u0012\u0003KAQAW\bA\u0002mCQaX\bA\u0002\u0001DQaZ\bA\u0002!$2aWA\u0015\u0011\u0015)\b\u00031\u0001w\u0005M\u0019\u0006/\u0019:tKZ+7\r^8s!&\u001c7\u000e\\3s'\r\t\u0012q\u0006\t\u0005\u0013*\u000b\t\u0004E\u0002N\u0003gI1!!\u000eO\u00051\u0019\u0006/\u0019:tKZ+7\r^8s)\t\tI\u0004\u0005\u0002J#Q9a+!\u0010\u0002@\u0005\u0005\u0003\"\u0002.\u0014\u0001\u0004Y\u0006\"B0\u0014\u0001\u0004\u0001\u0007\"B4\u0014\u0001\u0004AGcA.\u0002F!)Q\u000f\u0006a\u0001m\u0006Y\u0011N\\5uS\u0006d\u0017N_3e+\t\tY\u0005E\u00024\u0003\u001bJ1!a\u00145\u0005\u001d\u0011un\u001c7fC:\fq\"\u001b8ji&\fG.\u001b>fI~#S-\u001d\u000b\u0004-\u0006U\u0003\"CA,-\u0005\u0005\t\u0019AA&\u0003\rAH%M\u0001\rS:LG/[1mSj,G\rI\u0001\u000bS:LG/[1mSj,G#\u0001,\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u00027\u0002")
public final class MLSerDe {
    public static void initialize() {
        MLSerDe$.MODULE$.initialize();
    }

    public static void initialized_$eq(boolean bl) {
        MLSerDe$.MODULE$.initialized_$eq(bl);
    }

    public static boolean initialized() {
        return MLSerDe$.MODULE$.initialized();
    }

    public static String PYSPARK_PACKAGE() {
        return MLSerDe$.MODULE$.PYSPARK_PACKAGE();
    }

    public static JavaRDD<Object> pythonToJava(JavaRDD<byte[]> javaRDD, boolean bl) {
        return MLSerDe$.MODULE$.pythonToJava(javaRDD, bl);
    }

    public static JavaRDD<byte[]> javaToPython(JavaRDD<Object> javaRDD) {
        return MLSerDe$.MODULE$.javaToPython(javaRDD);
    }

    public static RDD<Object[]> fromTuple2RDD(RDD<Tuple2<Object, Object>> rDD) {
        return MLSerDe$.MODULE$.fromTuple2RDD(rDD);
    }

    public static RDD<Tuple2<Object, Object>> asTupleRDD(RDD<Object[]> rDD) {
        return MLSerDe$.MODULE$.asTupleRDD(rDD);
    }

    public static Object loads(byte[] byArray) {
        return MLSerDe$.MODULE$.loads(byArray);
    }

    public static byte[] dumps(Object object) {
        return MLSerDe$.MODULE$.dumps(object);
    }

    public static class DenseMatrixPickler
    extends SerDeBase.BasePickler<DenseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseMatrix m = (DenseMatrix)obj;
            byte[] bytes = new byte[8 * m.values().length];
            ByteOrder order = ByteOrder.nativeOrder();
            int isTransposed = m.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().put(m.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 4) {
                throw new PickleException("length of args should be 4");
            }
            byte[] bytes = this.getBytes(args[2]);
            int n = bytes.length / 8;
            double[] values = new double[n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[3]) == 1;
            return new DenseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), values, isTransposed);
        }

        public DenseMatrixPickler() {
            super(MLSerDe$.MODULE$, ClassTag$.MODULE$.apply(DenseMatrix.class));
        }
    }

    public static class DenseVectorPickler
    extends SerDeBase.BasePickler<DenseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseVector vector = (DenseVector)obj;
            byte[] bytes = new byte[8 * vector.size()];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            db.put(vector.values());
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(133);
        }

        public Object construct(Object[] args) {
            if (args.length != 1) {
                throw new PickleException("length of args should be 1");
            }
            byte[] bytes = this.getBytes(args[0]);
            ByteBuffer bb = ByteBuffer.wrap(bytes, 0, bytes.length);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            double[] ans = new double[bytes.length / 8];
            db.get(ans);
            return Vectors$.MODULE$.dense(ans);
        }

        public DenseVectorPickler() {
            super(MLSerDe$.MODULE$, ClassTag$.MODULE$.apply(DenseVector.class));
        }
    }

    public static class SparseMatrixPickler
    extends SerDeBase.BasePickler<SparseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseMatrix s = (SparseMatrix)obj;
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = new byte[4 * s.colPtrs().length];
            byte[] indicesBytes = new byte[4 * s.rowIndices().length];
            byte[] valuesBytes = new byte[8 * s.values().length];
            int isTransposed = s.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().put(s.colPtrs());
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().put(s.rowIndices());
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().put(s.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)colPtrsBytes.length));
            out.write(colPtrsBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indicesBytes.length));
            out.write(indicesBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valuesBytes.length));
            out.write(valuesBytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 6) {
                throw new PickleException("length of args should be 6");
            }
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = this.getBytes(args[2]);
            byte[] indicesBytes = this.getBytes(args[3]);
            byte[] valuesBytes = this.getBytes(args[4]);
            int[] colPtrs = new int[colPtrsBytes.length / 4];
            int[] rowIndices = new int[indicesBytes.length / 4];
            double[] values = new double[valuesBytes.length / 8];
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().get(colPtrs);
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().get(rowIndices);
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[5]) == 1;
            return new SparseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), colPtrs, rowIndices, values, isTransposed);
        }

        public SparseMatrixPickler() {
            super(MLSerDe$.MODULE$, ClassTag$.MODULE$.apply(SparseMatrix.class));
        }
    }

    public static class SparseVectorPickler
    extends SerDeBase.BasePickler<SparseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseVector v = (SparseVector)obj;
            int n = v.indices().length;
            byte[] indiceBytes = new byte[4 * n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().put(v.indices());
            byte[] valueBytes = new byte[8 * n];
            ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().put(v.values());
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)v.size()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indiceBytes.length));
            out.write(indiceBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valueBytes.length));
            out.write(valueBytes);
            out.write(135);
        }

        public Object construct(Object[] args) {
            Object object;
            if (args.length != 3) {
                throw new PickleException("length of args should be 3");
            }
            int size = BoxesRunTime.unboxToInt((Object)args[0]);
            byte[] indiceBytes = this.getBytes(args[1]);
            byte[] valueBytes = this.getBytes(args[2]);
            int n = indiceBytes.length / 4;
            int[] indices = new int[n];
            double[] values = new double[n];
            if (n > 0) {
                ByteOrder order = ByteOrder.nativeOrder();
                ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().get(indices);
                object = ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().get(values);
            } else {
                object = BoxedUnit.UNIT;
            }
            return new SparseVector(size, indices, values);
        }

        public SparseVectorPickler() {
            super(MLSerDe$.MODULE$, ClassTag$.MODULE$.apply(SparseVector.class));
        }
    }
}

