/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.clustering.VectorWithNorm$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3Qa\u0002\u0005\u0001\u0019IAQa\u0006\u0001\u0005\u0002eAQa\u0007\u0001\u0005BqAQA\u000b\u0001\u0005B-BQ!\u000f\u0001\u0005BiBQA\u0010\u0001\u0005B}BQA\u0012\u0001\u0005B\u001d\u0013QcQ8tS:,G)[:uC:\u001cW-T3bgV\u0014XM\u0003\u0002\n\u0015\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005-a\u0011!B7mY&\u0014'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005A\u0011B\u0001\f\t\u0005=!\u0015n\u001d;b]\u000e,W*Z1tkJ,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003i\u0001\"\u0001\u0006\u0001\u0002\u0011\u0011L7\u000f^1oG\u0016$2!H\u0012)!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019!u.\u001e2mK\")AE\u0001a\u0001K\u0005\u0011a/\r\t\u0003)\u0019J!a\n\u0005\u0003\u001dY+7\r^8s/&$\bNT8s[\")\u0011F\u0001a\u0001K\u0005\u0011aOM\u0001\u0011kB$\u0017\r^3DYV\u001cH/\u001a:Tk6$2\u0001L\u00182!\tqR&\u0003\u0002/?\t!QK\\5u\u0011\u0015\u00014\u00011\u0001&\u0003\u0015\u0001x.\u001b8u\u0011\u0015\u00114\u00011\u00014\u0003\r\u0019X/\u001c\t\u0003i]j\u0011!\u000e\u0006\u0003m)\ta\u0001\\5oC2<\u0017B\u0001\u001d6\u0005\u00191Vm\u0019;pe\u0006A1-\u001a8ue>LG\rF\u0002&wqBQA\r\u0003A\u0002MBQ!\u0010\u0003A\u0002u\t\u0011b^3jO\"$8+^7\u0002\u0017\rdWo\u001d;fe\u000e{7\u000f\u001e\u000b\u0006;\u0001\u000b5\t\u0012\u0005\u0006s\u0015\u0001\r!\n\u0005\u0006\u0005\u0016\u0001\r!J\u0001\na>Lg\u000e^:Tk6DQ!P\u0003A\u0002uAQ!R\u0003A\u0002u\t\u0011\u0003]8j]R\u001c8+];be\u0016$gj\u001c:n\u0003I\u0019\u00180\\7fiJL7mQ3oiJ|\u0017\u000eZ:\u0015\t![Uj\u0014\t\u0005=%+S%\u0003\u0002K?\t1A+\u001e9mKJBQ\u0001\u0014\u0004A\u0002u\tQ\u0001\\3wK2DQA\u0014\u0004A\u0002M\nQA\\8jg\u0016DQ!\u000f\u0004A\u0002M\u0002")
public class CosineDistanceMeasure
extends DistanceMeasure {
    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        Predef$.MODULE$.assert(v1.norm() > 0.0 && v2.norm() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Cosine distance is not defined for zero-length vectors.");
        return 1.0 - BLAS$.MODULE$.dot(v1.vector(), v2.vector()) / v1.norm() / v2.norm();
    }

    @Override
    public void updateClusterSum(VectorWithNorm point, Vector sum) {
        Predef$.MODULE$.assert(point.norm() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Cosine distance is not defined for zero-length vectors.");
        BLAS$.MODULE$.axpy(point.weight() / point.norm(), point.vector(), sum);
    }

    @Override
    public VectorWithNorm centroid(Vector sum, double weightSum) {
        BLAS$.MODULE$.scal(1.0 / weightSum, sum);
        double norm = Vectors$.MODULE$.norm(sum, 2.0);
        BLAS$.MODULE$.scal(1.0 / norm, sum);
        return new VectorWithNorm(sum, 1.0, VectorWithNorm$.MODULE$.$lessinit$greater$default$3());
    }

    @Override
    public double clusterCost(VectorWithNorm centroid, VectorWithNorm pointsSum, double weightSum, double pointsSquaredNorm) {
        Vector costVector = pointsSum.vector().copy();
        return package$.MODULE$.max(weightSum - BLAS$.MODULE$.dot(centroid.vector(), costVector) / centroid.norm(), 0.0);
    }

    @Override
    public Tuple2<VectorWithNorm, VectorWithNorm> symmetricCentroids(double level, Vector noise, Vector centroid) {
        Tuple2<VectorWithNorm, VectorWithNorm> tuple2 = super.symmetricCentroids(level, noise, centroid);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        VectorWithNorm left = (VectorWithNorm)tuple2._1();
        VectorWithNorm right = (VectorWithNorm)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
        Tuple2 tuple23 = tuple22;
        VectorWithNorm left2 = (VectorWithNorm)tuple23._1();
        VectorWithNorm right2 = (VectorWithNorm)tuple23._2();
        Vector leftVector = left2.vector();
        Vector rightVector = right2.vector();
        BLAS$.MODULE$.scal(1.0 / left2.norm(), leftVector);
        BLAS$.MODULE$.scal(1.0 / right2.norm(), rightVector);
        return new Tuple2((Object)new VectorWithNorm(leftVector, 1.0, VectorWithNorm$.MODULE$.$lessinit$greater$default$3()), (Object)new VectorWithNorm(rightVector, 1.0, VectorWithNorm$.MODULE$.$lessinit$greater$default$3()));
    }
}

