/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LinearSVC$;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.LinearSVCTrainingSummary;
import org.apache.spark.ml.classification.LinearSVCTrainingSummaryImpl;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BlockHingeAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\f\u0019\u0001\rB\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0005\u0010\u0005\t'\u0002\u0011\t\u0011)A\u0005{!)Q\u000b\u0001C\u0001-\")Q\u000b\u0001C\u00015\")A\f\u0001C\u0001;\")a\r\u0001C\u0001O\")Q\u000e\u0001C\u0001]\")A\u000f\u0001C\u0001k\")\u0001\u0010\u0001C\u0001s\")A\u0010\u0001C\u0001{\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!a\r\u0001\t#\n)\u0004C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\u001e9\u0011\u0011\u001e\r\t\u0002\u0005-hAB\f\u0019\u0011\u0003\ti\u000f\u0003\u0004V'\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0007\u0019B\u0011\tB\u0003\u0011%\u0011iaEA\u0001\n\u0013\u0011yAA\u0005MS:,\u0017M]*W\u0007*\u0011\u0011DG\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tYB$\u0001\u0002nY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!#'\u000e\t\u0006K\u0019BcfL\u0007\u00021%\u0011q\u0005\u0007\u0002\u000b\u00072\f7o]5gS\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0019a\u0017N\\1mO&\u0011QF\u000b\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005\u0015\u0002\u0001CA\u00131\u0013\t\t\u0004D\u0001\bMS:,\u0017M]*W\u00076{G-\u001a7\u0011\u0005\u0015\u001a\u0014B\u0001\u001b\u0019\u0005=a\u0015N\\3beN36\tU1sC6\u001c\bC\u0001\u001c:\u001b\u00059$B\u0001\u001d\u001b\u0003\u0011)H/\u001b7\n\u0005i:$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.Z\u0001\u0004k&$W#A\u001f\u0011\u0005y:eBA F!\t\u00015)D\u0001B\u0015\t\u0011%%\u0001\u0004=e>|GO\u0010\u0006\u0002\t\u0006)1oY1mC&\u0011aiQ\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G\u0007\"\u001a\u0011aS)\u0011\u00051{U\"A'\u000b\u00059c\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001+\u0014\u0002\u0006'&t7-Z\u0011\u0002%\u0006)!G\f\u001a/a\u0005!Q/\u001b3!Q\r\u00111*U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059:\u0006\"B\u001e\u0004\u0001\u0004i\u0004fA,L#\"\u001a1aS)\u0015\u00039B3\u0001B&R\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0005y{V\"\u0001\u0001\t\u000b\u0001,\u0001\u0019A1\u0002\u000bY\fG.^3\u0011\u0005\t\u001cW\"A\"\n\u0005\u0011\u001c%A\u0002#pk\ndW\rK\u0002\u0006\u0017F\u000b!b]3u\u001b\u0006D\u0018\n^3s)\tq\u0006\u000eC\u0003a\r\u0001\u0007\u0011\u000e\u0005\u0002cU&\u00111n\u0011\u0002\u0004\u0013:$\bf\u0001\u0004L#\u0006y1/\u001a;GSRLe\u000e^3sG\u0016\u0004H\u000f\u0006\u0002__\")\u0001m\u0002a\u0001aB\u0011!-]\u0005\u0003e\u000e\u0013qAQ8pY\u0016\fg\u000eK\u0002\b\u0017F\u000baa]3u)>dGC\u00010w\u0011\u0015\u0001\u0007\u00021\u0001bQ\rA1*U\u0001\u0013g\u0016$8\u000b^1oI\u0006\u0014H-\u001b>bi&|g\u000e\u0006\u0002_u\")\u0001-\u0003a\u0001a\"\u001a\u0011bS)\u0002\u0019M,GoV3jO\"$8i\u001c7\u0015\u0005ys\b\"\u00021\u000b\u0001\u0004i\u0004f\u0001\u0006L#\u0006a1/\u001a;UQJ,7\u000f[8mIR\u0019a,!\u0002\t\u000b\u0001\\\u0001\u0019A1)\u0007-Y\u0015+A\ntKR\fum\u001a:fO\u0006$\u0018n\u001c8EKB$\b\u000eF\u0002_\u0003\u001bAQ\u0001\u0019\u0007A\u0002%D3\u0001D&R\u0003M\u0019X\r^'bq\ncwnY6TSj,\u0017J\\'C)\rq\u0016Q\u0003\u0005\u0006A6\u0001\r!\u0019\u0015\u0005\u001b-\u000bI\"\t\u0002\u0002\u001c\u0005)1GL\u0019/a\u0005!1m\u001c9z)\rq\u0013\u0011\u0005\u0005\b\u0003Gq\u0001\u0019AA\u0013\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u00165\u0005)\u0001/\u0019:b[&!\u0011qFA\u0015\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\bL#\u0006)AO]1j]R\u0019q&a\u000e\t\u000f\u0005er\u00021\u0001\u0002<\u00059A-\u0019;bg\u0016$\b\u0007BA\u001f\u0003\u001b\u0002b!a\u0010\u0002F\u0005%SBAA!\u0015\r\t\u0019\u0005H\u0001\u0004gFd\u0017\u0002BA$\u0003\u0003\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002L\u00055C\u0002\u0001\u0003\r\u0003\u001f\n9$!A\u0001\u0002\u000b\u0005\u0011\u0011\u000b\u0002\u0004?\u0012\n\u0014\u0003BA*\u00033\u00022AYA+\u0013\r\t9f\u0011\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u00171L\u0005\u0004\u0003;\u001a%aA!os\u0006Y1M]3bi\u0016lu\u000eZ3m)%y\u00131MA8\u0003g\n9\bC\u0004\u0002:A\u0001\r!!\u001a1\t\u0005\u001d\u00141\u000e\t\u0007\u0003\u007f\t)%!\u001b\u0011\t\u0005-\u00131\u000e\u0003\r\u0003[\n\u0019'!A\u0001\u0002\u000b\u0005\u0011\u0011\u000b\u0002\u0004?\u0012\u0012\u0004BBA9!\u0001\u0007\u0001&\u0001\u0007d_\u00164g-[2jK:$8\u000f\u0003\u0004\u0002vA\u0001\r!Y\u0001\nS:$XM]2faRDq!!\u001f\u0011\u0001\u0004\tY(\u0001\tpE*,7\r^5wK\"K7\u000f^8ssB!!-! b\u0013\r\tyh\u0011\u0002\u0006\u0003J\u0014\u0018-_\u0001\niJ\f\u0017N\\%na2$B\"!\"\u0002\f\u0006\u001d\u00161VAX\u0003\u0013\u0004rAYAD\u0003w\nY(C\u0002\u0002\n\u000e\u0013a\u0001V;qY\u0016\u0014\u0004bBAG#\u0001\u0007\u0011qR\u0001\nS:\u001cH/\u00198dKN\u0004b!!%\u0002\u0018\u0006mUBAAJ\u0015\r\t)\nH\u0001\u0004e\u0012$\u0017\u0002BAM\u0003'\u00131A\u0015#E!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ5\u00059a-Z1ukJ,\u0017\u0002BAS\u0003?\u0013\u0001\"\u00138ti\u0006t7-\u001a\u0005\u0007\u0003S\u000b\u0002\u0019A1\u0002'\u0005\u001cG/^1m\u00052|7m[*ju\u0016Le.\u0014\"\t\u000f\u00055\u0016\u00031\u0001\u0002|\u0005Ya-Z1ukJ,7o\u0015;e\u0011\u001d\t\t,\u0005a\u0001\u0003g\u000baB]3hk2\f'/\u001b>bi&|g\u000eE\u0003c\u0003k\u000bI,C\u0002\u00028\u000e\u0013aa\u00149uS>t\u0007\u0003BA^\u0003\u000bl!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\u0005Y>\u001c8OC\u0002\u0002Dj\tQa\u001c9uS6LA!a2\u0002>\n\u0001BJ\r*fOVd\u0017M]5{CRLwN\u001c\u0005\b\u0003\u0017\f\u0002\u0019AAg\u0003%y\u0007\u000f^5nSj,'\u000fE\u0004\u0002P\u0006e\u0017.!8\u000e\u0005\u0005E'\u0002BAj\u0003+\f\u0001b\u001c9uS6L'0\u001a\u0006\u0003\u0003/\faA\u0019:fKj,\u0017\u0002BAn\u0003#\u0014QaT,M#:\u0003R!a8\u0002d\u0006l!!!9\u000b\u0007-\n).\u0003\u0003\u0002f\u0006\u0005(a\u0003#f]N,g+Z2u_JD3\u0001A&R\u0003%a\u0015N\\3beN36\t\u0005\u0002&'M91#a<\u0002v\u0006m\bc\u00012\u0002r&\u0019\u00111_\"\u0003\r\u0005s\u0017PU3g!\u00111\u0014q\u001f\u0018\n\u0007\u0005exGA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\u0007\t\fi0C\u0002\u0002\u0000\u000e\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a;\u0002\t1|\u0017\r\u001a\u000b\u0004]\t\u001d\u0001B\u0002B\u0005+\u0001\u0007Q(\u0001\u0003qCRD\u0007fA\u000bL#\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0002\u0005\u0003\u0003\u0014\tuQB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\t1\fgn\u001a\u0006\u0003\u00057\tAA[1wC&!!q\u0004B\u000b\u0005\u0019y%M[3di\"\u001a1cS))\u0007IY\u0015\u000b")
public class LinearSVC
extends Classifier<Vector, LinearSVC, LinearSVCModel>
implements LinearSVCParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam threshold;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    public static LinearSVC load(String string) {
        return LinearSVC$.MODULE$.load(string);
    }

    public static MLReader<LinearSVC> read() {
        return LinearSVC$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearSVC setRegParam(double value) {
        return (LinearSVC)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setMaxIter(int value) {
        return (LinearSVC)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setFitIntercept(boolean value) {
        return (LinearSVC)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setTol(double value) {
        return (LinearSVC)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setStandardization(boolean value) {
        return (LinearSVC)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setWeightCol(String value) {
        return (LinearSVC)this.set(this.weightCol(), value);
    }

    public LinearSVC setThreshold(double value) {
        return (LinearSVC)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setAggregationDepth(int value) {
        return (LinearSVC)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setMaxBlockSizeInMB(double value) {
        return (LinearSVC)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LinearSVC copy(ParamMap extra) {
        return (LinearSVC)this.defaultCopy(extra);
    }

    @Override
    public LinearSVCModel train(Dataset<?> dataset) {
        return (LinearSVCModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            None$ none$;
            int n;
            Option<Object> option;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.regParam(), this.maxIter(), this.fitIntercept(), this.tol(), this.standardization(), this.threshold(), this.aggregationDepth(), this.maxBlockSizeInMB()}));
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("Input instances will be standardized, blockified to blocks, and ").append("then cached during training. Be careful of double caching!").toString());
            }
            RDD instances = this.extractInstances(dataset).setName("training instances");
            Tuple2<SummarizerBuffer, MultiClassSummarizer> tuple2 = Summarizer$.MODULE$.getClassificationSummarizers((RDD<Instance>)instances, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"}))));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            Tuple2 tuple23 = tuple22;
            SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            double[] histogram = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numFeatures = summarizer2.mean().size();
            instr.logNumExamples(summarizer2.count());
            instr.logNamedValue("lowestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).min((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logNamedValue("highestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).max((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logSumOfWeights(summarizer2.weightSum());
            double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
            if (actualBlockSizeInMB == 0.0) {
                actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable & scala.Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                instr.logNamedValue("actualBlockSizeInMB", ((Object)BoxesRunTime.boxToDouble((double)actualBlockSizeInMB)).toString());
            }
            if ((option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())))) instanceof Some) {
                Some some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                int n3 = n2;
                Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Specified number of classes ").append(n3).append(" was ").append("less than the number of unique labels ").append(histogram.length).append(".").toString());
                n = n3;
            } else if (None$.MODULE$.equals(option)) {
                n = histogram.length;
            } else {
                throw new MatchError(option);
            }
            int numClasses = n;
            Predef$.MODULE$.require(numClasses == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("LinearSVC only supports binary classification.").append(" ").append(numClasses).append(" classes detected in ").append(this.labelCol()).toString());
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                String msg = new StringBuilder(66).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").append("Found ").append(numInvalid).append(" invalid labels.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] featuresStd = summarizer2.std().toArray();
            JFunction1.mcDI.sp & Serializable & scala.Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> featuresStd[j];
            if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) != 0.0) {
                JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> idx >= 0 && idx < numFeatures;
                none$ = new Some((Object)new L2Regularization(BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
            } else {
                none$ = None$.MODULE$;
            }
            None$ regularization = none$;
            OWLQN optimizer = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearSVC.regParamL1Fun$1(), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
            Tuple2<double[], double[]> tuple24 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, featuresStd, (Option<L2Regularization>)regularization, (OWLQN<Object, DenseVector<Object>>)optimizer);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            double[] rawCoefficients = (double[])tuple24._1();
            double[] objectiveHistory = (double[])tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)rawCoefficients, (Object)objectiveHistory);
            Tuple2 tuple26 = tuple25;
            double[] rawCoefficients2 = (double[])tuple26._1();
            double[] objectiveHistory2 = (double[])tuple26._2();
            if (rawCoefficients2 == null) {
                String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] coefficientArray = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> featuresStd[i] != 0.0 ? rawCoefficients2[i] / featuresStd[i] : 0.0, ClassTag$.MODULE$.Double());
            double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rawCoefficients2)).last()) : 0.0;
            return this.createModel(dataset, Vectors$.MODULE$.dense(coefficientArray), intercept, objectiveHistory2);
        });
    }

    private LinearSVCModel createModel(Dataset<?> dataset, Vector coefficients, double intercept, double[] objectiveHistory) {
        LinearSVCModel model = this.copyValues(new LinearSVCModel(this.uid(), coefficients, intercept), this.copyValues$default$2());
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = model.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ClassificationModel summaryModel = (ClassificationModel)tuple3._1();
        String rawPredictionColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)rawPredictionColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ClassificationModel summaryModel2 = (ClassificationModel)tuple33._1();
        String rawPredictionColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        LinearSVCTrainingSummaryImpl summary = new LinearSVCTrainingSummaryImpl(summaryModel2.transform(dataset), rawPredictionColName2, predictionColName2, this.$(this.labelCol()), weightColName, objectiveHistory);
        return (LinearSVCModel)model.setSummary((Option<LinearSVCTrainingSummary>)new Some((Object)summary));
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double[] featuresStd, Option<L2Regularization> regularization, OWLQN<Object, DenseVector<Object>> optimizer) {
        int numFeatures = featuresStd.length;
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD standardized = instances.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            double[] inverseStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])bcFeaturesStd.value())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)std -> std != 0.0 ? 1.0 / std : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), inverseStd, false, true);
            return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance == null) {
                    throw new MatchError((Object)instance);
                }
                double label = instance.label();
                double weight = instance.weight();
                Vector vec = instance.features();
                Instance instance2 = new Instance(label, weight, (Vector)func.apply((Object)vec));
                return instance2;
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)standardized, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(new StringBuilder(32).append("training blocks (blockSizeInMB=").append(actualBlockSizeInMB).append(")").toString());
        Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$4 -> new BlockHingeAggregator(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<Vector>)x$4);
        RDDLossFunction costFun = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(BlockHingeAggregator.class));
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)Vectors$.MODULE$.zeros(numFeaturesPlusIntercept).asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcFeaturesStd.destroy();
        return new Tuple2(state != null ? ((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()) : null, arrayBuilder.result());
    }

    private static final Function1 regParamL1Fun$1() {
        return (JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> 0.0;
    }

    public LinearSVC(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public LinearSVC() {
        this(Identifiable$.MODULE$.randomUID("linearsvc"));
    }
}

