/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasVarianceCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$NodeData$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001\u0002\u0013&\u0001AB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tE\u0015\u0005\t=\u0002\u0011\t\u0011)A\u0005'\"Aq\f\u0001BC\u0002\u0013\u0005\u0003\r\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003b\u0011!)\u0007A!b\u0001\n\u00032\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B4\t\r-\u0004A\u0011A\u0014m\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0019Y\u0007\u0001\"\u0001(k\")\u0001\u0010\u0001C!s\"1q\u0010\u0001C\t\u0003\u0003Aq!!\u0002\u0001\t\u0003\n9\u0001C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005BCAL\u0001!\u0015\r\u0011\"\u0001\u0002\u001a\"A\u0011Q\u0014\u0001\u0005B%\ny\nC\u0004\u00022\u0002!\t%a-\b\u000f\u0005}V\u0005#\u0001\u0002B\u001a1A%\nE\u0001\u0003\u0007Daa\u001b\u000b\u0005\u0002\u0005E\u0007bBAj)\u0011\u0005\u0013Q\u001b\u0005\b\u0003?$B\u0011IAq\r\u001d\tI\u000f\u0006\u0001\u0015\u0003WD\u0011\"!<\u0019\u0005\u0003\u0005\u000b\u0011B\u001e\t\r-DB\u0011AAx\u0011\u001d\t9\u0010\u0007C)\u0003s4aAa\u0001\u0015\t\t\u0015\u0001BB6\u001d\t\u0003\u00119\u0001C\u0005\u0003\fq\u0011\r\u0011\"\u0003\u0003\u000e!A!Q\u0004\u000f!\u0002\u0013\u0011y\u0001C\u0004\u0002`r!\tEa\b\t\u0011\t\rB\u0003\"\u0001(\u0005KA!B!\u0011\u0015#\u0003%\ta\nB\"\u0011%\u00119\u0006FA\u0001\n\u0013\u0011IFA\u000eEK\u000eL7/[8o)J,WMU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003M\u001d\n!B]3he\u0016\u001c8/[8o\u0015\tA\u0013&\u0001\u0002nY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\tDHQ#L!\u0011\u00114'N\u001e\u000e\u0003\u0015J!\u0001N\u0013\u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u0014\u0002\r1Lg.\u00197h\u0013\tQtG\u0001\u0004WK\u000e$xN\u001d\t\u0003e\u0001\u0001\"!\u0010!\u000e\u0003yR!aP\u0014\u0002\tQ\u0014X-Z\u0005\u0003\u0003z\u0012\u0011\u0003R3dSNLwN\u001c+sK\u0016lu\u000eZ3m!\ti4)\u0003\u0002E}\tYB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg>\u0014\b+\u0019:b[N\u0004\"AR%\u000e\u0003\u001dS!\u0001S\u0014\u0002\tU$\u0018\u000e\\\u0005\u0003\u0015\u001e\u0013!\"\u0014'Xe&$\u0018M\u00197f!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002'B\u0011Ak\u0017\b\u0003+f\u0003\"AV'\u000e\u0003]S!\u0001W\u0018\u0002\rq\u0012xn\u001c;?\u0013\tQV*\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.N\u0003\u0011)\u0018\u000e\u001a\u0011\u0002\u0011I|w\u000e\u001e(pI\u0016,\u0012!\u0019\t\u0003{\tL!a\u0019 \u0003\t9{G-Z\u0001\ne>|GOT8eK\u0002\n1B\\;n\r\u0016\fG/\u001e:fgV\tq\r\u0005\u0002MQ&\u0011\u0011.\u0014\u0002\u0004\u0013:$\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003<[:|\u0007\"B)\b\u0001\u0004\u0019\u0006\"B0\b\u0001\u0004\t\u0007\"B3\b\u0001\u00049\u0017AD:fiZ\u000b'/[1oG\u0016\u001cu\u000e\u001c\u000b\u0003eNl\u0011\u0001\u0001\u0005\u0006i\"\u0001\raU\u0001\u0006m\u0006dW/\u001a\u000b\u0004wY<\b\"B0\n\u0001\u0004\t\u0007\"B3\n\u0001\u00049\u0017a\u00029sK\u0012L7\r\u001e\u000b\u0003uv\u0004\"\u0001T>\n\u0005ql%A\u0002#pk\ndW\rC\u0003\u007f\u0015\u0001\u0007Q'\u0001\u0005gK\u0006$XO]3t\u0003=\u0001(/\u001a3jGR4\u0016M]5b]\u000e,Gc\u0001>\u0002\u0004!)ap\u0003a\u0001k\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002\n\u0005e\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u0003'I\u0013aA:rY&!\u0011qCA\u0007\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u00037a\u0001\u0019AA\u0005\u0003\u0019\u00198\r[3nC\"*A\"a\b\u0002,A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&%\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI#a\t\u0003\u000bMKgnY3\"\u0005\u00055\u0012!B\u0019/i9\u0002\u0014!\u0003;sC:\u001chm\u001c:n)\u0011\t\u0019$!\u0015\u0011\t\u0005U\u00121\n\b\u0005\u0003o\t9E\u0004\u0003\u0002:\u0005\u0015c\u0002BA\u001e\u0003\u0007rA!!\u0010\u0002B9\u0019a+a\u0010\n\u00039J!\u0001L\u0017\n\u0005)Z\u0013bAA\nS%!\u0011\u0011JA\t\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0014\u0002P\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003\u0013\n\t\u0002C\u0004\u0002T5\u0001\r!!\u0016\u0002\u000f\u0011\fG/Y:fiB\"\u0011qKA2!\u0019\tI&a\u0017\u0002`5\u0011\u0011\u0011C\u0005\u0005\u0003;\n\tBA\u0004ECR\f7/\u001a;\u0011\t\u0005\u0005\u00141\r\u0007\u0001\t1\t)'!\u0015\u0002\u0002\u0003\u0005)\u0011AA4\u0005\ryFEM\t\u0005\u0003S\ny\u0007E\u0002M\u0003WJ1!!\u001cN\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001TA9\u0013\r\t\u0019(\u0014\u0002\u0004\u0003:L\b&B\u0007\u0002 \u0005]\u0014EAA=\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0011\u0019w\u000e]=\u0015\u0007m\ny\bC\u0004\u0002\u0002:\u0001\r!a!\u0002\u000b\u0015DHO]1\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#(\u0003\u0015\u0001\u0018M]1n\u0013\u0011\ti)a\"\u0003\u0011A\u000b'/Y7NCBDSADA\u0010\u0003W\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002'\"*q\"a\b\u0002,\u0005\u0011b-Z1ukJ,\u0017*\u001c9peR\fgnY3t+\u0005)\u0004&\u0002\t\u0002 \u0005]\u0014!\u0002;p\u001f2$WCAAQ!\u0011\t\u0019+a,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bQ!\\8eK2T1aPAV\u0015\r\ti+K\u0001\u0006[2d\u0017NY\u0005\u0004\u0003\u0006\u0015\u0016!B<sSR,WCAA[!\r1\u0015qW\u0005\u0004\u0003s;%\u0001C'M/JLG/\u001a:)\u000bI\ty\"a\u001e)\u000b\u0001\ty\"a\u000b\u00027\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t\u0011Dc\u0005\u0004\u0015\u0003\u000b\fYm\u0013\t\u0004\u0019\u0006\u001d\u0017bAAe\u001b\n1\u0011I\\=SK\u001a\u0004BARAgw%\u0019\u0011qZ$\u0003\u00155c%+Z1eC\ndW\r\u0006\u0002\u0002B\u0006!!/Z1e+\t\t9\u000e\u0005\u0003G\u00033\\\u0014bAAn\u000f\nAQ\n\u0014*fC\u0012,'\u000fK\u0003\u0017\u0003?\t9(\u0001\u0003m_\u0006$GcA\u001e\u0002d\"1\u0011Q]\fA\u0002M\u000bA\u0001]1uQ\"*q#a\b\u0002x\t\tC)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2<&/\u001b;feN\u0019\u0001$!.\u0002\u0011%t7\u000f^1oG\u0016$B!!=\u0002vB\u0019\u00111\u001f\r\u000e\u0003QAa!!<\u001b\u0001\u0004Y\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\u0005m(\u0011\u0001\t\u0004\u0019\u0006u\u0018bAA\u0000\u001b\n!QK\\5u\u0011\u0019\t)o\u0007a\u0001'\n\tC)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN\u0019A$a6\u0015\u0005\t%\u0001cAAz9\u0005I1\r\\1tg:\u000bW.Z\u000b\u0003\u0005\u001f\u0001BA!\u0005\u0003\u001c5\u0011!1\u0003\u0006\u0005\u0005+\u00119\"\u0001\u0003mC:<'B\u0001B\r\u0003\u0011Q\u0017M^1\n\u0007q\u0013\u0019\"\u0001\u0006dY\u0006\u001c8OT1nK\u0002\"2a\u000fB\u0011\u0011\u0019\t)\u000f\ta\u0001'\u00069aM]8n\u001f2$G#C\u001e\u0003(\t-\"Q\u0007B \u0011\u001d\u0011I#\ta\u0001\u0003C\u000b\u0001b\u001c7e\u001b>$W\r\u001c\u0005\b\u0005[\t\u0003\u0019\u0001B\u0018\u0003\u0019\u0001\u0018M]3oiB\u0019!G!\r\n\u0007\tMREA\u000bEK\u000eL7/[8o)J,WMU3he\u0016\u001c8o\u001c:\t\u000f\t]\u0012\u00051\u0001\u0003:\u0005\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB)AKa\u000fhO&\u0019!QH/\u0003\u00075\u000b\u0007\u000fC\u0004fCA\u0005\t\u0019A4\u0002#\u0019\u0014x.\\(mI\u0012\"WMZ1vYR$C'\u0006\u0002\u0003F)\u001aqMa\u0012,\u0005\t%\u0003\u0003\u0002B&\u0005'j!A!\u0014\u000b\t\t=#\u0011K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\nN\u0013\u0011\u0011)F!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006sK\u0006$'+Z:pYZ,GC\u0001B.!\u0011\u0011\tB!\u0018\n\t\t}#1\u0003\u0002\u0007\u001f\nTWm\u0019;)\u000bQ\ty\"a\u001e)\u000bM\ty\"a\u001e")
public class DecisionTreeRegressionModel
extends RegressionModel<Vector, DecisionTreeRegressionModel>
implements DecisionTreeModel,
DecisionTreeRegressorParams,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final Node rootNode;
    private final int numFeatures;
    private final Param<String> varianceCol;
    private final Param<String> impurity;
    private final Param<String> leafCol;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minWeightFractionPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final Param<String> weightCol;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private int depth;
    private int numLeave;
    private NominalAttribute leafAttr;
    private transient Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static DecisionTreeRegressionModel load(String string) {
        return DecisionTreeRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<DecisionTreeRegressionModel> read() {
        return DecisionTreeRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$DecisionTreeRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return DecisionTreeRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getVarianceCol() {
        return HasVarianceCol.getVarianceCol$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public int numNodes() {
        return DecisionTreeModel.numNodes$(this);
    }

    @Override
    public String toDebugString() {
        return DecisionTreeModel.toDebugString$(this);
    }

    @Override
    public int maxSplitFeatureIndex() {
        return DecisionTreeModel.maxSplitFeatureIndex$(this);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return DecisionTreeModel.getLeafField$(this, leafCol);
    }

    @Override
    public double predictLeaf(Vector features) {
        return DecisionTreeModel.predictLeaf$(this, features);
    }

    @Override
    public final Param<String> varianceCol() {
        return this.varianceCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasVarianceCol$_setter_$varianceCol_$eq(Param<String> x$1) {
        this.varianceCol = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    private int depth$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.depth = DecisionTreeModel.depth$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.depth;
    }

    @Override
    public int depth() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.depth$lzycompute() : this.depth;
    }

    private int numLeave$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.numLeave = DecisionTreeModel.numLeave$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.numLeave;
    }

    @Override
    public int numLeave() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.numLeave$lzycompute() : this.numLeave;
    }

    private NominalAttribute leafAttr$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.leafAttr = DecisionTreeModel.leafAttr$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.leafAttr;
    }

    @Override
    public NominalAttribute leafAttr() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.leafAttr$lzycompute() : this.leafAttr;
    }

    private Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices = DecisionTreeModel.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices() {
        return !this.bitmap$trans$0 ? this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute() : this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public Node rootNode() {
        return this.rootNode;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel setVarianceCol(String value) {
        return (DecisionTreeRegressionModel)this.set(this.varianceCol(), value);
    }

    @Override
    public double predict(Vector features) {
        return this.rootNode().predictImpl(features).prediction();
    }

    public double predictVariance(Vector features) {
        return this.rootNode().predictImpl(features).impurityStats().calculate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = super.transformSchema(schema);
            if (this.isDefined(this.varianceCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.varianceCol()))).nonEmpty()) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.varianceCol()));
            }
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)Seq$.MODULE$.empty();
        Seq predictionColumns = (Seq)Seq$.MODULE$.empty();
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (this.isDefined(this.varianceCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.varianceCol()))).nonEmpty()) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictVarianceUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictVariance(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.varianceCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictVarianceUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.varianceCol()), outputSchema.apply(this.$(this.varianceCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictLeaf(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append(this.uid()).append(": DecisionTreeRegressionModel.transform() does nothing").append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public DecisionTreeRegressionModel copy(ParamMap extra) {
        return (DecisionTreeRegressionModel)((Model)this.copyValues(new DecisionTreeRegressionModel(this.uid(), this.rootNode(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(66).append("DecisionTreeRegressionModel: uid=").append(this.uid()).append(", depth=").append(this.depth()).append(", numNodes=").append(this.numNodes()).append(", ").append("numFeatures=").append(this.numFeatures()).toString();
    }

    private Vector featureImportances$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this, this.numFeatures(), ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    @Override
    public org.apache.spark.mllib.tree.model.DecisionTreeModel toOld() {
        return new org.apache.spark.mllib.tree.model.DecisionTreeModel(this.rootNode().toOld(1), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new DecisionTreeRegressionModelWriter(this);
    }

    public DecisionTreeRegressionModel(String uid, Node rootNode, int numFeatures) {
        this.uid = uid;
        this.rootNode = rootNode;
        this.numFeatures = numFeatures;
        DecisionTreeModel.$init$(this);
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        HasVarianceCol.$init$(this);
        DecisionTreeRegressorParams.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(rootNode != null, (Function0 & Serializable & scala.Serializable)() -> "DecisionTreeRegressionModel given null rootNode, but it requires a non-null rootNode.");
    }

    public DecisionTreeRegressionModel(Node rootNode, int numFeatures) {
        this(Identifiable$.MODULE$.randomUID("dtr"), rootNode, numFeatures);
    }

    public static class DecisionTreeRegressionModelReader
    extends MLReader<DecisionTreeRegressionModel> {
        private final String className = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public DecisionTreeRegressionModel load(String path) {
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            Node root = DecisionTreeModelReadWrite$.MODULE$.loadTreeNodes(path, metadata, this.sparkSession());
            DecisionTreeRegressionModel model = new DecisionTreeRegressionModel(metadata.uid(), root, numFeatures);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class DecisionTreeRegressionModelWriter
    extends MLWriter {
        private final DecisionTreeRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            Seq nodeData;
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), (Option<JsonAST.JObject>)new Some((Object)extraMetadata), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Tuple2<Seq<DecisionTreeModelReadWrite.NodeData>, Object> tuple2 = DecisionTreeModelReadWrite$NodeData$.MODULE$.build(this.instance.rootNode(), 0);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq seq = nodeData = (Seq)tuple2._1();
            Seq nodeData2 = seq;
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.tree")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.tree.DecisionTreeModelReadWrite")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(DecisionTreeRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame(nodeData2, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(null))).write().parquet(dataPath);
        }

        public DecisionTreeRegressionModelWriter(DecisionTreeRegressionModel instance) {
            this.instance = instance;
        }
    }
}

