/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleRegressorParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015f\u0001B\u0016-\u0001]B\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0005\u0018\u0005\tQ\u0002\u0011\t\u0011)A\u0005;\"A\u0011\u000e\u0001BC\u0002\u0013%!\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003l\u0011!y\u0007A!b\u0001\n\u0013\u0001\b\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0011Y\u0004!Q1A\u0005B]D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u0007y\u0002!\tAL?\t\rq\u0004A\u0011AA\u0003\u0011\u0019\ty\u0002\u0001C!U\"A\u00111\u0005\u0001C\u0002\u0013\u0005q\u000fC\u0004\u0002,\u0001\u0001\u000b\u0011\u0002=\t\r\u0005=\u0002\u0001\"\u0011q\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!!\u0014\u0001\t\u0003\ny\u0005C\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006BCA\\\u0001!\u0015\r\u0011\"\u0001\u0002:\"A\u0011Q\u0018\u0001\u0005\u00029\ny\fC\u0004\u0002T\u0002!\t!!6\t\u000f\u00055\b\u0001\"\u0011\u0002p\u001e9\u00111 \u0017\t\u0002\u0005uhAB\u0016-\u0011\u0003\ty\u0010\u0003\u0004}3\u0011\u0005!Q\u0002\u0005\b\u0005\u001fIB\u0011\tB\t\u0011\u001d\u0011Y\"\u0007C!\u0005;1qA!\n\u001a\u0001e\u00119\u0003C\u0005\u0003*u\u0011\t\u0011)A\u0005\u0005\"1A0\bC\u0001\u0005WAqAa\r\u001e\t#\u0012)D\u0002\u0004\u0003@e!!\u0011\t\u0005\u0007y\u0006\"\tAa\u0011\t\u0013\t\u001d\u0013E1A\u0005\n\t%\u0003\u0002\u0003B-C\u0001\u0006IAa\u0013\t\u0013\tm\u0013E1A\u0005\n\t%\u0003\u0002\u0003B/C\u0001\u0006IAa\u0013\t\u000f\tm\u0011\u0005\"\u0011\u0003`!A!1M\r\u0005\u00029\u0012)\u0007\u0003\u0006\u0003\u0002f\t\n\u0011\"\u0001/\u0005\u0007C\u0011Ba&\u001a\u0003\u0003%IA!'\u0003%\u001d\u0013EKU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003[9\n!B]3he\u0016\u001c8/[8o\u0015\ty\u0003'\u0001\u0002nY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001A4)S(V!\u0011I$\b\u0010\"\u000e\u00031J!a\u000f\u0017\u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u0018\u0002\r1Lg.\u00197h\u0013\t\teH\u0001\u0004WK\u000e$xN\u001d\t\u0003s\u0001\u0001\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0018\u0002\tQ\u0014X-Z\u0005\u0003\u0011\u0016\u0013!c\u0012\"U%\u0016<'/Z:t_J\u0004\u0016M]1ngB\u0019AI\u0013'\n\u0005-+%!\u0005+sK\u0016,en]3nE2,Wj\u001c3fYB\u0011\u0011(T\u0005\u0003\u001d2\u00121\u0004R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001)T\u001b\u0005\t&B\u0001*/\u0003\u0011)H/\u001b7\n\u0005Q\u000b&AC'M/JLG/\u00192mKB\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\na1+\u001a:jC2L'0\u00192mK\u0006\u0019Q/\u001b3\u0016\u0003u\u0003\"AX3\u000f\u0005}\u001b\u0007C\u00011X\u001b\u0005\t'B\u000127\u0003\u0019a$o\\8u}%\u0011AmV\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e/\u0006!Q/\u001b3!\u0003\u0019yFO]3fgV\t1\u000eE\u0002WY2K!!\\,\u0003\u000b\u0005\u0013(/Y=\u0002\u000f}#(/Z3tA\u0005aq\f\u001e:fK^+\u0017n\u001a5ugV\t\u0011\u000fE\u0002WYJ\u0004\"AV:\n\u0005Q<&A\u0002#pk\ndW-A\u0007`iJ,WmV3jO\"$8\u000fI\u0001\f]Vlg)Z1ukJ,7/F\u0001y!\t1\u00160\u0003\u0002{/\n\u0019\u0011J\u001c;\u0002\u00199,XNR3biV\u0014Xm\u001d\u0011\u0002\rqJg.\u001b;?)\u001d\u0011ep`A\u0001\u0003\u0007AQaW\u0005A\u0002uCQ![\u0005A\u0002-DQa\\\u0005A\u0002EDQA^\u0005A\u0002a$rAQA\u0004\u0003\u0013\tY\u0001C\u0003\\\u0015\u0001\u0007Q\fC\u0003j\u0015\u0001\u00071\u000eC\u0003p\u0015\u0001\u0007\u0011\u000fK\u0003\u000b\u0003\u001f\tY\u0002\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003'\u0011QaU5oG\u0016\f#!!\b\u0002\u000bErCG\f\u0019\u0002\u000bQ\u0014X-Z:)\u000b-\ty!a\u0007\u0002\u0017\u001d,GOT;n)J,Wm\u001d\u0015\u0006\u0019\u0005=\u0011qE\u0011\u0003\u0003S\tQA\r\u00181]A\nAbZ3u\u001dVlGK]3fg\u0002BS!DA\b\u0003O\t1\u0002\u001e:fK^+\u0017n\u001a5ug\"*a\"a\u0004\u0002\u001c\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u00028\u0005\u001d\u0003\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u0003\u0003\u0002\u0014aA:rY&!\u0011QIA\u001e\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003\u0013z\u0001\u0019AA\u001c\u0003\u0019\u00198\r[3nC\"*q\"a\u0004\u0002\u001c\u0005IAO]1og\u001a|'/\u001c\u000b\u0005\u0003#\ny\u0007\u0005\u0003\u0002T\u0005%d\u0002BA+\u0003KrA!a\u0016\u0002d9!\u0011\u0011LA1\u001d\u0011\tY&a\u0018\u000f\u0007\u0001\fi&C\u00016\u0013\t\u0019D'\u0003\u00022e%\u0019\u0011\u0011\t\u0019\n\t\u0005\u001d\u0014qH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY'!\u001c\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA4\u0003\u007fAq!!\u001d\u0011\u0001\u0004\t\u0019(A\u0004eCR\f7/\u001a;1\t\u0005U\u0014\u0011\u0011\t\u0007\u0003o\nI(! \u000e\u0005\u0005}\u0012\u0002BA>\u0003\u007f\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u0000\u0005\u0005E\u0002\u0001\u0003\r\u0003\u0007\u000by'!A\u0001\u0002\u000b\u0005\u0011Q\u0011\u0002\u0004?\u0012\u0012\u0014\u0003BAD\u0003\u001b\u00032AVAE\u0013\r\tYi\u0016\u0002\b\u001d>$\b.\u001b8h!\r1\u0016qR\u0005\u0004\u0003#;&aA!os\u00069\u0001O]3eS\u000e$Hc\u0001:\u0002\u0018\"1\u0011\u0011T\tA\u0002q\n\u0001BZ3biV\u0014Xm]\u0001\u0005G>\u0004\u0018\u0010F\u0002C\u0003?Cq!!)\u0013\u0001\u0004\t\u0019+A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tIKL\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003[\u000b9K\u0001\u0005QCJ\fW.T1qQ\u0015\u0011\u0012qBA\u000e\u0003!!xn\u0015;sS:<G#A/)\u000bM\ty!a\u0007\u0002%\u0019,\u0017\r^;sK&k\u0007o\u001c:uC:\u001cWm]\u000b\u0002y!*A#a\u0004\u0002(\u0005)Ao\\(mIV\u0011\u0011\u0011\u0019\t\u0005\u0003\u0007\fy-\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0015iw\u000eZ3m\u0015\r1\u00151\u001a\u0006\u0004\u0003\u001b\u0004\u0014!B7mY&\u0014\u0017\u0002BAi\u0003\u000b\u0014\u0011d\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001cXj\u001c3fY\u0006)RM^1mk\u0006$X-R1dQ&#XM]1uS>tG#B9\u0002X\u0006\r\bbBA9-\u0001\u0007\u0011\u0011\u001c\u0019\u0005\u00037\fy\u000e\u0005\u0004\u0002x\u0005e\u0014Q\u001c\t\u0005\u0003\u007f\ny\u000e\u0002\u0007\u0002b\u0006]\u0017\u0011!A\u0001\u0006\u0003\t)IA\u0002`IMBa!!:\u0017\u0001\u0004i\u0016\u0001\u00027pgNDSAFA\b\u0003S\f#!a;\u0002\u000bIrCG\f\u0019\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\u0005E\bc\u0001)\u0002t&\u0019\u0011Q_)\u0003\u00115cuK]5uKJDSaFA\b\u0003OAS\u0001AA\b\u00037\t!c\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fYB\u0011\u0011(G\n\u00073\t\u0005!qA+\u0011\u0007Y\u0013\u0019!C\u0002\u0003\u0006]\u0013a!\u00118z%\u00164\u0007\u0003\u0002)\u0003\n\tK1Aa\u0003R\u0005)iEJU3bI\u0006\u0014G.\u001a\u000b\u0003\u0003{\fAA]3bIV\u0011!1\u0003\t\u0005!\nU!)C\u0002\u0003\u0018E\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u00067\u0005=\u0011qE\u0001\u0005Y>\fG\rF\u0002C\u0005?AaA!\t\u001d\u0001\u0004i\u0016\u0001\u00029bi\"DS\u0001HA\b\u0003O\u0011\u0001d\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\ri\u0012\u0011_\u0001\tS:\u001cH/\u00198dKR!!Q\u0006B\u0019!\r\u0011y#H\u0007\u00023!1!\u0011F\u0010A\u0002\t\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0005o\u0011i\u0004E\u0002W\u0005sI1Aa\u000fX\u0005\u0011)f.\u001b;\t\r\t\u0005\u0002\u00051\u0001^\u0005a9%\t\u0016*fOJ,7o]5p]6{G-\u001a7SK\u0006$WM]\n\u0004C\tMAC\u0001B#!\r\u0011y#I\u0001\nG2\f7o\u001d(b[\u0016,\"Aa\u0013\u0011\t\t5#qK\u0007\u0003\u0005\u001fRAA!\u0015\u0003T\u0005!A.\u00198h\u0015\t\u0011)&\u0001\u0003kCZ\f\u0017b\u00014\u0003P\u0005Q1\r\\1tg:\u000bW.\u001a\u0011\u0002\u001bQ\u0014X-Z\"mCN\u001ch*Y7f\u00039!(/Z3DY\u0006\u001c8OT1nK\u0002\"2A\u0011B1\u0011\u0019\u0011\tc\na\u0001;\u00069aM]8n\u001f2$G#\u0003\"\u0003h\t-$Q\u000fB@\u0011\u001d\u0011I\u0007\u000ba\u0001\u0003\u0003\f\u0001b\u001c7e\u001b>$W\r\u001c\u0005\b\u0005[B\u0003\u0019\u0001B8\u0003\u0019\u0001\u0018M]3oiB\u0019\u0011H!\u001d\n\u0007\tMDF\u0001\u0007H\u0005R\u0013Vm\u001a:fgN|'\u000fC\u0004\u0003x!\u0002\rA!\u001f\u0002'\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:\u0011\u000by\u0013Y\b\u001f=\n\u0007\tutMA\u0002NCBDqA\u001e\u0015\u0011\u0002\u0003\u0007\u00010A\tge>lw\n\u001c3%I\u00164\u0017-\u001e7uIQ*\"A!\"+\u0007a\u00149i\u000b\u0002\u0003\nB!!1\u0012BJ\u001b\t\u0011iI\u0003\u0003\u0003\u0010\nE\u0015!C;oG\",7m[3e\u0015\r\t)bV\u0005\u0005\u0005+\u0013iIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1B]3bIJ+7o\u001c7wKR\u0011!1\u0014\t\u0005\u0005\u001b\u0012i*\u0003\u0003\u0003 \n=#AB(cU\u0016\u001cG\u000fK\u0003\u001a\u0003\u001f\t9\u0003K\u0003\u0019\u0003\u001f\t9\u0003")
public class GBTRegressionModel
extends RegressionModel<Vector, GBTRegressionModel>
implements GBTRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int getNumTrees;
    private int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final Param<String> leafCol;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minWeightFractionPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final Param<String> weightCol;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTRegressionModel load(String string) {
        return GBTRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GBTRegressionModel> read() {
        return GBTRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams.getLossType$(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams.getOldLossType$(this);
    }

    @Override
    public Loss convertToOldLossType(String loss) {
        return GBTRegressorParams.convertToOldLossType$(this, loss);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)Seq$.MODULE$.empty();
        Seq predictionColumns = (Seq)Seq$.MODULE$.empty();
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTRegressionModel.class));
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$transform$1(bcastModel, features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.featuresCol()), outputSchema.apply(this.$(this.featuresCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(GBTRegressionModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> ((TreeEnsembleModel)bcastModel.value()).predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append(this.uid()).append(": GBTRegressionModel.transform() does nothing").append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public double predict(Vector features) {
        double[] treePredictions = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$predict$1(features, x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    @Override
    public GBTRegressionModel copy(ParamMap extra) {
        return (GBTRegressionModel)((Model)this.copyValues(new GBTRegressionModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(49).append("GBTRegressionModel: uid=").append(this.uid()).append(", numTrees=").append(this.getNumTrees()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    private Vector featureImportances$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this._treeWeights());
    }

    public double[] evaluateEachIteration(Dataset<?> dataset, String loss) {
        RDD<Instance> data = this.extractInstances(dataset);
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.convertToOldLossType(loss), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new GBTRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transform$1(Broadcast bcastModel$1, Vector features) {
        return ((GBTRegressionModel)bcastModel$1.value()).predict(features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleRegressorParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTRegressorParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "GBTRegressionModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("GBTRegressionModel given trees, treeWeights of").append(" non-matching lengths (").append(this._trees().length).append(", ").append(this._treeWeights().length).append(", respectively).").toString());
        this.getNumTrees = this.trees().length;
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1);
    }

    public static class GBTRegressionModelReader
    extends MLReader<GBTRegressionModel> {
        private final String className = GBTRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("GBTRegressionModel.load expected ").append(numTrees).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString());
            GBTRegressionModel model = new GBTRegressionModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTRegressionModelWriter
    extends MLWriter {
        private final GBTRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTRegressionModelWriter(GBTRegressionModel instance) {
            this.instance = instance;
        }
    }
}

