/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.r.MultilayerPerceptronClassifierWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class MultilayerPerceptronClassifierWrapper$
implements MLReadable<MultilayerPerceptronClassifierWrapper> {
    public static MultilayerPerceptronClassifierWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new MultilayerPerceptronClassifierWrapper$();
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public MultilayerPerceptronClassifierWrapper fit(Dataset<Row> data, String formula, int blockSize, int[] layers, String solver, int maxIter, double tol, double stepSize, String seed, double[] initialWeights, String handleInvalid) {
        Object object;
        String[] labels;
        RFormula rFormula = new RFormula().setFormula(formula).setForceIndexLabel(true).setHandleInvalid(handleInvalid);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        Tuple2<String[], String[]> tuple2 = RWrapperUtils$.MODULE$.getFeaturesAndLabels((RFormulaModel)rFormulaModel, data);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] stringArray = labels = (String[])tuple2._2();
        String[] labels2 = stringArray;
        MultilayerPerceptronClassifier mlp = (MultilayerPerceptronClassifier)((Predictor)((Predictor)new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(blockSize).setSolver(solver).setMaxIter(maxIter).setTol(tol).setStepSize(stepSize).setFeaturesCol(rFormula.getFeaturesCol())).setLabelCol(rFormula.getLabelCol())).setPredictionCol(this.PREDICTED_LABEL_INDEX_COL());
        Object object2 = seed != null && seed.length() > 0 ? mlp.setSeed(new StringOps(Predef$.MODULE$.augmentString(seed)).toInt()) : BoxedUnit.UNIT;
        if (initialWeights != null) {
            Predef$.MODULE$.require(initialWeights.length > 0);
            object = mlp.setInitialWeights(Vectors$.MODULE$.dense(initialWeights));
        } else {
            object = BoxedUnit.UNIT;
        }
        IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels2);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, mlp, idxToStr})).fit((Dataset)data);
        return new MultilayerPerceptronClassifierWrapper((PipelineModel)pipeline);
    }

    @Override
    public MLReader<MultilayerPerceptronClassifierWrapper> read() {
        return new MultilayerPerceptronClassifierWrapper.MultilayerPerceptronClassifierWrapperReader();
    }

    @Override
    public MultilayerPerceptronClassifierWrapper load(String path) {
        return (MultilayerPerceptronClassifierWrapper)MLReadable.load$(this, path);
    }

    private MultilayerPerceptronClassifierWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

