/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001\u0002\u001f>\u0001!C\u0001\u0002\u0017\u0001\u0003\u0002\u0004%I!\u0017\u0005\t;\u0002\u0011\t\u0019!C\u0005=\"AA\r\u0001B\u0001B\u0003&!\f\u0003\u0005f\u0001\t\u0005\r\u0011\"\u0003Z\u0011!1\u0007A!a\u0001\n\u00139\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0015\u0002.\t\u0011)\u0004!\u00111A\u0005\n-D\u0001b\u001e\u0001\u0003\u0002\u0004%I\u0001\u001f\u0005\tu\u0002\u0011\t\u0011)Q\u0005Y\"A1\u0010\u0001BA\u0002\u0013%\u0011\f\u0003\u0005}\u0001\t\u0005\r\u0011\"\u0003~\u0011!y\bA!A!B\u0013Q\u0006BCA\u0001\u0001\t\u0005\r\u0011\"\u0003\u0002\u0004!Q\u00111\u0002\u0001\u0003\u0002\u0004%I!!\u0004\t\u0015\u0005E\u0001A!A!B\u0013\t)\u0001\u0003\u0006\u0002\u0014\u0001\u0011\t\u0019!C\u0005\u0003+A!\"!\b\u0001\u0005\u0003\u0007I\u0011BA\u0010\u0011)\t\u0019\u0003\u0001B\u0001B\u0003&\u0011q\u0003\u0005\n\u0003K\u0001!\u00111A\u0005\n-D!\"a\n\u0001\u0005\u0003\u0007I\u0011BA\u0015\u0011%\ti\u0003\u0001B\u0001B\u0003&A\u000eC\u0004\u00020\u0001!I!!\r\t\u000f\u0005=\u0002\u0001\"\u0003\u0002F!9\u0011q\u0006\u0001\u0005\u0002\u0005\u0015\u0004BBA5\u0001\u0011\u0005\u0011\fC\u0004\u0002r\u0001!\t!a\u001d\t\r\u0005m\u0004\u0001\"\u0001Z\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003Ca!a\"\u0001\t\u0003Y\u0007bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\u0007\u0003'\u0003A\u0011A-\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011q\u0014\u0001\u0005\u0002\u0005\r\u0001bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003W\u0003A\u0011AA\u000b\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCa!a.\u0001\t\u0003Y\u0007bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\n\u0003\u000f\u0004\u0001\u0019!C\u0005\u0003\u0013D\u0011\"a6\u0001\u0001\u0004%I!!7\t\u0011\u0005u\u0007\u0001)Q\u0005\u0003\u0017Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002j\u0002!\t!a;\t\u0011\t-\u0001\u0001\"\u0001B\u0005\u001bAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003L\u0001!IA!\u0014\t\u0011\t]\u0003\u0001\"\u0001>\u00053:qA!\u001b>\u0011\u0003\u0011YG\u0002\u0004={!\u0005!Q\u000e\u0005\b\u0003_\tD\u0011\u0001B8\u0011%\u0011\t(\rb\u0001\n\u0003\u0011\u0019\b\u0003\u0005\u0003\u0006F\u0002\u000b\u0011\u0002B;\u0011%\u0011I)\rb\u0001\n\u0003\u0011\u0019\b\u0003\u0005\u0003\u000eF\u0002\u000b\u0011\u0002B;\u0011\u001d\u0011\t*\rC\u0001\u0005'CqA!%2\t\u0003\u0011)\u000bC\u0004\u0003\u0012F\"\tA!-\t\u0011\tm\u0016\u0007\"\u0001B\u0005{C\u0011Ba12\u0003\u0003%IA!2\u0003\r-kU-\u00198t\u0015\tqt(\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!\u0001Q!\u0002\u000b5dG.\u001b2\u000b\u0005\t\u001b\u0015!B:qCJ\\'B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0013>\u0013\u0006C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB!osJ+g\r\u0005\u0002K!&\u0011\u0011k\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0006\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003/R\u0013q\u0001T8hO&tw-A\u0001l+\u0005Q\u0006C\u0001&\\\u0013\ta6JA\u0002J]R\fQa[0%KF$\"a\u00182\u0011\u0005)\u0003\u0017BA1L\u0005\u0011)f.\u001b;\t\u000f\r\u0014\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002\u0005-\u0004\u0013!D7bq&#XM]1uS>t7/A\tnCbLE/\u001a:bi&|gn]0%KF$\"a\u00185\t\u000f\r,\u0011\u0011!a\u00015\u0006qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0013AE5oSRL\u0017\r\\5{CRLwN\\'pI\u0016,\u0012\u0001\u001c\t\u0003[Rt!A\u001c:\u0011\u0005=\\U\"\u00019\u000b\u0005E<\u0015A\u0002\u001fs_>$h(\u0003\u0002t\u0017\u00061\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u00198*\u0001\fj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,w\fJ3r)\ty\u0016\u0010C\u0004d\u0011\u0005\u0005\t\u0019\u00017\u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0011\u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:\u0002/%t\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:`I\u0015\fHCA0\u007f\u0011\u001d\u00197\"!AA\u0002i\u000bA#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faN\u0004\u0013aB3qg&dwN\\\u000b\u0003\u0003\u000b\u00012ASA\u0004\u0013\r\tIa\u0013\u0002\u0007\t>,(\r\\3\u0002\u0017\u0015\u00048/\u001b7p]~#S-\u001d\u000b\u0004?\u0006=\u0001\u0002C2\u000f\u0003\u0003\u0005\r!!\u0002\u0002\u0011\u0015\u00048/\u001b7p]\u0002\nAa]3fIV\u0011\u0011q\u0003\t\u0004\u0015\u0006e\u0011bAA\u000e\u0017\n!Aj\u001c8h\u0003!\u0019X-\u001a3`I\u0015\fHcA0\u0002\"!A1-EA\u0001\u0002\u0004\t9\"A\u0003tK\u0016$\u0007%A\beSN$\u0018M\\2f\u001b\u0016\f7/\u001e:f\u0003M!\u0017n\u001d;b]\u000e,W*Z1tkJ,w\fJ3r)\ry\u00161\u0006\u0005\bGR\t\t\u00111\u0001m\u0003A!\u0017n\u001d;b]\u000e,W*Z1tkJ,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003g\t9$!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\u00022!!\u000e\u0001\u001b\u0005i\u0004\"\u0002-\u0017\u0001\u0004Q\u0006\"B3\u0017\u0001\u0004Q\u0006\"\u00026\u0017\u0001\u0004a\u0007\"B>\u0017\u0001\u0004Q\u0006bBA\u0001-\u0001\u0007\u0011Q\u0001\u0005\b\u0003'1\u0002\u0019AA\f\u0011\u0019\t)C\u0006a\u0001YRq\u00111GA$\u0003\u0013\nY%!\u0014\u0002P\u0005E\u0003\"\u0002-\u0018\u0001\u0004Q\u0006\"B3\u0018\u0001\u0004Q\u0006\"\u00026\u0018\u0001\u0004a\u0007\"B>\u0018\u0001\u0004Q\u0006bBA\u0001/\u0001\u0007\u0011Q\u0001\u0005\b\u0003'9\u0002\u0019AA\fQ\u00159\u0012QKA1!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013\u0011\f\u0002\u0006'&t7-Z\u0011\u0003\u0003G\nQ\u0001\r\u00189]A\"\"!a\r)\u000ba\t)&!\u0019\u0002\t\u001d,Go\u0013\u0015\u00063\u0005U\u0013QN\u0011\u0003\u0003_\nQ!\r\u00185]A\nAa]3u\u0017R!\u0011QOA<\u001b\u0005\u0001\u0001\"\u0002-\u001b\u0001\u0004Q\u0006&\u0002\u000e\u0002V\u0005\u0005\u0014\u0001E4fi6\u000b\u00070\u0013;fe\u0006$\u0018n\u001c8tQ\u0015Y\u0012QKA7\u0003A\u0019X\r^'bq&#XM]1uS>t7\u000f\u0006\u0003\u0002v\u0005\r\u0005\"B3\u001d\u0001\u0004Q\u0006&\u0002\u000f\u0002V\u0005\u0005\u0014!F4fi&s\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0015\u0006;\u0005U\u0013QN\u0001\u0016g\u0016$\u0018J\\5uS\u0006d\u0017N_1uS>tWj\u001c3f)\u0011\t)(a$\t\u000b)t\u0002\u0019\u00017)\u000by\t)&!\u0019\u0002-\u001d,G/\u00138ji&\fG.\u001b>bi&|gn\u0015;faNDSaHA+\u0003[\nac]3u\u0013:LG/[1mSj\fG/[8o'R,\u0007o\u001d\u000b\u0005\u0003k\nY\nC\u0003|A\u0001\u0007!\fK\u0003!\u0003+\n\t'\u0001\u0006hKR,\u0005o]5m_:DS!IA+\u0003[\n!b]3u\u000bB\u001c\u0018\u000e\\8o)\u0011\t)(a*\t\u000f\u0005\u0005!\u00051\u0001\u0002\u0006!*!%!\u0016\u0002b\u00059q-\u001a;TK\u0016$\u0007&B\u0012\u0002V\u00055\u0014aB:fiN+W\r\u001a\u000b\u0005\u0003k\n\u0019\fC\u0004\u0002\u0014\u0011\u0002\r!a\u0006)\u000b\u0011\n)&!\u001c\u0002%\u001d,G\u000fR5ti\u0006t7-Z'fCN,(/\u001a\u0015\u0006K\u0005U\u00131X\u0011\u0003\u0003{\u000bQA\r\u00185]A\n!c]3u\t&\u001cH/\u00198dK6+\u0017m];sKR!\u0011QOAb\u0011\u0019\t)C\na\u0001Y\"*a%!\u0016\u0002<\u0006a\u0011N\\5uS\u0006dWj\u001c3fYV\u0011\u00111\u001a\t\u0006\u0015\u00065\u0017\u0011[\u0005\u0004\u0003\u001f\\%AB(qi&|g\u000e\u0005\u0003\u00026\u0005M\u0017bAAk{\tY1*T3b]Nlu\u000eZ3m\u0003AIg.\u001b;jC2lu\u000eZ3m?\u0012*\u0017\u000fF\u0002`\u00037D\u0001b\u0019\u0015\u0002\u0002\u0003\u0007\u00111Z\u0001\u000eS:LG/[1m\u001b>$W\r\u001c\u0011\u0002\u001fM,G/\u00138ji&\fG.T8eK2$B!!\u001e\u0002d\"9\u0011Q\u001d\u0016A\u0002\u0005E\u0017!B7pI\u0016d\u0007&\u0002\u0016\u0002V\u00055\u0014a\u0001:v]R!\u0011\u0011[Aw\u0011\u001d\tyo\u000ba\u0001\u0003c\fA\u0001Z1uCB1\u00111_A}\u0003{l!!!>\u000b\u0007\u0005]\u0018)A\u0002sI\u0012LA!a?\u0002v\n\u0019!\u000b\u0012#\u0011\t\u0005}(QA\u0007\u0003\u0005\u0003Q1Aa\u0001@\u0003\u0019a\u0017N\\1mO&!!q\u0001B\u0001\u0005\u00191Vm\u0019;pe\"*1&!\u0016\u0002b\u0005i!/\u001e8XSRDw+Z5hQR$\u0002\"!5\u0003\u0010\tm!Q\u0005\u0005\b\u0005#a\u0003\u0019\u0001B\n\u0003%Ign\u001d;b]\u000e,7\u000f\u0005\u0004\u0002t\u0006e(Q\u0003\t\b\u0015\n]\u0011Q`A\u0003\u0013\r\u0011Ib\u0013\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\tuA\u00061\u0001\u0003 \u0005\t\u0002.\u00198eY\u0016\u0004VM]:jgR,gnY3\u0011\u0007)\u0013\t#C\u0002\u0003$-\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003(1\u0002\rA!\u000b\u0002\u000b%t7\u000f\u001e:\u0011\u000b)\u000biMa\u000b\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u0005!Q\u000f^5m\u0015\r\u0011)$Q\u0001\u0003[2LAA!\u000f\u00030\ty\u0011J\\:ueVlWM\u001c;bi&|g.\u0001\fsk:\fEnZ8sSRDWnV5uQ^+\u0017n\u001a5u)\u0019\t\tNa\u0010\u0003J!9\u0011q^\u0017A\u0002\t\u0005\u0003CBAz\u0003s\u0014\u0019\u0005\u0005\u0003\u00026\t\u0015\u0013b\u0001B${\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007b\u0002B\u0014[\u0001\u0007!\u0011F\u0001\u000bS:LGOU1oI>lG\u0003\u0002B(\u0005+\u0002RA\u0013B)\u0005\u0007J1Aa\u0015L\u0005\u0015\t%O]1z\u0011\u001d\tyO\fa\u0001\u0005\u0003\n!#\u001b8ji.kU-\u00198t!\u0006\u0014\u0018\r\u001c7fYR1!q\nB.\u0005;Bq!a<0\u0001\u0004\u0011\t\u0005C\u0004\u0003`=\u0002\rA!\u0019\u0002/\u0011L7\u000f^1oG\u0016lU-Y:ve\u0016Len\u001d;b]\u000e,\u0007\u0003BA\u001b\u0005GJ1A!\u001a>\u0005=!\u0015n\u001d;b]\u000e,W*Z1tkJ,\u0007&\u0002\u0001\u0002V\u0005\u0005\u0014AB&NK\u0006t7\u000fE\u0002\u00026E\u001a2!M%P)\t\u0011Y'\u0001\u0004S\u0003:#u*T\u000b\u0003\u0005k\u0002BAa\u001e\u0003\u00026\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(\u0001\u0003mC:<'B\u0001B@\u0003\u0011Q\u0017M^1\n\u0007U\u0014I\bK\u00034\u0003+\n\t'A\u0004S\u0003:#u*\u0014\u0011)\u000bQ\n)&!\u0019\u0002!-{V*R!O'~\u0003\u0016IU!M\u0019\u0016c\u0005&B\u001b\u0002V\u0005\u0005\u0014!E&`\u001b\u0016\u000bejU0Q\u0003J\u000bE\nT#MA!*a'!\u0016\u0002b\u0005)AO]1j]Ra\u0011\u0011\u001bBK\u0005/\u0013IJa'\u0003\u001e\"9\u0011q^\u001cA\u0002\u0005E\b\"\u0002-8\u0001\u0004Q\u0006\"B38\u0001\u0004Q\u0006\"\u000268\u0001\u0004a\u0007bBA\no\u0001\u0007\u0011q\u0003\u0015\u0006o\u0005U#\u0011U\u0011\u0003\u0005G\u000bQA\r\u00182]A\"\"\"!5\u0003(\n%&1\u0016BW\u0011\u001d\ty\u000f\u000fa\u0001\u0003cDQ\u0001\u0017\u001dA\u0002iCQ!\u001a\u001dA\u0002iCQA\u001b\u001dA\u00021DS\u0001OA+\u0005C#\u0002\"!5\u00034\nU&q\u0017\u0005\b\u0003_L\u0004\u0019AAy\u0011\u0015A\u0016\b1\u0001[\u0011\u0015)\u0017\b1\u0001[Q\u0015I\u0014QKA1\u0003A1\u0018\r\\5eCR,\u0017J\\5u\u001b>$W\r\u0006\u0003\u0003 \t}\u0006B\u0002Bau\u0001\u0007A.\u0001\u0005j]&$Xj\u001c3f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0007\u0003\u0002B<\u0005\u0013LAAa3\u0003z\t1qJ\u00196fGRDS!MA+\u0003CBS\u0001MA+\u0003C\u0002")
public class KMeans
implements scala.Serializable,
Logging {
    private int k;
    private int maxIterations;
    private String initializationMode;
    private int initializationSteps;
    private double epsilon;
    private long seed;
    private String distanceMeasure;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initializationMode() {
        return this.initializationMode;
    }

    private void initializationMode_$eq(String x$1) {
        this.initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    private double epsilon() {
        return this.epsilon;
    }

    private void epsilon_$eq(double x$1) {
        this.epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public int getK() {
        return this.k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.initializationMode_$eq(initializationMode);
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Number of initialization steps must be positive but got ").append(initializationSteps).toString());
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Distance threshold must be nonnegative but got ").append(epsilon).toString());
        this.epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public KMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.k(), (Function0 & Serializable & scala.Serializable)() -> "mismatched cluster count");
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        RDD instances = data.map((Function1 & Serializable & scala.Serializable)point -> new Tuple2(point, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class));
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.runWithWeight((RDD<Tuple2<Vector, Object>>)instances, handlePersistence, (Option<Instrumentation>)None$.MODULE$);
    }

    public KMeansModel runWithWeight(RDD<Tuple2<Vector, Object>> instances, boolean handlePersistence, Option<Instrumentation> instr) {
        RDD norms = instances.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$runWithWeight$1(x0$1)), ClassTag$.MODULE$.Double());
        RDD vectors = instances.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            double norm;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    norm = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Vector v = (Vector)tuple2._1();
            double w = tuple2._2$mcD$sp();
            VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm, w);
            return vectorWithNorm;
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        RDD rDD = handlePersistence ? vectors.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : norms.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        KMeansModel model = this.runAlgorithmWithWeight((RDD<VectorWithNorm>)vectors, instr);
        RDD rDD2 = handlePersistence ? vectors.unpersist(vectors.unpersist$default$1()) : norms.unpersist(norms.unpersist$default$1());
        return model;
    }

    private KMeansModel runAlgorithmWithWeight(RDD<VectorWithNorm> data, Option<Instrumentation> instr) {
        boolean shouldDistributed;
        VectorWithNorm[] vectorWithNormArray;
        SparkContext sc = data.sparkContext();
        long initStartTime = System.nanoTime();
        DistanceMeasure distanceMeasureInstance = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        Option<KMeansModel> option = this.initialModel();
        if (option instanceof Some) {
            Some some = (Some)option;
            KMeansModel kMeansCenters = (KMeansModel)some.value();
            vectorWithNormArray = (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters())).map((Function1 & Serializable & scala.Serializable)x$1 -> new VectorWithNorm((Vector)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
        } else if (None$.MODULE$.equals(option)) {
            String string = this.initializationMode();
            String string2 = KMeans$.MODULE$.RANDOM();
            vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data, distanceMeasureInstance);
        } else {
            throw new MatchError(option);
        }
        VectorWithNorm[] centers = vectorWithNormArray;
        int numFeatures = ((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).head()).vector().size();
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String arg$macro$1 = this.initializationMode();
            double arg$macro$2 = initTimeInSeconds;
            return new StringOps("Initialization with %s took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        });
        BooleanRef converged = BooleanRef.create((boolean)false);
        DoubleRef cost = DoubleRef.create((double)0.0);
        IntRef iteration = IntRef.create((int)0);
        long iterationStartTime = System.nanoTime();
        instr.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.logNumFeatures(numFeatures);
            return BoxedUnit.UNIT;
        });
        boolean bl = shouldDistributed = (long)(centers.length * centers.length) * (long)numFeatures > 1000000L;
        while (iteration.elem < this.maxIterations() && !converged.elem) {
            Broadcast bcCenters = sc.broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            double[] stats = shouldDistributed ? distanceMeasureInstance.computeStatisticsDistributedly(sc, (Broadcast<VectorWithNorm[]>)bcCenters) : distanceMeasureInstance.computeStatistics(centers);
            Broadcast bcStats = sc.broadcast((Object)stats, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            DoubleAccumulator costAccum = sc.doubleAccumulator();
            Map collected = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1 & Serializable & scala.Serializable)points -> {
                VectorWithNorm[] centers = (VectorWithNorm[])bcCenters.value();
                double[] stats = (double[])bcStats.value();
                int dims = ((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).head()).vector().size();
                Vector[] sums = (Vector[])Array$.MODULE$.fill(centers.length, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.zeros(dims), ClassTag$.MODULE$.apply(Vector.class));
                double[] clusterWeightSum = (double[])Array$.MODULE$.ofDim(centers.length, ClassTag$.MODULE$.Double());
                points.foreach((Function1 & Serializable & scala.Serializable)point -> {
                    KMeans.$anonfun$runAlgorithmWithWeight$6(distanceMeasureInstance, centers, stats, costAccum, sums, clusterWeightSum, point);
                    return BoxedUnit.UNIT;
                });
                return package$.MODULE$.Iterator().tabulate(centers.length, (Function1 & Serializable & scala.Serializable)j -> KMeans.$anonfun$runAlgorithmWithWeight$7(sums, clusterWeightSum, BoxesRunTime.unboxToInt((Object)j))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$runAlgorithmWithWeight$8(x$4)));
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(sumweight1, sumweight2) -> {
                BLAS$.MODULE$.axpy(1.0, (Vector)sumweight2._1(), (Vector)sumweight1._1());
                return new Tuple2(sumweight1._1(), (Object)BoxesRunTime.boxToDouble((double)(sumweight1._2$mcD$sp() + sumweight2._2$mcD$sp())));
            }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            if (iteration.elem == 0) {
                instr.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.logNumExamples(costAccum.count());
                    return BoxedUnit.UNIT;
                });
                instr.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    x$6.logSumOfWeights(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)collected.values().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)x$7._2$mcD$sp()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                    return BoxedUnit.UNIT;
                });
            }
            bcCenters.destroy();
            bcStats.destroy();
            converged.elem = true;
            collected.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KMeans.$anonfun$runAlgorithmWithWeight$13(this, distanceMeasureInstance, converged, centers, x0$1);
                return BoxedUnit.UNIT;
            });
            cost.elem = Predef$.MODULE$.Double2double(costAccum.value());
            instr.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.logNamedValue(new StringBuilder(10).append("Cost@iter=").append(iteration.elem).toString(), String.valueOf(BoxesRunTime.boxToDouble((double)cost.elem)));
                return BoxedUnit.UNIT;
            });
            ++iteration.elem;
        }
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            double arg$macro$3 = iterationTimeInSeconds;
            return new StringOps("Iterations took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
        });
        if (iteration.elem == this.maxIterations()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("KMeans reached the max number of iterations: ").append(this.maxIterations()).append(".").toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("KMeans converged in ").append(iteration$1.elem).append(" iterations.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("The cost is ").append(cost$1.elem).append(".").toString());
        return new KMeansModel((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))), this.distanceMeasure(), cost.elem, iteration.elem);
    }

    private VectorWithNorm[] initRandom(RDD<VectorWithNorm> data) {
        return (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.takeSample(false, this.k(), (long)new XORShiftRandom(this.seed()).nextInt()))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))))).distinct())).map((Function1 & Serializable & scala.Serializable)x$11 -> new VectorWithNorm((Vector)x$11), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
    }

    public VectorWithNorm[] initKMeansParallel(RDD<VectorWithNorm> data, DistanceMeasure distanceMeasureInstance) {
        VectorWithNorm[] vectorWithNormArray;
        RDD costs = data.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$1(x$12)), ClassTag$.MODULE$.Double());
        int seed = new XORShiftRandom(this.seed()).nextInt();
        VectorWithNorm[] sample = (VectorWithNorm[])data.takeSample(false, 1, (long)seed);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("No samples available from ").append(data).toString());
        ArrayBuffer centers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        VectorWithNorm[] newCenters = (VectorWithNorm[])((Object[])new VectorWithNorm[]{((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).head()).toDense()});
        centers.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newCenters)));
        IntRef step = IntRef.create((int)0);
        ArrayBuffer bcNewCentersList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            bcNewCentersList.$plus$eq((Object)bcNewCenters);
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$3(distanceMeasureInstance, bcNewCenters, x0$1)), ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double sumCosts = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(costs).sum();
            bcNewCenters.unpersist();
            preCosts.unpersist(preCosts.unpersist$default$1());
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.Double());
            Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(index, pointCosts) -> KMeans.$anonfun$initKMeansParallel$4(this, seed, step, sumCosts, BoxesRunTime.unboxToInt((Object)index), pointCosts);
            boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
            VectorWithNorm[] chosen = (VectorWithNorm[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(VectorWithNorm.class)).collect();
            newCenters = (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chosen)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toDense(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
            centers.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newCenters)));
            ++step.elem;
        }
        RDD qual$2 = costs;
        boolean x$3 = qual$2.unpersist$default$1();
        qual$2.unpersist(x$3);
        bcNewCentersList.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.destroy();
            return BoxedUnit.UNIT;
        });
        VectorWithNorm[] distinctCenters = (VectorWithNorm[])((TraversableOnce)((TraversableLike)((SeqLike)centers.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.vector(), ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$17 -> new VectorWithNorm((Vector)x$17), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
        if (distinctCenters.length <= this.k()) {
            vectorWithNormArray = distinctCenters;
        } else {
            Broadcast bcCenters = data.context().broadcast((Object)distinctCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            Map countMap = data.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)KMeans.$anonfun$initKMeansParallel$11(distanceMeasureInstance, bcCenters, x$18)), ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            bcCenters.destroy();
            double[] myWeights = (double[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distinctCenters)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$19 -> BoxesRunTime.unboxToLong((Object)countMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)x$19), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            vectorWithNormArray = LocalKMeans$.MODULE$.kMeansPlusPlus(0, distinctCenters, myWeights, this.k(), 30);
        }
        return vectorWithNormArray;
    }

    public static final /* synthetic */ double $anonfun$runWithWeight$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector v = (Vector)tuple2._1();
        double d = Vectors$.MODULE$.norm(v, 2.0);
        return d;
    }

    public static final /* synthetic */ void $anonfun$runAlgorithmWithWeight$6(DistanceMeasure distanceMeasureInstance$1, VectorWithNorm[] centers$1, double[] stats$1, DoubleAccumulator costAccum$1, Vector[] sums$1, double[] clusterWeightSum$1, VectorWithNorm point) {
        Tuple2<Object, Object> tuple2 = distanceMeasureInstance$1.findClosest(centers$1, stats$1, point);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bestCenter = tuple2._1$mcI$sp();
        double cost = tuple2._2$mcD$sp();
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(bestCenter, cost);
        Tuple2.mcID.sp sp3 = sp2;
        int bestCenter2 = sp3._1$mcI$sp();
        double cost2 = sp3._2$mcD$sp();
        costAccum$1.add(cost2 * point.weight());
        distanceMeasureInstance$1.updateClusterSum(point, sums$1[bestCenter2]);
        clusterWeightSum$1[bestCenter2] = clusterWeightSum$1[bestCenter2] + point.weight();
    }

    public static final /* synthetic */ Tuple2 $anonfun$runAlgorithmWithWeight$7(Vector[] sums$1, double[] clusterWeightSum$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple2((Object)sums$1[j], (Object)BoxesRunTime.boxToDouble((double)clusterWeightSum$1[j])));
    }

    public static final /* synthetic */ boolean $anonfun$runAlgorithmWithWeight$8(Tuple2 x$4) {
        return ((Tuple2)x$4._2())._2$mcD$sp() > 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$runAlgorithmWithWeight$13(KMeans $this, DistanceMeasure distanceMeasureInstance$1, BooleanRef converged$1, VectorWithNorm[] centers$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int j = tuple2._1$mcI$sp();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Vector sum = (Vector)tuple22._1();
        double weightSum = tuple22._2$mcD$sp();
        VectorWithNorm newCenter = distanceMeasureInstance$1.centroid(sum, weightSum);
        if (converged$1.elem && !distanceMeasureInstance$1.isCenterConverged(centers$2[j], newCenter, $this.epsilon())) {
            converged$1.elem = false;
        }
        centers$2[j] = newCenter;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$1(VectorWithNorm x$12) {
        return Double.POSITIVE_INFINITY;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$3(DistanceMeasure distanceMeasureInstance$2, Broadcast bcNewCenters$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        VectorWithNorm point = (VectorWithNorm)tuple2._1();
        double cost = tuple2._2$mcD$sp();
        double d = scala.math.package$.MODULE$.min(distanceMeasureInstance$2.pointCost((VectorWithNorm[])bcNewCenters$1.value(), point), cost);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$initKMeansParallel$5(KMeans $this, XORShiftRandom rand$1, double sumCosts$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double c = tuple2._2$mcD$sp();
        boolean bl = rand$1.nextDouble() < 2.0 * c * (double)$this.k() / sumCosts$1;
        return bl;
    }

    public static final /* synthetic */ Iterator $anonfun$initKMeansParallel$4(KMeans $this, int seed$1, IntRef step$1, double sumCosts$1, int index, Iterator pointCosts) {
        XORShiftRandom rand = new XORShiftRandom((long)(seed$1 ^ step$1.elem << 16 ^ index));
        return pointCosts.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$initKMeansParallel$5($this, rand, sumCosts$1, x0$2))).map((Function1 & Serializable & scala.Serializable)x$13 -> (VectorWithNorm)x$13._1());
    }

    public static final /* synthetic */ int $anonfun$initKMeansParallel$11(DistanceMeasure distanceMeasureInstance$2, Broadcast bcCenters$2, VectorWithNorm x$18) {
        return distanceMeasureInstance$2.findClosest((VectorWithNorm[])bcCenters$2.value(), x$18)._1$mcI$sp();
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.epsilon = epsilon;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this(k, maxIterations, initializationMode, initializationSteps, epsilon, seed, DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public KMeans() {
        this(2, 20, KMeans$.MODULE$.K_MEANS_PARALLEL(), 2, 1.0E-4, Utils$.MODULE$.random().nextLong(), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }
}

