/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.sparkproject.dmg.pmml.BinarySimilarity;
import org.sparkproject.dmg.pmml.Chebychev;
import org.sparkproject.dmg.pmml.CityBlock;
import org.sparkproject.dmg.pmml.CompareFunction;
import org.sparkproject.dmg.pmml.Euclidean;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.Jaccard;
import org.sparkproject.dmg.pmml.Measure;
import org.sparkproject.dmg.pmml.Minkowski;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.SimpleMatching;
import org.sparkproject.dmg.pmml.SquaredEuclidean;
import org.sparkproject.dmg.pmml.StringValue;
import org.sparkproject.dmg.pmml.Tanimoto;
import org.sparkproject.dmg.pmml.Visitable;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "measure"})
@XmlRootElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"kind", "compareFunction", "minimum", "maximum", "extensions", "measure"})
public class ComparisonMeasure
extends PMMLObject
implements HasExtensions<ComparisonMeasure> {
    @XmlAttribute(name="kind", required=true)
    @JsonProperty(value="kind")
    private Kind kind;
    @XmlAttribute(name="compareFunction")
    @JsonProperty(value="compareFunction")
    private CompareFunction compareFunction;
    @XmlAttribute(name="minimum")
    @JsonProperty(value="minimum")
    private Double minimum;
    @XmlAttribute(name="maximum")
    @JsonProperty(value="maximum")
    private Double maximum;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="euclidean", namespace="http://www.dmg.org/PMML-4_3", type=Euclidean.class), @XmlElement(name="squaredEuclidean", namespace="http://www.dmg.org/PMML-4_3", type=SquaredEuclidean.class), @XmlElement(name="chebychev", namespace="http://www.dmg.org/PMML-4_3", type=Chebychev.class), @XmlElement(name="cityBlock", namespace="http://www.dmg.org/PMML-4_3", type=CityBlock.class), @XmlElement(name="minkowski", namespace="http://www.dmg.org/PMML-4_3", type=Minkowski.class), @XmlElement(name="simpleMatching", namespace="http://www.dmg.org/PMML-4_3", type=SimpleMatching.class), @XmlElement(name="jaccard", namespace="http://www.dmg.org/PMML-4_3", type=Jaccard.class), @XmlElement(name="tanimoto", namespace="http://www.dmg.org/PMML-4_3", type=Tanimoto.class), @XmlElement(name="binarySimilarity", namespace="http://www.dmg.org/PMML-4_3", type=BinarySimilarity.class)})
    @JsonProperty(value="Measure")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="Euclidean", value=Euclidean.class), @JsonSubTypes.Type(name="SquaredEuclidean", value=SquaredEuclidean.class), @JsonSubTypes.Type(name="Chebychev", value=Chebychev.class), @JsonSubTypes.Type(name="CityBlock", value=CityBlock.class), @JsonSubTypes.Type(name="Minkowski", value=Minkowski.class), @JsonSubTypes.Type(name="SimpleMatching", value=SimpleMatching.class), @JsonSubTypes.Type(name="Jaccard", value=Jaccard.class), @JsonSubTypes.Type(name="Tanimoto", value=Tanimoto.class), @JsonSubTypes.Type(name="BinarySimilarity", value=BinarySimilarity.class)})
    private Measure measure;
    private static final long serialVersionUID = 67305485L;

    public ComparisonMeasure() {
    }

    public ComparisonMeasure(@Property(value="kind") Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public ComparisonMeasure setKind(@Property(value="kind") Kind kind) {
        this.kind = kind;
        return this;
    }

    public CompareFunction getCompareFunction() {
        if (this.compareFunction == null) {
            return CompareFunction.ABS_DIFF;
        }
        return this.compareFunction;
    }

    public ComparisonMeasure setCompareFunction(@Property(value="compareFunction") CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public ComparisonMeasure setMinimum(@Property(value="minimum") Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public ComparisonMeasure setMaximum(@Property(value="maximum") Double maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComparisonMeasure addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public ComparisonMeasure setMeasure(@Property(value="measure") Measure measure) {
        this.measure = measure;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getMeasure());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Kind implements StringValue<Kind>
    {
        DISTANCE("distance"),
        SIMILARITY("similarity");

        private final String value;

        private Kind(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Kind fromValue(String v) {
            for (Kind c : Kind.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

