/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\r\u001b\t\u0015B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003M\u0001\u0011\u0005Q\nC\u0004T\u0001\t\u0007I\u0011\u0002+\t\rU\u0003\u0001\u0015!\u00031\u0011\u001d1\u0006\u00011A\u0005\n]Cqa\u0017\u0001A\u0002\u0013%A\f\u0003\u0004c\u0001\u0001\u0006K\u0001\u0017\u0005\bG\u0002\u0001\r\u0011\"\u0003e\u0011\u001d)\u0007\u00011A\u0005\n\u0019Da\u0001\u001b\u0001!B\u0013i\u0004bB5\u0001\u0005\u0004%I\u0001\u0016\u0005\u0007U\u0002\u0001\u000b\u0011\u0002\u0019\t\u0011-\u0004\u0001R1A\u0005\n1D\u0001\"\u001c\u0001\t\u0006\u0004%IA\u001c\u0005\ti\u0002A)\u0019!C\u0005]\"Aa\u000f\u0001EC\u0002\u0013%q\u000f\u0003\u0004\u0002\u0006\u0001!\ta\u0016\u0005\u0007\u0003\u000f\u0001A\u0011\u00013\t\r\u0005%\u0001\u0001\"\u0001m\u0011\u0019\tY\u0001\u0001C\u0001]\"1\u0011Q\u0002\u0001\u0005\u00029Dq!a\u0004\u0001\t\u0003\t\tBA\u000bFqB,7\r^1uS>t\u0017iZ4sK\u001e\fGo\u001c:\u000b\u0005ma\u0012AC2mkN$XM]5oO*\u0011QDH\u0001\u0003[2T!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dj\u0013B\u0001\u0018)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003-qW/\u001c$fCR,(/Z:\u0011\u0005\u001d\n\u0014B\u0001\u001a)\u0005\rIe\u000e^\u0001\nE\u000e<V-[4iiN\u00042!\u000e\u001d;\u001b\u00051$BA\u001c\u001f\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0002:m\tI!I]8bI\u000e\f7\u000f\u001e\t\u0004Omj\u0014B\u0001\u001f)\u0005\u0015\t%O]1z!\t9c(\u0003\u0002@Q\t1Ai\\;cY\u0016\f1BY2HCV\u001c8/[1ogB\u0019Q\u0007\u000f\"\u0011\u0007\u001dZ4\t\u0005\u0003(\t\u001a3\u0015BA#)\u0005\u0019!V\u000f\u001d7feA\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nH\u0001\u0007Y&t\u0017\r\\4\n\u0005-C%a\u0003#f]N,g+Z2u_J\fa\u0001P5oSRtD\u0003\u0002(Q#J\u0003\"a\u0014\u0001\u000e\u0003iAQa\f\u0003A\u0002ABQa\r\u0003A\u0002QBQ\u0001\u0011\u0003A\u0002\u0005\u000b\u0011a[\u000b\u0002a\u0005\u00111\u000eI\u0001\ti>$\u0018\r\\\"oiV\t\u0001\f\u0005\u0002(3&\u0011!\f\u000b\u0002\u0005\u0019>tw-\u0001\u0007u_R\fGn\u00118u?\u0012*\u0017\u000f\u0006\u0002^AB\u0011qEX\u0005\u0003?\"\u0012A!\u00168ji\"9\u0011\rCA\u0001\u0002\u0004A\u0016a\u0001=%c\u0005IAo\u001c;bY\u000esG\u000fI\u0001\u0011]\u0016<Hj\\4MS.,G.\u001b5p_\u0012,\u0012!P\u0001\u0015]\u0016<Hj\\4MS.,G.\u001b5p_\u0012|F%Z9\u0015\u0005u;\u0007bB1\f\u0003\u0003\u0005\r!P\u0001\u0012]\u0016<Hj\\4MS.,G.\u001b5p_\u0012\u0004\u0013aB2pmNK'0Z\u0001\tG>48+\u001b>fA\u0005Qa.Z<XK&<\u0007\u000e^:\u0016\u0003i\n\u0001B\\3x\u001b\u0016\fgn]\u000b\u0002_B\u0019qe\u000f$)\u0005A\t\bCA\u0014s\u0013\t\u0019\bFA\u0005ue\u0006t7/[3oi\u00069a.Z<D_Z\u001c\bFA\tr\u0003%9\u0017-^:tS\u0006t7/F\u0001y!\r93(\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fA\u0002Z5tiJL'-\u001e;j_:T!A \u000f\u0002\tM$\u0018\r^\u0005\u0004\u0003\u0003Y(\u0001F'vYRLg/\u0019:jCR,w)Y;tg&\fg\u000e\u000b\u0002\u0013c\u0006)1m\\;oi\u0006iAn\\4MS.,G.\u001b5p_\u0012\fqa^3jO\"$8/A\u0003nK\u0006t7/\u0001\u0003d_Z\u001c\u0018aA1eIR!\u00111CA\u000b\u001b\u0005\u0001\u0001bBA\f1\u0001\u0007\u0011\u0011D\u0001\tS:\u001cH/\u00198dKB)q\u0005RA\u000e{A\u0019q)!\b\n\u0007\u0005}\u0001J\u0001\u0004WK\u000e$xN\u001d")
public class ExpectationAggregator
implements scala.Serializable {
    private double[] newWeights;
    private transient DenseVector[] newMeans;
    private transient DenseVector[] newCovs;
    private transient MultivariateGaussian[] gaussians;
    private final int numFeatures;
    private final Broadcast<double[]> bcWeights;
    private final Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians;
    private final int k;
    private long totalCnt;
    private double newLogLikelihood;
    private final int covSize;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    private int k() {
        return this.k;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double newLogLikelihood() {
        return this.newLogLikelihood;
    }

    private void newLogLikelihood_$eq(double x$1) {
        this.newLogLikelihood = x$1;
    }

    private int covSize() {
        return this.covSize;
    }

    private double[] newWeights$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if (!this.bitmap$0) {
                this.newWeights = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
                this.bitmap$0 = true;
            }
        }
        return this.newWeights;
    }

    private double[] newWeights() {
        return !this.bitmap$0 ? this.newWeights$lzycompute() : this.newWeights;
    }

    private DenseVector[] newMeans$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.newMeans = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.zeros($this.numFeatures).toDense(), ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.newMeans;
    }

    private DenseVector[] newMeans() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.newMeans$lzycompute() : this.newMeans;
    }

    private DenseVector[] newCovs$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.newCovs = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.zeros(this.covSize()).toDense(), ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.newCovs;
    }

    private DenseVector[] newCovs() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.newCovs$lzycompute() : this.newCovs;
    }

    private MultivariateGaussian[] gaussians$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gaussians = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bcGaussians.value())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    DenseVector mean = (DenseVector)tuple2._1();
                    DenseVector covVec = (DenseVector)tuple2._2();
                    DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix($this.numFeatures, covVec.values());
                    MultivariateGaussian multivariateGaussian = new MultivariateGaussian((Vector)mean, (Matrix)cov);
                    return multivariateGaussian;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gaussians;
    }

    private MultivariateGaussian[] gaussians() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.gaussians$lzycompute() : this.gaussians;
    }

    public long count() {
        return this.totalCnt();
    }

    public double logLikelihood() {
        return this.newLogLikelihood();
    }

    public double[] weights() {
        return this.newWeights();
    }

    public DenseVector[] means() {
        return this.newMeans();
    }

    public DenseVector[] covs() {
        return this.newCovs();
    }

    public ExpectationAggregator add(Tuple2<Vector, Object> instance) {
        int i;
        double weight;
        Vector vector;
        block5: {
            Tuple2<Vector, Object> tuple2;
            block4: {
                tuple2 = instance;
                if (tuple2 == null) break block4;
                vector = (Vector)tuple2._1();
                weight = tuple2._2$mcD$sp();
                if (vector != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        Vector vector2 = vector;
        double d = weight;
        Tuple2 tuple2 = new Tuple2((Object)vector2, (Object)BoxesRunTime.boxToDouble((double)d));
        Tuple2 tuple22 = tuple2;
        Vector vector3 = (Vector)tuple22._1();
        double weight2 = tuple22._2$mcD$sp();
        double[] localWeights = (double[])this.bcWeights.value();
        MultivariateGaussian[] localGaussians = this.gaussians();
        double[] prob = new double[this.k()];
        double probSum = 0.0;
        for (i = 0; i < this.k(); ++i) {
            double p;
            prob[i] = p = Utils$.MODULE$.EPSILON() + localWeights[i] * localGaussians[i].pdf(vector3);
            probSum += p;
        }
        this.newLogLikelihood_$eq(this.newLogLikelihood() + package$.MODULE$.log(probSum) * weight2);
        double[] localNewWeights = this.newWeights();
        DenseVector[] localNewMeans = this.newMeans();
        DenseVector[] localNewCovs = this.newCovs();
        for (i = 0; i < this.k(); ++i) {
            double w = prob[i] / probSum * weight2;
            int n = i;
            localNewWeights[n] = localNewWeights[n] + w;
            BLAS$.MODULE$.axpy(w, vector3, (Vector)localNewMeans[i]);
            BLAS$.MODULE$.spr(w, vector3, localNewCovs[i]);
        }
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public ExpectationAggregator(int numFeatures, Broadcast<double[]> bcWeights, Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians) {
        this.numFeatures = numFeatures;
        this.bcWeights = bcWeights;
        this.bcGaussians = bcGaussians;
        this.k = ((double[])bcWeights.value()).length;
        this.totalCnt = 0L;
        this.newLogLikelihood = 0.0;
        this.covSize = numFeatures * (numFeatures + 1) / 2;
    }
}

