/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.EntropyAggregator;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.GiniAggregator;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.ImpurityAggregator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.impurity.VarianceAggregator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\u000e\u001d\u0001\tB\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\t\u0011e\u0002!\u0011!Q\u0001\nUB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019!\u0006\u0001)A\u0005\u0017\"9Q\u000b\u0001b\u0001\n\u00131\u0006BB,\u0001A\u0003%\u0011\tC\u0004Y\u0001\t\u0007I\u0011B-\t\ri\u0003\u0001\u0015!\u0003?\u0011\u001dY\u0006A1A\u0005\neCa\u0001\u0018\u0001!\u0002\u0013q\u0004bB/\u0001\u0005\u0004%IA\u0016\u0005\u0007=\u0002\u0001\u000b\u0011B!\t\u000f}\u0003!\u0019!C\u0005A\"1Q\r\u0001Q\u0001\n\u0005DqA\u001a\u0001C\u0002\u0013%\u0001\r\u0003\u0004h\u0001\u0001\u0006I!\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006g\u0002!\t\u0001\u001e\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u00055\u0002\u0001\"\u0001\u00020\t\tB\tV*uCR\u001c\u0018iZ4sK\u001e\fGo\u001c:\u000b\u0005uq\u0012\u0001B5na2T!a\b\u0011\u0002\tQ\u0014X-\u001a\u0006\u0003C\t\n!!\u001c7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c2\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011!\u0006M\u0005\u0003c-\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001\"\\3uC\u0012\fG/Y\u0002\u0001+\u0005)\u0004C\u0001\u001c8\u001b\u0005a\u0012B\u0001\u001d\u001d\u0005Q!UmY5tS>tGK]3f\u001b\u0016$\u0018\rZ1uC\u0006IQ.\u001a;bI\u0006$\u0018\rI\u0001\u000eM\u0016\fG/\u001e:f'V\u00147/\u001a;\u0011\u0007)bd(\u0003\u0002>W\t1q\n\u001d;j_:\u00042AK B\u0013\t\u00015FA\u0003BeJ\f\u0017\u0010\u0005\u0002+\u0005&\u00111i\u000b\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"A\u000e\u0001\t\u000bI\"\u0001\u0019A\u001b\t\u000bi\"\u0001\u0019A\u001e\u0002%%l\u0007/\u001e:jif\fum\u001a:fO\u0006$xN]\u000b\u0002\u0017B\u0011AJU\u0007\u0002\u001b*\u0011ajT\u0001\tS6\u0004XO]5us*\u0011q\u0004\u0015\u0006\u0003#\n\nQ!\u001c7mS\nL!aU'\u0003%%k\u0007/\u001e:jif\fum\u001a:fO\u0006$xN]\u0001\u0014S6\u0004XO]5us\u0006;wM]3hCR|'\u000fI\u0001\ngR\fGo]*ju\u0016,\u0012!Q\u0001\u000bgR\fGo]*ju\u0016\u0004\u0013a\u00028v[\nKgn]\u000b\u0002}\u0005Aa.^7CS:\u001c\b%\u0001\bgK\u0006$XO]3PM\u001a\u001cX\r^:\u0002\u001f\u0019,\u0017\r^;sK>3gm]3ug\u0002\nA\"\u00197m'R\fGo]*ju\u0016\fQ\"\u00197m'R\fGo]*ju\u0016\u0004\u0013\u0001C1mYN#\u0018\r^:\u0016\u0003\u0005\u00042AK c!\tQ3-\u0003\u0002eW\t1Ai\\;cY\u0016\f\u0011\"\u00197m'R\fGo\u001d\u0011\u0002\u0017A\f'/\u001a8u'R\fGo]\u0001\ra\u0006\u0014XM\u001c;Ti\u0006$8\u000fI\u0001\u0016O\u0016$\u0018*\u001c9ve&$\u0018pQ1mGVd\u0017\r^8s)\rQWn\u001c\t\u0003\u0019.L!\u0001\\'\u0003%%k\u0007/\u001e:jif\u001c\u0015\r\\2vY\u0006$xN\u001d\u0005\u0006]N\u0001\r!Q\u0001\u000eM\u0016\fG/\u001e:f\u001f\u001a47/\u001a;\t\u000bA\u001c\u0002\u0019A!\u0002\u0011\tLg.\u00138eKb\f1dZ3u!\u0006\u0014XM\u001c;J[B,(/\u001b;z\u0007\u0006d7-\u001e7bi>\u0014H#\u00016\u0002\rU\u0004H-\u0019;f)\u0019)\bP_>~\u007fB\u0011!F^\u0005\u0003o.\u0012A!\u00168ji\")\u00110\u0006a\u0001\u0003\u0006aa-Z1ukJ,\u0017J\u001c3fq\")\u0001/\u0006a\u0001\u0003\")A0\u0006a\u0001E\u0006)A.\u00192fY\")a0\u0006a\u0001\u0003\u0006Qa.^7TC6\u0004H.Z:\t\r\u0005\u0005Q\u00031\u0001c\u00031\u0019\u0018-\u001c9mK^+\u0017n\u001a5u\u00031)\b\u000fZ1uKB\u000b'/\u001a8u)\u001d)\u0018qAA\u0005\u0003\u0017AQ\u0001 \fA\u0002\tDQA \fA\u0002\u0005Ca!!\u0001\u0017\u0001\u0004\u0011\u0017!\u00044fCR,(/Z+qI\u0006$X\rF\u0006v\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001\"\u00028\u0018\u0001\u0004\t\u0005\"\u00029\u0018\u0001\u0004\t\u0005\"\u0002?\u0018\u0001\u0004\u0011\u0007\"\u0002@\u0018\u0001\u0004\t\u0005BBA\u0001/\u0001\u0007!-\u0001\thKR4U-\u0019;ve\u0016|eMZ:fiR\u0019\u0011)a\b\t\u000beD\u0002\u0019A!\u0002\u001f5,'oZ3G_J4U-\u0019;ve\u0016$r!^A\u0013\u0003O\tI\u0003C\u0003o3\u0001\u0007\u0011\tC\u0003q3\u0001\u0007\u0011\t\u0003\u0004\u0002,e\u0001\r!Q\u0001\u000e_RDWM\u001d\"j]&sG-\u001a=\u0002\u000b5,'oZ3\u0015\u0007\u0019\u000b\t\u0004\u0003\u0004\u00024i\u0001\rAR\u0001\u0006_RDWM\u001d")
public class DTStatsAggregator
implements scala.Serializable {
    private final DecisionTreeMetadata metadata;
    private final ImpurityAggregator impurityAggregator;
    private final int statsSize;
    private final int[] numBins;
    private final int[] featureOffsets;
    private final int allStatsSize;
    private final double[] allStats;
    private final double[] parentStats;

    public DecisionTreeMetadata metadata() {
        return this.metadata;
    }

    public ImpurityAggregator impurityAggregator() {
        return this.impurityAggregator;
    }

    private int statsSize() {
        return this.statsSize;
    }

    private int[] numBins() {
        return this.numBins;
    }

    private int[] featureOffsets() {
        return this.featureOffsets;
    }

    private int allStatsSize() {
        return this.allStatsSize;
    }

    private double[] allStats() {
        return this.allStats;
    }

    private double[] parentStats() {
        return this.parentStats;
    }

    public ImpurityCalculator getImpurityCalculator(int featureOffset, int binIndex) {
        return this.impurityAggregator().getCalculator(this.allStats(), featureOffset + binIndex * this.statsSize());
    }

    public ImpurityCalculator getParentImpurityCalculator() {
        return this.impurityAggregator().getCalculator(this.parentStats(), 0);
    }

    public void update(int featureIndex, int binIndex, double label, int numSamples, double sampleWeight) {
        int i = this.featureOffsets()[featureIndex] + binIndex * this.statsSize();
        this.impurityAggregator().update(this.allStats(), i, label, numSamples, sampleWeight);
    }

    public void updateParent(double label, int numSamples, double sampleWeight) {
        this.impurityAggregator().update(this.parentStats(), 0, label, numSamples, sampleWeight);
    }

    public void featureUpdate(int featureOffset, int binIndex, double label, int numSamples, double sampleWeight) {
        this.impurityAggregator().update(this.allStats(), featureOffset + binIndex * this.statsSize(), label, numSamples, sampleWeight);
    }

    public int getFeatureOffset(int featureIndex) {
        return this.featureOffsets()[featureIndex];
    }

    public void mergeForFeature(int featureOffset, int binIndex, int otherBinIndex) {
        this.impurityAggregator().merge(this.allStats(), featureOffset + binIndex * this.statsSize(), featureOffset + otherBinIndex * this.statsSize());
    }

    public DTStatsAggregator merge(DTStatsAggregator other) {
        Predef$.MODULE$.require(this.allStatsSize() == other.allStatsSize(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(140).append("DTStatsAggregator.merge requires that both aggregators have the same length stats vectors.").append(" This aggregator is of length ").append(this.allStatsSize()).append(", but the other is ").append(other.allStatsSize()).append(".").toString());
        for (int i = 0; i < this.allStatsSize(); ++i) {
            int n = i;
            this.allStats()[n] = this.allStats()[n] + other.allStats()[i];
        }
        Predef$.MODULE$.require(this.statsSize() == other.statsSize(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(160).append("DTStatsAggregator.merge requires that both aggregators have the same length parent ").append("stats vectors. This aggregator's parent stats are length ").append(this.statsSize()).append(", ").append("but the other is ").append(other.statsSize()).append(".").toString());
        for (int j = 0; j < this.statsSize(); ++j) {
            int n = j;
            this.parentStats()[n] = this.parentStats()[n] + other.parentStats()[j];
        }
        return this;
    }

    public DTStatsAggregator(DecisionTreeMetadata metadata, Option<int[]> featureSubset) {
        ImpurityAggregator impurityAggregator;
        this.metadata = metadata;
        Impurity impurity = metadata.impurity();
        if (Gini$.MODULE$.equals(impurity)) {
            impurityAggregator = new GiniAggregator(metadata.numClasses());
        } else if (Entropy$.MODULE$.equals(impurity)) {
            impurityAggregator = new EntropyAggregator(metadata.numClasses());
        } else if (Variance$.MODULE$.equals(impurity)) {
            impurityAggregator = new VarianceAggregator();
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Bad impurity parameter: ").append(metadata.impurity()).toString());
        }
        this.impurityAggregator = impurityAggregator;
        this.statsSize = this.impurityAggregator().statsSize();
        this.numBins = featureSubset.isDefined() ? (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])featureSubset.get())).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> this.metadata().numBins()[x$1], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())) : metadata.numBins();
        this.featureOffsets = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.numBins())).scanLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(total, nBins) -> total + this.statsSize() * nBins, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.allStatsSize = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.featureOffsets())).last());
        this.allStats = new double[this.allStatsSize()];
        this.parentStats = new double[this.statsSize()];
    }
}

