/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.StreamingKMeans$;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStream$;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0013'\u0001EB\u0001\"\u0011\u0001\u0003\u0002\u0004%\tA\u0011\u0005\t\u001f\u0002\u0011\t\u0019!C\u0001!\"Aq\u000b\u0001B\u0001B\u0003&1\t\u0003\u0005Z\u0001\t\u0005\r\u0011\"\u0001[\u0011!y\u0006A!a\u0001\n\u0003\u0001\u0007\u0002C2\u0001\u0005\u0003\u0005\u000b\u0015B.\t\u0011\u0015\u0004!\u00111A\u0005\u0002\u0019D\u0001b\u001d\u0001\u0003\u0002\u0004%\t\u0001\u001e\u0005\to\u0002\u0011\t\u0011)Q\u0005O\")\u0011\u0010\u0001C\u0001u\"1\u0011\u0010\u0001C\u0001\u0003\u0013A\u0011\"!\u0004\u0001\u0001\u0004%\t\"a\u0004\t\u0013\u0005]\u0001\u00011A\u0005\u0012\u0005e\u0001\u0002CA\u000f\u0001\u0001\u0006K!!\u0005\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GB\u0011\"!\u001f\u0001#\u0003%\t!a\u001f\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAK\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\tI\r\u0001C\u0001\u0003'Dq!!;\u0001\t\u0003\tY\u000fC\u0004\u0002j\u0002!\tAa\n\t\u0011\tm\u0002\u0001)C\u0005\u0005{9\u0001B!\u0011'\u0011\u00031#1\t\u0004\bK\u0019B\tA\nB#\u0011\u0019Ih\u0004\"\u0001\u0003H!I!\u0011\n\u0010C\u0002\u0013\u0015!1\n\u0005\t\u0005'r\u0002\u0015!\u0004\u0003N!I!Q\u000b\u0010C\u0002\u0013\u0015!q\u000b\u0005\t\u0005?r\u0002\u0015!\u0004\u0003Z!I!\u0011\r\u0010\u0002\u0002\u0013%!1\r\u0002\u0010'R\u0014X-Y7j]\u001e\\U*Z1og*\u0011q\u0005K\u0001\u000bG2,8\u000f^3sS:<'BA\u0015+\u0003\u0015iG\u000e\\5c\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0005\u0001IBd\b\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VM\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003w)\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003{i\u0012q\u0001T8hO&tw\r\u0005\u00024\u007f%\u0011\u0001\t\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0002WV\t1\t\u0005\u00024\t&\u0011Q\t\u000e\u0002\u0004\u0013:$\bfA\u0001H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JK\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001'J\u0005\u0015\u0019\u0016N\\2fC\u0005q\u0015!B\u0019/e9\u0002\u0014!B6`I\u0015\fHCA)U!\t\u0019$+\u0003\u0002Ti\t!QK\\5u\u0011\u001d)&!!AA\u0002\r\u000b1\u0001\u001f\u00132Q\r\u0011q)T\u0001\u0003W\u0002B3aA$N\u0003-!WmY1z\r\u0006\u001cGo\u001c:\u0016\u0003m\u0003\"a\r/\n\u0005u#$A\u0002#pk\ndW\rK\u0002\u0005\u000f6\u000bq\u0002Z3dCf4\u0015m\u0019;pe~#S-\u001d\u000b\u0003#\u0006Dq!V\u0003\u0002\u0002\u0003\u00071\fK\u0002\u0006\u000f6\u000bA\u0002Z3dCf4\u0015m\u0019;pe\u0002B3AB$N\u0003!!\u0018.\\3V]&$X#A4\u0011\u0005!|gBA5n!\tQG'D\u0001l\u0015\ta\u0007'\u0001\u0004=e>|GOP\u0005\u0003]R\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a\u000e\u000e\u0015\u0004\u000f\u001dk\u0015\u0001\u0004;j[\u0016,f.\u001b;`I\u0015\fHCA)v\u0011\u001d)\u0006\"!AA\u0002\u001dD3\u0001C$N\u0003%!\u0018.\\3V]&$\b\u0005K\u0002\n\u000f6\u000ba\u0001P5oSRtD#B>~\u007f\u0006\r\u0001C\u0001?\u0001\u001b\u00051\u0003\"B!\u000b\u0001\u0004\u0019\u0005fA?H\u001b\")\u0011L\u0003a\u00017\"\u001aqpR'\t\u000b\u0015T\u0001\u0019A4)\t\u0005\rq)\u0014\u0015\u0004\u0015\u001dkE#A>)\u0007-9U*A\u0003n_\u0012,G.\u0006\u0002\u0002\u0012A\u0019A0a\u0005\n\u0007\u0005UaE\u0001\u000bTiJ,\u0017-\\5oO.kU-\u00198t\u001b>$W\r\\\u0001\n[>$W\r\\0%KF$2!UA\u000e\u0011!)V\"!AA\u0002\u0005E\u0011AB7pI\u0016d\u0007%\u0001\u0003tKR\\E\u0003BA\u0012\u0003Ki\u0011\u0001\u0001\u0005\u0006\u0003>\u0001\ra\u0011\u0015\u0004\u001f\u001dk\u0015AD:fi\u0012+7-Y=GC\u000e$xN\u001d\u000b\u0005\u0003G\ti\u0003\u0003\u0004\u00020A\u0001\raW\u0001\u0002C\"\u001a\u0001cR'\u0002\u0017M,G\u000fS1mM2Kg-\u001a\u000b\u0007\u0003G\t9$a\u000f\t\r\u0005e\u0012\u00031\u0001\\\u0003!A\u0017\r\u001c4MS\u001a,\u0007\"B3\u0012\u0001\u00049\u0007fA\tH\u001b\u0006\t2/\u001a;J]&$\u0018.\u00197DK:$XM]:\u0015\r\u0005\r\u00121IA-\u0011\u001d\t)E\u0005a\u0001\u0003\u000f\nqaY3oi\u0016\u00148\u000fE\u00034\u0003\u0013\ni%C\u0002\u0002LQ\u0012Q!\u0011:sCf\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'B\u0013A\u00027j]\u0006dw-\u0003\u0003\u0002X\u0005E#A\u0002,fGR|'\u000fC\u0004\u0002\\I\u0001\r!!\u0018\u0002\u000f],\u0017n\u001a5ugB!1'!\u0013\\Q\r\u0011r)T\u0001\u0011g\u0016$(+\u00198e_6\u001cUM\u001c;feN$\u0002\"a\t\u0002f\u0005%\u0014Q\u000e\u0005\u0007\u0003O\u001a\u0002\u0019A\"\u0002\u0007\u0011LW\u000e\u0003\u0004\u0002lM\u0001\raW\u0001\u0007o\u0016Lw\r\u001b;\t\u0013\u0005=4\u0003%AA\u0002\u0005E\u0014\u0001B:fK\u0012\u00042aMA:\u0013\r\t)\b\u000e\u0002\u0005\u0019>tw\rK\u0002\u0014\u000f6\u000b!d]3u%\u0006tGm\\7DK:$XM]:%I\u00164\u0017-\u001e7uIM*\"!! +\t\u0005E\u0014qP\u0016\u0003\u0003\u0003\u0003B!a!\u0002\f6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005v]\u000eDWmY6fI*\u0011!\nN\u0005\u0005\u0003\u001b\u000b)IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0002\\1uKN$Xj\u001c3fYR\u0011\u0011\u0011\u0003\u0015\u0004+\u001dk\u0015a\u0002;sC&twJ\u001c\u000b\u0004#\u0006e\u0005bBAN-\u0001\u0007\u0011QT\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002 \u0006%\u0016QJ\u0007\u0003\u0003CSA!a)\u0002&\u00069Am\u001d;sK\u0006l'bAATU\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003W\u000b\tKA\u0004E'R\u0014X-Y7)\u0007Y9U\nF\u0002R\u0003cCq!a'\u0018\u0001\u0004\t\u0019\f\u0005\u0004\u00026\u0006}\u0016QJ\u0007\u0003\u0003oSA!!/\u0002<\u0006!!.\u0019<b\u0015\u0011\ti,!*\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002B\u0006]&a\u0003&bm\u0006$5\u000b\u001e:fC6DCaF$\u0002F\u0006\u0012\u0011qY\u0001\u0006c9\"d\u0006M\u0001\naJ,G-[2u\u001f:$B!!4\u0002PB)\u0011qTAU\u0007\"9\u00111\u0014\rA\u0002\u0005u\u0005f\u0001\rH\u001bR!\u0011Q[As!\u0019\t),a0\u0002XB!\u0011\u0011\\Aq\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017\u0001\u00027b]\u001eT!!!/\n\t\u0005\r\u00181\u001c\u0002\b\u0013:$XmZ3s\u0011\u001d\tY*\u0007a\u0001\u0003gCC!G$\u0002F\u0006y\u0001O]3eS\u000e$xJ\u001c,bYV,7/\u0006\u0003\u0002n\u0006uH\u0003BAx\u0005?!B!!=\u0003\u0010A1\u0011qTAU\u0003g\u0004baMA{\u0003s\u001c\u0015bAA|i\t1A+\u001e9mKJ\u0002B!a?\u0002~2\u0001AaBA\u00005\t\u0007!\u0011\u0001\u0002\u0002\u0017F!!1\u0001B\u0005!\r\u0019$QA\u0005\u0004\u0005\u000f!$a\u0002(pi\"Lgn\u001a\t\u0004g\t-\u0011b\u0001B\u0007i\t\u0019\u0011I\\=\t\u0013\tE!$!AA\u0004\tM\u0011AC3wS\u0012,gnY3%cA1!Q\u0003B\u000e\u0003sl!Aa\u0006\u000b\u0007\teA'A\u0004sK\u001adWm\u0019;\n\t\tu!q\u0003\u0002\t\u00072\f7o\u001d+bO\"9\u00111\u0014\u000eA\u0002\t\u0005\u0002CBAP\u0003S\u0013\u0019\u0003E\u00044\u0003k\fI0!\u0014)\u0007i9U*\u0006\u0003\u0003*\tMB\u0003\u0002B\u0016\u0005k\u0001\u0002\"!.\u0003.\tE\u0012q[\u0005\u0005\u0005_\t9LA\bKCZ\f\u0007+Y5s\tN#(/Z1n!\u0011\tYPa\r\u0005\u000f\u0005}8D1\u0001\u0003\u0002!9\u00111T\u000eA\u0002\t]\u0002\u0003CA[\u0005[\u0011\t$!\u0014)\tm9\u0015QY\u0001\u0012CN\u001cXM\u001d;J]&$\u0018.\u00197ju\u0016$G#A))\u0007\u00019U*A\bTiJ,\u0017-\\5oO.kU-\u00198t!\tahdE\u0002\u001fey\"\"Aa\u0011\u0002\u000f\t\u000bEk\u0011%F'V\u0011!QJ\b\u0003\u0005\u001f\n#A!\u0015\u0002\u000f\t\fGo\u00195fg\u0006A!)\u0011+D\u0011\u0016\u001b\u0006%\u0001\u0004Q\u001f&sEkU\u000b\u0003\u00053z!Aa\u0017\"\u0005\tu\u0013A\u00029pS:$8/A\u0004Q\u001f&sEk\u0015\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005K\u0002B!!7\u0003h%!!\u0011NAn\u0005\u0019y%M[3di\u0002")
public class StreamingKMeans
implements Logging,
scala.Serializable {
    private int k;
    private double decayFactor;
    private String timeUnit;
    private StreamingKMeansModel model;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String POINTS() {
        return StreamingKMeans$.MODULE$.POINTS();
    }

    public static String BATCHES() {
        return StreamingKMeans$.MODULE$.BATCHES();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public double decayFactor() {
        return this.decayFactor;
    }

    public void decayFactor_$eq(double x$1) {
        this.decayFactor = x$1;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public void timeUnit_$eq(String x$1) {
        this.timeUnit = x$1;
    }

    public StreamingKMeansModel model() {
        return this.model;
    }

    public void model_$eq(StreamingKMeansModel x$1) {
        this.model = x$1;
    }

    public StreamingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public StreamingKMeans setDecayFactor(double a) {
        Predef$.MODULE$.require(a >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decay factor must be nonnegative but got ").append(a).toString());
        this.decayFactor_$eq(a);
        return this;
    }

    public StreamingKMeans setHalfLife(double halfLife, String timeUnit) {
        Predef$.MODULE$.require(halfLife > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Half life must be positive but got ").append(halfLife).toString());
        String string = timeUnit;
        String string2 = "batches";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = timeUnit;
            String string4 = "points";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw new IllegalArgumentException(new StringBuilder(29).append("Invalid time unit for decay: ").append(timeUnit).toString());
            }
        }
        this.decayFactor_$eq(package$.MODULE$.exp(package$.MODULE$.log(0.5) / halfLife));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Setting decay factor to: %g ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.decayFactor())})));
        this.timeUnit_$eq(timeUnit);
        return this;
    }

    public StreamingKMeans setInitialCenters(Vector[] centers, double[] weights) {
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).size(), (Function0 & Serializable & scala.Serializable)() -> "Number of initial centers must be equal to number of weights");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).size() == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Number of initial centers must be ").append(this.k()).append(" but got ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).size()).toString());
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 0.0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Weight for each initial center must be nonnegative but got [").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).mkString(" ")).append("]").toString());
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public StreamingKMeans setRandomCenters(int dim, double weight, long seed) {
        Predef$.MODULE$.require(dim > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Number of dimensions must be positive but got ").append(dim).toString());
        Predef$.MODULE$.require(weight >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Weight for each center must be nonnegative but got ").append(weight).toString());
        XORShiftRandom random = new XORShiftRandom(seed);
        Vector[] centers = (Vector[])Array$.MODULE$.fill(this.k(), (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random.nextGaussian(), ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Vector.class));
        double[] weights = (double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> weight, ClassTag$.MODULE$.Double());
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public long setRandomCenters$default$3() {
        return Utils$.MODULE$.random().nextLong();
    }

    public StreamingKMeansModel latestModel() {
        return this.model();
    }

    public void trainOn(DStream<Vector> data) {
        this.assertInitialized();
        data.foreachRDD((Function2 & Serializable & scala.Serializable)(rdd, time) -> {
            this.model_$eq(this.model().update((RDD<Vector>)rdd, this.decayFactor(), this.timeUnit()));
            return BoxedUnit.UNIT;
        });
    }

    public void trainOn(JavaDStream<Vector> data) {
        this.trainOn((DStream<Vector>)data.dstream());
    }

    public DStream<Object> predictOn(DStream<Vector> data) {
        this.assertInitialized();
        StreamingKMeansModel streamingKMeansModel = this.model();
        return data.map((Function1 & Serializable & scala.Serializable)point -> BoxesRunTime.boxToInteger((int)streamingKMeansModel.predict(point)), ClassTag$.MODULE$.Int());
    }

    public JavaDStream<Integer> predictOn(JavaDStream<Vector> data) {
        return JavaDStream$.MODULE$.fromDStream(this.predictOn((DStream<Vector>)data.dstream()), ClassTag$.MODULE$.apply(Integer.class));
    }

    public <K> DStream<Tuple2<K, Object>> predictOnValues(DStream<Tuple2<K, Vector>> data, ClassTag<K> evidence$1) {
        this.assertInitialized();
        DStream<Tuple2<K, Vector>> x$1 = data;
        ClassTag<K> x$2 = evidence$1;
        ClassTag x$3 = ClassTag$.MODULE$.apply(Vector.class);
        Null$ x$4 = DStream$.MODULE$.toPairDStreamFunctions$default$4(x$1);
        StreamingKMeansModel streamingKMeansModel = this.model();
        return DStream$.MODULE$.toPairDStreamFunctions(x$1, x$2, x$3, null).mapValues((Function1 & Serializable & scala.Serializable)point -> BoxesRunTime.boxToInteger((int)streamingKMeansModel.predict(point)), ClassTag$.MODULE$.Int());
    }

    public <K> JavaPairDStream<K, Integer> predictOnValues(JavaPairDStream<K, Vector> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return JavaPairDStream$.MODULE$.fromPairDStream(this.predictOnValues(data.dstream(), tag), tag, ClassTag$.MODULE$.apply(Integer.class));
    }

    private void assertInitialized() {
        if (this.model().clusterCenters() == null) {
            throw new IllegalStateException("Initial cluster centers must be set before starting predictions");
        }
    }

    public StreamingKMeans(int k, double decayFactor, String timeUnit) {
        this.k = k;
        this.decayFactor = decayFactor;
        this.timeUnit = timeUnit;
        Logging.$init$((Logging)this);
        this.model = new StreamingKMeansModel(null, null);
    }

    public StreamingKMeans() {
        this(2, 1.0, "batches");
    }
}

