/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseMatrix$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class JsonMatrixConverter$ {
    public static JsonMatrixConverter$ MODULE$;
    private final String className;

    static {
        new JsonMatrixConverter$();
    }

    public String className() {
        return this.className;
    }

    public Matrix fromJson(String json) {
        DenseMatrix denseMatrix;
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        int n = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("type")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        switch (n) {
            case 0: {
                int numRows = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("numRows")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                int numCols = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("numCols")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                int[] colPtrs = (int[])((TraversableOnce)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("colPtrs")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toArray(ClassTag$.MODULE$.Int());
                int[] rowIndices = (int[])((TraversableOnce)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("rowIndices")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toArray(ClassTag$.MODULE$.Int());
                double[] values = (double[])((TraversableOnce)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("values")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toArray(ClassTag$.MODULE$.Double());
                boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("isTransposed")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Boolean()));
                denseMatrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values, isTransposed);
                break;
            }
            case 1: {
                int numRows = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("numRows")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                int numCols = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("numCols")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                double[] values = (double[])((TraversableOnce)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("values")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toArray(ClassTag$.MODULE$.Double());
                boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("isTransposed")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Boolean()));
                denseMatrix = new DenseMatrix(numRows, numCols, values, isTransposed);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("Cannot parse ").append(json).append(" into a Matrix.").toString());
            }
        }
        return denseMatrix;
    }

    public String toJson(Matrix m) {
        DenseMatrix denseMatrix;
        Option option;
        String string;
        SparseMatrix sparseMatrix;
        Option option2;
        Matrix matrix = m;
        if (matrix instanceof SparseMatrix && !(option2 = SparseMatrix$.MODULE$.unapply(sparseMatrix = (SparseMatrix)matrix)).isEmpty()) {
            JsonAST.JObject jValue;
            int numRows = BoxesRunTime.unboxToInt((Object)((Tuple6)option2.get())._1());
            int numCols = BoxesRunTime.unboxToInt((Object)((Tuple6)option2.get())._2());
            int[] colPtrs = (int[])((Tuple6)option2.get())._3();
            int[] rowIndices = (int[])((Tuple6)option2.get())._4();
            double[] values = (double[])((Tuple6)option2.get())._5();
            boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)((Tuple6)option2.get())._6());
            JsonAST.JObject x$1 = jValue = JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.className()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRows"), (Object)BoxesRunTime.boxToInteger((int)numRows)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCols"), (Object)BoxesRunTime.boxToInteger((int)numCols)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colPtrs"), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colPtrs)).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowIndices"), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rowIndices)).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isTransposed"), (Object)BoxesRunTime.boxToBoolean((boolean)isTransposed)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))));
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        } else if (matrix instanceof DenseMatrix && !(option = DenseMatrix$.MODULE$.unapply(denseMatrix = (DenseMatrix)matrix)).isEmpty()) {
            JsonAST.JObject jValue;
            int numRows = BoxesRunTime.unboxToInt((Object)((Tuple4)option.get())._1());
            int numCols = BoxesRunTime.unboxToInt((Object)((Tuple4)option.get())._2());
            double[] values = (double[])((Tuple4)option.get())._3();
            boolean isTransposed = BoxesRunTime.unboxToBoolean((Object)((Tuple4)option.get())._4());
            JsonAST.JObject x$3 = jValue = JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.className()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)1)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRows"), (Object)BoxesRunTime.boxToInteger((int)numRows)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCols"), (Object)BoxesRunTime.boxToInteger((int)numCols)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isTransposed"), (Object)BoxesRunTime.boxToBoolean((boolean)isTransposed)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))));
            Formats x$4 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$3);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$3, x$4));
        } else {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown matrix type ").append(m.getClass()).append(".").toString());
        }
        return string;
    }

    private JsonMatrixConverter$() {
        MODULE$ = this;
        this.className = "matrix";
    }
}

