/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.SparkException;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class Bucketizer$
implements DefaultParamsReadable<Bucketizer>,
Serializable {
    public static Bucketizer$ MODULE$;
    private final String SKIP_INVALID;
    private final String ERROR_INVALID;
    private final String KEEP_INVALID;
    private final String[] supportedHandleInvalids;

    static {
        new Bucketizer$();
    }

    @Override
    public MLReader<Bucketizer> read() {
        return DefaultParamsReadable.read$(this);
    }

    public String SKIP_INVALID() {
        return this.SKIP_INVALID;
    }

    public String ERROR_INVALID() {
        return this.ERROR_INVALID;
    }

    public String KEEP_INVALID() {
        return this.KEEP_INVALID;
    }

    public String[] supportedHandleInvalids() {
        return this.supportedHandleInvalids;
    }

    public boolean checkSplits(double[] splits) {
        boolean bl;
        if (splits.length < 3) {
            bl = false;
        } else {
            int n = splits.length - 1;
            for (int i = 0; i < n; ++i) {
                if (!(splits[i] >= splits[i + 1]) && !Double.isNaN(splits[i])) continue;
                return false;
            }
            bl = !Double.isNaN(splits[n]);
        }
        return bl;
    }

    public boolean checkSplitsArray(double[][] splitsArray) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitsArray)).forall((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Bucketizer$.MODULE$.checkSplits(x$3)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double binarySearchForBuckets(double[] splits, double feature, boolean keepInvalid) {
        double d;
        if (Double.isNaN(feature)) {
            if (!keepInvalid) throw new SparkException("Bucketizer encountered NaN value. To handle or skip NaNs, try setting Bucketizer.handleInvalid.");
            d = splits.length - 1;
            return d;
        } else if (feature == BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).last())) {
            d = splits.length - 2;
            return d;
        } else {
            int idx = Arrays.binarySearch(splits, feature);
            if (idx >= 0) {
                d = idx;
                return d;
            } else {
                int insertPos = -idx - 1;
                if (insertPos == 0 || insertPos == splits.length) {
                    throw new SparkException(new StringBuilder(111).append("Feature value ").append(feature).append(" out of Bucketizer bounds").append(" [").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).head()).append(", ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).last()).append("]. Check your features, or loosen ").append("the lower/upper bound constraints.").toString());
                }
                d = insertPos - 1;
            }
        }
        return d;
    }

    @Override
    public Bucketizer load(String path) {
        return (Bucketizer)MLReadable.load$(this, path);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Bucketizer$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        DefaultParamsReadable.$init$(this);
        this.SKIP_INVALID = "skip";
        this.ERROR_INVALID = "error";
        this.KEEP_INVALID = "keep";
        this.supportedHandleInvalids = (String[])((Object[])new String[]{this.SKIP_INVALID(), this.ERROR_INVALID(), this.KEEP_INVALID()});
    }
}

