/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\u0010 \u0001)B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005o!AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bY\u0003A\u0011A,\t\u000b\u0001\u0004A\u0011I1\t\u000b5\u0004A\u0011\t(\t\u000b=\u0004A\u0011\t9\t\rQ\u0004A\u0011I\u0012v\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0006\u0001\t\u0003\n9\u0002\u0003\u0004\u0002\u001a\u0001!\tE\u000e\u0005\u0007\u0003C\u0001A\u0011\t\u001c\t\u0011\u0005\u0015\u0002\u0001\"\u0011 \u0003OAa!!\f\u0001\t\u00032\u0004\u0002CA\u001b\u0001\u0011\u00051%a\u000e\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011q\t\u0001\u0005B\u0005%\u0003\u0002CA/\u0001\u0011\u00053%a\u0018\t\u0011\u0005e\u0004\u0001\"\u0011$\u0003?:q!!' \u0011\u0003\tYJ\u0002\u0004\u001f?!\u0005\u0011Q\u0014\u0005\u0007-f!\t!!*\t\u000f\u0005\u001d\u0016\u0004\"\u0001\u0002*\"9\u0011\u0011Y\r\u0005\u0002\u0005\r\u0007\"CAf3\u0005\u0005I\u0011BAg\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0015\t\u0001\u0013%\u0001\u0004mS:\fGn\u001a\u0006\u0003E\r\nQ!\u001c7mS\nT!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\r\u00011&\r\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u001aT\"A\u0010\n\u0005Qz\"A\u0002,fGR|'/\u0001\u0003tSj,W#A\u001c\u0011\u00051B\u0014BA\u001d.\u0005\rIe\u000e\u001e\u0015\u0004\u0003m\n\u0005C\u0001\u001f@\u001b\u0005i$B\u0001 $\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0001v\u0012QaU5oG\u0016\f\u0013AQ\u0001\u0006c9\u0002d\u0006M\u0001\u0006g&TX\r\t\u0015\u0004\u0005m\n\u0015aB5oI&\u001cWm]\u000b\u0002\u000fB\u0019A\u0006S\u001c\n\u0005%k#!B!se\u0006L\bfA\u0002<\u0003\u0006A\u0011N\u001c3jG\u0016\u001c\b\u0005K\u0002\u0005w\u0005\u000baA^1mk\u0016\u001cX#A(\u0011\u00071B\u0005\u000b\u0005\u0002-#&\u0011!+\f\u0002\u0007\t>,(\r\\3)\u0007\u0015Y\u0014)A\u0004wC2,Xm\u001d\u0011)\u0007\u0019Y\u0014)\u0001\u0004=S:LGO\u0010\u000b\u00051f[V\f\u0005\u00023\u0001!)Qg\u0002a\u0001o!\u001a\u0011lO!\t\u000b\u0015;\u0001\u0019A$)\u0007m[\u0014\tC\u0003N\u000f\u0001\u0007q\nK\u0002^w\u0005C3aB\u001eB\u0003!!xn\u0015;sS:<G#\u00012\u0011\u0005\rTgB\u00013i!\t)W&D\u0001g\u0015\t9\u0017&\u0001\u0004=e>|GOP\u0005\u0003S6\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011.L\u0001\bi>\f%O]1zQ\rI1(Q\u0001\u0005G>\u0004\u00180F\u0001YQ\rQ1H]\u0011\u0002g\u0006)\u0011GL\u0019/a\u0005A\u0011m\u001d\"sK\u0016TX-F\u0001w!\r98\u0010U\u0007\u0002q*\u0011\u0001%\u001f\u0006\u0002u\u00061!M]3fu\u0016L!\u0001\u000e=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005As\b\"B@\r\u0001\u00049\u0014!A5\u0002\r\u0015\fX/\u00197t)\u0011\t)!a\u0003\u0011\u00071\n9!C\u0002\u0002\n5\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u000e5\u0001\r!a\u0004\u0002\u000b=$\b.\u001a:\u0011\u00071\n\t\"C\u0002\u0002\u00145\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#A\u001c\u0002\u00159,X.Q2uSZ,7\u000f\u000b\u0003\u0010w\u0005u\u0011EAA\u0010\u0003\u0015\td\u0006\u000e\u00181\u0003-qW/\u001c(p]j,'o\\:)\tAY\u0014QD\u0001\u0011i>\u001c\u0006/\u0019:tK^KG\u000f[*ju\u0016$2\u0001WA\u0015\u0011\u0019\tY#\u0005a\u0001o\u0005\u0019aN\u001c>\u0002\r\u0005\u0014x-\\1yQ\u0011\u00112(!\r\"\u0005\u0005M\u0012!B\u0019/k9\u0002\u0014!B:mS\u000e,Gc\u0001-\u0002:!1\u00111H\nA\u0002\u001d\u000bqb]3mK\u000e$X\rZ%oI&\u001cWm]\u0001\u0007i>T5o\u001c8\u0016\u0003\tDC\u0001F\u001e\u0002D\u0005\u0012\u0011QI\u0001\u0006c92d\u0006M\u0001\u0005CNlE*\u0006\u0002\u0002LA!\u0011QJA+\u001b\t\tyEC\u0002!\u0003#R1!a\u0015$\u0003\tiG.C\u0002\u001f\u0003\u001fBC!F\u001e\u0002Z\u0005\u0012\u00111L\u0001\u0006e9\u0002d\u0006M\u0001\tSR,'/\u0019;peV\u0011\u0011\u0011\r\t\u0007\u0003G\ni'a\u001d\u000f\t\u0005\u0015\u0014\u0011\u000e\b\u0004K\u0006\u001d\u0014\"\u0001\u0018\n\u0007\u0005-T&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0014\u0011\u000f\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111N\u0017\u0011\u000b1\n)h\u000e)\n\u0007\u0005]TF\u0001\u0004UkBdWMM\u0001\u000fC\u000e$\u0018N^3Ji\u0016\u0014\u0018\r^8sQ\u001d\u0001\u0011QPAG\u0003\u001f\u0003B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))A\u0003usB,7OC\u0002\u0002\b\u000e\n1a]9m\u0013\u0011\tY)!!\u0003%M\u000bF*V:fe\u0012+g-\u001b8fIRK\b/Z\u0001\u0004k\u0012$8EAAI!\r\u0011\u00141S\u0005\u0004\u0003+{\"!\u0003,fGR|'/\u0016#UQ\r\u00011(Q\u0001\r'B\f'o]3WK\u000e$xN\u001d\t\u0003ee\u0019B!G\u0016\u0002 B\u0019A&!)\n\u0007\u0005\rVF\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\u001c\u00069QO\\1qa2LH\u0003BAV\u0003o\u0003R\u0001LAW\u0003cK1!a,.\u0005\u0019y\u0005\u000f^5p]B1A&a-8\u000f>K1!!..\u0005\u0019!V\u000f\u001d7fg!1\u0011\u0011X\u000eA\u0002a\u000b!a\u001d<)\tmY\u0014QX\u0011\u0003\u0003\u007f\u000bQ!\r\u00184]A\naA\u001a:p[6cEc\u0001-\u0002F\"9\u0011q\u0019\u000fA\u0002\u0005-\u0013!\u0001<)\tqY\u0014\u0011L\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002PB!\u0011\u0011[An\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017\u0001\u00027b]\u001eT!!!7\u0002\t)\fg/Y\u0005\u0005\u0003;\f\u0019N\u0001\u0004PE*,7\r\u001e\u0015\u00053m\ni\f\u000b\u0003\u0019w\u0005u\u0006")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static SparseVector fromML(org.apache.spark.ml.linalg.SparseVector sparseVector) {
        return SparseVector$.MODULE$.fromML(sparseVector);
    }

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreach$(this, f);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachActive$(this, f);
    }

    @Override
    public void foreachNonZero(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachNonZero$(this, f);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public double dot(Vector v) {
        return Vector.dot$(this, v);
    }

    @Override
    public Iterator<Tuple2<Object, Object>> nonZeroIterator() {
        return Vector.nonZeroIterator$(this);
    }

    @Override
    public double sparsity() {
        return Vector.sparsity$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new java.lang.StringBuilder(4).append("(").append(this.size()).append(",").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).mkString("[", ",", "]")).append(",").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).mkString("[", ",", "]")).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException(new java.lang.StringBuilder(26).append("Index ").append(i).append(" out of bounds [0, ").append(this.size()).append(")").toString());
        }
        int j = Arrays.binarySearch(this.indices(), i);
        return j < 0 ? 0.0 : this.values()[j];
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v == 0.0) break block0;
                ++nnz$3.elem;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
                ii$2[k$2.elem] = i;
                vv$2[k$2.elem] = v;
                ++k$2.elem;
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedIndices)).flatMap((Function1 & Serializable & scala.Serializable)origIdx -> SparseVector.$anonfun$slice$1(this, currentIdx, BoxesRunTime.unboxToInt((Object)origIdx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] sliceInds = (int[])tuple2._1();
        double[] sliceVals = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
        Tuple2 tuple23 = tuple22;
        int[] sliceInds2 = (int[])tuple23._1();
        double[] sliceVals2 = (double[])tuple23._2();
        return new SparseVector(selectedIndices.length, sliceInds2, sliceVals2);
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$1 = jValue = JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)this.size())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indices"), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public org.apache.spark.ml.linalg.SparseVector asML() {
        return new org.apache.spark.ml.linalg.SparseVector(this.size(), this.indices(), this.values());
    }

    @Override
    public Iterator<Tuple2<Object, Object>> iterator() {
        int localSize = this.size();
        int localNumActives = this.numActives();
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        return new Iterator<Tuple2<Object, Object>>(null, localIndices, localSize, localNumActives, localValues){
            private int i;
            private int j;
            private int k;
            private final int[] localIndices$1;
            private final int localSize$1;
            private final int localNumActives$1;
            private final double[] localValues$2;

            public Iterator<Tuple2<Object, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<Object, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<Object, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<Object, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<Object, Object>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<Object, Object>> filter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<Object, Object>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<Object, Object>> withFilter(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> filterNot(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<Object, Object>> takeWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> partition(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> span(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<Object, Object>> dropWhile(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<Object, Object>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<Object, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<Object, Object>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<Object, Object>> find(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<Object, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<Object, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<Object, Object>>, Iterator<Tuple2<Object, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<Object, Object>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<Object, Object>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<Object, Object>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<Object, Object>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<Object, Object>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<Object, Object>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<Object, Object>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<Object, Object>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<Object, Object>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<Object, Object>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<Object, Object>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<Object, Object>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<Object, Object>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<Object, Object>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public scala.collection.immutable.Vector<Tuple2<Object, Object>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<Object, Object>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple2<Object, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            private int j() {
                return this.j;
            }

            private void j_$eq(int x$1) {
                this.j = x$1;
            }

            private int k() {
                return this.k;
            }

            private void k_$eq(int x$1) {
                this.k = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.localSize$1;
            }

            public Tuple2<Object, Object> next() {
                double d;
                if (this.i() == this.k()) {
                    this.j_$eq(this.j() + 1);
                    this.k_$eq(this.j() < this.localNumActives$1 ? this.localIndices$1[this.j()] : -1);
                    d = this.localValues$2[this.j() - 1];
                } else {
                    d = 0.0;
                }
                double v = d;
                this.i_$eq(this.i() + 1);
                return new Tuple2.mcID.sp(this.i() - 1, v);
            }
            {
                this.localIndices$1 = localIndices$1;
                this.localSize$1 = localSize$1;
                this.localNumActives$1 = localNumActives$1;
                this.localValues$2 = localValues$2;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
                this.j = 0;
                this.k = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(localIndices$1)).headOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$k$1()}, serializedLambda);
            }
        };
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeIterator() {
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        return package$.MODULE$.Iterator().tabulate(this.numActives(), (Function1 & Serializable & scala.Serializable)j -> SparseVector.$anonfun$activeIterator$1(localIndices, localValues, BoxesRunTime.unboxToInt((Object)j)));
    }

    public static final /* synthetic */ Iterator $anonfun$slice$1(SparseVector $this, IntRef currentIdx$1, int origIdx) {
        int iIdx = Arrays.binarySearch($this.indices(), origIdx);
        Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(currentIdx$1.elem, $this.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        ++currentIdx$1.elem;
        return i_v;
    }

    public static final /* synthetic */ Tuple2 $anonfun$activeIterator$1(int[] localIndices$2, double[] localValues$3, int j) {
        return new Tuple2.mcID.sp(localIndices$2[j], localValues$3[j]);
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable & scala.Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(127).append("Sparse vectors require that the dimension of the").append(" indices match the dimension of the values. You provided ").append(this.indices().length).append(" indices and ").append(" ").append(this.values().length).append(" values.").toString());
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(75).append("You provided ").append(this.indices().length).append(" indices and values, ").append("which exceeds the specified vector size ").append(this.size()).append(".").toString());
    }
}

