/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.AFTSurvivalRegressionWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.AFTSurvivalRegression;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class AFTSurvivalRegressionWrapper$
implements MLReadable<AFTSurvivalRegressionWrapper> {
    public static AFTSurvivalRegressionWrapper$ MODULE$;
    private final Regex FORMULA_REGEXP;

    static {
        new AFTSurvivalRegressionWrapper$();
    }

    private Regex FORMULA_REGEXP() {
        return this.FORMULA_REGEXP;
    }

    private Tuple2<String, String> formulaRewrite(String formula) {
        String rewrittenFormula = null;
        String censorCol = null;
        try {
            String string = formula;
            Option option = this.FORMULA_REGEXP().unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)string);
            }
            String label = (String)((LinearSeqOptimized)option.get()).apply(0);
            String censor = (String)((LinearSeqOptimized)option.get()).apply(1);
            String features = (String)((LinearSeqOptimized)option.get()).apply(2);
            Tuple3 tuple3 = new Tuple3((Object)label, (Object)censor, (Object)features);
            String label2 = (String)tuple3._1();
            String censor2 = (String)tuple3._2();
            String features2 = (String)tuple3._3();
            if (features2.contains(".")) {
                throw new UnsupportedOperationException("Terms of survreg formula can not support dot operator.");
            }
            rewrittenFormula = new StringBuilder(1).append(label2.trim()).append("~").append(features2.trim()).toString();
            censorCol = censor2.trim();
        }
        catch (MatchError e) {
            throw new SparkException(new StringBuilder(25).append("Could not parse formula: ").append(formula).toString());
        }
        return new Tuple2((Object)rewrittenFormula, (Object)censorCol);
    }

    public AFTSurvivalRegressionWrapper fit(String formula, Dataset<Row> data, int aggregationDepth, String stringIndexerOrderType) {
        Tuple2<String, String> tuple2 = this.formulaRewrite(formula);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String rewrittenFormula = (String)tuple2._1();
        String censorCol = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rewrittenFormula, (Object)censorCol);
        String rewrittenFormula2 = (String)tuple22._1();
        String censorCol2 = (String)tuple22._2();
        RFormula rFormula = new RFormula().setFormula(rewrittenFormula2).setStringIndexerOrderType(stringIndexerOrderType);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(rFormula.getFeaturesCol())).attributes().get();
        String[] features = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureAttrs)).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3.name().get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        AFTSurvivalRegression aft = ((AFTSurvivalRegression)new AFTSurvivalRegression().setCensorCol(censorCol2).setFitIntercept(rFormula.hasIntercept()).setFeaturesCol(rFormula.getFeaturesCol())).setAggregationDepth(aggregationDepth);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, aft})).fit((Dataset)data);
        return new AFTSurvivalRegressionWrapper((PipelineModel)pipeline, features);
    }

    @Override
    public MLReader<AFTSurvivalRegressionWrapper> read() {
        return new AFTSurvivalRegressionWrapper.AFTSurvivalRegressionWrapperReader();
    }

    @Override
    public AFTSurvivalRegressionWrapper load(String path) {
        return (AFTSurvivalRegressionWrapper)MLReadable.load$(this, path);
    }

    private AFTSurvivalRegressionWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        this.FORMULA_REGEXP = new StringOps(Predef$.MODULE$.augmentString("Surv\\(([^,]+), ([^,]+)\\) ~ (.+)")).r();
    }
}

