/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.PolynomialExpansion;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;

public class JavaPolynomialExpansionSuite
extends SharedSparkSession {
    @Test
    public void polynomialExpansionTest() {
        PolynomialExpansion polyExpansion = ((PolynomialExpansion)((PolynomialExpansion)new PolynomialExpansion().setInputCol("features")).setOutputCol("polyFeatures")).setDegree(3);
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double)-2.0, (double[])new double[]{2.3}), Vectors.dense((double)-2.0, (double[])new double[]{4.0, -8.0, 2.3, -4.6, 9.2, 5.29, -10.58, 12.17})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.0, (double[])new double[]{0.0}), Vectors.dense((double[])new double[9])}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.6, (double[])new double[]{-1.1}), Vectors.dense((double)0.6, (double[])new double[]{0.36, 0.216, -1.1, -0.66, -0.396, 1.21, 0.726, -1.331})}));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty()), new StructField("expected", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset dataset = this.spark.createDataFrame(data, schema);
        List pairs = polyExpansion.transform(dataset).select("polyFeatures", new String[]{"expected"}).collectAsList();
        for (Row r : pairs) {
            double[] polyFeatures = ((Vector)r.get(0)).toArray();
            double[] expected = ((Vector)r.get(1)).toArray();
            Assert.assertArrayEquals((double[])polyFeatures, (double[])expected, (double)0.1);
        }
    }
}

