/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;

public class JavaVectorAssemblerSuite
extends SharedSparkSession {
    @Test
    public void testVectorAssembler() {
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"x", (DataType)DataTypes.DoubleType, (boolean)false), DataTypes.createStructField((String)"y", (DataType)new VectorUDT(), (boolean)false), DataTypes.createStructField((String)"name", (DataType)DataTypes.StringType, (boolean)false), DataTypes.createStructField((String)"z", (DataType)new VectorUDT(), (boolean)false), DataTypes.createStructField((String)"n", (DataType)DataTypes.LongType, (boolean)false)});
        Row row = RowFactory.create((Object[])new Object[]{0, 0.0, Vectors.dense((double)1.0, (double[])new double[]{2.0}), "a", Vectors.sparse((int)2, (int[])new int[]{1}, (double[])new double[]{3.0}), 10L});
        Dataset dataset = this.spark.createDataFrame(Arrays.asList(row), schema);
        VectorAssembler assembler = new VectorAssembler().setInputCols(new String[]{"x", "y", "z", "n"}).setOutputCol("features");
        Dataset output = assembler.transform(dataset);
        Assert.assertEquals((Object)Vectors.sparse((int)6, (int[])new int[]{1, 2, 4, 5}, (double[])new double[]{1.0, 2.0, 3.0, 10.0}), (Object)((Row)output.select("features", new String[0]).first()).getAs(0));
    }
}

