/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.feature.VectorAssembler$;
import org.apache.spark.ml.feature.VectorAssemblerSuite$;
import org.apache.spark.ml.feature.VectorSizeHint;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple8;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E3AAB\u0004\u0001%!)A\u0005\u0001C\u0001K!I\u0001\u0006\u0001a\u0001\u0002\u0004%\t!\u000b\u0005\n\t\u0002\u0001\r\u00111A\u0005\u0002\u0015C\u0011\"\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0016\t\u000b=\u0003A\u0011\t)\u0003)Y+7\r^8s\u0003N\u001cX-\u001c2mKJ\u001cV/\u001b;f\u0015\tA\u0011\"A\u0004gK\u0006$XO]3\u000b\u0005)Y\u0011AA7m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0005\u0001M9r\u0004\u0005\u0002\u0015+5\t1\"\u0003\u0002\u0017\u0017\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u00039-\tQ!\u001c7mS\nL!AH\r\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yiB\u0011\u0001EI\u0007\u0002C)\u0011!$C\u0005\u0003G\u0005\u0012A\u0003R3gCVdGOU3bI^\u0013\u0018\u000e^3UKN$\u0018A\u0002\u001fj]&$h\bF\u0001'!\t9\u0003!D\u0001\b\u0003I!gmV5uQ:+H\u000e\\:B]\u0012t\u0015MT:\u0016\u0003)\u0002$aK\u001a\u0011\u00071z\u0013'D\u0001.\u0015\tq3\"A\u0002tc2L!\u0001M\u0017\u0003\u000f\u0011\u000bG/Y:fiB\u0011!g\r\u0007\u0001\t%!D!!A\u0001\u0002\u000b\u0005QHA\u0002`IE\n1\u0003\u001a4XSRDg*\u001e7mg\u0006sGMT1Og\u0002B#\u0001B\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018C\u0001 B!\tAt(\u0003\u0002As\t9aj\u001c;iS:<\u0007C\u0001\u001dC\u0013\t\u0019\u0015HA\u0002B]f\fa\u0003\u001a4XSRDg*\u001e7mg\u0006sGMT1Og~#S-\u001d\u000b\u0003\r&\u0003\"\u0001O$\n\u0005!K$\u0001B+oSRDqAS\u0002\u0002\u0002\u0003\u00071*A\u0002yIE\u0002$\u0001\u0014(\u0011\u00071zS\n\u0005\u00023\u001d\u0012IA'SA\u0001\u0002\u0003\u0015\t!P\u0001\nE\u00164wN]3BY2$\u0012A\u0012")
public class VectorAssemblerSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> dfWithNullsAndNaNs;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Dataset<?> dfWithNullsAndNaNs() {
        return this.dfWithNullsAndNaNs;
    }

    public void dfWithNullsAndNaNs_$eq(Dataset<?> x$1) {
        this.dfWithNullsAndNaNs = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        Vector sv = Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{3.0});
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorAssemblerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple8"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Long").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})));
            }

            public Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator6$1(VectorAssemblerSuite $outer) {
            }
        }
        this.dfWithNullsAndNaNs_$eq(this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple8((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)Predef$.MODULE$.double2Double(0.0), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), (Object)"a", (Object)sv, (Object)BoxesRunTime.boxToLong((long)7L), null), (List)new .colon.colon((Object)new Tuple8((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)Predef$.MODULE$.double2Double(0.0), null, (Object)"a", (Object)sv, (Object)BoxesRunTime.boxToLong((long)6L), null), (List)new .colon.colon((Object)new Tuple8((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToLong((long)3L), null, (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), (Object)"a", (Object)sv, (Object)BoxesRunTime.boxToLong((long)8L), null), (List)new .colon.colon((Object)new Tuple8((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToLong((long)4L), null, null, (Object)"a", (Object)sv, (Object)BoxesRunTime.boxToLong((long)9L), null), (List)new .colon.colon((Object)new Tuple8((Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToLong((long)5L), (Object)Predef$.MODULE$.double2Double(Double.NaN), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), (Object)"a", (Object)sv, (Object)BoxesRunTime.boxToLong((long)7L), null), (List)new .colon.colon((Object)new Tuple8((Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToLong((long)6L), (Object)Predef$.MODULE$.double2Double(Double.NaN), null, (Object)"a", (Object)sv, (Object)BoxesRunTime.boxToLong((long)8L), null), (List)Nil$.MODULE$)))))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id1", "id2", "x", "y", "name", "z", "n", "nulls"})));
    }

    private final void testImplicits$lzycompute$1() {
        VectorAssemblerSuite vectorAssemblerSuite = this;
        synchronized (vectorAssemblerSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$24(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"y"), (Object)BoxesRunTime.boxToInteger((int)2));
        return !(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null);
    }

    private final Dataset runWithMetadata$1(String mode, String additional_filter, VectorAssembler assembler$2) {
        AttributeGroup attributeY = new AttributeGroup("y", 2);
        AttributeGroup attributeZ = new AttributeGroup("z", (Attribute[])((Object[])new Attribute[]{NumericAttribute$.MODULE$.defaultAttr().withName("foo"), NumericAttribute$.MODULE$.defaultAttr().withName("bar")}));
        Dataset dfWithMetadata = this.dfWithNullsAndNaNs().withColumn("y", functions$.MODULE$.col("y"), attributeY.toMetadata()).withColumn("z", functions$.MODULE$.col("z"), attributeZ.toMetadata()).filter(additional_filter);
        Dataset output = assembler$2.setHandleInvalid(mode).transform(dfWithMetadata);
        output.collect();
        return output;
    }

    private static final String runWithMetadata$default$2$1() {
        return "true";
    }

    private final Dataset runWithFirstRow$1(String mode, VectorAssembler assembler$2) {
        Dataset output = assembler$2.setHandleInvalid(mode).transform(this.dfWithNullsAndNaNs());
        output.collect();
        return output;
    }

    private final Dataset runWithAllNullVectors$1(String mode, VectorAssembler assembler$2) {
        Dataset output = assembler$2.setHandleInvalid(mode).transform(this.dfWithNullsAndNaNs().filter("0 == id1 % 2"));
        output.collect();
        return output;
    }

    public VectorAssemblerSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParamsSuite$.MODULE$.checkParams((Params)new VectorAssembler()), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("assemble", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.0)})));
            Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{1, 1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.0), BoxesRunTime.boxToDouble((double)1.0)})));
            Vector $org_scalatest_assert_macro_right2 = Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{1.0});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Vector dv = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{1, 2, 1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.0), dv, BoxesRunTime.boxToDouble((double)1.0)})));
            Vector $org_scalatest_assert_macro_right3 = Vectors$.MODULE$.sparse(4, new int[]{1, 3}, new double[]{2.0, 1.0});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Vector sv = Vectors$.MODULE$.sparse(2, new int[]{0, 1}, new double[]{3.0, 4.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{1, 2, 1, 2}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.0), dv, BoxesRunTime.boxToDouble((double)1.0), sv})));
            Vector $org_scalatest_assert_macro_right4 = Vectors$.MODULE$.sparse(6, new int[]{1, 3, 4, 5}, new double[]{2.0, 1.0, 3.0, 4.0});
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}))).foreach((Function1 & Serializable & scala.Serializable)v -> {
                this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.assemble(new int[]{1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                return (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.assemble(new int[]{1, 1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), v})), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            });
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("assemble should compress vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector v2;
            Vector v1;
            Vector $org_scalatest_assert_macro_left = v1 = VectorAssembler$.MODULE$.assemble(new int[]{1, 1, 1, 1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.0), BoxesRunTime.boxToDouble((double)0.0), BoxesRunTime.boxToDouble((double)0.0), Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.ml.linalg.SparseVector", $org_scalatest_assert_macro_left instanceof SparseVector, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            Vector sv = Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{4.0});
            Vector $org_scalatest_assert_macro_left2 = v2 = VectorAssembler$.MODULE$.assemble(new int[]{1, 1, 1, 1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToDouble((double)3.0), sv}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.linalg.DenseVector", $org_scalatest_assert_macro_left2 instanceof DenseVector, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("VectorAssembler", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorAssemblerSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator6$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
                }

                public Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator6$2(VectorAssemblerSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), (Object)"a", (Object)Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{3.0}), (Object)BoxesRunTime.boxToLong((long)10L)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator6$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "x", "y", "name", "z", "n"}));
            VectorAssembler assembler = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"x", "y", "z", "n"})).setOutputCol("features");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assembler.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Object v;
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (v = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                    Vector vector = (Vector)v;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(vector);
                    Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(6, new int[]{1, 2, 4, 5}, new double[]{1.0, 2.0, 3.0, 10.0});
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                }
                throw new MatchError((Object)row);
            });
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("transform should throw an exception in case of unsupported type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorAssemblerSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator16$1(VectorAssemblerSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)"a", (Object)"b", (Object)"c"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
            VectorAssembler assembler = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"a", "b", "c"})).setOutputCol("features");
            IllegalArgumentException thrown = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> assembler.transform(df), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            String $org_scalatest_assert_macro_left = thrown.getMessage();
            String $org_scalatest_assert_macro_right = "Data type string of column a is not supported.\nData type string of column b is not supported.\nData type string of column c is not supported.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("ML attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NominalAttribute browser = NominalAttribute$.MODULE$.defaultAttr().withValues("chrome", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firefox", "safari"}));
            NumericAttribute hour = NumericAttribute$.MODULE$.defaultAttr().withMin(0.0).withMax(24.0);
            AttributeGroup user = new AttributeGroup("user", (Attribute[])((Object[])new Attribute[]{NominalAttribute$.MODULE$.defaultAttr().withName("gender").withValues("male", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"female"})), NumericAttribute$.MODULE$.defaultAttr().withName("salary")}));
            Tuple5 row = new Tuple5((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1000.0})), (Object)Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{2.0}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorAssemblerSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator26$1(VectorAssemblerSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)row, (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"browser", "hour", "count", "user", "ad"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("browser").as("browser", browser.toMetadata()), functions$.MODULE$.col("hour").as("hour", hour.toMetadata()), functions$.MODULE$.col("count"), functions$.MODULE$.col("user").as("user", user.toMetadata()), functions$.MODULE$.col("ad")}));
            VectorAssembler assembler = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"browser", "hour", "count", "user", "ad"})).setOutputCol("features");
            Dataset output = assembler.transform(df);
            StructType schema = output.schema();
            AttributeGroup features = AttributeGroup$.MODULE$.fromStructField(schema.apply("features"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)features.size()));
            int $org_scalatest_assert_macro_right = 7;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Attribute browserOut = features.getAttr(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(browserOut);
            NominalAttribute $org_scalatest_assert_macro_right2 = browser.withIndex(0).withName("browser");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            Attribute hourOut = features.getAttr(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(hourOut);
            NumericAttribute $org_scalatest_assert_macro_right3 = hour.withIndex(1).withName("hour");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            Attribute countOut = features.getAttr(2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(countOut);
            NumericAttribute $org_scalatest_assert_macro_right4 = NumericAttribute$.MODULE$.defaultAttr().withName("count").withIndex(2);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            Attribute userGenderOut = features.getAttr(3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(userGenderOut);
            Attribute $org_scalatest_assert_macro_right5 = user.getAttr("gender").withName("user_gender").withIndex(3);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Attribute userSalaryOut = features.getAttr(4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(userSalaryOut);
            Attribute $org_scalatest_assert_macro_right6 = user.getAttr("salary").withName("user_salary").withIndex(4);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(features.getAttr(5));
            NumericAttribute $org_scalatest_assert_macro_right7 = NumericAttribute$.MODULE$.defaultAttr().withIndex(5).withName("ad_0");
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(features.getAttr(6));
            NumericAttribute $org_scalatest_assert_macro_right8 = NumericAttribute$.MODULE$.defaultAttr().withIndex(6).withName("ad_1");
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            VectorAssembler t = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"myInputCol", "myInputCol2"})).setOutputCol("myOutputCol");
            return this.testDefaultReadWrite(t, this.testDefaultReadWrite$default$2());
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("SPARK-22446: VectorAssembler's UDF should not apply on filtered data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorAssemblerSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
                }

                public Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator36$1(VectorAssemblerSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), (Object)"a", (Object)Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{3.0}), (Object)BoxesRunTime.boxToLong((long)10L)), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)1.0), null, (Object)"b", null, (Object)BoxesRunTime.boxToLong((long)20L)), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator36$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "x", "y", "name", "z", "n"}));
            VectorAssembler assembler = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"x", "z", "n"})).setOutputCol("features");
            Dataset filteredDF = df.filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$).isNotNull());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(VectorAssemblerSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator41$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator41$1(VectorAssemblerSuite $outer) {
                }
            }
            UserDefinedFunction vectorUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> BoxesRunTime.boxToInteger((int)vector.numActives()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator41$1(null)));
            long $org_scalatest_assert_macro_left = assembler.transform(filteredDF).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter(vectorUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}))).$((Seq)Nil$.MODULE$)})).$greater((Object)BoxesRunTime.boxToInteger((int)1))).count();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("assemble should keep nulls when keepInvalid is true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{1, 1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), null})));
            Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double.NaN}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{1, 2}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), null})));
            Vector $org_scalatest_assert_macro_right2 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double.NaN, Double.NaN}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{1}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Vector $org_scalatest_assert_macro_right3 = Vectors$.MODULE$.dense(Double.NaN, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(VectorAssembler$.MODULE$.assemble(new int[]{2}, true, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Vector $org_scalatest_assert_macro_right4 = Vectors$.MODULE$.dense(Double.NaN, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double.NaN}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("assemble should throw errors when keepInvalid is false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.assemble(new int[]{1, 1}, false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), null})), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.assemble(new int[]{1, 2}, false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), null})), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.assemble(new int[]{1}, false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            return (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.assemble(new int[]{2}, false, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("get lengths functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset<?> df = this.dfWithNullsAndNaNs();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(VectorAssembler$.MODULE$.getVectorLengthsFromFirstRow(df, (Seq)new .colon.colon((Object)"y", (List)Nil$.MODULE$)));
            Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"y"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            String $org_scalatest_assert_macro_left2 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.getVectorLengthsFromFirstRow(df.sort("id2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)new .colon.colon((Object)"y", (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191))).getMessage();
            String $org_scalatest_assert_macro_right2 = "VectorSizeHint";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            String $org_scalatest_assert_macro_left3 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.getVectorLengthsFromFirstRow(df.filter("id1 > 6"), (Seq)new .colon.colon((Object)"y", (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193))).getMessage();
            String $org_scalatest_assert_macro_right3 = "VectorSizeHint";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            Map $org_scalatest_assert_macro_left4 = VectorAssembler$.MODULE$.getLengths(df.sort("id2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)new .colon.colon((Object)"y", (List)Nil$.MODULE$), VectorAssembler$.MODULE$.SKIP_INVALID());
            Tuple2 $org_scalatest_assert_macro_right4 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"y"), (Object)BoxesRunTime.boxToInteger((int)2));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left4, (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VectorAssemblerSuite.$anonfun$new$24(x$1))), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            String $org_scalatest_assert_macro_left5 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.getLengths(df.sort("id2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)new .colon.colon((Object)"y", (List)Nil$.MODULE$), VectorAssembler$.MODULE$.ERROR_INVALID()), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197))).getMessage();
            String $org_scalatest_assert_macro_right5 = "VectorSizeHint";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            String $org_scalatest_assert_macro_left6 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> VectorAssembler$.MODULE$.getLengths(df.sort("id2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)new .colon.colon((Object)"y", (List)Nil$.MODULE$), VectorAssembler$.MODULE$.KEEP_INVALID()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199))).getMessage();
            String $org_scalatest_assert_macro_right6 = "VectorSizeHint";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("Handle Invalid should behave properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            VectorAssembler assembler = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"x", "y", "z", "n"})).setOutputCol("features");
            long $org_scalatest_assert_macro_left = this.runWithMetadata$1("keep", VectorAssemblerSuite.runWithMetadata$default$2$1(), assembler).count();
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should keep all rows", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            long $org_scalatest_assert_macro_left2 = this.runWithMetadata$1("skip", VectorAssemblerSuite.runWithMetadata$default$2$1(), assembler).count();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should skip rows with nulls", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.runWithMetadata$1("error", VectorAssemblerSuite.runWithMetadata$default$2$1(), assembler), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.runWithMetadata$1("error", "id1 > 4", assembler), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            String $org_scalatest_assert_macro_left3 = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.runWithFirstRow$1("keep", assembler).count(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244))).getMessage();
            String $org_scalatest_assert_macro_right3 = "VectorSizeHint";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should suggest to use metadata", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            long $org_scalatest_assert_macro_left4 = this.runWithFirstRow$1("skip", assembler).count();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"should infer size and skip rows with nulls", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.runWithFirstRow$1("error", assembler), ClassTag$.MODULE$.apply(SparkException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            String $org_scalatest_assert_macro_left5 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.runWithAllNullVectors$1("skip", assembler), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250))).getMessage();
            String $org_scalatest_assert_macro_right5 = "VectorSizeHint";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"should suggest to use metadata", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            String $org_scalatest_assert_macro_left6 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.runWithAllNullVectors$1("error", assembler), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252))).getMessage();
            String $org_scalatest_assert_macro_right6 = "VectorSizeHint";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"should suggest to use metadata", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            long $org_scalatest_assert_macro_left7 = this.runWithMetadata$1("keep", "id1 > 2", assembler).count();
            int $org_scalatest_assert_macro_right7 = 4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == (long)$org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("SPARK-25371: VectorAssembler with empty inputCols", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            VectorAssembler vectorAssembler = new VectorAssembler().setInputCols((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))).setOutputCol("a");
            Dataset output = vectorAssembler.transform(this.dfWithNullsAndNaNs());
            Row $org_scalatest_assert_macro_left = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.select("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).limit(1).collect())).head();
            Row $org_scalatest_assert_macro_right = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Vectors$.MODULE$.sparse(0, (Seq)Nil$.MODULE$)}));
            Row row = $org_scalatest_assert_macro_left;
            Row row2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(row != null ? !row.equals(row2) : row2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("SPARK-31671: should give explicit error message when can not infer column lengths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorAssemblerSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator47$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator47$1(VectorAssemblerSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), (Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorAssemblerSuite$$typecreator47$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n1", "n2"}));
            Dataset hintedDf = new VectorSizeHint().setInputCol("n1").setSize(1).transform(df);
            VectorAssembler assembler = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"n1", "n2"})).setOutputCol("features");
            String $org_scalatest_assert_macro_left = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> assembler.setHandleInvalid("keep").transform(hintedDf), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272))).getMessage();
            String $org_scalatest_assert_macro_right = "n1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should only show no vector size columns' name", Prettifier$.MODULE$.default(), new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        }, new Position("VectorAssemblerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
    }
}

