/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.MultinomialLogisticBlockAggregator;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001E\t\u0001=!)1\u0006\u0001C\u0001Y!Iq\u0006\u0001a\u0001\u0002\u0004%\t\u0001\r\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002yB\u0011\u0002\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u0019\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0004\"\u0003&\u0001\u0001\u0004\u0005\r\u0011\"\u0001L\u0011%i\u0005\u00011A\u0001B\u0003&\u0011\u0007C\u0005P\u0001\u0001\u0007\t\u0019!C\u0001a!I\u0001\u000b\u0001a\u0001\u0002\u0004%\t!\u0015\u0005\n'\u0002\u0001\r\u0011!Q!\nEB\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0001\u0019\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00039\u0006\"C-\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015i\u0006\u0001\"\u0003_\u0005\u001djU\u000f\u001c;j]>l\u0017.\u00197M_\u001eL7\u000f^5d\u00052|7m[!hOJ,w-\u0019;peN+\u0018\u000e^3\u000b\u0005I\u0019\u0012AC1hOJ,w-\u0019;pe*\u0011A#F\u0001\u0006_B$\u0018.\u001c\u0006\u0003-]\t!!\u001c7\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?\r\u0002\"\u0001I\u0011\u000e\u0003]I!AI\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003vi&d'B\u0001\u0015\u0018\u0003\u0015iG\u000e\\5c\u0013\tQSEA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u0005\t\u0012!C5ogR\fgnY3t+\u0005\t\u0004c\u0001\u001a6o5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0003BeJ\f\u0017\u0010\u0005\u00029w5\t\u0011H\u0003\u0002;+\u00059a-Z1ukJ,\u0017B\u0001\u001f:\u0005!Ien\u001d;b]\u000e,\u0017!D5ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011!\u0007Q\u0005\u0003\u0003N\u0012A!\u00168ji\"91iAA\u0001\u0002\u0004\t\u0014a\u0001=%c\u0005Q\u0011N\\:uC:\u001cWm\u001d\u0011)\u0005\u00111\u0005C\u0001\u001aH\u0013\tA5GA\u0005ue\u0006t7/[3oi\u0006A\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3\u00029%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014Xm\u0018\u0013fcR\u0011q\b\u0014\u0005\b\u0007\u001a\t\t\u00111\u00012\u0003eIgn\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e$fCR,(/\u001a\u0011)\u0005\u001d1\u0015\u0001I5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u001aKG\u000e^3sK\u0012\fA%\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:f\r&dG/\u001a:fI~#S-\u001d\u000b\u0003\u007fICqaQ\u0005\u0002\u0002\u0003\u0007\u0011'A\u0011j]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u00164\u0015\u000e\u001c;fe\u0016$\u0007\u0005\u000b\u0002\u000b\r\u0006y1oY1mK\u0012Len\u001d;b]\u000e,7/A\ntG\u0006dW\rZ%ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002@1\"91\tDA\u0001\u0002\u0004\t\u0014\u0001E:dC2,G-\u00138ti\u0006t7-Z:!Q\tia)A\u0005cK\u001a|'/Z!mYR\tq(\u0001\thKRtUm^!hOJ,w-\u0019;peR)qLY2laB\u0011a\u0006Y\u0005\u0003CF\u0011!%T;mi&tw.\\5bY2{w-[:uS\u000e\u0014En\\2l\u0003\u001e<'/Z4bi>\u0014\b\"B\u0018\u0010\u0001\u0004\t\u0004\"\u00023\u0010\u0001\u0004)\u0017\u0001D2pK\u001a4\u0017nY5f]R\u001c\bC\u00014j\u001b\u00059'B\u00015\u0016\u0003\u0019a\u0017N\\1mO&\u0011!n\u001a\u0002\u0007-\u0016\u001cGo\u001c:\t\u000b1|\u0001\u0019A7\u0002\u0019\u0019LG/\u00138uKJ\u001cW\r\u001d;\u0011\u0005Ir\u0017BA84\u0005\u001d\u0011un\u001c7fC:DQ!]\bA\u00025\f1BZ5u/&$\b.T3b]\u0002")
public class MultinomialLogisticBlockAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient Instance[] scaledInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    public Instance[] scaledInstances() {
        return this.scaledInstances;
    }

    public void scaledInstances_$eq(Instance[] x$1) {
        this.scaledInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
        this.scaledInstances_$eq(this.standardize(this.instances()));
    }

    private MultinomialLogisticBlockAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept, boolean fitWithMean) {
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
        SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
        double[] featuresStd = featuresSummarizer2.std().toArray();
        double[] featuresMean = featuresSummarizer2.mean().toArray();
        double[] inverseStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresStd)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)std -> {
            if (std != 0.0) {
                return 1.0 / std;
            }
            return 0.0;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] scaledMean = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(inverseStd)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(featuresMean), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToDouble((double)MultinomialLogisticBlockAggregatorSuite.$anonfun$getNewAggregator$2(t)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Broadcast bcInverseStd = this.sc().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = this.sc().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.sc().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new MultinomialLogisticBlockAggregator(bcInverseStd, bcScaledMean, fitIntercept, fitWithMean, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        MultinomialLogisticBlockAggregatorSuite multinomialLogisticBlockAggregatorSuite = this;
        synchronized (multinomialLogisticBlockAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$getNewAggregator$2(Tuple2 t) {
        return t._1$mcD$sp() * t._2$mcD$sp();
    }

    public static final /* synthetic */ double $anonfun$new$19(Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            double l = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            DenseVector p = (DenseVector)tuple3._3();
            return w * p.apply((int)l);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$new$20(Tuple3 x0$3) {
        Tuple3 tuple3 = x0$3;
        if (tuple3 != null) {
            double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            DenseVector p = (DenseVector)tuple3._3();
            return w * package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$new$22(int numClasses$1, Matrix stdCoefMat$1, double[] gradientCoef$1, Vector featuresStd$1, Instance x0$4) {
        Instance instance = x0$4;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            DenseVector margin = new DenseVector((double[])Array$.MODULE$.ofDim(numClasses$1, ClassTag$.MODULE$.Double()));
            BLAS$.MODULE$.gemv(1.0, stdCoefMat$1, f, 1.0, margin);
            double sum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margin.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                double fStd = f.apply(i / numClasses$1) / featuresStd$1.apply(i / numClasses$1);
                int cidx = i % numClasses$1;
                if (cidx == (int)l) {
                    gradientCoef$1[i] = gradientCoef$1[i] - w * fStd;
                }
                gradientCoef$1[i] = gradientCoef$1[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum * fStd;
            });
            return;
        }
        throw new MatchError((Object)instance);
    }

    public static final /* synthetic */ double $anonfun$new$36(Tuple3 x0$6) {
        Tuple3 tuple3 = x0$6;
        if (tuple3 != null) {
            double l = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            DenseVector p = (DenseVector)tuple3._3();
            return w * p.apply((int)l);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$new$37(Tuple3 x0$7) {
        Tuple3 tuple3 = x0$7;
        if (tuple3 != null) {
            double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            DenseVector p = (DenseVector)tuple3._3();
            return w * package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$new$39(Vector intercepts$1, Matrix stdCoefMat$2, double[] gradientCoef$2, int numClasses$2, Vector featuresStd$2, double[] gradientIntercept$1, Instance x0$8) {
        Instance instance = x0$8;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            DenseVector margin = intercepts$1.copy().toDense();
            BLAS$.MODULE$.gemv(1.0, stdCoefMat$2, f, 1.0, margin);
            double sum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margin.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$2)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                double fStd = f.apply(i / numClasses$2) / featuresStd$2.apply(i / numClasses$2);
                int cidx = i % numClasses$2;
                if (cidx == (int)l) {
                    gradientCoef$2[i] = gradientCoef$2[i] - w * fStd;
                }
                gradientCoef$2[i] = gradientCoef$2[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum * fStd;
            });
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                int cidx = i % numClasses$2;
                if (cidx == (int)l) {
                    gradientIntercept$1[i] = gradientIntercept$1[i] - w;
                }
                gradientIntercept$1[i] = gradientIntercept$1[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum;
            });
            return;
        }
        throw new MatchError((Object)instance);
    }

    public static final /* synthetic */ double $anonfun$new$54(Tuple3 x0$10) {
        Tuple3 tuple3 = x0$10;
        if (tuple3 != null) {
            double l = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            DenseVector p = (DenseVector)tuple3._3();
            return w * p.apply((int)l);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$new$55(Tuple3 x0$11) {
        Tuple3 tuple3 = x0$11;
        if (tuple3 != null) {
            double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            DenseVector p = (DenseVector)tuple3._3();
            return w * package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$new$57(Vector featuresMean$1, Vector intercepts$2, Matrix stdCoefMat$3, double[] gradientCoef$3, int numClasses$3, Vector featuresStd$3, double[] gradientIntercept$2, Instance x0$12) {
        Instance instance = x0$12;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            DenseVector centered = f.toDense().copy();
            BLAS$.MODULE$.axpy(-1.0, featuresMean$1, (Vector)centered);
            DenseVector margin = intercepts$2.copy().toDense();
            BLAS$.MODULE$.gemv(1.0, stdCoefMat$3, (Vector)centered, 1.0, margin);
            double sum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margin.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$3)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                double fStd = centered.apply(i / numClasses$3) / featuresStd$3.apply(i / numClasses$3);
                int cidx = i % numClasses$3;
                if (cidx == (int)l) {
                    gradientCoef$3[i] = gradientCoef$3[i] - w * fStd;
                }
                gradientCoef$3[i] = gradientCoef$3[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum * fStd;
            });
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept$2)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                int cidx = i % numClasses$3;
                if (cidx == (int)l) {
                    gradientIntercept$2[i] = gradientIntercept$2[i] - w;
                }
                gradientIntercept$2[i] = gradientIntercept$2[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum;
            });
            return;
        }
        throw new MatchError((Object)instance);
    }

    public MultinomialLogisticBlockAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("sparse coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Broadcast bcInverseStd = this.sc().broadcast((Object)new double[]{1.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcScaledMean = this.sc().broadcast((Object)new double[]{2.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcCoefficients = this.sc().broadcast((Object)Vectors$.MODULE$.sparse(4, new int[]{0}, new double[]{1.0}), ClassTag$.MODULE$.apply(Vector.class));
            MultinomialLogisticBlockAggregator binaryAgg = new MultinomialLogisticBlockAggregator(bcInverseStd, bcScaledMean, true, false, bcCoefficients);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            IllegalArgumentException thrownBinary = (IllegalArgumentException)this.withClue("aggregator cannot handle sparse coefficients", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> binaryAgg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80)));
            String $org_scalatest_assert_macro_left = thrownBinary.getMessage();
            String $org_scalatest_assert_macro_right = "coefficients only supports dense";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
            double[] interceptArray = new double[]{7.0, 8.0, 9.0};
            MultinomialLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94)));
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
            double[] interceptArray = new double[]{7.0, 8.0, 9.0};
            MultinomialLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator does not support negative instance weights", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107)));
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).distinct())).size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numClasses * (numFeatures + 1), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numClasses * numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.instances()));
            MultinomialLogisticBlockAggregator aggIntercept = this.getNewAggregator(this.instances(), coefWithIntercept, true, false);
            aggIntercept.add(block);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = (numFeatures + 1) * numClasses;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            MultinomialLogisticBlockAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefWithoutIntercept, false, false);
            aggNoIntercept.add(block);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures * numClasses;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("check correctness: fitIntercept = false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$22;
            WrappedArray x$1;
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toSet().size();
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$22 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
            Vector featuresStd = featuresSummarizer2.std();
            Matrix stdCoefMat = Matrices$.MODULE$.dense(numClasses, numFeatures, (double[])Array$.MODULE$.tabulate(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).size(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd.apply(i / numClasses), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Tuple3[] linearPredictors = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance != null) {
                    double l = instance.label();
                    double w = instance.weight();
                    Vector f = instance.features();
                    DenseVector result = new DenseVector((double[])Array$.MODULE$.ofDim(numClasses, ClassTag$.MODULE$.Double()));
                    BLAS$.MODULE$.gemv(1.0, stdCoefMat, f, 1.0, result);
                    return new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)result);
                }
                throw new MatchError((Object)instance);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            double sumLinear = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)MultinomialLogisticBlockAggregatorSuite.$anonfun$new$19(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sumLogs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)MultinomialLogisticBlockAggregatorSuite.$anonfun$new$20(x0$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = (sumLogs - sumLinear) / weightSum;
            double[] gradientCoef = new double[numFeatures * numClasses];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                MultinomialLogisticBlockAggregatorSuite.$anonfun$new$22(numClasses, stdCoefMat, gradientCoef, featuresStd, x0$4);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    MultinomialLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense(coefArray), false, false);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
                });
            });
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("check correctness: fitIntercept = true, fitWithMean = false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$4;
            WrappedArray x$3;
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toSet().size();
            Vector intercepts = Vectors$.MODULE$.dense(interceptArray);
            SparkContext qual$2 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$2.parallelize((Seq)(x$3 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$4 = qual$2.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
            Vector featuresStd = featuresSummarizer2.std();
            Matrix stdCoefMat = Matrices$.MODULE$.dense(numClasses, numFeatures, (double[])Array$.MODULE$.tabulate(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).size(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd.apply(i / numClasses), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)x$6.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Tuple3[] linearPredictors = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Instance instance = x0$5;
                if (instance != null) {
                    double l = instance.label();
                    double w = instance.weight();
                    Vector f = instance.features();
                    DenseVector result = intercepts.copy().toDense();
                    BLAS$.MODULE$.gemv(1.0, stdCoefMat, f, 1.0, result);
                    return new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)result);
                }
                throw new MatchError((Object)instance);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            double sumLinear = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToDouble((double)MultinomialLogisticBlockAggregatorSuite.$anonfun$new$36(x0$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sumLogs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToDouble((double)MultinomialLogisticBlockAggregatorSuite.$anonfun$new$37(x0$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = (sumLogs - sumLinear) / weightSum;
            double[] gradientCoef = new double[numFeatures * numClasses];
            double[] gradientIntercept = new double[numClasses];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                MultinomialLogisticBlockAggregatorSuite.$anonfun$new$39(intercepts, stdCoefMat, gradientCoef, numClasses, featuresStd, gradientIntercept, x0$8);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$7 -> x$7 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    MultinomialLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
                });
            });
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("check correctness: fitIntercept = true, fitWithMean = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$6;
            WrappedArray x$5;
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toSet().size();
            Vector intercepts = Vectors$.MODULE$.dense(interceptArray);
            SparkContext qual$3 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$3.parallelize((Seq)(x$5 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$6 = qual$3.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
            Vector featuresStd = featuresSummarizer2.std();
            Vector featuresMean = featuresSummarizer2.mean();
            Matrix stdCoefMat = Matrices$.MODULE$.dense(numClasses, numFeatures, (double[])Array$.MODULE$.tabulate(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).size(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd.apply(i / numClasses), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Tuple3[] linearPredictors = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                Instance instance = x0$9;
                if (instance != null) {
                    double l = instance.label();
                    double w = instance.weight();
                    Vector f = instance.features();
                    DenseVector centered = f.toDense().copy();
                    BLAS$.MODULE$.axpy(-1.0, featuresMean, (Vector)centered);
                    DenseVector result = intercepts.copy().toDense();
                    BLAS$.MODULE$.gemv(1.0, stdCoefMat, (Vector)centered, 1.0, result);
                    return new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)result);
                }
                throw new MatchError((Object)instance);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            double sumLinear = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToDouble((double)MultinomialLogisticBlockAggregatorSuite.$anonfun$new$54(x0$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sumLogs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$11 -> BoxesRunTime.boxToDouble((double)MultinomialLogisticBlockAggregatorSuite.$anonfun$new$55(x0$11)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = (sumLogs - sumLinear) / weightSum;
            double[] gradientCoef = new double[numFeatures * numClasses];
            double[] gradientIntercept = new double[numClasses];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
                MultinomialLogisticBlockAggregatorSuite.$anonfun$new$57(featuresMean, intercepts, stdCoefMat, gradientCoef, numClasses, featuresStd, gradientIntercept, x0$12);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$10 -> x$10 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    MultinomialLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
                });
            });
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] coefArrayFiltered = new double[]{3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            ((IterableLike)new .colon.colon((Object)new Tuple2.mcZZ.sp(false, false), (List)new .colon.colon((Object)new Tuple2.mcZZ.sp(true, false), (List)new .colon.colon((Object)new Tuple2.mcZZ.sp(true, true), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$13 -> {
                Tuple2 tuple2 = x0$13;
                if (tuple2 != null) {
                    boolean fitIntercept = tuple2._1$mcZ$sp();
                    boolean fitWithMean = tuple2._2$mcZ$sp();
                    Vector coefVec = fitIntercept ? Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))) : Vectors$.MODULE$.dense(coefArray);
                    MultinomialLogisticBlockAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), coefVec, fitIntercept, fitWithMean);
                    aggConstantFeature.add(InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.standardize(this.instancesConstantFeature()))));
                    Vector grad = aggConstantFeature.gradient();
                    Vector coefVecFiltered = fitIntercept ? Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArrayFiltered)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))) : Vectors$.MODULE$.dense(coefArrayFiltered);
                    MultinomialLogisticBlockAggregator aggConstantFeatureFiltered = this.getNewAggregator(this.instancesConstantFeatureFiltered(), coefVecFiltered, fitIntercept, fitWithMean);
                    aggConstantFeatureFiltered.add(InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.standardize(this.instancesConstantFeatureFiltered()))));
                    Vector gradFiltered = aggConstantFeatureFiltered.gradient();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(grad.toArray())).take(3)));
                    Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.zeros(3);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(grad.toArray())).slice(3, 6))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradFiltered.toArray())).take(3))).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(scala.Predef.doubleArrayOps(grad.toArray).slice(3, 6))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(scala.Predef.doubleArrayOps(gradFiltered.toArray).take(3))).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
                    if (fitIntercept) {
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(grad.toArray())).takeRight(3))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradFiltered.toArray())).takeRight(3))).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(scala.Predef.doubleArrayOps(grad.toArray).takeRight(3))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(scala.Predef.doubleArrayOps(gradFiltered.toArray).takeRight(3))).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("MultinomialLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
    }
}

