/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.spark.LocalRootDirsTest;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSCleanerSuite$;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.recommendation.ALSSuite$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001i1AAA\u0002\u0001\u001d!)a\u0003\u0001C\u0001/\ty\u0011\tT*DY\u0016\fg.\u001a:Tk&$XM\u0003\u0002\u0005\u000b\u0005q!/Z2p[6,g\u000eZ1uS>t'B\u0001\u0004\b\u0003\tiGN\u0003\u0002\t\u0013\u0005)1\u000f]1sW*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u00192\u0001A\b\u0014!\t\u0001\u0012#D\u0001\b\u0013\t\u0011rAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003!QI!!F\u0004\u0003#1{7-\u00197S_>$H)\u001b:t)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0007\u0001")
public class ALSCleanerSuite
extends SparkFunSuite
implements LocalRootDirsTest {
    private final SparkConf conf;
    private File tempDir;
    private transient SparkContext sc;

    public /* synthetic */ void org$apache$spark$LocalRootDirsTest$$super$beforeAll() {
        LocalSparkContext.beforeAll$((LocalSparkContext)this);
    }

    public /* synthetic */ void org$apache$spark$LocalRootDirsTest$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$LocalRootDirsTest$$super$afterEach() {
        LocalSparkContext.afterEach$((LocalSparkContext)this);
    }

    public void beforeAll() {
        LocalRootDirsTest.beforeAll$((LocalRootDirsTest)this);
    }

    public void beforeEach() {
        LocalRootDirsTest.beforeEach$((LocalRootDirsTest)this);
    }

    public void afterEach() {
        LocalRootDirsTest.afterEach$((LocalRootDirsTest)this);
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.resetSparkContext$((LocalSparkContext)this);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public void org$apache$spark$LocalRootDirsTest$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private static final Set getAllFiles$1(File localDir$1) {
        Set files = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)localDir$1, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSet();
        return files;
    }

    public ALSCleanerSuite() {
        LocalSparkContext.$init$((LocalSparkContext)this);
        LocalRootDirsTest.$init$((LocalRootDirsTest)this);
        this.test("ALS shuffle cleanup in algorithm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            SparkConf conf = new SparkConf();
            File localDir = Utils$.MODULE$.createTempDir();
            File checkpointDir = Utils$.MODULE$.createTempDir();
            try {
                conf.set("spark.local.dir", localDir.getAbsolutePath());
                SparkContext sc = new SparkContext("local[2]", "ALSCleanerSuite", conf);
                Regex pattern = new StringOps(Predef$.MODULE$.augmentString("shuffle_(\\d+)_.+\\.data")).r();
                try {
                    sc.setCheckpointDir(checkpointDir.getAbsolutePath());
                    Set initialIds = (Set)ALSCleanerSuite.getAllFiles$1(localDir).flatMap((Function1 & Serializable & scala.Serializable)f -> pattern.findAllIn((CharSequence)f.getName()).matchData().map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.group(1)), Set$.MODULE$.canBuildFrom());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)initialIds.size()));
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1044));
                    Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = ALSSuite$.MODULE$.genImplicitTestData(sc, 20, 5, 1, 0.2, 0L);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    RDD training = (RDD)tuple2._1();
                    RDD training2 = training;
                    SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate();
                    ALS als = new ALS().setRank(1).setRegParam(1.0E-5).setSeed(0L).setCheckpointInterval(1).setMaxIter(7);
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSCleanerSuite.class.getClassLoader());
                    public final class Org_apache_spark_ml_recommendation_ALSCleanerSuite$$typecreator6$6
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.recommendation")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.recommendation.ALS")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                        }

                        public Org_apache_spark_ml_recommendation_ALSCleanerSuite$$typecreator6$6(ALSCleanerSuite $outer) {
                        }
                    }
                    ALSModel model = als.fit(spark.implicits().rddToDatasetHolder(training2, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSCleanerSuite$$typecreator6$6(null)))).toDF());
                    Set resultingFiles = ALSCleanerSuite.getAllFiles$1(localDir);
                    Set rddIds = (Set)resultingFiles.flatMap((Function1 & Serializable & scala.Serializable)f -> pattern.findAllIn((CharSequence)f.getName()).matchData().map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.group(1)), Set$.MODULE$.canBuildFrom());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rddIds.size()));
                    int $org_scalatest_assert_macro_right2 = 4;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
                }
                finally {
                    sc.stop();
                }
            }
            finally {
                Utils$.MODULE$.deleteRecursively(localDir);
                Utils$.MODULE$.deleteRecursively(checkpointDir);
            }
            return assertion;
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
    }
}

