/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.recommendation.ALSStorageSuite$;
import org.apache.spark.ml.recommendation.IntermediateRDDStorageListener;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00112AAA\u0002\u0001\u001d!)\u0001\u0005\u0001C\u0001C\ty\u0011\tT*Ti>\u0014\u0018mZ3Tk&$XM\u0003\u0002\u0005\u000b\u0005q!/Z2p[6,g\u000eZ1uS>t'B\u0001\u0004\b\u0003\tiGN\u0003\u0002\t\u0013\u0005)1\u000f]1sW*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u0019B\u0001A\b\u00147A\u0011\u0001#E\u0007\u0002\u000f%\u0011!c\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001B;uS2T!\u0001G\u0004\u0002\u000b5dG.\u001b2\n\u0005i)\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\t\u00039yi\u0011!\b\u0006\u0003-\u0015I!aH\u000f\u0003)\u0011+g-Y;miJ+\u0017\rZ,sSR,G+Z:u\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t1\u0001")
public class ALSStorageSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$2();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$2() {
        ALSStorageSuite aLSStorageSuite = this;
        synchronized (aLSStorageSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public ALSStorageSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("invalid storage params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new ALS().setIntermediateStorageLevel("foo"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1078));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new ALS().setIntermediateStorageLevel("NONE"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1081));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new ALS().setFinalStorageLevel("foo"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1084));
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1077));
        this.test("default and non-default storage params set correct RDD StorageLevels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession spark = this.spark();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSStorageSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_recommendation_ALSStorageSuite$$typecreator6$7
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_ml_recommendation_ALSStorageSuite$$typecreator6$7(ALSStorageSuite $outer) {
                }
            }
            Dataset data = spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)2.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)3.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)2.0)), (List)Nil$.MODULE$)))), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSStorageSuite$$typecreator6$7(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user", "item", "rating"}));
            ALS als = new ALS().setMaxIter(1).setRank(1);
            IntermediateRDDStorageListener defaultListener = new IntermediateRDDStorageListener();
            this.sc().addSparkListener((SparkListenerInterface)defaultListener);
            ALSModel model = als.fit(data);
            Map defaultFactorRDDs = ((TraversableOnce)this.sc().getPersistentRDDs().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<Object, RDD<?>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    block2: {
                        RDD rdd;
                        int id;
                        block3: {
                            A1 A1 = x1;
                            if (A1 == null) break block2;
                            id = A1._1$mcI$sp();
                            rdd = (RDD)A1._2();
                            String string = rdd.name();
                            String string2 = "userFactors";
                            if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                            String string3 = rdd.name();
                            String string4 = "itemFactors";
                            if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                        }
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rdd.name()), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)rdd.getStorageLevel()));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<Object, RDD<?>> x1) {
                    block2: {
                        block3: {
                            Tuple2<Object, RDD<?>> tuple2 = x1;
                            if (tuple2 == null) break block2;
                            RDD rdd = (RDD)tuple2._2();
                            String string = rdd.name();
                            String string2 = "userFactors";
                            if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                            String string3 = rdd.name();
                            String string4 = "itemFactors";
                            if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                        }
                        return true;
                    }
                    return false;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            defaultFactorRDDs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    StorageLevel level;
                    StorageLevel $org_scalatest_assert_macro_left = level = (StorageLevel)tuple2._2();
                    StorageLevel $org_scalatest_assert_macro_right = StorageLevel$.MODULE$.MEMORY_AND_DISK();
                    StorageLevel storageLevel = $org_scalatest_assert_macro_left;
                    StorageLevel storageLevel2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1109));
                }
                throw new MatchError((Object)tuple22);
            });
            defaultListener.storageLevels().foreach((Function1 & Serializable & scala.Serializable)level -> {
                StorageLevel $org_scalatest_assert_macro_left = level;
                StorageLevel $org_scalatest_assert_macro_right = StorageLevel$.MODULE$.MEMORY_AND_DISK();
                StorageLevel storageLevel = $org_scalatest_assert_macro_left;
                StorageLevel storageLevel2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1111));
            });
            IntermediateRDDStorageListener nonDefaultListener = new IntermediateRDDStorageListener();
            this.sc().addSparkListener((SparkListenerInterface)nonDefaultListener);
            ALSModel nonDefaultModel = als.setFinalStorageLevel("MEMORY_ONLY").setIntermediateStorageLevel("DISK_ONLY").fit(data);
            Iterable levels = (Iterable)this.sc().getPersistentRDDs().collect((PartialFunction)new scala.Serializable(null, defaultFactorRDDs){
                public static final long serialVersionUID = 0L;
                private final Map defaultFactorRDDs$1;

                public final <A1 extends Tuple2<Object, RDD<?>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    block2: {
                        RDD rdd;
                        block3: {
                            A1 A1 = x2;
                            if (A1 == null) break block2;
                            rdd = (RDD)A1._2();
                            String string = rdd.name();
                            String string2 = "userFactors";
                            if (!(string != null ? !string.equals(string2) : string2 != null) && rdd.id() != ((Tuple2)this.defaultFactorRDDs$1.apply((Object)"userFactors"))._1$mcI$sp()) break block3;
                            String string3 = rdd.name();
                            String string4 = "itemFactors";
                            if ((string3 != null ? !string3.equals(string4) : string4 != null) || rdd.id() == ((Tuple2)this.defaultFactorRDDs$1.apply((Object)"itemFactors"))._1$mcI$sp()) break block2;
                        }
                        return (B1)rdd.getStorageLevel();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Tuple2<Object, RDD<?>> x2) {
                    block2: {
                        block3: {
                            Tuple2<Object, RDD<?>> tuple2 = x2;
                            if (tuple2 == null) break block2;
                            RDD rdd = (RDD)tuple2._2();
                            String string = rdd.name();
                            String string2 = "userFactors";
                            if (!(string != null ? !string.equals(string2) : string2 != null) && rdd.id() != ((Tuple2)this.defaultFactorRDDs$1.apply((Object)"userFactors"))._1$mcI$sp()) break block3;
                            String string3 = rdd.name();
                            String string4 = "itemFactors";
                            if ((string3 != null ? !string3.equals(string4) : string4 != null) || rdd.id() == ((Tuple2)this.defaultFactorRDDs$1.apply((Object)"itemFactors"))._1$mcI$sp()) break block2;
                        }
                        return true;
                    }
                    return false;
                }
                {
                    this.defaultFactorRDDs$1 = defaultFactorRDDs$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            levels.foreach((Function1 & Serializable & scala.Serializable)level -> {
                StorageLevel $org_scalatest_assert_macro_left = level;
                StorageLevel $org_scalatest_assert_macro_right = StorageLevel$.MODULE$.MEMORY_ONLY();
                StorageLevel storageLevel = $org_scalatest_assert_macro_left;
                StorageLevel storageLevel2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1126));
            });
            nonDefaultListener.storageLevels().foreach((Function1 & Serializable & scala.Serializable)level -> {
                StorageLevel $org_scalatest_assert_macro_left = level;
                StorageLevel $org_scalatest_assert_macro_right = StorageLevel$.MODULE$.DISK_ONLY();
                StorageLevel storageLevel = $org_scalatest_assert_macro_left;
                StorageLevel storageLevel2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1127));
            });
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1089));
    }
}

