/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.File;
import java.io.IOException;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.util.MyParams;
import org.apache.spark.util.Utils;
import org.junit.Assert;
import org.junit.Test;

public class JavaDefaultReadWriteSuite
extends SharedSparkSession {
    File tempDir = null;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        this.tempDir = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"JavaDefaultReadWriteSuite");
    }

    @Override
    public void tearDown() {
        super.tearDown();
        Utils.deleteRecursively((File)this.tempDir);
    }

    @Test
    public void testDefaultReadWrite() throws IOException {
        String uid = "my_params";
        MyParams instance = new MyParams(uid);
        instance.set(instance.intParam(), 2);
        String outputPath = new File(this.tempDir, uid).getPath();
        instance.save(outputPath);
        Assert.assertThrows(IOException.class, () -> instance.save(outputPath));
        instance.write().session(this.spark).overwrite().save(outputPath);
        MyParams newInstance = MyParams.load(outputPath);
        Assert.assertEquals((String)"UID should match.", (Object)instance.uid(), (Object)newInstance.uid());
        Assert.assertEquals((String)"Params should be preserved.", (Object)2, newInstance.getOrDefault(newInstance.intParam()));
    }
}

