/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMModel$;
import org.apache.spark.mllib.classification.SVMSuite$;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.classification.SVMWithSGD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u<Qa\u0003\u0007\t\u0002]1Q!\u0007\u0007\t\u0002iAQ\u0001J\u0001\u0005\u0002\u0015BQAJ\u0001\u0005\u0002\u001dBQaR\u0001\u0005\u0002!Cq!W\u0001C\u0002\u0013%!\f\u0003\u0004_\u0003\u0001\u0006Ia\u0017\u0005\b?\u0006\t\t\u0011\"\u0003a\r\u0011IB\u0002A4\t\u000b\u0011BA\u0011A9\t\u000bMDA\u0011\u0001;\u0002\u0011M3VjU;ji\u0016T!!\u0004\b\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011q\u0002E\u0001\u0006[2d\u0017N\u0019\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u0001\u0001C\u0001\r\u0002\u001b\u0005a!\u0001C*W\u001bN+\u0018\u000e^3\u0014\u0007\u0005Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u00039\tJ!aI\u000f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u00059\u0012AF4f]\u0016\u0014\u0018\r^3T-6Ke\u000e];u\u0003Nd\u0015n\u001d;\u0015\u000b!24\bQ#\u0011\u0007%r\u0003'D\u0001+\u0015\tYC&\u0001\u0003vi&d'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012A\u0001T5tiB\u0011\u0011\u0007N\u0007\u0002e)\u00111GD\u0001\u000be\u0016<'/Z:tS>t\u0017BA\u001b3\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0011\u001594\u00011\u00019\u0003%Ig\u000e^3sG\u0016\u0004H\u000f\u0005\u0002\u001ds%\u0011!(\b\u0002\u0007\t>,(\r\\3\t\u000bq\u001a\u0001\u0019A\u001f\u0002\u000f],\u0017n\u001a5ugB\u0019AD\u0010\u001d\n\u0005}j\"!B!se\u0006L\b\"B!\u0004\u0001\u0004\u0011\u0015a\u00028Q_&tGo\u001d\t\u00039\rK!\u0001R\u000f\u0003\u0007%sG\u000fC\u0003G\u0007\u0001\u0007!)\u0001\u0003tK\u0016$\u0017\u0001E4f]\u0016\u0014\u0018\r^3T-6Ke\u000e];u)\u0015IUKV,Y!\rQ%\u000b\r\b\u0003\u0017Bs!\u0001T(\u000e\u00035S!A\u0014\f\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012BA)\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0015+\u0003\u0007M+\u0017O\u0003\u0002R;!)q\u0007\u0002a\u0001q!)A\b\u0002a\u0001{!)\u0011\t\u0002a\u0001\u0005\")a\t\u0002a\u0001\u0005\u0006Y!-\u001b8beflu\u000eZ3m+\u0005Y\u0006C\u0001\r]\u0013\tiFB\u0001\u0005T-6ku\u000eZ3m\u00031\u0011\u0017N\\1ss6{G-\u001a7!\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0017\u0002\t1\fgnZ\u0005\u0003M\u000e\u0014aa\u00142kK\u000e$8c\u0001\u0005iYB\u0011\u0011N[\u0007\u0002!%\u00111\u000e\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u00055|W\"\u00018\u000b\u0005-r\u0011B\u00019o\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR$\u0012A\u001d\t\u00031!\t!C^1mS\u0012\fG/\u001a)sK\u0012L7\r^5p]R\u0019Q\u000f_>\u0011\u0005q1\u0018BA<\u001e\u0005\u0011)f.\u001b;\t\u000beT\u0001\u0019\u0001>\u0002\u0017A\u0014X\rZ5di&|gn\u001d\t\u0004\u0015JC\u0004\"\u0002?\u000b\u0001\u0004I\u0015!B5oaV$\b")
public class SVMSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Seq<LabeledPoint> generateSVMInput(double d, double[] dArray, int n, int n2) {
        return SVMSuite$.MODULE$.generateSVMInput(d, dArray, n, n2);
    }

    public static List<LabeledPoint> generateSVMInputAsList(double d, double[] dArray, int n, int n2) {
        return SVMSuite$.MODULE$.generateSVMInputAsList(d, dArray, n, n2);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SVMSuite.$anonfun$validatePrediction$1(x0$1)));
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
    }

    private final void testImplicits$lzycompute$1() {
        SVMSuite sVMSuite = this;
        synchronized (sVMSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validatePrediction$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LabeledPoint expected;
            double prediction = tuple2._1$mcD$sp();
            return prediction != (expected = (LabeledPoint)tuple2._2()).label();
        }
        throw new MatchError((Object)tuple2);
    }

    public SVMSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("SVM with threshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 0.01;
            double B = -1.5;
            double C = 1.0;
            Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            SVMWithSGD svm = (SVMWithSGD)new SVMWithSGD().setIntercept(true);
            svm.optimizer().setStepSize(1.0).setRegParam(1.0).setNumIterations(100);
            SVMModel model = (SVMModel)svm.run(testRDD);
            Seq<LabeledPoint> validationData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            double[] predictions = (double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.features(), ClassTag$.MODULE$.apply(Vector.class))).collect();
            int $org_scalatest_assert_macro_left = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predictions)).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 == 0.0);
            int $org_scalatest_assert_macro_right = predictions.length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            model.setThreshold(10000.0);
            predictions = (double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.features(), ClassTag$.MODULE$.apply(Vector.class))).collect();
            int $org_scalatest_assert_macro_left2 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predictions)).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 == 0.0);
            int $org_scalatest_assert_macro_right2 = predictions.length;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            model.setThreshold(-10000.0);
            predictions = (double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.features(), ClassTag$.MODULE$.apply(Vector.class))).collect();
            int $org_scalatest_assert_macro_left3 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predictions)).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 == 1.0);
            int $org_scalatest_assert_macro_right3 = predictions.length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        }, new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("SVM using local random SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 0.01;
            double B = -1.5;
            double C = 1.0;
            Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            SVMWithSGD svm = (SVMWithSGD)new SVMWithSGD().setIntercept(true);
            svm.optimizer().setStepSize(1.0).setRegParam(1.0).setNumIterations(100);
            SVMModel model = (SVMModel)svm.run(testRDD);
            Seq<LabeledPoint> validationData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData);
        }, new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("SVM local random SGD with initial weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 0.01;
            double B = -1.5;
            double C = 1.0;
            Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
            double initialB = -1.0;
            double initialC = -1.0;
            Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{initialC}));
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            SVMWithSGD svm = (SVMWithSGD)new SVMWithSGD().setIntercept(true);
            svm.optimizer().setStepSize(1.0).setRegParam(1.0).setNumIterations(100);
            SVMModel model = (SVMModel)svm.run(testRDD, initialWeights);
            Seq<LabeledPoint> validationData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData);
        }, new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("SVM with invalid labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 0.01;
            double B = -1.5;
            double C = 1.0;
            Seq<LabeledPoint> testData = SVMSuite$.MODULE$.generateSVMInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42);
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            RDD testRDDInvalid = testRDD.map((Function1 & Serializable & scala.Serializable)lp -> {
                if (lp.label() == 0.0) {
                    return new LabeledPoint(-1.0, lp.features());
                }
                return lp;
            }, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> SVMWithSGD$.MODULE$.train(testRDDInvalid, 100), ClassTag$.MODULE$.apply(SparkException.class), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            return (SVMModel)new SVMWithSGD().setValidateData(false).run(testRDDInvalid);
        }, new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            SVMModel model = SVMSuite$.MODULE$.org$apache$spark$mllib$classification$SVMSuite$$binaryModel();
            model.clearThreshold();
            Option $org_scalatest_assert_macro_left = model.getThreshold();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            File tempDir = Utils$.MODULE$.createTempDir();
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                SVMModel sameModel = SVMModel$.MODULE$.load(this.sc(), path);
                Vector $org_scalatest_assert_macro_left2 = model.weights();
                Vector $org_scalatest_assert_macro_right = sameModel.weights();
                Vector vector = $org_scalatest_assert_macro_left2;
                Vector vector2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(vector != null ? !vector.equals(vector2) : vector2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
                double $org_scalatest_assert_macro_left3 = model.intercept();
                double $org_scalatest_assert_macro_right2 = sameModel.intercept();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                Option $org_scalatest_assert_macro_left4 = sameModel.getThreshold();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            try {
                model.setThreshold(0.7);
                model.save(this.sc(), path);
                SVMModel sameModel2 = SVMModel$.MODULE$.load(this.sc(), path);
                double $org_scalatest_assert_macro_left5 = BoxesRunTime.unboxToDouble((Object)model.getThreshold().get());
                double $org_scalatest_assert_macro_right = BoxesRunTime.unboxToDouble((Object)sameModel2.getThreshold().get());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("SVMSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
    }
}

