/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.diag$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.support.LiteralRow$;
import breeze.math.Semiring$;
import breeze.storage.Zero$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0004\b\u00017!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0003Y\u0003B\u0002\u001a\u0001A\u0003%A\u0006C\u00044\u0001\t\u0007I\u0011A\u0016\t\rQ\u0002\u0001\u0015!\u0003-\u0011\u001d)\u0004A1A\u0005\u0002YBa\u0001\u0011\u0001!\u0002\u00139\u0004\"C!\u0001\u0001\u0004\u0005\r\u0011\"\u0001C\u0011%I\u0005\u00011AA\u0002\u0013\u0005!\nC\u0005Q\u0001\u0001\u0007\t\u0011)Q\u0005\u0007\")\u0011\u000b\u0001C!%\")1\u000b\u0001C\u0001)\n)\u0012J\u001c3fq\u0016$'k\\<NCR\u0014\u0018\u000e_*vSR,'BA\b\u0011\u0003-!\u0017n\u001d;sS\n,H/\u001a3\u000b\u0005E\u0011\u0012A\u00027j]\u0006dwM\u0003\u0002\u0014)\u0005)Q\u000e\u001c7jE*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\u0002\u0005\u0005\u0002\u001e=5\tA#\u0003\u0002 )\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\t\u0013\u000e\u0003\tR!a\t\n\u0002\tU$\u0018\u000e\\\u0005\u0003K\t\u0012Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u001d\u0005\tQ.F\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\rIe\u000e^\u0001\u0003[\u0002\n\u0011A\\\u0001\u0003]\u0002\nA\u0001Z1uCV\tq\u0007E\u00029wuj\u0011!\u000f\u0006\u0003u9\n!bY8mY\u0016\u001cG/[8o\u0013\ta\u0014HA\u0002TKF\u0004\"!\u000b \n\u0005}r!AC%oI\u0016DX\r\u001a*po\u0006)A-\u0019;bA\u0005Y\u0011N\u001c3fq\u0016$'k\\<t+\u0005\u0019\u0005c\u0001#H{5\tQI\u0003\u0002G)\u0005\u0019!\u000f\u001a3\n\u0005!+%a\u0001*E\t\u0006y\u0011N\u001c3fq\u0016$'k\\<t?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011Q\u0006T\u0005\u0003\u001b:\u0012A!\u00168ji\"9q*CA\u0001\u0002\u0004\u0019\u0015a\u0001=%c\u0005a\u0011N\u001c3fq\u0016$'k\\<tA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\u0017\u0006Y1\r\\8tKR{',\u001a:p)\t)\u0006\f\u0005\u0002.-&\u0011qK\f\u0002\b\u0005>|G.Z1o\u0011\u0015IF\u00021\u0001[\u0003\u00059\u0005cA.`C6\tAL\u0003\u0002\u0012;*\ta,\u0001\u0004ce\u0016,'0Z\u0005\u0003Ar\u00131\u0002R3og\u0016l\u0015\r\u001e:jqB\u0011QFY\u0005\u0003G:\u0012a\u0001R8vE2,\u0007")
public class IndexedRowMatrixSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int m;
    private final int n;
    private final Seq<IndexedRow> data;
    private RDD<IndexedRow> indexedRows;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public Seq<IndexedRow> data() {
        return this.data;
    }

    public RDD<IndexedRow> indexedRows() {
        return this.indexedRows;
    }

    public void indexedRows_$eq(RDD<IndexedRow> x$1) {
        this.indexedRows = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.indexedRows_$eq((RDD<IndexedRow>)this.sc().parallelize(this.data(), 2, ClassTag$.MODULE$.apply(IndexedRow.class)));
    }

    public boolean closeToZero(breeze.linalg.DenseMatrix<Object> G) {
        return BoxesRunTime.unboxToDouble((Object)G.valuesIterator().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.abs(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) < 1.0E-6;
    }

    private final void testImplicits$lzycompute$1() {
        IndexedRowMatrixSuite indexedRowMatrixSuite = this;
        synchronized (indexedRowMatrixSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$12(Tuple2 x0$1) {
        Matrix matrix;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (matrix = (Matrix)tuple2._2()) != null) {
            Matrix matrix2 = matrix;
            return matrix2 instanceof DenseMatrix;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$13(boolean x$2, boolean x$3) {
        return x$2 && x$3;
    }

    public static final /* synthetic */ boolean $anonfun$new$14(Tuple2 x0$2) {
        Matrix matrix;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null && (matrix = (Matrix)tuple2._2()) != null) {
            Matrix matrix2 = matrix;
            return matrix2 instanceof DenseMatrix;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$15(boolean x$4, boolean x$5) {
        return x$4 && x$5;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Tuple2 x0$3) {
        Matrix matrix;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null && (matrix = (Matrix)tuple2._2()) != null) {
            Matrix matrix2 = matrix;
            return matrix2 instanceof SparseMatrix;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$19(Tuple2 x0$4) {
        Matrix matrix;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null && (matrix = (Matrix)tuple2._2()) != null) {
            Matrix matrix2 = matrix;
            return matrix2 instanceof SparseMatrix;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$24(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Matrix matrix = (Matrix)tuple2._2();
            if (tuple22 != null) {
                int row = tuple22._1$mcI$sp();
                if (row == 0) {
                    return matrix instanceof DenseMatrix;
                }
                return matrix instanceof SparseMatrix;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Assertion $anonfun$new$33(breeze.linalg.DenseMatrix gram$1, int i$1, breeze.linalg.DenseMatrix G$1, int j) {
        double trueResult = gram$1.apply$mcD$sp(i$1, j) / package$.MODULE$.sqrt(gram$1.apply$mcD$sp(i$1, i$1) * gram$1.apply$mcD$sp(j, j));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(G$1.apply$mcD$sp(i$1, j)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(trueResult).absTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(G.apply(i, j)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(trueResult).absTol(1.0E-6))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
    }

    public IndexedRowMatrixSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.m = 4;
        this.n = 3;
        this.data = (Seq)((TraversableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 5.0}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}))), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)x -> new IndexedRow(x._1$mcJ$sp(), (Vector)x._2()), Seq$.MODULE$.canBuildFrom());
        this.test("size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix mat1 = new IndexedRowMatrix(this.indexedRows());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)mat1.numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)mat1.numCols()));
            int $org_scalatest_assert_macro_right2 = this.n();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            IndexedRowMatrix mat2 = new IndexedRowMatrix(this.indexedRows(), 5L, 0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)mat2.numRows()));
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)mat2.numCols()));
            int $org_scalatest_assert_macro_right4 = this.n();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("empty rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD rows = this.sc().parallelize((Seq)Nil$.MODULE$, 1, ClassTag$.MODULE$.apply(IndexedRow.class));
            IndexedRowMatrix mat = new IndexedRowMatrix(rows);
            this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> mat.numRows(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            return (RuntimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> mat.numCols(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("toBreeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix mat = new IndexedRowMatrix(this.indexedRows());
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)5.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)9.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mat.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("toRowMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix idxRowMat = new IndexedRowMatrix(this.indexedRows());
            RowMatrix rowMat = idxRowMat.toRowMatrix();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numCols()));
            int $org_scalatest_assert_macro_right = this.n();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numRows()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should drop empty rows", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowMat.rows().collect())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = ((SeqLike)this.data().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.vector(), Seq$.MODULE$.canBuildFrom())).toSeq();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("toCoordinateMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix idxRowMat = new IndexedRowMatrix(this.indexedRows());
            CoordinateMatrix coordMat = idxRowMat.toCoordinateMatrix();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numCols()));
            int $org_scalatest_assert_macro_right2 = this.n();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(coordMat.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = idxRowMat.toBreeze();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("toBlockMatrix dense backing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix idxRowMatDense = new IndexedRowMatrix(this.indexedRows());
            BlockMatrix blockMat = idxRowMatDense.toBlockMatrix(2, 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numCols()));
            int $org_scalatest_assert_macro_right2 = this.n();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(blockMat.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = idxRowMatDense.toBreeze();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            BlockMatrix blockMat2 = idxRowMatDense.toBlockMatrix(3, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat2.numRows()));
            int $org_scalatest_assert_macro_right4 = this.m();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat2.numCols()));
            int $org_scalatest_assert_macro_right5 = this.n();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(blockMat2.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right6 = idxRowMatDense.toBreeze();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> idxRowMatDense.toBlockMatrix(-1, 2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> idxRowMatDense.toBlockMatrix(2, 0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean((Object)blockMat.blocks().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexedRowMatrixSuite.$anonfun$new$12(x0$1)), ClassTag$.MODULE$.Boolean()).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)IndexedRowMatrixSuite.$anonfun$new$13(BoxesRunTime.unboxToBoolean((Object)x$2), BoxesRunTime.unboxToBoolean((Object)x$3))))), "blockMat.blocks.map[Boolean](((x0$1: ((Int, Int), org.apache.spark.mllib.linalg.Matrix)) => x0$1 match {\n  case (_1: (Int, Int), _2: org.apache.spark.mllib.linalg.Matrix)((Int, Int), org.apache.spark.mllib.linalg.Matrix)(_, (matrix @ (_: org.apache.spark.mllib.linalg.Matrix))) => matrix.isInstanceOf[org.apache.spark.mllib.linalg.DenseMatrix]\n}))((ClassTag.Boolean: scala.reflect.ClassTag[Boolean])).reduce(((x$2: Boolean, x$3: Boolean) => x$2.&&(x$3)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean((Object)blockMat2.blocks().map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)IndexedRowMatrixSuite.$anonfun$new$14(x0$2)), ClassTag$.MODULE$.Boolean()).reduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)IndexedRowMatrixSuite.$anonfun$new$15(BoxesRunTime.unboxToBoolean((Object)x$4), BoxesRunTime.unboxToBoolean((Object)x$5))))), "blockMat2.blocks.map[Boolean](((x0$2: ((Int, Int), org.apache.spark.mllib.linalg.Matrix)) => x0$2 match {\n  case (_1: (Int, Int), _2: org.apache.spark.mllib.linalg.Matrix)((Int, Int), org.apache.spark.mllib.linalg.Matrix)(_, (matrix @ (_: org.apache.spark.mllib.linalg.Matrix))) => matrix.isInstanceOf[org.apache.spark.mllib.linalg.DenseMatrix]\n}))((ClassTag.Boolean: scala.reflect.ClassTag[Boolean])).reduce(((x$4: Boolean, x$5: Boolean) => x$4.&&(x$5)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("toBlockMatrix sparse backing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq sparseData = (Seq)((TraversableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)Vectors$.MODULE$.sparse(12, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 4.0), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x -> new IndexedRow(x._1$mcJ$sp(), (Vector)x._2()), Seq$.MODULE$.canBuildFrom());
            int m = 16;
            int n = 12;
            SparkContext qual$1 = this.sc();
            Seq x$1 = sparseData;
            int x$2 = qual$1.parallelize$default$2();
            IndexedRowMatrix idxRowMatSparse = new IndexedRowMatrix(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(IndexedRow.class)));
            BlockMatrix blockMat = idxRowMatSparse.toBlockMatrix(8, 8);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numRows()));
            int $org_scalatest_assert_macro_right = m;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numCols()));
            int $org_scalatest_assert_macro_right2 = n;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(blockMat.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = idxRowMatSparse.toBreeze();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            BlockMatrix blockMat2 = idxRowMatSparse.toBlockMatrix(6, 6);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat2.numRows()));
            int $org_scalatest_assert_macro_right4 = m;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat2.numCols()));
            int $org_scalatest_assert_macro_right5 = n;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(blockMat2.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right6 = idxRowMatSparse.toBreeze();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockMat.blocks().collect())).forall((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)IndexedRowMatrixSuite.$anonfun$new$18(x0$3))), "scala.Predef.refArrayOps[((Int, Int), org.apache.spark.mllib.linalg.Matrix)](blockMat.blocks.collect()).forall(((x0$3: ((Int, Int), org.apache.spark.mllib.linalg.Matrix)) => x0$3 match {\n  case (_1: (Int, Int), _2: org.apache.spark.mllib.linalg.Matrix)((Int, Int), org.apache.spark.mllib.linalg.Matrix)(_, (matrix @ (_: org.apache.spark.mllib.linalg.Matrix))) => matrix.isInstanceOf[org.apache.spark.mllib.linalg.SparseMatrix]\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockMat2.blocks().collect())).forall((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)IndexedRowMatrixSuite.$anonfun$new$19(x0$4))), "scala.Predef.refArrayOps[((Int, Int), org.apache.spark.mllib.linalg.Matrix)](blockMat2.blocks.collect()).forall(((x0$4: ((Int, Int), org.apache.spark.mllib.linalg.Matrix)) => x0$4 match {\n  case (_1: (Int, Int), _2: org.apache.spark.mllib.linalg.Matrix)((Int, Int), org.apache.spark.mllib.linalg.Matrix)(_, (matrix @ (_: org.apache.spark.mllib.linalg.Matrix))) => matrix.isInstanceOf[org.apache.spark.mllib.linalg.SparseMatrix]\n}))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("toBlockMatrix mixed backing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 24;
            int n = 18;
            Seq mixedData = (Seq)((TraversableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)Vectors$.MODULE$.dense((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 17).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$6 -> x$6, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)Vectors$.MODULE$.dense((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 17).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$7 -> x$7, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)23L), (Object)Vectors$.MODULE$.sparse(18, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 4.0), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)x -> new IndexedRow(x._1$mcJ$sp(), (Vector)x._2()), Seq$.MODULE$.canBuildFrom());
            SparkContext qual$2 = this.sc();
            Seq x$3 = mixedData;
            int x$4 = qual$2.parallelize$default$2();
            IndexedRowMatrix idxRowMatMixed = new IndexedRowMatrix(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(IndexedRow.class)));
            BlockMatrix blockMat = idxRowMatMixed.toBlockMatrix(12, 12);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numRows()));
            int $org_scalatest_assert_macro_right = m;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numCols()));
            int $org_scalatest_assert_macro_right2 = n;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(blockMat.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = idxRowMatMixed.toBreeze();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            BlockMatrix blockMat2 = idxRowMatMixed.toBlockMatrix(18, 6);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat2.numRows()));
            int $org_scalatest_assert_macro_right4 = m;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat2.numCols()));
            int $org_scalatest_assert_macro_right5 = n;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(blockMat2.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right6 = idxRowMatMixed.toBreeze();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Tuple2[] blocks = (Tuple2[])blockMat.blocks().collect();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).forall((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)IndexedRowMatrixSuite.$anonfun$new$24(x0$5))), "scala.Predef.refArrayOps[((Int, Int), org.apache.spark.mllib.linalg.Matrix)](blocks).forall(((x0$5: ((Int, Int), org.apache.spark.mllib.linalg.Matrix)) => x0$5 match {\n  case (_1: (Int, Int), _2: org.apache.spark.mllib.linalg.Matrix)((Int, Int), org.apache.spark.mllib.linalg.Matrix)((_1: Int, _2: Int)(Int, Int)((row @ _), (col @ _)), (matrix @ _)) => if (row.==(0))\n    matrix.isInstanceOf[org.apache.spark.mllib.linalg.DenseMatrix]\n  else\n    matrix.isInstanceOf[org.apache.spark.mllib.linalg.SparseMatrix]\n}))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("multiply a local matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix A = new IndexedRowMatrix(this.indexedRows());
            Matrix B = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
            IndexedRowMatrix C = A.multiply(B);
            breeze.linalg.DenseMatrix localA = A.toBreeze();
            breeze.linalg.DenseMatrix localC = C.toBreeze();
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)localA.$times((Object)((breeze.linalg.DenseMatrix)B.asBreeze()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(localC);
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("gram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix A = new IndexedRowMatrix(this.indexedRows());
            Matrix G = A.computeGramianMatrix();
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)90.0), (Object)BoxesRunTime.boxToDouble((double)12.0), (Object)BoxesRunTime.boxToDouble((double)24.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)12.0), (Object)BoxesRunTime.boxToDouble((double)17.0), (Object)BoxesRunTime.boxToDouble((double)22.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)24.0), (Object)BoxesRunTime.boxToDouble((double)22.0), (Object)BoxesRunTime.boxToDouble((double)30.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(G.asBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix A = new IndexedRowMatrix(this.indexedRows());
            SingularValueDecomposition svd = A.computeSVD(this.n(), true, A.computeSVD$default$3());
            IndexedRowMatrix $org_scalatest_assert_macro_left = (IndexedRowMatrix)svd.U();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix", $org_scalatest_assert_macro_left instanceof IndexedRowMatrix, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            breeze.linalg.DenseMatrix localA = A.toBreeze();
            breeze.linalg.DenseMatrix U = ((IndexedRowMatrix)svd.U()).toBreeze();
            DenseVector s = (DenseVector)svd.s().asBreeze();
            breeze.linalg.DenseMatrix V = (breeze.linalg.DenseMatrix)((Matrix)svd.V()).asBreeze();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.closeToZero((breeze.linalg.DenseMatrix<Object>)((breeze.linalg.DenseMatrix)((ImmutableNumericOps)((ImmutableNumericOps)U.t(HasOps$.MODULE$.canTranspose_DM())).$times((Object)U, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD())).$minus((Object)DenseMatrix$.MODULE$.eye$mDc$sp(this.n(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD()), HasOps$.MODULE$.op_DM_DM_Double_OpSub()))), "IndexedRowMatrixSuite.this.closeToZero(U.t[breeze.linalg.DenseMatrix[Double]](operators.this.HasOps.canTranspose_DM[Double]).*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](U)(operators.this.HasOps.impl_OpMulMatrix_DMD_DMD_eq_DMD).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.linalg.DenseMatrix.eye[Double](IndexedRowMatrixSuite.this.n)((ClassTag.Double: scala.reflect.ClassTag[Double]), storage.this.Zero.DoubleZero, math.this.Semiring.semiringD))(operators.this.HasOps.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.closeToZero((breeze.linalg.DenseMatrix<Object>)((breeze.linalg.DenseMatrix)((ImmutableNumericOps)((ImmutableNumericOps)V.t(HasOps$.MODULE$.canTranspose_DM())).$times((Object)V, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD())).$minus((Object)DenseMatrix$.MODULE$.eye$mDc$sp(this.n(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD()), HasOps$.MODULE$.op_DM_DM_Double_OpSub()))), "IndexedRowMatrixSuite.this.closeToZero(V.t[breeze.linalg.DenseMatrix[Double]](operators.this.HasOps.canTranspose_DM[Double]).*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](V)(operators.this.HasOps.impl_OpMulMatrix_DMD_DMD_eq_DMD).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.linalg.DenseMatrix.eye[Double](IndexedRowMatrixSuite.this.n)((ClassTag.Double: scala.reflect.ClassTag[Double]), storage.this.Zero.DoubleZero, math.this.Semiring.semiringD))(operators.this.HasOps.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.closeToZero((breeze.linalg.DenseMatrix<Object>)((breeze.linalg.DenseMatrix)((ImmutableNumericOps)((ImmutableNumericOps)U.$times(diag$.MODULE$.apply((Object)s, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero())), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD())).$times(V.t(HasOps$.MODULE$.canTranspose_DM()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD())).$minus((Object)localA, HasOps$.MODULE$.op_DM_DM_Double_OpSub()))), "IndexedRowMatrixSuite.this.closeToZero(U.*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.linalg.diag.apply[breeze.linalg.DenseVector[Double], breeze.linalg.DenseMatrix[Double]](s)(linalg.this.diag.diagDVDMImpl[Double]((ClassTag.Double: scala.reflect.ClassTag[Double]), storage.this.Zero.DoubleZero)))(operators.this.HasOps.impl_OpMulMatrix_DMD_DMD_eq_DMD).*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](V.t[breeze.linalg.DenseMatrix[Double]](operators.this.HasOps.canTranspose_DM[Double]))(operators.this.HasOps.impl_OpMulMatrix_DMD_DMD_eq_DMD).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](localA)(operators.this.HasOps.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("validate matrix sizes of svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int k = 2;
            IndexedRowMatrix A = new IndexedRowMatrix(this.indexedRows());
            SingularValueDecomposition svd = A.computeSVD(k, true, A.computeSVD$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndexedRowMatrix)svd.U()).numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndexedRowMatrix)svd.U()).numCols()));
            int $org_scalatest_assert_macro_right2 = k;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)svd.s().size()));
            int $org_scalatest_assert_macro_right3 = k;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd.V()).numRows()));
            int $org_scalatest_assert_macro_right4 = this.n();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd.V()).numCols()));
            int $org_scalatest_assert_macro_right5 = k;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("validate k in svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix A = new IndexedRowMatrix(this.indexedRows());
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> A.computeSVD(-1, A.computeSVD$default$2(), A.computeSVD$default$3()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("similar columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IndexedRowMatrix A = new IndexedRowMatrix(this.indexedRows());
            breeze.linalg.DenseMatrix gram = A.computeGramianMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
            breeze.linalg.DenseMatrix G = A.columnSimilarities().toBreeze();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.n()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(i + 1), this.n()).foreach((Function1 & Serializable & scala.Serializable)j -> IndexedRowMatrixSuite.$anonfun$new$33(gram, i, G, BoxesRunTime.unboxToInt((Object)j))));
        }, new Position("IndexedRowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
    }
}

