/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionModel$;
import org.apache.spark.mllib.regression.RidgeRegressionSuite$;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001i;Q!\u0003\u0006\t\nU1Qa\u0006\u0006\t\naAQAI\u0001\u0005\u0002\rBq\u0001J\u0001C\u0002\u0013\u0005Q\u0005\u0003\u0004*\u0003\u0001\u0006IA\n\u0005\bU\u0005\t\t\u0011\"\u0003,\r\u00119\"\u0002\u0001\u001b\t\u000b\t2A\u0011A \t\u000b\u00053A\u0011\u0001\"\u0002)IKGmZ3SK\u001e\u0014Xm]:j_:\u001cV/\u001b;f\u0015\tYA\"\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0004\b\u0002\u000b5dG.\u001b2\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0017\u00035\t!B\u0001\u000bSS\u0012<WMU3he\u0016\u001c8/[8o'VLG/Z\n\u0004\u0003ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002\u001bA%\u0011\u0011e\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\tQ!\\8eK2,\u0012A\n\t\u0003-\u001dJ!\u0001\u000b\u0006\u0003)IKGmZ3SK\u001e\u0014Xm]:j_:lu\u000eZ3m\u0003\u0019iw\u000eZ3mA\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005a\u0003CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0007\u001f\nTWm\u0019;\u0014\u0007\u0019)\u0014\b\u0005\u00027o5\ta\"\u0003\u00029\u001d\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003}m\u0012Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000fF\u0001A!\t1b!A\bqe\u0016$\u0017n\u0019;j_:,%O]8s)\r\u0019e\t\u0016\t\u00035\u0011K!!R\u000e\u0003\r\u0011{WO\u00197f\u0011\u00159\u0005\u00021\u0001I\u0003-\u0001(/\u001a3jGRLwN\\:\u0011\u0007%\u000b6I\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011Q\nF\u0001\u0007yI|w\u000e\u001e \n\u0003qI!\u0001U\u000e\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\u0004'\u0016\f(B\u0001)\u001c\u0011\u0015)\u0006\u00021\u0001W\u0003\u0015Ig\u000e];u!\rI\u0015k\u0016\t\u0003-aK!!\u0017\u0006\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;")
public class RidgeRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static RidgeRegressionModel model() {
        return RidgeRegressionSuite$.MODULE$.model();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public double predictionError(Seq<Object> predictions, Seq<LabeledPoint> input) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RidgeRegressionSuite.$anonfun$predictionError$1(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)predictions.size();
    }

    private final void testImplicits$lzycompute$1() {
        RidgeRegressionSuite ridgeRegressionSuite = this;
        synchronized (ridgeRegressionSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$predictionError$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double prediction = tuple2._1$mcD$sp();
            LabeledPoint expected = (LabeledPoint)tuple2._2();
            return (prediction - expected.label()) * (prediction - expected.label());
        }
        throw new MatchError((Object)tuple2);
    }

    public RidgeRegressionSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("ridge regression can help avoid overfitting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double ridgeErr;
            int numExamples = 50;
            int numFeatures = 20;
            Random random = new Random(42);
            double[] w = (double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random.nextDouble() - 0.5, ClassTag$.MODULE$.Double());
            Seq data = LinearDataGenerator$.MODULE$.generateLinearInput(3.0, w, 2 * numExamples, 42, 10.0);
            Seq testData = (Seq)data.take(numExamples);
            Seq validationData = (Seq)data.takeRight(numExamples);
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LinearRegressionWithSGD linearReg = new LinearRegressionWithSGD(1.0, 200, 0.0, 1.0);
            LinearRegressionModel linearModel = (LinearRegressionModel)linearReg.run(testRDD);
            double linearErr = this.predictionError((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])linearModel.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
            RidgeRegressionWithSGD ridgeReg = new RidgeRegressionWithSGD(1.0, 200, 0.1, 1.0);
            RidgeRegressionModel ridgeModel = (RidgeRegressionModel)ridgeReg.run(testRDD);
            double $org_scalatest_assert_macro_left = ridgeErr = this.predictionError((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])ridgeModel.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
            double $org_scalatest_assert_macro_right = linearErr;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(45).append("ridgeError (").append(ridgeErr).append(") was not less than linearError(").append(linearErr).append(")").toString(), Prettifier$.MODULE$.default(), new Position("RidgeRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("RidgeRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            RidgeRegressionModel model = RidgeRegressionSuite$.MODULE$.model();
            File tempDir = Utils$.MODULE$.createTempDir();
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                RidgeRegressionModel sameModel = RidgeRegressionModel$.MODULE$.load(this.sc(), path);
                Vector $org_scalatest_assert_macro_left = model.weights();
                Vector $org_scalatest_assert_macro_right = sameModel.weights();
                Vector vector = $org_scalatest_assert_macro_left;
                Vector vector2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(vector != null ? !vector.equals(vector2) : vector2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RidgeRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                double $org_scalatest_assert_macro_left2 = model.intercept();
                double $org_scalatest_assert_macro_right2 = sameModel.intercept();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RidgeRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("RidgeRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }
}

