/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.LinearSVCModel$;
import org.apache.spark.ml.classification.LinearSVCModel$LinearSVCWriter$;
import org.apache.spark.ml.classification.LinearSVCModel$LinearSVCWriter$Data$;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.LinearSVCSummary;
import org.apache.spark.ml.classification.LinearSVCSummaryImpl;
import org.apache.spark.ml.classification.LinearSVCTrainingSummary;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rea\u0001\u0002 @\u0001)C\u0001\"\u001a\u0001\u0003\u0006\u0004%\tE\u001a\u0005\t{\u0002\u0011\t\u0011)A\u0005O\"Iq\u0010\u0001BC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n=C!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\t\u00037\u0001A\u0011A \u0002\u001e!I\u00111\u0006\u0001C\u0002\u0013\u0005\u0013Q\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u00020!I\u00111\b\u0001C\u0002\u0013\u0005\u0013Q\u0006\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u00020!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003\"CA(\u0001\t\u0007I\u0011BA)\u0011!\tI\u0006\u0001Q\u0001\n\u0005M\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\tI\n\u0001C!\u00037Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002.\u0002!\t&a,\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u00111\u001a\u0001\u0005B\u00055\u0007bBAl\u0001\u0011\u0005\u0013\u0011\\\u0004\b\u0003?|\u0004\u0012AAq\r\u0019qt\b#\u0001\u0002d\"9\u00111\u0004\r\u0005\u0002\t\u0005\u0001b\u0002B\u00021\u0011\u0005#Q\u0001\u0005\b\u0005\u001fAB\u0011\tB\t\r\u001d\u0011I\u0002\u0007\u0001\u0019\u00057A\u0011B!\u000b\u001d\u0005\u0003\u0005\u000b\u0011B+\t\u000f\u0005mA\u0004\"\u0001\u0003,\u00191!1\u0007\u000fE\u0005kA\u0011b`\u0010\u0003\u0016\u0004%\t!!\u0001\t\u0013\u0005\u0015qD!E!\u0002\u0013y\u0005BCA\u0005?\tU\r\u0011\"\u0001\u0002\f!Q\u0011qC\u0010\u0003\u0012\u0003\u0006I!!\u0004\t\u000f\u0005mq\u0004\"\u0001\u0003N!I\u0011QW\u0010\u0002\u0002\u0013\u0005!q\u000b\u0005\n\u0005;z\u0012\u0013!C\u0001\u0005?B\u0011Ba\u001d #\u0003%\tA!\u001e\t\u0013\tet$!A\u0005B\tm\u0004\"\u0003BD?\u0005\u0005I\u0011AA\u0017\u0011%\u0011IiHA\u0001\n\u0003\u0011Y\tC\u0005\u0003\u0012~\t\t\u0011\"\u0011\u0003\u0014\"I!\u0011U\u0010\u0002\u0002\u0013\u0005!1\u0015\u0005\n\u0005[{\u0012\u0011!C!\u0005_C\u0011Ba- \u0003\u0003%\tE!.\t\u0013\u0005]w$!A\u0005B\t]\u0006\"\u0003B]?\u0005\u0005I\u0011\tB^\u000f%\u0011y\fHA\u0001\u0012\u0013\u0011\tMB\u0005\u00034q\t\t\u0011#\u0003\u0003D\"9\u00111\u0004\u001a\u0005\u0002\tE\u0007\"CAle\u0005\u0005IQ\tB\\\u0011%\u0011\u0019NMA\u0001\n\u0003\u0013)\u000eC\u0005\u0003\\J\n\t\u0011\"!\u0003^\"9!q\u001e\u000f\u0005R\tEhA\u0002B~1\u0011\u0011i\u0010C\u0004\u0002\u001ca\"\tAa@\t\u0013\r\r\u0001H1A\u0005\n\tm\u0004\u0002CB\u0003q\u0001\u0006IA! \t\u000f\t=\u0001\b\"\u0011\u0004\b!I11\u0002\r\u0002\u0002\u0013%1Q\u0002\u0002\u000f\u0019&tW-\u0019:T-\u000eku\u000eZ3m\u0015\t\u0001\u0015)\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\t\u001b\u0015AA7m\u0015\t!U)A\u0003ta\u0006\u00148N\u0003\u0002G\u000f\u00061\u0011\r]1dQ\u0016T\u0011\u0001S\u0001\u0004_J<7\u0001A\n\u0006\u0001-3\u0016l\u0018\t\u0005\u00196{U+D\u0001@\u0013\tquHA\nDY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0003\u00061A.\u001b8bY\u001eL!\u0001V)\u0003\rY+7\r^8s!\ta\u0005\u0001\u0005\u0002M/&\u0011\u0001l\u0010\u0002\u0010\u0019&tW-\u0019:T-\u000e\u0003\u0016M]1ngB\u0011!,X\u0007\u00027*\u0011A,Q\u0001\u0005kRLG.\u0003\u0002_7\nQQ\nT,sSR\f'\r\\3\u0011\u0007i\u0003'-\u0003\u0002b7\n\u0011\u0002*Y:Ue\u0006Lg.\u001b8h'VlW.\u0019:z!\ta5-\u0003\u0002e\u007f\tAB*\u001b8fCJ\u001cfk\u0011+sC&t\u0017N\\4Tk6l\u0017M]=\u0002\u0007ULG-F\u0001h!\tA\u0017O\u0004\u0002j_B\u0011!.\\\u0007\u0002W*\u0011A.S\u0001\u0007yI|w\u000e\u001e \u000b\u00039\fQa]2bY\u0006L!\u0001]7\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003a6D3!A;|!\t1\u00180D\u0001x\u0015\tA8)\u0001\u0006b]:|G/\u0019;j_:L!A_<\u0003\u000bMKgnY3\"\u0003q\fQA\r\u00183]A\nA!^5eA!\u001a!!^>\u0002\u0019\r|WM\u001a4jG&,g\u000e^:\u0016\u0003=C3aA;|\u00035\u0019w.\u001a4gS\u000eLWM\u001c;tA!\u001aA!^>\u0002\u0013%tG/\u001a:dKB$XCAA\u0007!\u0011\ty!!\u0005\u000e\u00035L1!a\u0005n\u0005\u0019!u.\u001e2mK\"\u001aQ!^>\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002\u0007kn\fa\u0001P5oSRtDcB+\u0002 \u0005\r\u0012q\u0005\u0005\u0006K\u001e\u0001\ra\u001a\u0015\u0005\u0003?)8\u0010C\u0003\u0000\u000f\u0001\u0007q\n\u000b\u0003\u0002$U\\\bbBA\u0005\u000f\u0001\u0007\u0011Q\u0002\u0015\u0005\u0003O)80\u0001\u0006ok6\u001cE.Y:tKN,\"!a\f\u0011\t\u0005=\u0011\u0011G\u0005\u0004\u0003gi'aA%oi\"\u001a\u0001\"^>\u0002\u00179,Xn\u00117bgN,7\u000f\t\u0015\u0004\u0013U\\\u0018a\u00038v[\u001a+\u0017\r^;sKND3AC;|\u00031qW/\u001c$fCR,(/Z:!Q\rYQo_\u0001\rg\u0016$H\u000b\u001b:fg\"|G\u000e\u001a\u000b\u0005\u0003\u000f\nI%D\u0001\u0001\u0011\u001d\tY\u0005\u0004a\u0001\u0003\u001b\tQA^1mk\u0016D3\u0001D;|\u0003\u0019i\u0017M]4j]V\u0011\u00111\u000b\t\b\u0003\u001f\t)fTA\u0007\u0013\r\t9&\u001c\u0002\n\rVt7\r^5p]F\nq!\\1sO&t\u0007%A\u0004tk6l\u0017M]=\u0016\u0003\tDCaD;\u0002b\u0005\u0012\u00111M\u0001\u0006g9\nd\u0006M\u0001\tKZ\fG.^1uKR!\u0011\u0011NA8!\ra\u00151N\u0005\u0004\u0003[z$\u0001\u0005'j]\u0016\f'o\u0015,D'VlW.\u0019:z\u0011\u001d\t\t\b\u0005a\u0001\u0003g\nq\u0001Z1uCN,G\u000f\r\u0003\u0002v\u0005\u0015\u0005CBA<\u0003{\n\t)\u0004\u0002\u0002z)\u0019\u00111P\"\u0002\u0007M\fH.\u0003\u0003\u0002\u0000\u0005e$a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0007\u000b)\t\u0004\u0001\u0005\u0019\u0005\u001d\u0015qNA\u0001\u0002\u0003\u0015\t!!#\u0003\u0007}#3'\u0005\u0003\u0002\f\u0006E\u0005\u0003BA\b\u0003\u001bK1!a$n\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0004\u0002\u0014&\u0019\u0011QS7\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u0011k\u0006\u0005\u0014a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003\u001b\ti\n\u0003\u0004\u0002 F\u0001\raT\u0001\tM\u0016\fG/\u001e:fg\u0006Q\u0001O]3eS\u000e$(+Y<\u0015\u0007=\u000b)\u000b\u0003\u0004\u0002 J\u0001\ra\u0014\u0015\u0005%U\fI+\t\u0002\u0002,\u0006)1G\f\u0019/a\u0005q!/Y<3aJ,G-[2uS>tG\u0003BA\u0007\u0003cCa!a-\u0014\u0001\u0004y\u0015!\u0004:boB\u0013X\rZ5di&|g.\u0001\u0003d_BLHcA+\u0002:\"9\u00111\u0018\u000bA\u0002\u0005u\u0016!B3yiJ\f\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\r\u0017)A\u0003qCJ\fW.\u0003\u0003\u0002H\u0006\u0005'\u0001\u0003)be\u0006lW*\u00199)\u0007Q)80A\u0003xe&$X-\u0006\u0002\u0002PB\u0019!,!5\n\u0007\u0005M7L\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\r)Ro_\u0001\ti>\u001cFO]5oOR\tq\r\u000b\u0003\u0017k\u0006%\u0006f\u0001\u0001vw\u0006qA*\u001b8fCJ\u001cfkQ'pI\u0016d\u0007C\u0001'\u0019'\u001dA\u0012Q]Av\u0003c\u0004B!a\u0004\u0002h&\u0019\u0011\u0011^7\u0003\r\u0005s\u0017PU3g!\u0011Q\u0016Q^+\n\u0007\u0005=8L\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004B!a=\u0002~6\u0011\u0011Q\u001f\u0006\u0005\u0003o\fI0\u0001\u0002j_*\u0011\u00111`\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0000\u0006U(\u0001D*fe&\fG.\u001b>bE2,GCAAq\u0003\u0011\u0011X-\u00193\u0016\u0005\t\u001d\u0001\u0003\u0002.\u0003\nUK1Aa\u0003\\\u0005!iEJU3bI\u0016\u0014\bf\u0001\u000evw\u0006!An\\1e)\r)&1\u0003\u0005\u0007\u0005+Y\u0002\u0019A4\u0002\tA\fG\u000f\u001b\u0015\u00047U\\(a\u0004'j]\u0016\f'o\u0015,D/JLG/\u001a:\u0014\u000bq\tyM!\b\u0011\t\t}!QE\u0007\u0003\u0005CQ1Aa\tD\u0003!Ig\u000e^3s]\u0006d\u0017\u0002\u0002B\u0014\u0005C\u0011q\u0001T8hO&tw-\u0001\u0005j]N$\u0018M\\2f)\u0011\u0011iC!\r\u0011\u0007\t=B$D\u0001\u0019\u0011\u0019\u0011IC\ba\u0001+\n!A)\u0019;b'\u001dy\u0012Q\u001dB\u001c\u0005{\u0001B!a\u0004\u0003:%\u0019!1H7\u0003\u000fA\u0013x\u000eZ;diB!!q\bB%\u001d\u0011\u0011\tE!\u0012\u000f\u0007)\u0014\u0019%C\u0001o\u0013\r\u00119%\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tyPa\u0013\u000b\u0007\t\u001dS\u000e\u0006\u0004\u0003P\tM#Q\u000b\t\u0004\u0005#zR\"\u0001\u000f\t\u000b}$\u0003\u0019A(\t\u000f\u0005%A\u00051\u0001\u0002\u000eQ1!q\nB-\u00057Bqa`\u0013\u0011\u0002\u0003\u0007q\nC\u0005\u0002\n\u0015\u0002\n\u00111\u0001\u0002\u000e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B1U\ry%1M\u0016\u0003\u0005K\u0002BAa\u001a\u0003p5\u0011!\u0011\u000e\u0006\u0005\u0005W\u0012i'A\u0005v]\u000eDWmY6fI*\u0011\u00010\\\u0005\u0005\u0005c\u0012IGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003x)\"\u0011Q\u0002B2\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0010\t\u0005\u0005\u007f\u0012))\u0004\u0002\u0003\u0002*!!1QA}\u0003\u0011a\u0017M\\4\n\u0007I\u0014\t)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E%Q\u0012\u0005\n\u0005\u001fS\u0013\u0011!a\u0001\u0003_\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BK!\u0019\u00119J!(\u0002\u00126\u0011!\u0011\u0014\u0006\u0004\u00057k\u0017AC2pY2,7\r^5p]&!!q\u0014BM\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u0015&1\u0016\t\u0005\u0003\u001f\u00119+C\u0002\u0003*6\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003\u00102\n\t\u00111\u0001\u0002\u0012\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011iH!-\t\u0013\t=U&!AA\u0002\u0005=\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005=BC\u0001B?\u0003\u0019)\u0017/^1mgR!!Q\u0015B_\u0011%\u0011y\tMA\u0001\u0002\u0004\t\t*\u0001\u0003ECR\f\u0007c\u0001B)eM)!G!2\u0002rBI!q\u0019Bg\u001f\u00065!qJ\u0007\u0003\u0005\u0013T1Aa3n\u0003\u001d\u0011XO\u001c;j[\u0016LAAa4\u0003J\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\t\u0005\u0017!B1qa2LHC\u0002B(\u0005/\u0014I\u000eC\u0003\u0000k\u0001\u0007q\nC\u0004\u0002\nU\u0002\r!!\u0004\u0002\u000fUt\u0017\r\u001d9msR!!q\u001cBv!\u0019\tyA!9\u0003f&\u0019!1]7\u0003\r=\u0003H/[8o!\u001d\tyAa:P\u0003\u001bI1A!;n\u0005\u0019!V\u000f\u001d7fe!I!Q\u001e\u001c\u0002\u0002\u0003\u0007!qJ\u0001\u0004q\u0012\u0002\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\tM(\u0011 \t\u0005\u0003\u001f\u0011)0C\u0002\u0003x6\u0014A!\u00168ji\"1!QC\u001cA\u0002\u001d\u0014q\u0002T5oK\u0006\u00148KV\"SK\u0006$WM]\n\u0004q\t\u001dACAB\u0001!\r\u0011y\u0003O\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!)\r)6\u0011\u0002\u0005\u0007\u0005+a\u0004\u0019A4\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r=\u0001\u0003\u0002B@\u0007#IAaa\u0005\u0003\u0002\n1qJ\u00196fGRD3\u0001G;|Q\r9Ro\u001f")
public class LinearSVCModel
extends ClassificationModel<Vector, LinearSVCModel>
implements LinearSVCParams,
MLWritable,
HasTrainingSummary<LinearSVCTrainingSummary> {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final int numClasses;
    private final int numFeatures;
    private final Function1<Vector, Object> margin;
    private Option<LinearSVCTrainingSummary> trainingSummary;
    private DoubleParam threshold;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam regParam;

    public static LinearSVCModel load(String string) {
        return LinearSVCModel$.MODULE$.load(string);
    }

    public static MLReader<LinearSVCModel> read() {
        return LinearSVCModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LinearSVCTrainingSummary> setSummary(Option<LinearSVCTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Option<LinearSVCTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LinearSVCTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearSVCModel setThreshold(double value) {
        return (LinearSVCModel)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    @Override
    public LinearSVCTrainingSummary summary() {
        return (LinearSVCTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public LinearSVCSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ClassificationModel summaryModel = (ClassificationModel)tuple3._1();
        String rawPrediction = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)rawPrediction, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ClassificationModel summaryModel2 = (ClassificationModel)tuple33._1();
        String rawPrediction2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return new LinearSVCSummaryImpl(summaryModel2.transform(dataset), rawPrediction2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features)) > BoxesRunTime.unboxToDouble((Object)this.$(this.threshold())) ? 1.0 : 0.0;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return rawPrediction.apply(1) > BoxesRunTime.unboxToDouble((Object)this.$(this.threshold())) ? 1.0 : 0.0;
    }

    @Override
    public LinearSVCModel copy(ParamMap extra) {
        return (LinearSVCModel)((Model)this.copyValues(new LinearSVCModel(this.uid(), this.coefficients(), this.intercept()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new LinearSVCWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(47).append("LinearSVCModel: uid=").append(this.uid()).append(", numClasses=").append(this.numClasses()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LinearSVCModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this.coefficients()) + $this.intercept();
    }

    public LinearSVCModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numClasses = 2;
        this.numFeatures = coefficients.size();
        this.margin = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LinearSVCModel.$anonfun$margin$1(this, features));
        Statics.releaseFence();
    }

    private static class LinearSVCReader
    extends MLReader<LinearSVCModel> {
        private final String className = LinearSVCModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearSVCModel load(String path) {
            Vector vector;
            Object intercept;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    Some some;
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().format("parquet").load(dataPath);
                    row = (Row)data.select("coefficients", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept"})).head();
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block2;
                    Object coefficients = ((SeqOps)some.get()).apply(0);
                    intercept = ((SeqOps)some.get()).apply(1);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (intercept instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d = BoxesRunTime.unboxToDouble((Object)intercept);
            Tuple2 tuple2 = new Tuple2((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d));
            Tuple2 tuple22 = tuple2;
            Vector coefficients = (Vector)tuple22._1();
            double intercept2 = tuple22._2$mcD$sp();
            LinearSVCModel model = new LinearSVCModel(metadata.uid(), coefficients, intercept2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LinearSVCWriter
    extends MLWriter {
        private volatile LinearSVCModel$LinearSVCWriter$Data$ Data$module;
        private final LinearSVCModel instance;

        private LinearSVCModel$LinearSVCWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(LinearSVCWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LinearSVCModel.LinearSVCWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LinearSVCModel.LinearSVCWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$1(LinearSVCWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LinearSVCWriter linearSVCWriter = this;
            synchronized (linearSVCWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LinearSVCModel$LinearSVCWriter$Data$(this);
                }
            }
        }

        public LinearSVCWriter(LinearSVCModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final Vector coefficients;
            private final double intercept;
            public final /* synthetic */ LinearSVCWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public Data copy(Vector coefficients, double intercept) {
                return new Data(this.org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer(), coefficients, intercept);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "coefficients";
                        break;
                    }
                    case 1: {
                        string = "intercept";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LinearSVCWriter org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LinearSVCWriter $outer, Vector coefficients, double intercept) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

