/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BinaryLogisticBlockAggregator;
import org.apache.spark.ml.optim.aggregator.MultinomialLogisticBlockAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r-c\u0001B\u0016-\u0001]B\u0001\"\u0016\u0001\u0003\u0006\u0004%\tE\u0016\u0005\t[\u0002\u0011\t\u0011)A\u0005/\")q\u000e\u0001C\u0001a\")q\u000e\u0001C\u0001m\")\u0001\u0010\u0001C\u0001s\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t\t\b\u0001C!\u0003gBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t)\f\u0001C\u0005\u0003oC\u0011\"a2\u0001\u0001\u0004%I!!3\t\u0013\u0005E\u0007\u00011A\u0005\n\u0005M\u0007\u0002CAm\u0001\u0001\u0006K!a3\t\u0011\u0005m\u0007\u0001\"\u00011\u0003;D\u0001\"a9\u0001\t#\u0001\u0014Q\u001d\u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011\u001d\u00119\u0002\u0001C\u0005\u00053AqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003H\u0001!IA!\u0013\t\u000f\te\u0004\u0001\"\u0003\u0003|!9!1\u0014\u0001\u0005\n\tu\u0005b\u0002Bs\u0001\u0011\u0005#q]\u0004\b\u0005{d\u0003\u0012\u0001B\u0000\r\u0019YC\u0006#\u0001\u0004\u0002!1q.\nC\u0001\u0007?Aqa!\t&\t\u0003\u001a\u0019\u0003\u0003\u0006\u0004,\u0015\u0012\r\u0011\"\u0001-\u0007[A\u0001ba\u000f&A\u0003%1q\u0006\u0005\n\u0007{)\u0013\u0011!C\u0005\u0007\u007f\u0011!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]*\u0011QFL\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\ty\u0003'\u0001\u0002nY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Ad)S(\u0011\u000beRDHQ\"\u000e\u00031J!a\u000f\u0017\u0003/A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u0014\bCA\u001fA\u001b\u0005q$BA /\u0003\u0019a\u0017N\\1mO&\u0011\u0011I\u0010\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005e\u0002\u0001CA\u001dE\u0013\t)EFA\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011\u0011hR\u0005\u0003\u00112\u0012\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\tQU*D\u0001L\u0015\tae&\u0001\u0003vi&d\u0017B\u0001(L\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"\u0001U*\u000e\u0003ES!A\u0015\u0019\u0002\u0011%tG/\u001a:oC2L!\u0001V)\u0003\u000f1{wmZ5oO\u0006\u0019Q/\u001b3\u0016\u0003]\u0003\"\u0001W1\u000f\u0005e{\u0006C\u0001.^\u001b\u0005Y&B\u0001/7\u0003\u0019a$o\\8u})\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\u00061\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001W\fK\u0002\u0002K.\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002kO\n)1+\u001b8dK\u0006\nA.A\u00032]Qr\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002fW\u00061A(\u001b8jiz\"\"AQ9\t\u000bU\u001b\u0001\u0019A,)\u0007E,7\u000eK\u0002\u0004KR\f\u0013!^\u0001\u0006c9\u0012d\u0006\r\u000b\u0002\u0005\"\u001aA!Z6\u0002\u0017M,GOU3h!\u0006\u0014\u0018-\u001c\u000b\u0003unl\u0011\u0001\u0001\u0005\u0006y\u0016\u0001\r!`\u0001\u0006m\u0006dW/\u001a\t\u0003}~l\u0011!X\u0005\u0004\u0003\u0003i&A\u0002#pk\ndW\rK\u0002\u0006KR\f!c]3u\u000b2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[R\u0019!0!\u0003\t\u000bq4\u0001\u0019A?)\u0007\u0019)7.\u0001\u0006tKRl\u0015\r_%uKJ$2A_A\t\u0011\u0019ax\u00011\u0001\u0002\u0014A\u0019a0!\u0006\n\u0007\u0005]QLA\u0002J]RD3aB3u\u0003\u0019\u0019X\r\u001e+pYR\u0019!0a\b\t\u000bqD\u0001\u0019A?)\u0007!)7.A\btKR4\u0015\u000e^%oi\u0016\u00148-\u001a9u)\rQ\u0018q\u0005\u0005\u0007y&\u0001\r!!\u000b\u0011\u0007y\fY#C\u0002\u0002.u\u0013qAQ8pY\u0016\fg\u000eK\u0002\nK.\f\u0011b]3u\r\u0006l\u0017\u000e\\=\u0015\u0007i\f)\u0004C\u0003}\u0015\u0001\u0007q\u000b\u000b\u0003\u000bK\u0006e\u0012EAA\u001e\u0003\u0015\u0011d&\r\u00181\u0003I\u0019X\r^*uC:$\u0017M\u001d3ju\u0006$\u0018n\u001c8\u0015\u0007i\f\t\u0005\u0003\u0004}\u0017\u0001\u0007\u0011\u0011\u0006\u0015\u0005\u0017\u0015\f)%\t\u0002\u0002H\u0005)\u0011GL\u001b/a\u0005a1/\u001a;UQJ,7\u000f[8mIR\u0019!0!\u0014\t\u000bqd\u0001\u0019A?)\t1)\u0017QI\u0001\rO\u0016$H\u000b\u001b:fg\"|G\u000eZ\u000b\u0002{\"\"Q\"ZA#\u00031\u0019X\r^,fS\u001eDGoQ8m)\rQ\u00181\f\u0005\u0006y:\u0001\ra\u0016\u0015\u0005\u001d\u0015\fy&\t\u0002\u0002b\u0005)\u0011G\f\u001c/a\u0005i1/\u001a;UQJ,7\u000f[8mIN$2A_A4\u0011\u0019ax\u00021\u0001\u0002jA!a0a\u001b~\u0013\r\ti'\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0005\u001f\u0015\f)%A\u0007hKR$\u0006N]3tQ>dGm]\u000b\u0003\u0003SBC\u0001E3\u0002F\u0005\u00192/\u001a;BO\u001e\u0014XmZ1uS>tG)\u001a9uQR\u0019!0a\u001f\t\rq\f\u0002\u0019AA\nQ\u0011\tR-!\u000f\u00029M,G\u000fT8xKJ\u0014u.\u001e8eg>s7i\\3gM&\u001c\u0017.\u001a8ugR\u0019!0a!\t\rq\u0014\u0002\u0019AAC!\ri\u0014qQ\u0005\u0004\u0003\u0013s$AB'biJL\u0007\u0010\u000b\u0003\u0013K\u00065\u0015EAAH\u0003\u0015\u0011dF\r\u00181\u0003q\u0019X\r^+qa\u0016\u0014(i\\;oIN|enQ8fM\u001aL7-[3oiN$2A_AK\u0011\u0019a8\u00031\u0001\u0002\u0006\"\"1#ZAG\u0003i\u0019X\r\u001e'po\u0016\u0014(i\\;oIN|e.\u00138uKJ\u001cW\r\u001d;t)\rQ\u0018Q\u0014\u0005\u0006yR\u0001\r\u0001\u0010\u0015\u0005)\u0015\fi)\u0001\u000etKR,\u0006\u000f]3s\u0005>,h\u000eZ:P]&sG/\u001a:dKB$8\u000fF\u0002{\u0003KCQ\u0001`\u000bA\u0002qBC!F3\u0002\u000e\u0006\u00192/\u001a;NCb\u0014En\\2l'&TX-\u00138N\u0005R\u0019!0!,\t\u000bq4\u0002\u0019A?)\tY)\u0017\u0011W\u0011\u0003\u0003g\u000bQa\r\u00182]A\nQ&Y:tKJ$(i\\;oI\u000e{gn\u001d;sC&tW\rZ(qi&l\u0017N_1uS>t\u0007+\u0019:b[N4\u0016\r\\5e)\u0019\tI,a0\u0002DB\u0019a0a/\n\u0007\u0005uVL\u0001\u0003V]&$\bbBAa/\u0001\u0007\u00111C\u0001\u0013]Vl7i\\3gM&\u001c\u0017.\u001a8u'\u0016$8\u000fC\u0004\u0002F^\u0001\r!a\u0005\u0002\u00179,XNR3biV\u0014Xm]\u0001\u0010_B$\u0018J\\5uS\u0006dWj\u001c3fYV\u0011\u00111\u001a\t\u0005}\u000657)C\u0002\u0002Pv\u0013aa\u00149uS>t\u0017aE8qi&s\u0017\u000e^5bY6{G-\u001a7`I\u0015\fH\u0003BA]\u0003+D\u0011\"a6\u001a\u0003\u0003\u0005\r!a3\u0002\u0007a$\u0013'\u0001\tpaRLe.\u001b;jC2lu\u000eZ3mA\u0005y1/\u001a;J]&$\u0018.\u00197N_\u0012,G\u000eF\u0002{\u0003?Da!!9\u001c\u0001\u0004\u0019\u0015!B7pI\u0016d\u0017!\u0002;sC&tGcA\"\u0002h\"9\u0011\u0011\u001e\u000fA\u0002\u0005-\u0018a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003[\fi\u0010\u0005\u0004\u0002p\u0006U\u0018\u0011`\u0007\u0003\u0003cT1!a=1\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003o\f\tPA\u0004ECR\f7/\u001a;\u0011\t\u0005m\u0018Q \u0007\u0001\t1\ty0a:\u0002\u0002\u0003\u0005)\u0011\u0001B\u0001\u0005\ryF%M\t\u0005\u0005\u0007\u0011I\u0001E\u0002\u007f\u0005\u000bI1Aa\u0002^\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A B\u0006\u0013\r\u0011i!\u0018\u0002\u0004\u0003:L\u0018\u0001E2iK\u000e\\W*\u001e7uS:|W.[1m)\u0011\tICa\u0005\t\u000f\tUQ\u00041\u0001\u0002\u0014\u0005Qa.^7DY\u0006\u001c8/Z:\u0002\u0017\r\u0014X-\u0019;f\u001b>$W\r\u001c\u000b\f\u0007\nm!q\u0005B\u0015\u0005[\u0011\t\u0004C\u0004\u0002jz\u0001\rA!\b1\t\t}!1\u0005\t\u0007\u0003_\f)P!\t\u0011\t\u0005m(1\u0005\u0003\r\u0005K\u0011Y\"!A\u0001\u0002\u000b\u0005!\u0011\u0001\u0002\u0004?\u0012\u0012\u0004b\u0002B\u000b=\u0001\u0007\u00111\u0003\u0005\b\u0005Wq\u0002\u0019AAC\u0003E\u0019w.\u001a4gS\u000eLWM\u001c;NCR\u0014\u0018\u000e\u001f\u0005\u0007\u0005_q\u0002\u0019\u0001\u001f\u0002\u001f%tG/\u001a:dKB$h+Z2u_JDqAa\r\u001f\u0001\u0004\tI'\u0001\tpE*,7\r^5wK\"K7\u000f^8ss\u0006a1M]3bi\u0016\u0014u.\u001e8egRA!\u0011\bB \u0005\u0003\u0012\u0019\u0005E\u0004\u007f\u0005w\tI'!\u001b\n\u0007\tuRL\u0001\u0004UkBdWM\r\u0005\b\u0005+y\u0002\u0019AA\n\u0011\u001d\t)m\ba\u0001\u0003'AqA!\u0012 \u0001\u0004\tI'A\u0006gK\u0006$XO]3t'R$\u0017aD2sK\u0006$Xm\u00149uS6L'0\u001a:\u0015\u0019\t-#1\u000eB7\u0005_\u0012\tH!\u001e\u0011\u0011\t5#q\u000bB.\u0005Kj!Aa\u0014\u000b\t\tE#1K\u0001\t_B$\u0018.\\5{K*\u0011!QK\u0001\u0007EJ,WM_3\n\t\te#q\n\u0002\u0014\r&\u00148\u000f^(sI\u0016\u0014X*\u001b8j[&TXM\u001d\t\u0006\u0005;\u0012\t'`\u0007\u0003\u0005?R1a\u0010B*\u0013\u0011\u0011\u0019Ga\u0018\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\t\u0007\u0005\u001b\u00129Ga\u0017\n\t\t%$q\n\u0002\r\t&4gMR;oGRLwN\u001c\u0005\b\u0005+\u0001\u0003\u0019AA\n\u0011\u001d\t)\r\ta\u0001\u0003'AqA!\u0012!\u0001\u0004\tI\u0007C\u0004\u0003t\u0001\u0002\r!!\u001b\u0002\u00171|w/\u001a:C_VtGm\u001d\u0005\b\u0005o\u0002\u0003\u0019AA5\u0003-)\b\u000f]3s\u0005>,h\u000eZ:\u0002+\r\u0014X-\u0019;f\u0013:LG/[1m'>dW\u000f^5p]R\u0001\"Q\u0010BB\u0005\u000b\u00139Ia#\u0003\u000e\n=%\u0011\u0013\t\u0004{\t}\u0014b\u0001BA}\tYA)\u001a8tK6\u000bGO]5y\u0011\u001d\u0011)\"\ta\u0001\u0003'Aq!!2\"\u0001\u0004\t\u0019\u0002C\u0004\u0003\n\u0006\u0002\r!!\u001b\u0002\u0013!L7\u000f^8he\u0006l\u0007b\u0002B#C\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005g\n\u0003\u0019AA5\u0011\u001d\u00119(\ta\u0001\u0003SBqAa%\"\u0001\u0004\u0011)*A\u0003j]N$(\u000fE\u0002K\u0005/K1A!'L\u0005=Ien\u001d;sk6,g\u000e^1uS>t\u0017!\u0003;sC&t\u0017*\u001c9m)I\u0011IDa(\u0003<\n}&\u0011\u0019Bc\u0005\u000f\u0014YM!9\t\u000f\t\u0005&\u00051\u0001\u0003$\u0006I\u0011N\\:uC:\u001cWm\u001d\t\u0007\u0005K\u0013YKa,\u000e\u0005\t\u001d&b\u0001BUa\u0005\u0019!\u000f\u001a3\n\t\t5&q\u0015\u0002\u0004%\u0012#\u0005\u0003\u0002BY\u0005ok!Aa-\u000b\u0007\tUf&A\u0004gK\u0006$XO]3\n\t\te&1\u0017\u0002\t\u0013:\u001cH/\u00198dK\"1!Q\u0018\u0012A\u0002u\f1#Y2uk\u0006d'\t\\8dWNK'0Z%o\u001b\nCqA!\u0012#\u0001\u0004\tI\u0007C\u0004\u0003D\n\u0002\r!!\u001b\u0002\u0019\u0019,\u0017\r^;sKNlU-\u00198\t\u000f\tU!\u00051\u0001\u0002\u0014!9!\u0011\u001a\u0012A\u0002\u0005%\u0014aD5oSRL\u0017\r\\*pYV$\u0018n\u001c8\t\u000f\t5'\u00051\u0001\u0003P\u0006q!/Z4vY\u0006\u0014\u0018N_1uS>t\u0007#\u0002@\u0002N\nE\u0007\u0003\u0002Bj\u0005;l!A!6\u000b\t\t]'\u0011\\\u0001\u0005Y>\u001c8OC\u0002\u0003\\:\nQa\u001c9uS6LAAa8\u0003V\n\u0001BJ\r*fOVd\u0017M]5{CRLwN\u001c\u0005\b\u0005G\u0014\u0003\u0019\u0001B&\u0003%y\u0007\u000f^5nSj,'/\u0001\u0003d_BLHc\u0001\"\u0003j\"9!1^\u0012A\u0002\t5\u0018!B3yiJ\f\u0007\u0003\u0002Bx\u0005kl!A!=\u000b\u0007\tMh&A\u0003qCJ\fW.\u0003\u0003\u0003x\nE(\u0001\u0003)be\u0006lW*\u00199)\u0007\r*7\u000eK\u0002\u0001KR\f!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u0011\u0011(J\n\bK\r\r1\u0011BB\b!\rq8QA\u0005\u0004\u0007\u000fi&AB!osJ+g\r\u0005\u0003K\u0007\u0017\u0011\u0015bAB\u0007\u0017\n)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007\u0003BB\t\u00077i!aa\u0005\u000b\t\rU1qC\u0001\u0003S>T!a!\u0007\u0002\t)\fg/Y\u0005\u0005\u0007;\u0019\u0019B\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\u0000\u0006!An\\1e)\r\u00115Q\u0005\u0005\u0007\u0007O9\u0003\u0019A,\u0002\tA\fG\u000f\u001b\u0015\u0005O\u0015\fy&\u0001\u000btkB\u0004xN\u001d;fI\u001a\u000bW.\u001b7z\u001d\u0006lWm]\u000b\u0003\u0007_\u0001RA`A6\u0007c\u0001Baa\r\u0004:5\u00111Q\u0007\u0006\u0005\u0007o\u00199\"\u0001\u0003mC:<\u0017b\u00012\u00046\u0005)2/\u001e9q_J$X\r\u001a$b[&d\u0017PT1nKN\u0004\u0013\u0001D<sSR,'+\u001a9mC\u000e,GCAB!!\u0011\u0019\u0019da\u0011\n\t\r\u00153Q\u0007\u0002\u0007\u001f\nTWm\u0019;)\t\u0015*\u0017q\f\u0015\u0005I\u0015\fy\u0006")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private Param<String> family;
    private Param<Matrix> lowerBoundsOnCoefficients;
    private Param<Matrix> upperBoundsOnCoefficients;
    private Param<Vector> lowerBoundsOnIntercepts;
    private Param<Vector> upperBoundsOnIntercepts;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private DoubleParam threshold;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;

    public static LogisticRegression load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setFamily(String value) {
        return (LogisticRegression)this.set(this.family(), value);
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    public LogisticRegression setAggregationDepth(int value) {
        return (LogisticRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setLowerBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnCoefficients(), value);
    }

    public LogisticRegression setUpperBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.upperBoundsOnCoefficients(), value);
    }

    public LogisticRegression setLowerBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnIntercepts(), value);
    }

    public LogisticRegression setUpperBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.upperBoundsOnIntercepts(), value);
    }

    public LogisticRegression setMaxBlockSizeInMB(double value) {
        return (LogisticRegression)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    private void assertBoundConstrainedOptimizationParamsValid(int numCoefficientSets, int numFeatures) {
        block5: {
            if (this.isSet(this.lowerBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.lowerBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable)() -> new StringBuilder(194).append("The shape of LowerBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append(new StringBuilder(5).append("(").append(this.getLowerBoundsOnCoefficients().numRows()).append(", ").append(this.getLowerBoundsOnCoefficients().numCols()).append(").").toString()).toString());
            }
            if (this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.upperBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable)() -> new StringBuilder(194).append("The shape of upperBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append(new StringBuilder(5).append("(").append(this.getUpperBoundsOnCoefficients().numRows()).append(", ").append(this.getUpperBoundsOnCoefficients().numCols()).append(").").toString()).toString());
            }
            if (this.isSet(this.lowerBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable)() -> new StringBuilder(97).append("The size of lowerBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append(new StringBuilder(48).append("classes for multinomial regression, but found: ").append(this.getLowerBoundsOnIntercepts().size()).append(".").toString()).toString());
            }
            if (this.isSet(this.upperBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable)() -> new StringBuilder(97).append("The size of upperBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append(new StringBuilder(48).append("classes for multinomial regression, but found: ").append(this.getUpperBoundsOnIntercepts().size()).append(".").toString()).toString());
            }
            if (this.isSet(this.lowerBoundsOnCoefficients()) && this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnCoefficients()).toArray()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnCoefficients()).toArray()))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$5(x))), (Function0 & Serializable)() -> new StringBuilder(103).append("LowerBoundsOnCoefficients should always be less than or equal to upperBoundsOnCoefficients, but found: ").append(new StringBuilder(30).append("lowerBoundsOnCoefficients = ").append(this.getLowerBoundsOnCoefficients()).append(", ").toString()).append(new StringBuilder(29).append("upperBoundsOnCoefficients = ").append(this.getUpperBoundsOnCoefficients()).append(".").toString()).toString());
            }
            if (!this.isSet(this.lowerBoundsOnIntercepts()) || !this.isSet(this.upperBoundsOnIntercepts())) break block5;
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnIntercepts()).toArray()))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$7(x))), (Function0 & Serializable)() -> new StringBuilder(99).append("LowerBoundsOnIntercepts should always be less than or equal to upperBoundsOnIntercepts, but found: ").append(new StringBuilder(28).append("lowerBoundsOnIntercepts = ").append(this.getLowerBoundsOnIntercepts()).append(", ").toString()).append(new StringBuilder(27).append("upperBoundsOnIntercepts = ").append(this.getUpperBoundsOnIntercepts()).append(".").toString()).toString());
        }
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        LogisticRegressionModel logisticRegressionModel;
        Object object = new Object();
        try {
            logisticRegressionModel = (LogisticRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
                None$ none$;
                double regParamL2;
                boolean isConstantLabel;
                boolean isMultinomial;
                int numCoefficientSets;
                int n;
                instr.logPipelineStage(this);
                instr.logDataset(dataset);
                instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.thresholds(), this.maxIter(), this.tol(), this.fitIntercept(), this.maxBlockSizeInMB()}));
                StorageLevel storageLevel = dataset.storageLevel();
                StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Input instances will be standardized, blockified to blocks, and ").append("then cached during training. Be careful of double caching!").toString());
                }
                RDD instances = this.extractInstances(dataset).setName("training instances");
                Tuple2<SummarizerBuffer, MultiClassSummarizer> tuple2 = Summarizer$.MODULE$.getClassificationSummarizers((RDD<Instance>)instances, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"}))));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
                MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
                Tuple2 tuple23 = tuple22;
                SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple23._1();
                MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
                int numFeatures = summarizer2.mean().size();
                double[] histogram = labelSummarizer2.histogram();
                long numInvalid = labelSummarizer2.countInvalid();
                int numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
                Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                    int n3 = n2;
                    Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(33).append("Specified number of classes ").append(n3).append(" was ").toString()).append(new StringBuilder(39).append("less than the number of unique labels ").append(histogram.length).append(".").toString()).toString());
                    n = n3;
                } else {
                    if (!None$.MODULE$.equals(option)) {
                        throw new MatchError(option);
                    }
                    n = histogram.length;
                }
                int numClasses = n;
                if (numInvalid != 0L) {
                    String msg = new StringBuilder(0).append(new StringBuilder(44).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").toString()).append(new StringBuilder(22).append("Found ").append(numInvalid).append(" invalid labels.").toString()).toString();
                    instr.logError((Function0<String>)(Function0 & Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                instr.logNumClasses(numClasses);
                instr.logNumFeatures(numFeatures);
                instr.logNumExamples(summarizer2.count());
                instr.logNamedValue("lowestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
                instr.logNamedValue("highestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
                instr.logSumOfWeights(summarizer2.weightSum());
                double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
                if (actualBlockSizeInMB == 0.0) {
                    actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                    Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                    instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
                }
                int n4 = numCoefficientSets = (isMultinomial = this.checkMultinomial(numClasses)) ? numClasses : 1;
                if (this.usingBoundConstrainedOptimization()) {
                    this.assertBoundConstrainedOptimizationParamsValid(numCoefficientSets, numFeatures);
                }
                if (this.isDefined(this.thresholds())) {
                    Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable)() -> new StringBuilder(67).append(this.getClass().getSimpleName()).append(".train() called with non-matching numClasses and thresholds.length.").append(new StringBuilder(40).append(" numClasses=").append(numClasses).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString()).toString());
                }
                boolean bl = isConstantLabel = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.doubleArrayOps(histogram), (Function1)(JFunction1.mcZD.sp & Serializable)x$2 -> x$2 != 0.0) == 1;
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel && !this.usingBoundConstrainedOptimization()) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("All labels are the same value and fitIntercept=true, so the ").append("coefficients will be zeros. Training is not needed.").toString());
                    int constantLabelIndex = Vectors$.MODULE$.dense(histogram).argmax();
                    Matrix coefMatrix = new SparseMatrix(numCoefficientSets, numFeatures, new int[numCoefficientSets + 1], Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray(), true).compressed();
                    Vector interceptVec = isMultinomial ? Vectors$.MODULE$.sparse(numClasses, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(constantLabelIndex, Double.POSITIVE_INFINITY)}))) : Vectors$.MODULE$.dense(numClasses == 2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY, (Seq)Nil$.MODULE$);
                    throw new NonLocalReturnControl(object, (Object)this.createModel(dataset, numClasses, coefMatrix, interceptVec, new double[]{0.0}));
                }
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("All labels belong to a single class and fitIntercept=false. It's a ").append("dangerous ground, so the algorithm may not converge.").toString());
                }
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = summarizer2.std().toArray();
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Fitting LogisticRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                if ((regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()))) != 0.0) {
                    JFunction1.mcDI.sp & Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable)j -> j >= 0 && j < numCoefficientSets * numFeatures ? featuresStd[j / numCoefficientSets] : 0.0;
                    JFunction1.mcZI.sp & Serializable shouldApply = (JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < numFeatures * numCoefficientSets;
                    none$ = new Some((Object)new L2Regularization(regParamL2, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                Tuple2<double[], double[]> tuple24 = this.createBounds(numClasses, numFeatures, featuresStd);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                double[] lowerBounds = (double[])tuple24._1();
                double[] upperBounds = (double[])tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                Tuple2 tuple26 = tuple25;
                double[] lowerBounds2 = (double[])tuple26._1();
                double[] upperBounds2 = (double[])tuple26._2();
                FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer = this.createOptimizer(numClasses, numFeatures, featuresStd, lowerBounds2, upperBounds2);
                DenseMatrix initialSolution = this.createInitialSolution(numClasses, numFeatures, histogram, featuresStd, lowerBounds2, upperBounds2, (Instrumentation)instr);
                Tuple2<double[], double[]> tuple27 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, featuresStd, featuresMean, numClasses, initialSolution.toArray(), (Option<L2Regularization>)regularization, optimizer);
                if (tuple27 == null) {
                    throw new MatchError(tuple27);
                }
                double[] allCoefficients = (double[])tuple27._1();
                double[] objectiveHistory = (double[])tuple27._2();
                Tuple2 tuple28 = new Tuple2((Object)allCoefficients, (Object)objectiveHistory);
                Tuple2 tuple29 = tuple28;
                double[] allCoefficients2 = (double[])tuple29._1();
                double[] objectiveHistory2 = (double[])tuple29._2();
                if (allCoefficients2 == null) {
                    String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                    instr.logError((Function0<String>)(Function0 & Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                DenseMatrix allCoefMatrix = new DenseMatrix(numCoefficientSets, numFeaturesPlusIntercept, allCoefficients2);
                DenseMatrix denseCoefficientMatrix = new DenseMatrix(numCoefficientSets, numFeatures, new double[numCoefficientSets * numFeatures], true);
                Vector interceptVec = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || !isMultinomial ? Vectors$.MODULE$.zeros(numCoefficientSets) : Vectors$.MODULE$.sparse(numCoefficientSets, (Seq)scala.package$.MODULE$.Seq().empty());
                allCoefMatrix.foreachActive((Function3 & Serializable)(classIndex, featureIndex, value) -> {
                    LogisticRegression.$anonfun$train$15(this, numFeatures, featuresStd, denseCoefficientMatrix, interceptVec, BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value));
                    return BoxedUnit.UNIT;
                });
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] centers = (double[])Array$.MODULE$.ofDim(numFeatures, (ClassTag)ClassTag$.MODULE$.Double());
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
                        LogisticRegression.$anonfun$train$16(centers, BoxesRunTime.unboxToInt((Object)x0$1), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
                        return BoxedUnit.UNIT;
                    });
                    Predef$.MODULE$.wrapDoubleArray(centers).transform((Function1)(JFunction1.mcDD.sp & Serializable)x$5 -> x$5 / (double)numCoefficientSets);
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable)(x0$2, x1$2, x2$2) -> {
                        LogisticRegression.$anonfun$train$18(denseCoefficientMatrix, centers, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$2), BoxesRunTime.unboxToDouble((Object)x2$2));
                        return BoxedUnit.UNIT;
                    });
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] interceptArray = interceptVec.toArray();
                    double interceptMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(interceptArray).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)interceptArray.length;
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), interceptVec.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                        interceptArray$1[i] = interceptArray[i] - interceptMean;
                    });
                }
                throw new NonLocalReturnControl(object, (Object)this.createModel(dataset, numClasses, denseCoefficientMatrix.compressed(), interceptVec.compressed(), objectiveHistory2));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                logisticRegressionModel = (LogisticRegressionModel)ex.value();
            }
            throw ex;
        }
        return logisticRegressionModel;
    }

    private boolean checkMultinomial(int numClasses) {
        boolean bl;
        block9: {
            String string;
            block6: {
                block7: {
                    block8: {
                        string = this.$(this.family()).toLowerCase(Locale.ROOT);
                        switch (string == null ? 0 : string.hashCode()) {
                            case 3005871: {
                                if (!"auto".equals(string)) break block6;
                                break block7;
                            }
                            case 508210817: {
                                if (!"multinomial".equals(string)) break block6;
                                break block8;
                            }
                            case 950395663: {
                                if ("binomial".equals(string)) {
                                    break;
                                }
                                break block6;
                            }
                            default: {
                                break block6;
                            }
                        }
                        Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0 & Serializable)() -> new StringBuilder(0).append("Binomial family only supports 1 or 2 ").append(new StringBuilder(27).append("outcome classes but found ").append(numClasses).append(".").toString()).toString());
                        bl = false;
                        break block9;
                    }
                    bl = true;
                    break block9;
                }
                bl = numClasses > 2;
                break block9;
            }
            throw new IllegalArgumentException(new StringBuilder(20).append("Unsupported family: ").append(string).toString());
        }
        return bl;
    }

    private LogisticRegressionModel createModel(Dataset<?> dataset, int numClasses, Matrix coefficientMatrix, Vector interceptVector, double[] objectiveHistory) {
        LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficientMatrix, interceptVector, numClasses, this.checkMultinomial(numClasses)), this.copyValues$default$2());
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = model.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        LogisticRegressionSummaryImpl logRegSummary = numClasses <= 2 ? new BinaryLogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName, objectiveHistory) : new LogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName, objectiveHistory);
        return (LogisticRegressionModel)model.setSummary((Option<LogisticRegressionTrainingSummary>)new Some((Object)logRegSummary));
    }

    private Tuple2<double[], double[]> createBounds(int numClasses, int numFeatures, double[] featuresStd) {
        Tuple2 tuple2;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        int numCoefficientSets = isMultinomial ? numClasses : 1;
        int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
        if (this.usingBoundConstrainedOptimization()) {
            double[] lowerBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
            double[] upperBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.POSITIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
            boolean isSetLowerBoundsOnCoefficients = this.isSet(this.lowerBoundsOnCoefficients());
            boolean isSetUpperBoundsOnCoefficients = this.isSet(this.upperBoundsOnCoefficients());
            boolean isSetLowerBoundsOnIntercepts = this.isSet(this.lowerBoundsOnIntercepts());
            boolean isSetUpperBoundsOnIntercepts = this.isSet(this.upperBoundsOnIntercepts());
            for (int i = 0; i < numCoeffsPlusIntercepts; ++i) {
                int coefficientSetIndex = i % numCoefficientSets;
                int featureIndex = i / numCoefficientSets;
                if (featureIndex < numFeatures) {
                    if (isSetLowerBoundsOnCoefficients) {
                        lowerBounds[i] = this.$(this.lowerBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                    }
                    if (!isSetUpperBoundsOnCoefficients) continue;
                    upperBounds[i] = this.$(this.upperBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                    continue;
                }
                if (isSetLowerBoundsOnIntercepts) {
                    lowerBounds[i] = this.$(this.lowerBoundsOnIntercepts()).apply(coefficientSetIndex);
                }
                if (!isSetUpperBoundsOnIntercepts) continue;
                upperBounds[i] = this.$(this.upperBoundsOnIntercepts()).apply(coefficientSetIndex);
            }
            tuple2 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
        } else {
            tuple2 = new Tuple2(null, null);
        }
        return tuple2;
    }

    private FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> createOptimizer(int numClasses, int numFeatures, double[] featuresStd, double[] lowerBounds, double[] upperBounds) {
        Object object;
        int numCoefficientSets;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
        int n = numCoefficientSets = isMultinomial ? numClasses : 1;
        if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0) {
            object = lowerBounds != null && upperBounds != null ? new LBFGSB(DenseVector$.MODULE$.apply((Object)lowerBounds), DenseVector$.MODULE$.apply((Object)upperBounds), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7()) : new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
        } else {
            boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
            object = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, numCoefficientSets, standardizationParam, regParamL1, featuresStd), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
        }
        return object;
    }

    private DenseMatrix createInitialSolution(int numClasses, int numFeatures, double[] histogram, double[] featuresStd, double[] lowerBounds, double[] upperBounds, Instrumentation instr) {
        boolean bl;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        int numCoefficientSets = isMultinomial ? numClasses : 1;
        int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
        DenseMatrix initialCoefWithInterceptMatrix = DenseMatrix$.MODULE$.zeros(numCoefficientSets, numFeaturesPlusIntercept);
        Option<LogisticRegressionModel> option = this.optInitialModel();
        if (option instanceof Some) {
            boolean modelIsValid;
            Some some = (Some)option;
            LogisticRegressionModel _initialModel = (LogisticRegressionModel)some.value();
            Matrix providedCoefs = _initialModel.coefficientMatrix();
            boolean bl2 = modelIsValid = providedCoefs.numRows() == numCoefficientSets && providedCoefs.numCols() == numFeatures && _initialModel.interceptVector().size() == numCoefficientSets && _initialModel.getFitIntercept() == BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()));
            if (!modelIsValid) {
                instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Initial coefficients will be ignored! Its dimensions ").append(new StringBuilder(23).append("(").append(providedCoefs.numRows()).append(", ").append(providedCoefs.numCols()).append(") did not match the ").toString()).append(new StringBuilder(18).append("expected size (").append(numCoefficientSets).append(", ").append(numFeatures).append(")").toString()).toString());
            }
            bl = modelIsValid;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        boolean initialModelIsValid = bl;
        if (initialModelIsValid) {
            Matrix providedCoef = ((LogisticRegressionModel)this.optInitialModel().get()).coefficientMatrix();
            providedCoef.foreachActive((Function3 & Serializable)(classIndex, featureIndex, value) -> {
                initialCoefWithInterceptMatrix.update(BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value) * featuresStd[BoxesRunTime.unboxToInt((Object)featureIndex)]);
                return BoxedUnit.UNIT;
            });
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                ((LogisticRegressionModel)this.optInitialModel().get()).interceptVector().foreachNonZero((Function2)(JFunction2.mcVID.sp & Serializable)(classIndex, value) -> initialCoefWithInterceptMatrix.update(classIndex, numFeatures, value));
            }
        } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
            double[] rawIntercepts = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(histogram), (Function1)(JFunction1.mcDD.sp & Serializable)x -> package$.MODULE$.log1p(x), (ClassTag)ClassTag$.MODULE$.Double());
            double rawMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(rawIntercepts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawIntercepts.length;
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.doubleArrayOps(rawIntercepts)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> initialCoefWithInterceptMatrix.update(i, numFeatures, rawIntercepts[i] - rawMean));
        } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            initialCoefWithInterceptMatrix.update(0, numFeatures, package$.MODULE$.log(histogram[1] / histogram[0]));
        }
        if (this.usingBoundConstrainedOptimization()) {
            for (int i2 = 0; i2 < numCoeffsPlusIntercepts; ++i2) {
                int coefficientSetIndex = i2 % numCoefficientSets;
                int featureIndex2 = i2 / numCoefficientSets;
                if (initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex2) < lowerBounds[i2]) {
                    initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex2, lowerBounds[i2]);
                    continue;
                }
                if (!(initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex2) > upperBounds[i2])) continue;
                initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex2, upperBounds[i2]);
            }
        }
        return initialCoefWithInterceptMatrix;
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double[] featuresStd, double[] featuresMean, int numClasses, double[] initialSolution, Option<L2Regularization> regularization, FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer) {
        double[] solution;
        RDDLossFunction costFun;
        RDDLossFunction rDDLossFunction;
        boolean multinomial = this.checkMultinomial(numClasses);
        boolean fitWithMean = !(!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || this.isSet(this.lowerBoundsOnIntercepts()) && !ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray()), (Function1)(JFunction1.mcZD.sp & Serializable)x$7 -> RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(x$7))) || this.isSet(this.upperBoundsOnIntercepts()) && !ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.upperBoundsOnIntercepts()).toArray()), (Function1)(JFunction1.mcZD.sp & Serializable)x$8 -> RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(x$8))));
        int numFeatures = featuresStd.length;
        double[] inverseStd = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(featuresStd), (Function1)(JFunction1.mcDD.sp & Serializable)std -> std != 0.0 ? 1.0 / std : 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        double[] scaledMean = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> inverseStd[i] * featuresMean[i], (ClassTag)ClassTag$.MODULE$.Double());
        Broadcast bcInverseStd = instances.context().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = instances.context().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD scaled = instances.mapPartitions((Function1 & Serializable)iter -> {
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()), (double[])bcInverseStd.value(), false, true);
            return iter.map((Function1 & Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance == null) {
                    throw new MatchError((Object)instance);
                }
                double label = instance.label();
                double weight = instance.weight();
                Vector vec = instance.features();
                Instance instance2 = new Instance(label, weight, (Vector)func.apply((Object)vec));
                return instance2;
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)scaled, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(new StringBuilder(34).append(this.uid()).append(": training blocks (blockSizeInMB=").append(actualBlockSizeInMB).append(")").toString());
        if (multinomial) {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$9 -> new MultinomialLogisticBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), fitWithMean, (Broadcast<Vector>)x$9);
            rDDLossFunction = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(MultinomialLogisticBlockAggregator.class));
        } else {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$10 -> new BinaryLogisticBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), fitWithMean, (Broadcast<Vector>)x$10);
            rDDLossFunction = costFun = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(BinaryLogisticBlockAggregator.class));
        }
        if (fitWithMean) {
            if (multinomial) {
                double[] adapt = (double[])Array$.MODULE$.ofDim(numClasses, (ClassTag)ClassTag$.MODULE$.Double());
                BLAS$.MODULE$.javaBLAS().dgemv("N", numClasses, numFeatures, 1.0, initialSolution, numClasses, scaledMean, 1, 0.0, adapt, 1);
                BLAS$.MODULE$.javaBLAS().daxpy(numClasses, 1.0, adapt, 0, 1, initialSolution, numClasses * numFeatures, 1);
            } else {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, initialSolution, 1, scaledMean, 1);
                initialSolution[numFeatures] = initialSolution[numFeatures] + adapt;
            }
        }
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector((ClassTag)ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialSolution));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcInverseStd.destroy();
        bcScaledMean.destroy();
        double[] dArray = solution = state == null ? null : ((DenseVector)state.x()).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        if (fitWithMean && solution != null) {
            if (multinomial) {
                double[] adapt = (double[])Array$.MODULE$.ofDim(numClasses, (ClassTag)ClassTag$.MODULE$.Double());
                BLAS$.MODULE$.javaBLAS().dgemv("N", numClasses, numFeatures, 1.0, solution, numClasses, scaledMean, 1, 0.0, adapt, 1);
                BLAS$.MODULE$.javaBLAS().daxpy(numClasses, -1.0, adapt, 0, 1, solution, numClasses * numFeatures, 1);
            } else {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, solution, 1, scaledMean, 1);
                solution[numFeatures] = solution[numFeatures] - adapt;
            }
        }
        return new Tuple2((Object)solution, arrayBuilder.result());
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$5(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$7(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$train$15(LogisticRegression $this, int numFeatures$1, double[] featuresStd$1, DenseMatrix denseCoefficientMatrix$1, Vector interceptVec$1, int classIndex, int featureIndex, double value) {
        block1: {
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)$this.$($this.fitIntercept())) && featureIndex == numFeatures$1;
            if (!isIntercept && featuresStd$1[featureIndex] != 0.0) {
                denseCoefficientMatrix$1.update(classIndex, featureIndex, value / featuresStd$1[featureIndex]);
            }
            if (!isIntercept) break block1;
            interceptVec$1.toArray()[classIndex] = value;
        }
    }

    public static final /* synthetic */ void $anonfun$train$16(double[] centers$1, int x0$1, int x1$1, double x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        centers$1[j] = centers$1[j] + v;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$train$18(DenseMatrix denseCoefficientMatrix$1, double[] centers$1, int x0$2, int x1$2, double x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$2), (Object)BoxesRunTime.boxToDouble((double)x2$2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        denseCoefficientMatrix$1.update(i, j, v - centers$1[j]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Function1 regParamL1Fun$1(int numFeatures$2, int numCoefficientSets$2, boolean standardizationParam$1, double regParamL1$1, double[] featuresStd$2) {
        return (JFunction1.mcDI.sp & Serializable)index -> {
            int featureIndex;
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && index >= numFeatures$2 * numCoefficientSets$2;
            return isIntercept ? 0.0 : (standardizationParam$1 ? regParamL1$1 : (featuresStd$2[featureIndex = index / numCoefficientSets$2] != 0.0 ? regParamL1$1 / featuresStd$2[featureIndex] : 0.0));
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.optInitialModel = None$.MODULE$;
        Statics.releaseFence();
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

