/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ImageSchema$ {
    public static final ImageSchema$ MODULE$ = new ImageSchema$();
    private static final String undefinedImageType = "Undefined";
    private static final Map<String, Object> ocvTypes = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.undefinedImageType()), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8U"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC3"), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC4"), (Object)BoxesRunTime.boxToInteger((int)24))}));
    private static final java.util.Map<String, Object> javaOcvTypes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(MODULE$.ocvTypes()).asJava();
    private static final StructType columnSchema;
    private static final String[] imageFields;
    private static final StructType imageSchema;

    static {
        StructField structField = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("nChannels", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("mode", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("data", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        columnSchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        imageFields = MODULE$.columnSchema().fieldNames();
        StructField structField7 = new StructField("image", (DataType)MODULE$.columnSchema(), true, StructField$.MODULE$.apply$default$4());
        imageSchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField7));
    }

    public String undefinedImageType() {
        return undefinedImageType;
    }

    public Map<String, Object> ocvTypes() {
        return ocvTypes;
    }

    public java.util.Map<String, Object> javaOcvTypes() {
        return javaOcvTypes;
    }

    public StructType columnSchema() {
        return columnSchema;
    }

    public String[] imageFields() {
        return imageFields;
    }

    public StructType imageSchema() {
        return imageSchema;
    }

    public String getOrigin(Row row) {
        return row.getString(0);
    }

    public int getHeight(Row row) {
        return row.getInt(1);
    }

    public int getWidth(Row row) {
        return row.getInt(2);
    }

    public int getNChannels(Row row) {
        return row.getInt(3);
    }

    public int getMode(Row row) {
        return row.getInt(4);
    }

    public byte[] getData(Row row) {
        return (byte[])row.getAs(5);
    }

    public Row invalidImageRow(String origin) {
        return Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), this.ocvTypes().apply((Object)this.undefinedImageType()), Array$.MODULE$.ofDim(0, (ClassTag)ClassTag$.MODULE$.Byte())}))}));
    }

    public Option<Row> decode(String origin, byte[] bytes) {
        None$ none$;
        BufferedImage img;
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (RuntimeException runtimeException) {
            bufferedImage = img = null;
        }
        if (img == null) {
            none$ = None$.MODULE$;
        } else {
            Tuple2.mcII.sp sp2;
            boolean isGray = img.getColorModel().getColorSpace().getType() == 6;
            boolean hasAlpha = img.getColorModel().hasAlpha();
            int height = img.getHeight();
            int width = img.getWidth();
            Tuple2.mcII.sp sp3 = isGray ? new Tuple2.mcII.sp(1, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC1"))) : (sp2 = hasAlpha ? new Tuple2.mcII.sp(4, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC4"))) : new Tuple2.mcII.sp(3, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC3"))));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int nChannels = sp2._1$mcI$sp();
            int mode = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(nChannels, mode);
            Tuple2.mcII.sp sp5 = sp4;
            int nChannels2 = sp5._1$mcI$sp();
            int mode2 = sp5._2$mcI$sp();
            int imageSize = height * width * nChannels2;
            Predef$.MODULE$.assert((double)imageSize < 1.0E9, (Function0 & Serializable)() -> "image is too large");
            byte[] decoded = (byte[])Array$.MODULE$.ofDim(imageSize, (ClassTag)ClassTag$.MODULE$.Byte());
            if (isGray) {
                IntRef offset = IntRef.create((int)0);
                WritableRaster raster = img.getRaster();
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)h -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)w -> {
                    decoded$1[offset$1.elem] = (byte)raster.getSample(w, h, 0);
                    ++offset$1.elem;
                }));
            } else {
                IntRef offset = IntRef.create((int)0);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)h -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)w -> {
                    Color color = new Color(img.getRGB(w, h), hasAlpha);
                    decoded$1[offset$2.elem] = (byte)color.getBlue();
                    decoded$1[offset$2.elem + 1] = (byte)color.getGreen();
                    decoded$1[offset$2.elem + 2] = (byte)color.getRed();
                    if (hasAlpha) {
                        decoded$1[offset$2.elem + 3] = (byte)color.getAlpha();
                    }
                    offset$2.elem += nChannels2;
                }));
            }
            none$ = new Some((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nChannels2), BoxesRunTime.boxToInteger((int)mode2), decoded}))})));
        }
        return none$;
    }

    private ImageSchema$() {
    }
}

