/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class MetadataUtils$ {
    public static final MetadataUtils$ MODULE$ = new MetadataUtils$();

    public Option<Object> getNumClasses(StructField labelSchema) {
        None$ none$;
        Attribute attribute = Attribute$.MODULE$.fromStructField(labelSchema);
        if (attribute instanceof BinaryAttribute) {
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)2));
        } else if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.getNumValues();
        } else {
            boolean bl = attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute);
            if (bl) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)attribute);
            }
        }
        return none$;
    }

    public int getNumFeatures(Dataset<?> dataset, String vectorCol) {
        return BoxesRunTime.unboxToInt((Object)this.getNumFeatures(dataset.schema().apply(vectorCol)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> ((Vector)((Row)dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, vectorCol)})).head()).getAs(0)).size()));
    }

    public Option<Object> getNumFeatures(StructField vectorSchema) {
        AttributeGroup group;
        int size;
        DataType dataType = vectorSchema.dataType();
        VectorUDT vectorUDT = new VectorUDT();
        return !(dataType != null ? !dataType.equals((Object)vectorUDT) : vectorUDT != null) ? ((size = (group = AttributeGroup$.MODULE$.fromStructField(vectorSchema)).size()) >= 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)size)) : None$.MODULE$) : None$.MODULE$;
    }

    public Map<Object, Object> getCategoricalFeatures(StructField featuresSchema) {
        AttributeGroup metadata = AttributeGroup$.MODULE$.fromStructField(featuresSchema);
        return metadata.attributes().isEmpty() ? HashMap$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])metadata.attributes().get()))), (Function1 & Serializable)x0$1 -> {
            Iterator iterator;
            block6: {
                Tuple2 tuple2;
                block4: {
                    Iterator iterator2;
                    block8: {
                        Attribute attribute;
                        block10: {
                            int numValues;
                            int idx;
                            block12: {
                                Option<Object> option;
                                block11: {
                                    block9: {
                                        block7: {
                                            Attribute attr;
                                            block5: {
                                                tuple2 = x0$1;
                                                if (tuple2 == null) break block4;
                                                attr = (Attribute)tuple2._1();
                                                idx = tuple2._2$mcI$sp();
                                                if (attr != null) break block5;
                                                iterator = package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                                                break block6;
                                            }
                                            attribute = attr;
                                            boolean bl = attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute);
                                            if (!bl) break block7;
                                            iterator2 = package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                                            break block8;
                                        }
                                        if (!(attribute instanceof BinaryAttribute)) break block9;
                                        iterator2 = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                                        break block8;
                                    }
                                    if (!(attribute instanceof NominalAttribute)) break block10;
                                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                                    option = nominalAttribute.getNumValues();
                                    if (!(option instanceof Some)) break block11;
                                    Some some = (Some)option;
                                    numValues = BoxesRunTime.unboxToInt((Object)some.value());
                                    if (true) break block12;
                                }
                                if (None$.MODULE$.equals(option)) {
                                    throw new IllegalArgumentException(new StringBuilder(76).append(new StringBuilder(21).append("Feature ").append(idx).append(" is marked as").toString()).append(" Nominal (categorical), but it does not have the number of values specified.").toString());
                                }
                                throw new MatchError(option);
                            }
                            int n = numValues;
                            Iterator iterator3 = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)n))}));
                            iterator2 = iterator3;
                            break block8;
                        }
                        throw new MatchError((Object)attribute);
                    }
                    iterator = iterator2;
                    break block6;
                }
                throw new MatchError((Object)tuple2);
            }
            Iterator iterator4 = iterator;
            return iterator4;
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int[] getFeatureIndicesFromNames(StructField col, String[] names) {
        Predef$.MODULE$.require(col.dataType() instanceof VectorUDT, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(43).append("getFeatureIndicesFromNames expected column ").append(col).toString()).append(new StringBuilder(45).append(" to be Vector type, but it was type ").append(col.dataType()).append(" instead.").toString()).toString());
        AttributeGroup inputAttr = AttributeGroup$.MODULE$.fromStructField(col);
        return (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])names), (Function1 & Serializable)name -> BoxesRunTime.boxToInteger((int)MetadataUtils$.$anonfun$getFeatureIndicesFromNames$2(inputAttr, col, name)), (ClassTag)ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ int $anonfun$getFeatureIndicesFromNames$2(AttributeGroup inputAttr$1, StructField col$1, String name) {
        Predef$.MODULE$.require(inputAttr$1.hasAttr(name), (Function0 & Serializable)() -> new StringBuilder(66).append("getFeatureIndicesFromNames found no feature with name ").append(name).append(" in column ").append(col$1).append(".").toString());
        return BoxesRunTime.unboxToInt((Object)inputAttr$1.getAttr(name).index().get());
    }

    private MetadataUtils$() {
    }
}

