/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}fAB\r\u001b\u0003\u0003qB\u0005C\u00039\u0001\u0011\u0005\u0011\bC\u0003=\u0001\u0019\u0005Q\bC\u0003=\u0001\u0011\u00051\tC\u0003N\u0001\u0011\u0005a\nC\u0003^\u0001\u0019\u0005a\fC\u0003^\u0001\u0011\u0005!\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0003C\u0001\u0019\u0005A\u0010C\u0004\u0002\u0004\u00011\t!!\u0002\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u0013\u0002A\u0011AA&\u000f\u001d\t\tF\u0007E\u0001\u0003'2a!\u0007\u000e\t\u0002\u0005U\u0003B\u0002\u001d\u0011\t\u0003\t)\u0007C\u0005\u0002hA\u0011\r\u0011\"\u0001\u0002j!A\u0011\u0011\u0012\t!\u0002\u0013\tY\u0007C\u0005\u0002\u000eB\u0011\r\u0011\"\u0001\u0002j!A\u0011\u0011\u0013\t!\u0002\u0013\tY\u0007\u0003\u0005\u0002\u0016B!\tAHAL\u0011!\tY\u000b\u0005C\u0001=\u00055\u0006\"CAY!\u0005\u0005I\u0011BAZ\u0005=!\u0015n\u001d;b]\u000e,W*Z1tkJ,'BA\u000e\u001d\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003;y\tQ!\u001c7mS\nT!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-k9\u0011Qf\r\b\u0003]Ij\u0011a\f\u0006\u0003aE\na\u0001\u0010:p_Rt4\u0001A\u0005\u0002Q%\u0011AgJ\u0001\ba\u0006\u001c7.Y4f\u0013\t1tG\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00025O\u00051A(\u001b8jiz\"\u0012A\u000f\t\u0003w\u0001i\u0011AG\u0001\u0012G>l\u0007/\u001e;f'R\fG/[:uS\u000e\u001cHC\u0001 B!\t1s(\u0003\u0002AO\t1Ai\\;cY\u0016DQA\u0011\u0002A\u0002y\n\u0001\u0002Z5ti\u0006t7-\u001a\u000b\u0003\t\u001e\u00032AJ#?\u0013\t1uEA\u0003BeJ\f\u0017\u0010C\u0003I\u0007\u0001\u0007\u0011*A\u0004dK:$XM]:\u0011\u0007\u0019*%\n\u0005\u0002<\u0017&\u0011AJ\u0007\u0002\u000f-\u0016\u001cGo\u001c:XSRDgj\u001c:n\u0003y\u0019w.\u001c9vi\u0016\u001cF/\u0019;jgRL7m\u001d#jgR\u0014\u0018NY;uK\u0012d\u0017\u0010F\u0002E\u001fVCQ\u0001\u0015\u0003A\u0002E\u000b!a]2\u0011\u0005I\u001bV\"\u0001\u0010\n\u0005Qs\"\u0001D*qCJ\\7i\u001c8uKb$\b\"\u0002,\u0005\u0001\u00049\u0016!\u00032d\u0007\u0016tG/\u001a:t!\rA6,S\u0007\u00023*\u0011!LH\u0001\nEJ|\u0017\rZ2bgRL!\u0001X-\u0003\u0013\t\u0013x.\u00193dCN$\u0018a\u00034j]\u0012\u001cEn\\:fgR$BaX3gQB!a\u0005\u00192?\u0013\t\twE\u0001\u0004UkBdWM\r\t\u0003M\rL!\u0001Z\u0014\u0003\u0007%sG\u000fC\u0003I\u000b\u0001\u0007\u0011\nC\u0003h\u000b\u0001\u0007A)\u0001\u0006ti\u0006$\u0018n\u001d;jGNDQ![\u0003A\u0002)\u000bQ\u0001]8j]R$2aX6m\u0011\u0015Ae\u00011\u0001J\u0011\u0015Ig\u00011\u0001K\u0003%\u0001x.\u001b8u\u0007>\u001cH\u000fF\u0002?_BDQ\u0001S\u0004A\u0002%CQ![\u0004A\u0002)\u000b\u0011#[:DK:$XM]\"p]Z,'oZ3e)\u0011\u0019h\u000f\u001f>\u0011\u0005\u0019\"\u0018BA;(\u0005\u001d\u0011un\u001c7fC:DQa\u001e\u0005A\u0002)\u000b\u0011b\u001c7e\u0007\u0016tG/\u001a:\t\u000beD\u0001\u0019\u0001&\u0002\u00139,woQ3oi\u0016\u0014\b\"B>\t\u0001\u0004q\u0014aB3qg&dwN\u001c\u000b\u0004}u|\b\"\u0002@\n\u0001\u0004Q\u0015A\u0001<2\u0011\u0019\t\t!\u0003a\u0001\u0015\u0006\u0011aOM\u0001\fG2,8\u000f^3s\u0007>\u001cH\u000fF\u0005?\u0003\u000f\tY!a\u0004\u0002\u0014!1\u0011\u0011\u0002\u0006A\u0002)\u000b\u0001bY3oiJ|\u0017\u000e\u001a\u0005\u0007\u0003\u001bQ\u0001\u0019\u0001&\u0002\u0013A|\u0017N\u001c;t'Vl\u0007BBA\t\u0015\u0001\u0007a(A\u0005xK&<\u0007\u000e^*v[\"1\u0011Q\u0003\u0006A\u0002y\n\u0011\u0003]8j]R\u001c8+];be\u0016$gj\u001c:n\u0003A)\b\u000fZ1uK\u000ecWo\u001d;feN+X\u000e\u0006\u0004\u0002\u001c\u0005\u0005\u00121\u0005\t\u0004M\u0005u\u0011bAA\u0010O\t!QK\\5u\u0011\u0015I7\u00021\u0001K\u0011\u001d\t)c\u0003a\u0001\u0003O\t1a];n!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u00179\u00051A.\u001b8bY\u001eLA!!\r\u0002,\t1a+Z2u_J$RASA\u001b\u0003oAq!!\n\r\u0001\u0004\t9\u0003\u0003\u0004\u0002\u00121\u0001\rAP\u0001\u0013gflW.\u001a;sS\u000e\u001cUM\u001c;s_&$7\u000f\u0006\u0005\u0002>\u0005}\u00121IA$!\u00111\u0003M\u0013&\t\r\u0005\u0005S\u00021\u0001?\u0003\u0015aWM^3m\u0011\u001d\t)%\u0004a\u0001\u0003O\tQA\\8jg\u0016Dq!!\u0003\u000e\u0001\u0004\t9#\u0001\u0003d_N$H#\u0002 \u0002N\u0005=\u0003\"B5\u000f\u0001\u0004Q\u0005BBA\u0005\u001d\u0001\u0007!*A\bESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f!\tY\u0004c\u0005\u0003\u0011K\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0003S>T!!!\u0019\u0002\t)\fg/Y\u0005\u0004m\u0005mCCAA*\u0003%)Uk\u0011'J\t\u0016\u000be*\u0006\u0002\u0002lA!\u0011QNA:\u001b\t\tyG\u0003\u0003\u0002r\u0005}\u0013\u0001\u00027b]\u001eLA!!\u001e\u0002p\t11\u000b\u001e:j]\u001eDSAEA=\u0003\u000b\u0003B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fr\u0012AC1o]>$\u0018\r^5p]&!\u00111QA?\u0005\u0015\u0019\u0016N\\2fC\t\t9)A\u00033]Qr\u0003'\u0001\u0006F+\u000ec\u0015\nR#B\u001d\u0002BSaEA=\u0003\u000b\u000baaQ(T\u0013:+\u0005&\u0002\u000b\u0002z\u0005\u0015\u0015aB\"P'&sU\t\t\u0015\u0006+\u0005e\u0014QQ\u0001\u0011I\u0016\u001cw\u000eZ3Ge>l7\u000b\u001e:j]\u001e$2AOAM\u0011\u001d\tYJ\u0006a\u0001\u0003;\u000bq\u0002Z5ti\u0006t7-Z'fCN,(/\u001a\t\u0005\u0003?\u000b9K\u0004\u0003\u0002\"\u0006\r\u0006C\u0001\u0018(\u0013\r\t)kJ\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0014\u0011\u0016\u0006\u0004\u0003K;\u0013a\u0006<bY&$\u0017\r^3ESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f)\r\u0019\u0018q\u0016\u0005\b\u00037;\u0002\u0019AAO\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t)\f\u0005\u0003\u0002n\u0005]\u0016\u0002BA]\u0003_\u0012aa\u00142kK\u000e$\b&\u0002\t\u0002z\u0005\u0015\u0005&B\b\u0002z\u0005\u0015\u0005")
public abstract class DistanceMeasure
implements Serializable {
    public static String COSINE() {
        return DistanceMeasure$.MODULE$.COSINE();
    }

    public static String EUCLIDEAN() {
        return DistanceMeasure$.MODULE$.EUCLIDEAN();
    }

    public abstract double computeStatistics(double var1);

    /*
     * WARNING - void declaration
     */
    public double[] computeStatistics(VectorWithNorm[] centers) {
        void var3_3;
        int i;
        int k = centers.length;
        if (k == 1) {
            return new double[]{Double.NaN};
        }
        double[] packedValues = (double[])Array$.MODULE$.ofDim(k * (k + 1) / 2, (ClassTag)ClassTag$.MODULE$.Double());
        double[] diagValues = (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.POSITIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
        for (i = 0; i < k; ++i) {
            for (int j = i + 1; j < k; ++j) {
                double d = this.distance(centers[i], centers[j]);
                double s = this.computeStatistics(d);
                int index = Utils$.MODULE$.indexUpperTriangular(k, i, j);
                packedValues[index] = s;
                if (s < diagValues[i]) {
                    diagValues[i] = s;
                }
                if (!(s < diagValues[j])) continue;
                diagValues[j] = s;
            }
        }
        for (i = 0; i < k; ++i) {
            int index = Utils$.MODULE$.indexUpperTriangular(k, i, i);
            packedValues[index] = diagValues[i];
        }
        return var3_3;
    }

    public double[] computeStatisticsDistributedly(SparkContext sc, Broadcast<VectorWithNorm[]> bcCenters) {
        int k = ((VectorWithNorm[])bcCenters.value()).length;
        if (k == 1) {
            return new double[]{Double.NaN};
        }
        double[] packedValues = (double[])Array$.MODULE$.ofDim(k * (k + 1) / 2, (ClassTag)ClassTag$.MODULE$.Double());
        double[] diagValues = (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.POSITIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
        int numParts = package$.MODULE$.min(k, 1024);
        RDD qual$1 = sc.range(0L, (long)numParts, 1L, numParts);
        Function2 & Serializable x$1 = (Function2 & Serializable)(x0$1, x1$1) -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$2(this, bcCenters, k, numParts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class)).collect()), (Function1 & Serializable)x0$2 -> {
            DistanceMeasure.$anonfun$computeStatisticsDistributedly$5(k, packedValues, diagValues, x0$2);
            return BoxedUnit.UNIT;
        });
        for (int i = 0; i < k; ++i) {
            int index = Utils$.MODULE$.indexUpperTriangular(k, i, i);
            packedValues[index] = diagValues[i];
        }
        return packedValues;
    }

    public abstract Tuple2<Object, Object> findClosest(VectorWithNorm[] var1, double[] var2, VectorWithNorm var3);

    public Tuple2<Object, Object> findClosest(VectorWithNorm[] centers, VectorWithNorm point) {
        double bestDistance = Double.POSITIVE_INFINITY;
        int bestIndex = 0;
        for (int i = 0; i < centers.length; ++i) {
            VectorWithNorm center = centers[i];
            double currentDistance = this.distance(center, point);
            if (!(currentDistance < bestDistance)) continue;
            bestDistance = currentDistance;
            bestIndex = i;
        }
        return new Tuple2.mcID.sp(bestIndex, bestDistance);
    }

    public double pointCost(VectorWithNorm[] centers, VectorWithNorm point) {
        return this.findClosest(centers, point)._2$mcD$sp();
    }

    public boolean isCenterConverged(VectorWithNorm oldCenter, VectorWithNorm newCenter, double epsilon) {
        return this.distance(oldCenter, newCenter) <= epsilon;
    }

    public abstract double distance(VectorWithNorm var1, VectorWithNorm var2);

    public abstract double clusterCost(VectorWithNorm var1, VectorWithNorm var2, double var3, double var5);

    public void updateClusterSum(VectorWithNorm point, Vector sum) {
        BLAS$.MODULE$.axpy(point.weight(), point.vector(), sum);
    }

    public VectorWithNorm centroid(Vector sum, double weightSum) {
        BLAS$.MODULE$.scal(1.0 / weightSum, sum);
        return new VectorWithNorm(sum);
    }

    public Tuple2<VectorWithNorm, VectorWithNorm> symmetricCentroids(double level, Vector noise, Vector centroid) {
        Vector left = centroid.copy();
        BLAS$.MODULE$.axpy(-level, noise, left);
        Vector right = centroid.copy();
        BLAS$.MODULE$.axpy(level, noise, right);
        return new Tuple2((Object)new VectorWithNorm(left), (Object)new VectorWithNorm(right));
    }

    public double cost(VectorWithNorm point, VectorWithNorm centroid) {
        return this.distance(point, centroid);
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$4(DistanceMeasure $this, int i$1, int numParts$1, int pid$1, VectorWithNorm[] centers$1, int j) {
        Iterator iterator;
        int hash = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(new Tuple2.mcII.sp(i$1, j).hashCode()));
        if (hash % numParts$1 == pid$1) {
            double d = $this.distance(centers$1[i$1], centers$1[j]);
            double s = $this.computeStatistics(d);
            iterator = scala.package$.MODULE$.Iterator().single((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i$1), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)s)));
        } else {
            iterator = scala.package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$3(DistanceMeasure $this, int k$1, int numParts$1, int pid$1, VectorWithNorm[] centers$1, int i) {
        return scala.package$.MODULE$.Iterator().range(i + 1, k$1).flatMap((Function1 & Serializable)j -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$4($this, i, numParts$1, pid$1, centers$1, BoxesRunTime.unboxToInt((Object)j)));
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$2(DistanceMeasure $this, Broadcast bcCenters$1, int k$1, int numParts$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int pid = tuple2._1$mcI$sp();
        VectorWithNorm[] centers = (VectorWithNorm[])bcCenters$1.value();
        Iterator iterator = scala.package$.MODULE$.Iterator().range(0, k$1).flatMap((Function1 & Serializable)i -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$3($this, k$1, numParts$1, pid, centers, BoxesRunTime.unboxToInt((Object)i)));
        return iterator;
    }

    public static final /* synthetic */ void $anonfun$computeStatisticsDistributedly$5(int k$1, double[] packedValues$1, double[] diagValues$1, Tuple3 x0$2) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            int index = Utils$.MODULE$.indexUpperTriangular(k$1, i, j);
            packedValues$1[index] = s;
            if (s < diagValues$1[i]) {
                diagValues$1[i] = s;
            }
            if (s < diagValues$1[j]) {
                diagValues$1[j] = s;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }
}

