/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dh\u0001\u0002\u001f>\u0001!C\u0001\"\u0019\u0001\u0003\u0002\u0004%IA\u0019\u0005\tM\u0002\u0011\t\u0019!C\u0005O\"AQ\u000e\u0001B\u0001B\u0003&1\r\u0003\u0005o\u0001\t\u0005\r\u0011\"\u0003c\u0011!y\u0007A!a\u0001\n\u0013\u0001\b\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0015B2\t\u0011M\u0004!\u00111A\u0005\nQD\u0001\" \u0001\u0003\u0002\u0004%IA \u0005\n\u0003\u0003\u0001!\u0011!Q!\nUD\u0011\"a\u0001\u0001\u0005\u0003\u0007I\u0011\u00022\t\u0015\u0005\u0015\u0001A!a\u0001\n\u0013\t9\u0001C\u0005\u0002\f\u0001\u0011\t\u0011)Q\u0005G\"Q\u0011Q\u0002\u0001\u0003\u0002\u0004%I!a\u0004\t\u0015\u0005]\u0001A!a\u0001\n\u0013\tI\u0002\u0003\u0006\u0002\u001e\u0001\u0011\t\u0011)Q\u0005\u0003#A!\"a\b\u0001\u0005\u0003\u0007I\u0011BA\u0011\u0011)\tI\u0003\u0001BA\u0002\u0013%\u00111\u0006\u0005\u000b\u0003_\u0001!\u0011!Q!\n\u0005\r\u0002\"CA\u0019\u0001\t\u0005\r\u0011\"\u0003u\u0011)\t\u0019\u0004\u0001BA\u0002\u0013%\u0011Q\u0007\u0005\n\u0003s\u0001!\u0011!Q!\nUDq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002<\u0001!I!!\u0015\t\u000f\u0005m\u0002\u0001\"\u0001\u0002r!1\u0011Q\u000f\u0001\u0005\u0002\tDq!! \u0001\t\u0003\ty\b\u0003\u0004\u0002\b\u0002!\tA\u0019\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u0019\t\u0019\n\u0001C\u0001i\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005BBAP\u0001\u0011\u0005!\rC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005-\u0006\u0001\"\u0001\u0002\u0010!9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003w\u0003A\u0011AA_\u0011\u0019\t\u0019\r\u0001C\u0001i\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007\"CAj\u0001\u0001\u0007I\u0011BAk\u0011%\t\u0019\u000f\u0001a\u0001\n\u0013\t)\u000f\u0003\u0005\u0002j\u0002\u0001\u000b\u0015BAl\u0011\u001d\tY\u000f\u0001C\u0001\u0003[Dq!!>\u0001\t\u0003\t9\u0010\u0003\u0005\u0003\u0018\u0001!\t!\u0011B\r\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013BqAa\u0016\u0001\t\u0013\u0011I\u0006\u0003\u0005\u0003d\u0001!\t!\u0010B3\u000f\u001d\u0011)(\u0010E\u0001\u0005o2a\u0001P\u001f\t\u0002\te\u0004bBA\u001ec\u0011\u0005!\u0011\u0012\u0005\n\u0005\u0017\u000b$\u0019!C\u0001\u0005\u001bC\u0001Ba'2A\u0003%!q\u0012\u0005\n\u0005?\u000b$\u0019!C\u0001\u0005\u001bC\u0001Ba)2A\u0003%!q\u0012\u0005\b\u0005O\u000bD\u0011\u0001BU\u0011\u001d\u00119+\rC\u0001\u0005wCqAa*2\t\u0003\u00119\r\u0003\u0005\u0003RF\"\t!\u0011Bj\u0011%\u0011I.MA\u0001\n\u0013\u0011YN\u0001\u0004L\u001b\u0016\fgn\u001d\u0006\u0003}}\n!b\u00197vgR,'/\u001b8h\u0015\t\u0001\u0015)A\u0003nY2L'M\u0003\u0002C\u0007\u0006)1\u000f]1sW*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A%P7B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\u0004\"\u0001\u0015-\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+H\u0003\u0019a$o\\8u}%\tA*\u0003\u0002X\u0017\u00069\u0001/Y2lC\u001e,\u0017BA-[\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t96\n\u0005\u0002]?6\tQL\u0003\u0002_\u0003\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002a;\n9Aj\\4hS:<\u0017!A6\u0016\u0003\r\u0004\"A\u00133\n\u0005\u0015\\%aA%oi\u0006)1n\u0018\u0013fcR\u0011\u0001n\u001b\t\u0003\u0015&L!A[&\u0003\tUs\u0017\u000e\u001e\u0005\bY\n\t\t\u00111\u0001d\u0003\rAH%M\u0001\u0003W\u0002\nQ\"\\1y\u0013R,'/\u0019;j_:\u001c\u0018!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u0011\u0001.\u001d\u0005\bY\u0016\t\t\u00111\u0001d\u00039i\u0017\r_%uKJ\fG/[8og\u0002\n!#\u001b8ji&\fG.\u001b>bi&|g.T8eKV\tQ\u000f\u0005\u0002wu:\u0011q\u000f\u001f\t\u0003%.K!!_&\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003s.\u000ba#\u001b8ji&\fG.\u001b>bi&|g.T8eK~#S-\u001d\u000b\u0003Q~Dq\u0001\u001c\u0005\u0002\u0002\u0003\u0007Q/A\nj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,\u0007%A\nj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048/A\fj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048o\u0018\u0013fcR\u0019\u0001.!\u0003\t\u000f1\\\u0011\u0011!a\u0001G\u0006!\u0012N\\5uS\u0006d\u0017N_1uS>t7\u000b^3qg\u0002\nq!\u001a9tS2|g.\u0006\u0002\u0002\u0012A\u0019!*a\u0005\n\u0007\u0005U1J\u0001\u0004E_V\u0014G.Z\u0001\fKB\u001c\u0018\u000e\\8o?\u0012*\u0017\u000fF\u0002i\u00037A\u0001\u0002\u001c\b\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\tKB\u001c\u0018\u000e\\8oA\u0005!1/Z3e+\t\t\u0019\u0003E\u0002K\u0003KI1!a\nL\u0005\u0011auN\\4\u0002\u0011M,W\rZ0%KF$2\u0001[A\u0017\u0011!a\u0017#!AA\u0002\u0005\r\u0012!B:fK\u0012\u0004\u0013a\u00043jgR\fgnY3NK\u0006\u001cXO]3\u0002'\u0011L7\u000f^1oG\u0016lU-Y:ve\u0016|F%Z9\u0015\u0007!\f9\u0004C\u0004m)\u0005\u0005\t\u0019A;\u0002!\u0011L7\u000f^1oG\u0016lU-Y:ve\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\t\u0002@\u0005\r\u0013QIA$\u0003\u0013\nY%!\u0014\u0002PA\u0019\u0011\u0011\t\u0001\u000e\u0003uBQ!\u0019\fA\u0002\rDQA\u001c\fA\u0002\rDQa\u001d\fA\u0002UDa!a\u0001\u0017\u0001\u0004\u0019\u0007bBA\u0007-\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003?1\u0002\u0019AA\u0012\u0011\u0019\t\tD\u0006a\u0001kRq\u0011qHA*\u0003+\n9&!\u0017\u0002\\\u0005u\u0003\"B1\u0018\u0001\u0004\u0019\u0007\"\u00028\u0018\u0001\u0004\u0019\u0007\"B:\u0018\u0001\u0004)\bBBA\u0002/\u0001\u00071\rC\u0004\u0002\u000e]\u0001\r!!\u0005\t\u000f\u0005}q\u00031\u0001\u0002$!*q#!\u0019\u0002nA!\u00111MA5\u001b\t\t)GC\u0002\u0002h\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY'!\u001a\u0003\u000bMKgnY3\"\u0005\u0005=\u0014!\u0002\u0019/q9\u0002DCAA Q\u0015A\u0012\u0011MA7\u0003\u00119W\r^&)\u000be\t\t'!\u001f\"\u0005\u0005m\u0014!B\u0019/i9\u0002\u0014\u0001B:fi.#B!!!\u0002\u00046\t\u0001\u0001C\u0003b5\u0001\u00071\rK\u0003\u001b\u0003C\ni'\u0001\thKRl\u0015\r_%uKJ\fG/[8og\"*1$!\u0019\u0002z\u0005\u00012/\u001a;NCbLE/\u001a:bi&|gn\u001d\u000b\u0005\u0003\u0003\u000by\tC\u0003o9\u0001\u00071\rK\u0003\u001d\u0003C\ni'A\u000bhKRLe.\u001b;jC2L'0\u0019;j_:lu\u000eZ3)\u000bu\t\t'!\u001f\u0002+M,G/\u00138ji&\fG.\u001b>bi&|g.T8eKR!\u0011\u0011QAN\u0011\u0015\u0019h\u00041\u0001vQ\u0015q\u0012\u0011MA7\u0003Y9W\r^%oSRL\u0017\r\\5{CRLwN\\*uKB\u001c\b&B\u0010\u0002b\u0005e\u0014AF:fi&s\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:\u0015\t\u0005\u0005\u0015q\u0015\u0005\u0007\u0003\u0007\u0001\u0003\u0019A2)\u000b\u0001\n\t'!\u001c\u0002\u0015\u001d,G/\u00129tS2|g\u000eK\u0003\"\u0003C\nI(\u0001\u0006tKR,\u0005o]5m_:$B!!!\u00024\"9\u0011Q\u0002\u0012A\u0002\u0005E\u0001&\u0002\u0012\u0002b\u00055\u0014aB4fiN+W\r\u001a\u0015\u0006G\u0005\u0005\u0014\u0011P\u0001\bg\u0016$8+Z3e)\u0011\t\t)a0\t\u000f\u0005}A\u00051\u0001\u0002$!*A%!\u0019\u0002z\u0005\u0011r-\u001a;ESN$\u0018M\\2f\u001b\u0016\f7/\u001e:fQ\u0015)\u0013\u0011MAdC\t\tI-A\u00033]Qr\u0003'\u0001\ntKR$\u0015n\u001d;b]\u000e,W*Z1tkJ,G\u0003BAA\u0003\u001fDa!!\r'\u0001\u0004)\b&\u0002\u0014\u0002b\u0005\u001d\u0017\u0001D5oSRL\u0017\r\\'pI\u0016dWCAAl!\u0015Q\u0015\u0011\\Ao\u0013\r\tYn\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0005\u0013q\\\u0005\u0004\u0003Cl$aC&NK\u0006t7/T8eK2\f\u0001#\u001b8ji&\fG.T8eK2|F%Z9\u0015\u0007!\f9\u000f\u0003\u0005mQ\u0005\u0005\t\u0019AAl\u00035Ig.\u001b;jC2lu\u000eZ3mA\u0005y1/\u001a;J]&$\u0018.\u00197N_\u0012,G\u000e\u0006\u0003\u0002\u0002\u0006=\bbBAyU\u0001\u0007\u0011Q\\\u0001\u0006[>$W\r\u001c\u0015\u0006U\u0005\u0005\u0014\u0011P\u0001\u0004eVtG\u0003BAo\u0003sDq!a?,\u0001\u0004\ti0\u0001\u0003eCR\f\u0007CBA\u0000\u0005\u000b\u0011I!\u0004\u0002\u0003\u0002)\u0019!1A!\u0002\u0007I$G-\u0003\u0003\u0003\b\t\u0005!a\u0001*E\tB!!1\u0002B\t\u001b\t\u0011iAC\u0002\u0003\u0010}\na\u0001\\5oC2<\u0017\u0002\u0002B\n\u0005\u001b\u0011aAV3di>\u0014\b&B\u0016\u0002b\u00055\u0014!\u0004:v]^KG\u000f[,fS\u001eDG\u000f\u0006\u0005\u0002^\nm!q\u0005B\u0019\u0011\u001d\u0011i\u0002\fa\u0001\u0005?\t\u0011\"\u001b8ti\u0006t7-Z:\u0011\r\u0005}(Q\u0001B\u0011!\u001dQ%1\u0005B\u0005\u0003#I1A!\nL\u0005\u0019!V\u000f\u001d7fe!9!\u0011\u0006\u0017A\u0002\t-\u0012!\u00055b]\u0012dW\rU3sg&\u001cH/\u001a8dKB\u0019!J!\f\n\u0007\t=2JA\u0004C_>dW-\u00198\t\u000f\tMB\u00061\u0001\u00036\u0005)\u0011N\\:ueB)!*!7\u00038A!!\u0011\bB\"\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012\u0001B;uS2T1A!\u0011B\u0003\tiG.\u0003\u0003\u0003F\tm\"aD%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u0002-I,h.\u00117h_JLG\u000f[7XSRDw+Z5hQR$b!!8\u0003L\tU\u0003bBA~[\u0001\u0007!Q\n\t\u0007\u0003\u007f\u0014)Aa\u0014\u0011\t\u0005\u0005#\u0011K\u0005\u0004\u0005'j$A\u0004,fGR|'oV5uQ:{'/\u001c\u0005\b\u0005gi\u0003\u0019\u0001B\u001b\u0003)Ig.\u001b;SC:$w.\u001c\u000b\u0005\u00057\u0012\t\u0007E\u0003K\u0005;\u0012y%C\u0002\u0003`-\u0013Q!\u0011:sCfDq!a?/\u0001\u0004\u0011i%\u0001\nj]&$8*T3b]N\u0004\u0016M]1mY\u0016dGC\u0002B.\u0005O\u0012I\u0007C\u0004\u0002|>\u0002\rA!\u0014\t\u000f\t-t\u00061\u0001\u0003n\u00059B-[:uC:\u001cW-T3bgV\u0014X-\u00138ti\u0006t7-\u001a\t\u0005\u0003\u0003\u0012y'C\u0002\u0003ru\u0012q\u0002R5ti\u0006t7-Z'fCN,(/\u001a\u0015\u0006\u0001\u0005\u0005\u0014QN\u0001\u0007\u00176+\u0017M\\:\u0011\u0007\u0005\u0005\u0013g\u0005\u00032\u0013\nm\u0004\u0003\u0002B?\u0005\u000fk!Aa \u000b\t\t\u0005%1Q\u0001\u0003S>T!A!\"\u0002\t)\fg/Y\u0005\u00043\n}DC\u0001B<\u0003\u0019\u0011\u0016I\u0014#P\u001bV\u0011!q\u0012\t\u0005\u0005#\u00139*\u0004\u0002\u0003\u0014*!!Q\u0013BB\u0003\u0011a\u0017M\\4\n\u0007m\u0014\u0019\nK\u00034\u0003C\ni'A\u0004S\u0003:#u*\u0014\u0011)\u000bQ\n\t'!\u001c\u0002!-{V*R!O'~\u0003\u0016IU!M\u0019\u0016c\u0005&B\u001b\u0002b\u00055\u0014!E&`\u001b\u0016\u000bejU0Q\u0003J\u000bE\nT#MA!*a'!\u0019\u0002n\u0005)AO]1j]Ra\u0011Q\u001cBV\u0005[\u0013yK!-\u00034\"9\u00111`\u001cA\u0002\u0005u\b\"B18\u0001\u0004\u0019\u0007\"\u000288\u0001\u0004\u0019\u0007\"B:8\u0001\u0004)\bbBA\u0010o\u0001\u0007\u00111\u0005\u0015\u0006o\u0005\u0005$qW\u0011\u0003\u0005s\u000bQA\r\u00182]A\"\"\"!8\u0003>\n}&\u0011\u0019Bb\u0011\u001d\tY\u0010\u000fa\u0001\u0003{DQ!\u0019\u001dA\u0002\rDQA\u001c\u001dA\u0002\rDQa\u001d\u001dA\u0002UDS\u0001OA1\u0005o#\u0002\"!8\u0003J\n-'Q\u001a\u0005\b\u0003wL\u0004\u0019AA\u007f\u0011\u0015\t\u0017\b1\u0001d\u0011\u0015q\u0017\b1\u0001dQ\u0015I\u0014\u0011MA7\u0003A1\u0018\r\\5eCR,\u0017J\\5u\u001b>$W\r\u0006\u0003\u0003,\tU\u0007B\u0002Blu\u0001\u0007Q/\u0001\u0005j]&$Xj\u001c3f\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011i\u000e\u0005\u0003\u0003\u0012\n}\u0017\u0002\u0002Bq\u0005'\u0013aa\u00142kK\u000e$\b&B\u0019\u0002b\u00055\u0004&\u0002\u0019\u0002b\u00055\u0004")
public class KMeans
implements Serializable,
Logging {
    private int k;
    private int maxIterations;
    private String initializationMode;
    private int initializationSteps;
    private double epsilon;
    private long seed;
    private String distanceMeasure;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initializationMode() {
        return this.initializationMode;
    }

    private void initializationMode_$eq(String x$1) {
        this.initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    private double epsilon() {
        return this.epsilon;
    }

    private void epsilon_$eq(double x$1) {
        this.epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public int getK() {
        return this.k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.initializationMode_$eq(initializationMode);
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0 & Serializable)() -> new StringBuilder(56).append("Number of initialization steps must be positive but got ").append(initializationSteps).toString());
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0 & Serializable)() -> new StringBuilder(47).append("Distance threshold must be nonnegative but got ").append(epsilon).toString());
        this.epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public KMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.k(), (Function0 & Serializable)() -> "mismatched cluster count");
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        RDD instances = data.map((Function1 & Serializable)point -> new Tuple2(point, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class));
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.runWithWeight((RDD<Tuple2<Vector, Object>>)instances, handlePersistence, (Option<Instrumentation>)None$.MODULE$);
    }

    public KMeansModel runWithWeight(RDD<Tuple2<Vector, Object>> instances, boolean handlePersistence, Option<Instrumentation> instr) {
        RDD norms = instances.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$runWithWeight$1(x0$1)), (ClassTag)ClassTag$.MODULE$.Double());
        RDD vectors = instances.zip(norms, (ClassTag)ClassTag$.MODULE$.Double()).map((Function1 & Serializable)x0$2 -> {
            double norm;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    norm = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Vector v = (Vector)tuple2._1();
            double w = tuple2._2$mcD$sp();
            VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm, w);
            return vectorWithNorm;
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        RDD rDD = handlePersistence ? vectors.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : norms.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        KMeansModel model = this.runAlgorithmWithWeight((RDD<VectorWithNorm>)vectors, instr);
        RDD rDD2 = handlePersistence ? vectors.unpersist(vectors.unpersist$default$1()) : norms.unpersist(norms.unpersist$default$1());
        return model;
    }

    private KMeansModel runAlgorithmWithWeight(RDD<VectorWithNorm> data, Option<Instrumentation> instr) {
        boolean shouldDistributed;
        VectorWithNorm[] vectorWithNormArray;
        SparkContext sc = data.sparkContext();
        long initStartTime = System.nanoTime();
        DistanceMeasure distanceMeasureInstance = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        Option<KMeansModel> option = this.initialModel();
        if (option instanceof Some) {
            Some some = (Some)option;
            KMeansModel kMeansCenters = (KMeansModel)some.value();
            vectorWithNormArray = (VectorWithNorm[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters()), (Function1 & Serializable)x$1 -> new VectorWithNorm((Vector)x$1), ClassTag$.MODULE$.apply(VectorWithNorm.class));
        } else if (None$.MODULE$.equals(option)) {
            String string = this.initializationMode();
            String string2 = KMeans$.MODULE$.RANDOM();
            vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data, distanceMeasureInstance);
        } else {
            throw new MatchError(option);
        }
        VectorWithNorm[] centers = vectorWithNormArray;
        int numFeatures = ((VectorWithNorm)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])centers))).vector().size();
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> {
            String arg$macro$1 = this.initializationMode();
            double arg$macro$2 = initTimeInSeconds;
            return StringOps$.MODULE$.format$extension("Initialization with %s took %.3f seconds.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        });
        BooleanRef converged = BooleanRef.create((boolean)false);
        DoubleRef cost = DoubleRef.create((double)0.0);
        IntRef iteration = IntRef.create((int)0);
        long iterationStartTime = System.nanoTime();
        instr.foreach((Function1 & Serializable)x$2 -> {
            x$2.logNumFeatures(numFeatures);
            return BoxedUnit.UNIT;
        });
        boolean bl = shouldDistributed = (long)(centers.length * centers.length) * (long)numFeatures > 1000000L;
        while (iteration.elem < this.maxIterations() && !converged.elem) {
            Broadcast bcCenters = sc.broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            double[] stats = shouldDistributed ? distanceMeasureInstance.computeStatisticsDistributedly(sc, (Broadcast<VectorWithNorm[]>)bcCenters) : distanceMeasureInstance.computeStatistics(centers);
            Broadcast bcStats = sc.broadcast((Object)stats, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            DoubleAccumulator costAccum = sc.doubleAccumulator();
            Map collected = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1 & Serializable)points -> {
                VectorWithNorm[] centers = (VectorWithNorm[])bcCenters.value();
                double[] stats = (double[])bcStats.value();
                int dims = ((VectorWithNorm)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])centers))).vector().size();
                Vector[] sums = (Vector[])Array$.MODULE$.fill(centers.length, (Function0 & Serializable)() -> Vectors$.MODULE$.zeros(dims), ClassTag$.MODULE$.apply(Vector.class));
                double[] clusterWeightSum = (double[])Array$.MODULE$.ofDim(centers.length, (ClassTag)ClassTag$.MODULE$.Double());
                points.foreach((Function1 & Serializable)point -> {
                    KMeans.$anonfun$runAlgorithmWithWeight$6(distanceMeasureInstance, centers, stats, costAccum, sums, clusterWeightSum, point);
                    return BoxedUnit.UNIT;
                });
                return package$.MODULE$.Iterator().tabulate(centers.length, (Function1 & Serializable)j -> KMeans.$anonfun$runAlgorithmWithWeight$7(sums, clusterWeightSum, BoxesRunTime.unboxToInt((Object)j))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$runAlgorithmWithWeight$8(x$4)));
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable)(sumweight1, sumweight2) -> {
                BLAS$.MODULE$.axpy(1.0, (Vector)sumweight2._1(), (Vector)sumweight1._1());
                return new Tuple2(sumweight1._1(), (Object)BoxesRunTime.boxToDouble((double)(sumweight1._2$mcD$sp() + sumweight2._2$mcD$sp())));
            }), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            if (iteration.elem == 0) {
                instr.foreach((Function1 & Serializable)x$5 -> {
                    x$5.logNumExamples(costAccum.count());
                    return BoxedUnit.UNIT;
                });
                instr.foreach((Function1 & Serializable)x$6 -> {
                    x$6.logSumOfWeights(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)collected.values().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)x$7._2$mcD$sp()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                    return BoxedUnit.UNIT;
                });
            }
            bcCenters.destroy();
            bcStats.destroy();
            converged.elem = true;
            collected.foreach((Function1 & Serializable)x0$1 -> {
                KMeans.$anonfun$runAlgorithmWithWeight$13(this, distanceMeasureInstance, converged, centers, x0$1);
                return BoxedUnit.UNIT;
            });
            cost.elem = Predef$.MODULE$.Double2double(costAccum.value());
            instr.foreach((Function1 & Serializable)x$8 -> {
                x$8.logNamedValue(new StringBuilder(10).append("Cost@iter=").append(iteration.elem).toString(), String.valueOf(BoxesRunTime.boxToDouble((double)cost.elem)));
                return BoxedUnit.UNIT;
            });
            ++iteration.elem;
        }
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> {
            double arg$macro$3 = iterationTimeInSeconds;
            return StringOps$.MODULE$.format$extension("Iterations took %.3f seconds.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
        });
        if (iteration.elem == this.maxIterations()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("KMeans reached the max number of iterations: ").append(this.maxIterations()).append(".").toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("KMeans converged in ").append(iteration$1.elem).append(" iterations.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("The cost is ").append(cost$1.elem).append(".").toString());
        return new KMeansModel((Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])centers), (Function1 & Serializable)x$9 -> x$9.vector(), ClassTag$.MODULE$.apply(Vector.class)), this.distanceMeasure(), cost.elem, iteration.elem);
    }

    private VectorWithNorm[] initRandom(RDD<VectorWithNorm> data) {
        return (VectorWithNorm[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])data.takeSample(false, this.k(), (long)new XORShiftRandom(this.seed()).nextInt())), (Function1 & Serializable)x$10 -> x$10.vector(), ClassTag$.MODULE$.apply(Vector.class))))), (Function1 & Serializable)x$11 -> new VectorWithNorm((Vector)x$11), ClassTag$.MODULE$.apply(VectorWithNorm.class));
    }

    public VectorWithNorm[] initKMeansParallel(RDD<VectorWithNorm> data, DistanceMeasure distanceMeasureInstance) {
        VectorWithNorm[] vectorWithNormArray;
        RDD costs = data.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$1(x$12)), (ClassTag)ClassTag$.MODULE$.Double());
        int seed = new XORShiftRandom(this.seed()).nextInt();
        VectorWithNorm[] sample = (VectorWithNorm[])data.takeSample(false, 1, (long)seed);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])sample)), (Function0 & Serializable)() -> new StringBuilder(26).append("No samples available from ").append(data).toString());
        ArrayBuffer centers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        VectorWithNorm[] newCenters = (VectorWithNorm[])((Object[])new VectorWithNorm[]{((VectorWithNorm)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])sample))).toDense()});
        centers.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newCenters));
        IntRef step = IntRef.create((int)0);
        ArrayBuffer bcNewCentersList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            bcNewCentersList.$plus$eq((Object)bcNewCenters);
            RDD preCosts = costs;
            costs = data.zip(preCosts, (ClassTag)ClassTag$.MODULE$.Double()).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$3(distanceMeasureInstance, bcNewCenters, x0$1)), (ClassTag)ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double sumCosts = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(costs).sum();
            bcNewCenters.unpersist();
            preCosts.unpersist(preCosts.unpersist$default$1());
            RDD qual$1 = data.zip(costs, (ClassTag)ClassTag$.MODULE$.Double());
            Function2 & Serializable x$1 = (Function2 & Serializable)(index, pointCosts) -> KMeans.$anonfun$initKMeansParallel$4(this, seed, step, sumCosts, BoxesRunTime.unboxToInt((Object)index), pointCosts);
            boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
            VectorWithNorm[] chosen = (VectorWithNorm[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(VectorWithNorm.class)).collect();
            newCenters = (VectorWithNorm[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])chosen), (Function1 & Serializable)x$14 -> x$14.toDense(), ClassTag$.MODULE$.apply(VectorWithNorm.class));
            centers.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newCenters));
            ++step.elem;
        }
        RDD qual$2 = costs;
        boolean x$3 = qual$2.unpersist$default$1();
        qual$2.unpersist(x$3);
        bcNewCentersList.foreach((Function1 & Serializable)x$15 -> {
            x$15.destroy();
            return BoxedUnit.UNIT;
        });
        VectorWithNorm[] distinctCenters = (VectorWithNorm[])((IterableOnceOps)((StrictOptimizedIterableOps)((SeqOps)centers.map((Function1 & Serializable)x$16 -> x$16.vector())).distinct()).map((Function1 & Serializable)x$17 -> new VectorWithNorm((Vector)x$17))).toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
        if (distinctCenters.length <= this.k()) {
            vectorWithNormArray = distinctCenters;
        } else {
            Broadcast bcCenters = data.context().broadcast((Object)distinctCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            Map countMap = data.map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)KMeans.$anonfun$initKMeansParallel$11(distanceMeasureInstance, bcCenters, x$18)), (ClassTag)ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            bcCenters.destroy();
            double[] myWeights = (double[])ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])distinctCenters)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$19 -> BoxesRunTime.unboxToLong((Object)countMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)x$19), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))).toArray((ClassTag)ClassTag$.MODULE$.Double());
            vectorWithNormArray = LocalKMeans$.MODULE$.kMeansPlusPlus(0, distinctCenters, myWeights, this.k(), 30);
        }
        return vectorWithNormArray;
    }

    public static final /* synthetic */ double $anonfun$runWithWeight$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector v = (Vector)tuple2._1();
        double d = Vectors$.MODULE$.norm(v, 2.0);
        return d;
    }

    public static final /* synthetic */ void $anonfun$runAlgorithmWithWeight$6(DistanceMeasure distanceMeasureInstance$1, VectorWithNorm[] centers$1, double[] stats$1, DoubleAccumulator costAccum$1, Vector[] sums$1, double[] clusterWeightSum$1, VectorWithNorm point) {
        Tuple2<Object, Object> tuple2 = distanceMeasureInstance$1.findClosest(centers$1, stats$1, point);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bestCenter = tuple2._1$mcI$sp();
        double cost = tuple2._2$mcD$sp();
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(bestCenter, cost);
        Tuple2.mcID.sp sp3 = sp2;
        int bestCenter2 = sp3._1$mcI$sp();
        double cost2 = sp3._2$mcD$sp();
        costAccum$1.add(cost2 * point.weight());
        distanceMeasureInstance$1.updateClusterSum(point, sums$1[bestCenter2]);
        clusterWeightSum$1[bestCenter2] = clusterWeightSum$1[bestCenter2] + point.weight();
    }

    public static final /* synthetic */ Tuple2 $anonfun$runAlgorithmWithWeight$7(Vector[] sums$1, double[] clusterWeightSum$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple2((Object)sums$1[j], (Object)BoxesRunTime.boxToDouble((double)clusterWeightSum$1[j])));
    }

    public static final /* synthetic */ boolean $anonfun$runAlgorithmWithWeight$8(Tuple2 x$4) {
        return ((Tuple2)x$4._2())._2$mcD$sp() > 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$runAlgorithmWithWeight$13(KMeans $this, DistanceMeasure distanceMeasureInstance$1, BooleanRef converged$1, VectorWithNorm[] centers$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int j = tuple2._1$mcI$sp();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Vector sum = (Vector)tuple22._1();
        double weightSum = tuple22._2$mcD$sp();
        VectorWithNorm newCenter = distanceMeasureInstance$1.centroid(sum, weightSum);
        if (converged$1.elem && !distanceMeasureInstance$1.isCenterConverged(centers$2[j], newCenter, $this.epsilon())) {
            converged$1.elem = false;
        }
        centers$2[j] = newCenter;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$1(VectorWithNorm x$12) {
        return Double.POSITIVE_INFINITY;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$3(DistanceMeasure distanceMeasureInstance$2, Broadcast bcNewCenters$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        VectorWithNorm point = (VectorWithNorm)tuple2._1();
        double cost = tuple2._2$mcD$sp();
        double d = scala.math.package$.MODULE$.min(distanceMeasureInstance$2.pointCost((VectorWithNorm[])bcNewCenters$1.value(), point), cost);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$initKMeansParallel$5(KMeans $this, XORShiftRandom rand$1, double sumCosts$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double c = tuple2._2$mcD$sp();
        boolean bl = rand$1.nextDouble() < 2.0 * c * (double)$this.k() / sumCosts$1;
        return bl;
    }

    public static final /* synthetic */ Iterator $anonfun$initKMeansParallel$4(KMeans $this, int seed$1, IntRef step$1, double sumCosts$1, int index, Iterator pointCosts) {
        XORShiftRandom rand = new XORShiftRandom((long)(seed$1 ^ step$1.elem << 16 ^ index));
        return pointCosts.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$initKMeansParallel$5($this, rand, sumCosts$1, x0$2))).map((Function1 & Serializable)x$13 -> (VectorWithNorm)x$13._1());
    }

    public static final /* synthetic */ int $anonfun$initKMeansParallel$11(DistanceMeasure distanceMeasureInstance$2, Broadcast bcCenters$2, VectorWithNorm x$18) {
        return distanceMeasureInstance$2.findClosest((VectorWithNorm[])bcCenters$2.value(), x$18)._1$mcI$sp();
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.epsilon = epsilon;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this(k, maxIterations, initializationMode, initializationSteps, epsilon, seed, DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public KMeans() {
        this(2, 20, KMeans$.MODULE$.K_MEANS_PARALLEL(), 2, 1.0E-4, Utils$.MODULE$.random().nextLong(), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }
}

