/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.feature.VocabWord;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t]f\u0001\u0002\u001e<\u0001\u0019CQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001A\u0002\u0013%A\rC\u0004i\u0001\u0001\u0007I\u0011B5\t\r=\u0004\u0001\u0015)\u0003f\u0011\u001d\u0001\b\u00011A\u0005\nEDq!\u001e\u0001A\u0002\u0013%a\u000f\u0003\u0004y\u0001\u0001\u0006KA\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003e\u0011\u001dQ\b\u00011A\u0005\nmDa! \u0001!B\u0013)\u0007b\u0002@\u0001\u0001\u0004%I\u0001\u001a\u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002!9\u0011Q\u0001\u0001!B\u0013)\u0007\"CA\u0004\u0001\u0001\u0007I\u0011BA\u0005\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0015BA\u0006\u0011!\tI\u0002\u0001a\u0001\n\u0013!\u0007\"CA\u000e\u0001\u0001\u0007I\u0011BA\u000f\u0011\u001d\t\t\u0003\u0001Q!\n\u0015D\u0001\"a\t\u0001\u0001\u0004%I\u0001\u001a\u0005\n\u0003K\u0001\u0001\u0019!C\u0005\u0003OAq!a\u000b\u0001A\u0003&Q\rC\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\u0002\u0002!\t!a!\t\u0011\u00055\u0005A1A\u0005\n\u0011Dq!a$\u0001A\u0003%Q\r\u0003\u0005\u0002\u0012\u0002\u0011\r\u0011\"\u0003e\u0011\u001d\t\u0019\n\u0001Q\u0001\n\u0015D\u0001\"!&\u0001\u0005\u0004%I\u0001\u001a\u0005\b\u0003/\u0003\u0001\u0015!\u0003f\u0011!\tI\b\u0001a\u0001\n\u0013!\u0007\"CAM\u0001\u0001\u0007I\u0011BAN\u0011\u001d\ty\n\u0001Q!\n\u0015D\u0011\"!)\u0001\u0001\u0004%I!!\u0003\t\u0013\u0005\r\u0006\u00011A\u0005\n\u0005\u0015\u0006\u0002CAU\u0001\u0001\u0006K!a\u0003\t\u0011\u0005-\u0006\u00011A\u0005\n\u0011D\u0011\"!,\u0001\u0001\u0004%I!a,\t\u000f\u0005M\u0006\u0001)Q\u0005K\"I\u0011Q\u0017\u0001A\u0002\u0013%\u0011q\u0017\u0005\n\u0003\u000b\u0004\u0001\u0019!C\u0005\u0003\u000fD\u0001\"a3\u0001A\u0003&\u0011\u0011\u0018\u0005\n\u0003+\u0004\u0001\u0019!C\u0005\u0003/D\u0011\"!?\u0001\u0001\u0004%I!a?\t\u0011\u0005}\b\u0001)Q\u0005\u00033DqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0004\u00030\u0001!IA!\r\t\u000f\tm\u0002\u0001\"\u0003\u0003>!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005\u007f\u0001A\u0011\u0001BF\u0005!9vN\u001d33-\u0016\u001c'B\u0001\u001f>\u0003\u001d1W-\u0019;ve\u0016T!AP \u0002\u000b5dG.\u001b2\u000b\u0005\u0001\u000b\u0015!B:qCJ\\'B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u000f6K\u0006C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%AB!osJ+g\r\u0005\u0002O-:\u0011q\n\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%\u0016\u000ba\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005UK\u0015a\u00029bG.\fw-Z\u0005\u0003/b\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!V%\u0011\u0005ikV\"A.\u000b\u0005q{\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005y[&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0004\"A\u0019\u0001\u000e\u0003m\n!B^3di>\u00148+\u001b>f+\u0005)\u0007C\u0001%g\u0013\t9\u0017JA\u0002J]R\faB^3di>\u00148+\u001b>f?\u0012*\u0017\u000f\u0006\u0002k[B\u0011\u0001j[\u0005\u0003Y&\u0013A!\u00168ji\"9anAA\u0001\u0002\u0004)\u0017a\u0001=%c\u0005Ya/Z2u_J\u001c\u0016N_3!\u00031aW-\u0019:oS:<'+\u0019;f+\u0005\u0011\bC\u0001%t\u0013\t!\u0018J\u0001\u0004E_V\u0014G.Z\u0001\u0011Y\u0016\f'O\\5oOJ\u000bG/Z0%KF$\"A[<\t\u000f94\u0011\u0011!a\u0001e\u0006iA.Z1s]&twMU1uK\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00058v[B\u000b'\u000f^5uS>t7o\u0018\u0013fcR\u0011!\u000e \u0005\b]&\t\t\u00111\u0001f\u00039qW/\u001c)beRLG/[8og\u0002\nQB\\;n\u0013R,'/\u0019;j_:\u001c\u0018!\u00058v[&#XM]1uS>t7o\u0018\u0013fcR\u0019!.a\u0001\t\u000f9d\u0011\u0011!a\u0001K\u0006qa.^7Ji\u0016\u0014\u0018\r^5p]N\u0004\u0013\u0001B:fK\u0012,\"!a\u0003\u0011\u0007!\u000bi!C\u0002\u0002\u0010%\u0013A\u0001T8oO\u0006A1/Z3e?\u0012*\u0017\u000fF\u0002k\u0003+A\u0001B\\\b\u0002\u0002\u0003\u0007\u00111B\u0001\u0006g\u0016,G\rI\u0001\t[&t7i\\;oi\u0006aQ.\u001b8D_VtGo\u0018\u0013fcR\u0019!.a\b\t\u000f9\u0014\u0012\u0011!a\u0001K\u0006IQ.\u001b8D_VtG\u000fI\u0001\u0012[\u0006D8+\u001a8uK:\u001cW\rT3oORD\u0017!F7bqN+g\u000e^3oG\u0016dUM\\4uQ~#S-\u001d\u000b\u0004U\u0006%\u0002b\u00028\u0016\u0003\u0003\u0005\r!Z\u0001\u0013[\u0006D8+\u001a8uK:\u001cW\rT3oORD\u0007%\u0001\u000btKRl\u0015\r_*f]R,gnY3MK:<G\u000f\u001b\u000b\u0005\u0003c\t\u0019$D\u0001\u0001\u0011\u0019\t\u0019c\u0006a\u0001K\"*q#a\u000e\u0002DA!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>}\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t%a\u000f\u0003\u000bMKgnY3\"\u0005\u0005\u0015\u0013!\u0002\u001a/a9\u0002\u0014!D:fiZ+7\r^8s'&TX\r\u0006\u0003\u00022\u0005-\u0003\"B2\u0019\u0001\u0004)\u0007&\u0002\r\u00028\u0005=\u0013EAA)\u0003\u0015\td&\r\u00181\u0003=\u0019X\r\u001e'fCJt\u0017N\\4SCR,G\u0003BA\u0019\u0003/BQ\u0001]\rA\u0002IDS!GA\u001c\u0003\u001f\n\u0001c]3u\u001dVl\u0007+\u0019:uSRLwN\\:\u0015\t\u0005E\u0012q\f\u0005\u0006sj\u0001\r!\u001a\u0015\u00065\u0005]\u0012qJ\u0001\u0011g\u0016$h*^7Ji\u0016\u0014\u0018\r^5p]N$B!!\r\u0002h!)ap\u0007a\u0001K\"*1$a\u000e\u0002P\u000591/\u001a;TK\u0016$G\u0003BA\u0019\u0003_Bq!a\u0002\u001d\u0001\u0004\tY\u0001K\u0003\u001d\u0003o\ty%A\u0007tKR<\u0016N\u001c3poNK'0\u001a\u000b\u0005\u0003c\t9\b\u0003\u0004\u0002zu\u0001\r!Z\u0001\u0007o&tGm\\<)\u000bu\t9$! \"\u0005\u0005}\u0014!B\u0019/m9\u0002\u0014aC:fi6KgnQ8v]R$B!!\r\u0002\u0006\"1\u0011\u0011\u0004\u0010A\u0002\u0015DSAHA\u001c\u0003\u0013\u000b#!a#\u0002\u000bEr3G\f\u0019\u0002\u001d\u0015C\u0006k\u0018+B\u00052+ulU%[\u000b\u0006yQ\t\u0017)`)\u0006\u0013E*R0T\u0013j+\u0005%A\u0004N\u0003b{V\t\u0017)\u0002\u00115\u000b\u0005lX#Y!\u0002\nq\"T!Y?\u000e{E)R0M\u000b:;E\u000bS\u0001\u0011\u001b\u0006CvlQ(E\u000b~cUIT$U\u0011\u0002\n!b^5oI><x\fJ3r)\rQ\u0017Q\u0014\u0005\b]\u001a\n\t\u00111\u0001f\u0003\u001d9\u0018N\u001c3po\u0002\nq\u0002\u001e:bS:<vN\u001d3t\u0007>,h\u000e^\u0001\u0014iJ\f\u0017N\\,pe\u0012\u001c8i\\;oi~#S-\u001d\u000b\u0004U\u0006\u001d\u0006\u0002\u00038*\u0003\u0003\u0005\r!a\u0003\u0002!Q\u0014\u0018-\u001b8X_J$7oQ8v]R\u0004\u0013!\u0003<pG\u0006\u00147+\u001b>f\u000351xnY1c'&TXm\u0018\u0013fcR\u0019!.!-\t\u000f9d\u0013\u0011!a\u0001K\u0006Qao\\2bENK'0\u001a\u0011\u0002\u000bY|7-\u00192\u0016\u0005\u0005e\u0006#\u0002%\u0002<\u0006}\u0016bAA_\u0013\n)\u0011I\u001d:bsB\u0019!-!1\n\u0007\u0005\r7HA\u0005W_\u000e\f'mV8sI\u0006Iao\\2bE~#S-\u001d\u000b\u0004U\u0006%\u0007\u0002\u000380\u0003\u0003\u0005\r!!/\u0002\rY|7-\u00192!Q\r\u0001\u0014q\u001a\t\u0004\u0011\u0006E\u0017bAAj\u0013\nIAO]1og&,g\u000e^\u0001\nm>\u001c\u0017M\u0019%bg\",\"!!7\u0011\u000f\u0005m\u0017Q]AuK6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t/A\u0004nkR\f'\r\\3\u000b\u0007\u0005\r\u0018*\u0001\u0006d_2dWm\u0019;j_:LA!a:\u0002^\n9\u0001*Y:i\u001b\u0006\u0004\b\u0003BAv\u0003gtA!!<\u0002pB\u0011\u0001+S\u0005\u0004\u0003cL\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0006](AB*ue&twMC\u0002\u0002r&\u000bQB^8dC\nD\u0015m\u001d5`I\u0015\fHc\u00016\u0002~\"AaNMA\u0001\u0002\u0004\tI.\u0001\u0006w_\u000e\f'\rS1tQ\u0002B3aMAh\u0003)aW-\u0019:o->\u001c\u0017MY\u000b\u0005\u0005\u000f\u0011i\u0002F\u0002k\u0005\u0013AqAa\u00035\u0001\u0004\u0011i!A\u0004eCR\f7/\u001a;\u0011\r\t=!Q\u0003B\r\u001b\t\u0011\tBC\u0002\u0003\u0014}\n1A\u001d3e\u0013\u0011\u00119B!\u0005\u0003\u0007I#E\t\u0005\u0003\u0003\u001c\tuA\u0002\u0001\u0003\b\u0005?!$\u0019\u0001B\u0011\u0005\u0005\u0019\u0016\u0003\u0002B\u0012\u0005S\u00012\u0001\u0013B\u0013\u0013\r\u00119#\u0013\u0002\b\u001d>$\b.\u001b8h!\u0015q%1FAu\u0013\r\u0011i\u0003\u0017\u0002\t\u0013R,'/\u00192mK\u0006q1M]3bi\u0016,\u0005\u0010\u001d+bE2,GC\u0001B\u001a!\u0015A\u00151\u0018B\u001b!\rA%qG\u0005\u0004\u0005sI%!\u0002$m_\u0006$\u0018\u0001E2sK\u0006$XMQ5oCJLHK]3f)\u0005Q\u0017a\u00014jiV!!1\tB))\u0011\u0011)Ea\u0013\u0011\u0007\t\u00149%C\u0002\u0003Jm\u0012QbV8sIJ2VmY'pI\u0016d\u0007b\u0002B\u0006o\u0001\u0007!Q\n\t\u0007\u0005\u001f\u0011)Ba\u0014\u0011\t\tm!\u0011\u000b\u0003\b\u0005?9$\u0019\u0001B\u0011Q\u00159\u0014qGA(\u0003\u0015!wNR5u+\u0011\u0011IF!\u0019\u0015\u0019\t\u0015#1\fB2\u0005_\u0012yH!\"\t\u000f\t-\u0001\b1\u0001\u0003^A1!q\u0002B\u000b\u0005?\u0002BAa\u0007\u0003b\u00119!q\u0004\u001dC\u0002\t\u0005\u0002b\u0002B3q\u0001\u0007!qM\u0001\u0003g\u000e\u0004BA!\u001b\u0003l5\tq(C\u0002\u0003n}\u0012Ab\u00159be.\u001cuN\u001c;fqRDqA!\u001d9\u0001\u0004\u0011\u0019(\u0001\u0005fqB$\u0016M\u00197f!\u0019\u0011)Ha\u001f\u000345\u0011!q\u000f\u0006\u0004\u0005sz\u0014!\u00032s_\u0006$7-Y:u\u0013\u0011\u0011iHa\u001e\u0003\u0013\t\u0013x.\u00193dCN$\bb\u0002BAq\u0001\u0007!1Q\u0001\bE\u000e4vnY1c!\u0019\u0011)Ha\u001f\u0002:\"9!q\u0011\u001dA\u0002\t%\u0015a\u00032d->\u001c\u0017M\u0019%bg\"\u0004bA!\u001e\u0003|\u0005eW\u0003\u0002BG\u0005G#BA!\u0012\u0003\u0010\"9!1B\u001dA\u0002\tE\u0005C\u0002BJ\u0005;\u0013\t+\u0004\u0002\u0003\u0016*!!q\u0013BM\u0003\u0011Q\u0017M^1\u000b\u0007\tmu(A\u0002ba&LAAa(\u0003\u0016\n9!*\u0019<b%\u0012#\u0005\u0003\u0002B\u000e\u0005G#qAa\b:\u0005\u0004\u0011)+\u0005\u0003\u0003$\t\u001d\u0006C\u0002BU\u0005c\u000bI/\u0004\u0002\u0003,*!!Q\u0016BX\u0003\u0011a\u0017M\\4\u000b\u0005\t]\u0015\u0002\u0002B\u0017\u0005WCS!OA\u001c\u0003\u001fBS\u0001AA\u001c\u0003\u001f\u0002")
public class Word2Vec
implements Serializable,
Logging {
    private int vectorSize;
    private double learningRate;
    private int numPartitions;
    private int numIterations;
    private long seed;
    private int minCount;
    private int maxSentenceLength;
    private final int EXP_TABLE_SIZE;
    private final int MAX_EXP;
    private final int MAX_CODE_LENGTH;
    private int window;
    private long trainWordsCount;
    private int vocabSize;
    private transient VocabWord[] vocab;
    private transient HashMap<String, Object> vocabHash;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private void vectorSize_$eq(int x$1) {
        this.vectorSize = x$1;
    }

    private double learningRate() {
        return this.learningRate;
    }

    private void learningRate_$eq(double x$1) {
        this.learningRate = x$1;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.numPartitions = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int minCount() {
        return this.minCount;
    }

    private void minCount_$eq(int x$1) {
        this.minCount = x$1;
    }

    private int maxSentenceLength() {
        return this.maxSentenceLength;
    }

    private void maxSentenceLength_$eq(int x$1) {
        this.maxSentenceLength = x$1;
    }

    public Word2Vec setMaxSentenceLength(int maxSentenceLength) {
        Predef$.MODULE$.require(maxSentenceLength > 0, (Function0 & Serializable)() -> new StringBuilder(53).append("Maximum length of sentences must be positive but got ").append(maxSentenceLength).toString());
        this.maxSentenceLength_$eq(maxSentenceLength);
        return this;
    }

    public Word2Vec setVectorSize(int vectorSize) {
        Predef$.MODULE$.require(vectorSize > 0, (Function0 & Serializable)() -> new StringBuilder(37).append("vector size must be positive but got ").append(vectorSize).toString());
        this.vectorSize_$eq(vectorSize);
        return this;
    }

    public Word2Vec setLearningRate(double learningRate) {
        Predef$.MODULE$.require(learningRate > 0.0, (Function0 & Serializable)() -> new StringBuilder(47).append("Initial learning rate must be positive but got ").append(learningRate).toString());
        this.learningRate_$eq(learningRate);
        return this;
    }

    public Word2Vec setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0 & Serializable)() -> new StringBuilder(46).append("Number of partitions must be positive but got ").append(numPartitions).toString());
        this.numPartitions_$eq(numPartitions);
        return this;
    }

    public Word2Vec setNumIterations(int numIterations) {
        Predef$.MODULE$.require(numIterations >= 0, (Function0 & Serializable)() -> new StringBuilder(49).append("Number of iterations must be nonnegative but got ").append(numIterations).toString());
        this.numIterations_$eq(numIterations);
        return this;
    }

    public Word2Vec setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public Word2Vec setWindowSize(int window) {
        Predef$.MODULE$.require(window > 0, (Function0 & Serializable)() -> new StringBuilder(41).append("Window of words must be positive but got ").append(window).toString());
        this.window_$eq(window);
        return this;
    }

    public Word2Vec setMinCount(int minCount) {
        Predef$.MODULE$.require(minCount >= 0, (Function0 & Serializable)() -> new StringBuilder(52).append("Minimum number of times must be nonnegative but got ").append(minCount).toString());
        this.minCount_$eq(minCount);
        return this;
    }

    private int EXP_TABLE_SIZE() {
        return this.EXP_TABLE_SIZE;
    }

    private int MAX_EXP() {
        return this.MAX_EXP;
    }

    private int MAX_CODE_LENGTH() {
        return this.MAX_CODE_LENGTH;
    }

    private int window() {
        return this.window;
    }

    private void window_$eq(int x$1) {
        this.window = x$1;
    }

    private long trainWordsCount() {
        return this.trainWordsCount;
    }

    private void trainWordsCount_$eq(long x$1) {
        this.trainWordsCount = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private VocabWord[] vocab() {
        return this.vocab;
    }

    private void vocab_$eq(VocabWord[] x$1) {
        this.vocab = x$1;
    }

    private HashMap<String, Object> vocabHash() {
        return this.vocabHash;
    }

    private void vocabHash_$eq(HashMap<String, Object> x$1) {
        this.vocabHash = x$1;
    }

    private <S extends Iterable<String>> void learnVocab(RDD<S> dataset) {
        RDD words = dataset.flatMap((Function1 & Serializable)x -> x, ClassTag$.MODULE$.apply(String.class));
        this.vocab_$eq((VocabWord[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(words.map((Function1 & Serializable)w -> new Tuple2(w, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable)(x$1, x$2) -> x$1 + x$2).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Word2Vec.$anonfun$learnVocab$4(this, x$3))).map((Function1 & Serializable)x -> new VocabWord((String)x._1(), x._2$mcI$sp(), new int[this.MAX_CODE_LENGTH()], new int[this.MAX_CODE_LENGTH()], 0), ClassTag$.MODULE$.apply(VocabWord.class)).collect()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.cn()), package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$).reverse()));
        this.vocabSize_$eq(this.vocab().length);
        Predef$.MODULE$.require(this.vocabSize() > 0, (Function0 & Serializable)() -> "The vocabulary size should be > 0. You may need to check the setting of minCount, which could be large enough to remove all your words in sentences.");
        for (int a = 0; a < this.vocabSize(); ++a) {
            this.vocabHash().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.vocab()[a].word()), (Object)BoxesRunTime.boxToInteger((int)a)));
            this.trainWordsCount_$eq(this.trainWordsCount() + this.vocab()[a].cn());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("vocabSize = ").append(this.vocabSize()).append(", trainWordsCount = ").append(this.trainWordsCount()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private float[] createExpTable() {
        void var1_1;
        float[] expTable = new float[this.EXP_TABLE_SIZE()];
        for (int i = 0; i < this.EXP_TABLE_SIZE(); ++i) {
            double tmp = scala.math.package$.MODULE$.exp((2.0 * (double)i / (double)this.EXP_TABLE_SIZE() - 1.0) * (double)this.MAX_EXP());
            expTable[i] = (float)(tmp / (tmp + 1.0));
        }
        return var1_1;
    }

    private void createBinaryTree() {
        int a;
        long[] count = new long[this.vocabSize() * 2 + 1];
        int[] binary = new int[this.vocabSize() * 2 + 1];
        int[] parentNode = new int[this.vocabSize() * 2 + 1];
        int[] code = new int[this.MAX_CODE_LENGTH()];
        int[] point = new int[this.MAX_CODE_LENGTH()];
        for (a = 0; a < this.vocabSize(); ++a) {
            count[a] = this.vocab()[a].cn();
        }
        while (a < 2 * this.vocabSize()) {
            count[a] = Long.MAX_VALUE;
            ++a;
        }
        int pos1 = this.vocabSize() - 1;
        int pos2 = this.vocabSize();
        int min1i = 0;
        int min2i = 0;
        for (a = 0; a < this.vocabSize() - 1; ++a) {
            min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            Predef$.MODULE$.assert(count[min1i] < Long.MAX_VALUE);
            Predef$.MODULE$.assert(count[min2i] < Long.MAX_VALUE);
            count[this.vocabSize() + a] = count[min1i] + count[min2i];
            parentNode[min1i] = this.vocabSize() + a;
            parentNode[min2i] = this.vocabSize() + a;
            binary[min2i] = 1;
        }
        int i = 0;
        for (a = 0; a < this.vocabSize(); ++a) {
            int b = a;
            i = 0;
            while (b != this.vocabSize() * 2 - 2) {
                code[i] = binary[b];
                point[i] = b;
                ++i;
                b = parentNode[b];
            }
            this.vocab()[a].codeLen_$eq(i);
            this.vocab()[a].point()[0] = this.vocabSize() - 2;
            for (b = 0; b < i; ++b) {
                this.vocab()[a].code()[i - b - 1] = code[b];
                this.vocab()[a].point()[i - b] = point[b] - this.vocabSize();
            }
        }
    }

    public <S extends Iterable<String>> Word2VecModel fit(RDD<S> dataset) {
        Word2VecModel word2VecModel;
        this.learnVocab(dataset);
        this.createBinaryTree();
        SparkContext sc = dataset.context();
        Broadcast expTable = sc.broadcast((Object)this.createExpTable(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        Broadcast bcVocab = sc.broadcast((Object)this.vocab(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VocabWord.class)));
        Broadcast bcVocabHash = sc.broadcast(this.vocabHash(), ClassTag$.MODULE$.apply(HashMap.class));
        try {
            word2VecModel = this.doFit(dataset, sc, (Broadcast<float[]>)expTable, (Broadcast<VocabWord[]>)bcVocab, (Broadcast<HashMap<String, Object>>)bcVocabHash);
        }
        finally {
            expTable.destroy();
            bcVocab.destroy();
            bcVocabHash.destroy();
        }
        return word2VecModel;
    }

    private <S extends Iterable<String>> Word2VecModel doFit(RDD<S> dataset, SparkContext sc, Broadcast<float[]> expTable, Broadcast<VocabWord[]> bcVocab, Broadcast<HashMap<String, Object>> bcVocabHash) {
        RDD sentences = dataset.mapPartitions((Function1 & Serializable)sentenceIter -> sentenceIter.flatMap((Function1 & Serializable)sentence -> {
            HashMap hashMap = (HashMap)bcVocabHash.value();
            Iterable wordIndexes = (Iterable)sentence.flatMap((Function1 & Serializable)key -> hashMap.get(key));
            return wordIndexes.grouped(this.maxSentenceLength()).map((Function1 & Serializable)x$5 -> (int[])x$5.toArray((ClassTag)ClassTag$.MODULE$.Int()));
        }), dataset.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        int x$1 = this.numPartitions();
        Ordering x$2 = sentences.repartition$default$2(x$1);
        RDD newSentences = sentences.repartition(x$1, x$2).cache();
        XORShiftRandom initRandom = new XORShiftRandom(this.seed());
        if ((long)this.vocabSize() * (long)this.vectorSize() >= Integer.MAX_VALUE) {
            throw new RuntimeException(new StringBuilder(184).append("Please increase minCount or decrease vectorSize in Word2Vec to avoid an OOM. You are highly recommended to make your vocabSize*vectorSize, which is ").append(this.vocabSize()).append("*").append(this.vectorSize()).append(" for now, less than `Int.MaxValue`.").toString());
        }
        float[] syn0Global = (float[])Array$.MODULE$.fill(this.vocabSize() * this.vectorSize(), (Function0)(JFunction0.mcF.sp & Serializable)() -> (initRandom.nextFloat() - 0.5f) / (float)this.vectorSize(), (ClassTag)ClassTag$.MODULE$.Float());
        float[] syn1Global = new float[this.vocabSize() * this.vectorSize()];
        long totalWordsCounts = (long)this.numIterations() * this.trainWordsCount() + 1L;
        DoubleRef alpha = DoubleRef.create((double)this.learningRate());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
            Broadcast bcSyn0Global = sc.broadcast((Object)syn0Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            Broadcast bcSyn1Global = sc.broadcast((Object)syn1Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            long numWordsProcessedInPreviousIterations = (long)(k - 1) * this.trainWordsCount();
            RDD partial = newSentences.mapPartitionsWithIndex((Function2 & Serializable)(x0$1, x1$1) -> Word2Vec.$anonfun$doFit$7(this, k, bcSyn0Global, bcSyn1Global, alpha, numWordsProcessedInPreviousIterations, totalWordsCounts, bcVocab, expTable, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), newSentences.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Tuple2[] synAgg = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(partial.mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int id = tuple2._1$mcI$sp();
                float[] vec = (float[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)new Tuple2((Object)vec, (Object)BoxesRunTime.boxToInteger((int)1)));
                return tuple22;
            }), partial.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable)(vc1, vc2) -> {
                BLAS$.MODULE$.nativeBLAS().saxpy(this.vectorSize(), 1.0f, (float[])vc2._1(), 1, (float[])vc1._1(), 1);
                return new Tuple2(vc1._1(), (Object)BoxesRunTime.boxToInteger((int)(vc1._2$mcI$sp() + vc2._2$mcI$sp())));
            }).map((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2;
                int id;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$4;
                        if (tuple22 == null) break block2;
                        id = tuple22._1$mcI$sp();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                float[] vec = (float[])tuple2._1();
                int count = tuple2._2$mcI$sp();
                BLAS$.MODULE$.nativeBLAS().sscal(this.vectorSize(), 1.0f / (float)count, vec, 1);
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)vec);
                return tuple23;
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            for (int i = 0; i < synAgg.length; ++i) {
                int index = synAgg[i]._1$mcI$sp();
                if (index < this.vocabSize()) {
                    Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn0Global, index * this.vectorSize(), this.vectorSize());
                    continue;
                }
                Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn1Global, (index - this.vocabSize()) * this.vectorSize(), this.vectorSize());
            }
            bcSyn0Global.destroy();
            bcSyn1Global.destroy();
        });
        newSentences.unpersist(newSentences.unpersist$default$1());
        String[] wordArray = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.vocab()), (Function1 & Serializable)x$6 -> x$6.word(), ClassTag$.MODULE$.apply(String.class));
        return new Word2VecModel((Map<String, Object>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])wordArray))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), syn0Global);
    }

    public <S extends java.lang.Iterable<String>> Word2VecModel fit(JavaRDD<S> dataset) {
        return this.fit(dataset.rdd().map((Function1 & Serializable)x$7 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$7).asScala(), ClassTag$.MODULE$.apply(Iterable.class)));
    }

    public static final /* synthetic */ boolean $anonfun$learnVocab$4(Word2Vec $this, Tuple2 x$3) {
        return x$3._2$mcI$sp() >= $this.minCount();
    }

    public static final /* synthetic */ Option $anonfun$doFit$10(Word2Vec $this, int[] syn0Modify$1, float[] syn0Local$1, int index) {
        return syn0Modify$1[index] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.floatArrayOps(syn0Local$1), index * $this.vectorSize(), (index + 1) * $this.vectorSize()))) : None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$doFit$12(Word2Vec $this, int[] syn1Modify$1, float[] syn1Local$1, int index) {
        return syn1Modify$1[index] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(index + $this.vocabSize())), ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.floatArrayOps(syn1Local$1), index * $this.vectorSize(), (index + 1) * $this.vectorSize()))) : None$.MODULE$;
    }

    public static final /* synthetic */ Iterator $anonfun$doFit$7(Word2Vec $this, int k$1, Broadcast bcSyn0Global$1, Broadcast bcSyn1Global$1, DoubleRef alpha$1, long numWordsProcessedInPreviousIterations$1, long totalWordsCounts$1, Broadcast bcVocab$1, Broadcast expTable$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int idx = tuple2._1$mcI$sp();
        Iterator iter = (Iterator)tuple2._2();
        XORShiftRandom random = new XORShiftRandom($this.seed() ^ (long)(idx + 1 << 16) ^ (long)(-k$1 - 1 << 8));
        int[] syn0Modify = new int[$this.vocabSize()];
        int[] syn1Modify = new int[$this.vocabSize()];
        Tuple4 model = (Tuple4)iter.foldLeft((Object)new Tuple4(bcSyn0Global$1.value(), bcSyn1Global$1.value(), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple4 tuple4 = (Tuple4)tuple2._1();
            int[] sentence = (int[])tuple2._2();
            if (tuple4 == null) throw new MatchError((Object)tuple2);
            float[] syn0 = (float[])tuple4._1();
            float[] syn1 = (float[])tuple4._2();
            long lastWordCount = BoxesRunTime.unboxToLong((Object)tuple4._3());
            long wordCount = BoxesRunTime.unboxToLong((Object)tuple4._4());
            long lwc = lastWordCount;
            long wc = wordCount;
            if (wordCount - lastWordCount > 10000L) {
                lwc = wordCount;
                alpha$1.elem = $this.learningRate() * (1.0 - ((double)$this.numPartitions() * (double)wordCount + (double)numWordsProcessedInPreviousIterations$1) / (double)totalWordsCounts$1);
                if (alpha$1.elem < $this.learningRate() * 1.0E-4) {
                    alpha$1.elem = $this.learningRate() * 1.0E-4;
                }
                $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(14).append("wordCount = ").append(wordCount + numWordsProcessedInPreviousIterations$1).append(", ").toString()).append(new StringBuilder(8).append("alpha = ").append(alpha$1.elem).toString()).toString());
            }
            wc += (long)sentence.length;
            int pos = 0;
            while (pos < sentence.length) {
                int b;
                int word = sentence[pos];
                for (int a = b = random.nextInt($this.window()); a < $this.window() * 2 + 1 - b; ++a) {
                    int c;
                    if (a == $this.window() || (c = pos - $this.window() + a) < 0 || c >= sentence.length) continue;
                    int lastWord = sentence[c];
                    int l1 = lastWord * $this.vectorSize();
                    float[] neu1e = new float[$this.vectorSize()];
                    for (int d = 0; d < ((VocabWord[])bcVocab$1.value())[word].codeLen(); ++d) {
                        int inner = ((VocabWord[])bcVocab$1.value())[word].point()[d];
                        int l2 = inner * $this.vectorSize();
                        float f = BLAS$.MODULE$.nativeBLAS().sdot($this.vectorSize(), syn0, l1, 1, syn1, l2, 1);
                        if (!(f > (float)(-$this.MAX_EXP())) || !(f < (float)$this.MAX_EXP())) continue;
                        int ind = (int)((double)(f + (float)$this.MAX_EXP()) * ((double)($this.EXP_TABLE_SIZE() / $this.MAX_EXP()) / 2.0));
                        f = ((float[])expTable$1.value())[ind];
                        float g = (float)((double)((float)(1 - ((VocabWord[])bcVocab$1.value())[word].code()[d]) - f) * alpha$1.elem);
                        BLAS$.MODULE$.nativeBLAS().saxpy($this.vectorSize(), g, syn1, l2, 1, neu1e, 0, 1);
                        BLAS$.MODULE$.nativeBLAS().saxpy($this.vectorSize(), g, syn0, l1, 1, syn1, l2, 1);
                        syn1Modify$1[inner] = syn1Modify[inner] + 1;
                    }
                    BLAS$.MODULE$.nativeBLAS().saxpy($this.vectorSize(), 1.0f, neu1e, 0, 1, syn0, l1, 1);
                    syn0Modify$1[lastWord] = syn0Modify[lastWord] + 1;
                }
                ++pos;
            }
            return new Tuple4((Object)syn0, (Object)syn1, (Object)BoxesRunTime.boxToLong((long)lwc), (Object)BoxesRunTime.boxToLong((long)wc));
        });
        float[] syn0Local = (float[])model._1();
        float[] syn1Local = (float[])model._2();
        Iterator iterator = package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable)index -> Word2Vec.$anonfun$doFit$10($this, syn0Modify, syn0Local, BoxesRunTime.unboxToInt((Object)index))).flatten(Predef$.MODULE$.$conforms()).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable)index -> Word2Vec.$anonfun$doFit$12($this, syn1Modify, syn1Local, BoxesRunTime.unboxToInt((Object)index))).flatten(Predef$.MODULE$.$conforms()));
        return iterator;
    }

    public Word2Vec() {
        Logging.$init$((Logging)this);
        this.vectorSize = 100;
        this.learningRate = 0.025;
        this.numPartitions = 1;
        this.numIterations = 1;
        this.seed = Utils$.MODULE$.random().nextLong();
        this.minCount = 5;
        this.maxSentenceLength = 1000;
        this.EXP_TABLE_SIZE = 1000;
        this.MAX_EXP = 6;
        this.MAX_CODE_LENGTH = 40;
        this.window = 5;
        this.trainWordsCount = 0L;
        this.vocabSize = 0;
        this.vocab = null;
        this.vocabHash = HashMap$.MODULE$.empty();
    }
}

