/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.normalize$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaPairRDD$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.LocalLDAModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\ruc\u0001\u0002#F\u0001AC\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\ti\u0002\u0011\t\u0011)A\u0005K\"Aa\u000f\u0001BC\u0002\u0013\u0005s\u000f\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003y\u0011)\t\t\u0001\u0001BC\u0002\u0013\u0005\u00131\u0001\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001bCA\n\u0001\t\u0015\r\u0011\"\u0015J\u0003\u0007A!\"!\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011!\t9\u0002\u0001C\u0001\u0013\u0006e\u0001BCA\u0016\u0001\u0001\u0007I\u0011A%\u0002.!Q\u0011Q\u0007\u0001A\u0002\u0013\u0005\u0011*a\u000e\t\u0011\u0005\r\u0003\u0001)Q\u0005\u0003_Aq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002R\u0001!\t%a\u0012\t\r\u0005U\u0003\u0001\"\u0011e\u0011\u001d\tI\u0006\u0001C!\u00037Bq!a\u001d\u0001\t\u0003\ti\u0003C\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAV\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\t)\u000f\u0001C\u0001\u0003[Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u001a\u0001!\tAa\u0007\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$!9!\u0011\u0004\u0001\u0005\u0002\t=ra\u0002B\u001e\u000b\"\u0005!Q\b\u0004\u0007\t\u0016C\tAa\u0010\t\u000f\u0005]Q\u0004\"\u0001\u0003^\u001d9!qL\u000f\t\n\t\u0005da\u0002B3;!%!q\r\u0005\b\u0003/\u0001C\u0011\u0001B5\u0011%\u0011Y\u0007\tb\u0001\n\u0003\u0011i\u0007\u0003\u0005\u0003t\u0001\u0002\u000b\u0011\u0002B8\u0011%\u0011)\b\tb\u0001\n\u0003\u0011i\u0007\u0003\u0005\u0003x\u0001\u0002\u000b\u0011\u0002B8\r\u0019\u0011I\b\t!\u0003|!I!1\u0011\u0014\u0003\u0016\u0004%\ta\u001e\u0005\n\u0005\u000b3#\u0011#Q\u0001\naD!Ba\"'\u0005+\u0007I\u0011AA$\u0011)\u0011II\nB\tB\u0003%\u0011\u0011\n\u0005\b\u0003/1C\u0011\u0001BF\u0011%\u0011)JJA\u0001\n\u0003\u00119\nC\u0005\u0003\u001e\u001a\n\n\u0011\"\u0001\u0003 \"I!1\u0017\u0014\u0012\u0002\u0013\u0005!Q\u0017\u0005\n\u0005s3\u0013\u0011!C!\u0005[B\u0011Ba/'\u0003\u0003%\t!a\u0012\t\u0013\tuf%!A\u0005\u0002\t}\u0006\"\u0003BeM\u0005\u0005I\u0011\tBf\u0011%\u0011INJA\u0001\n\u0003\u0011Y\u000eC\u0005\u0003f\u001a\n\t\u0011\"\u0011\u0003h\"I!1\u001e\u0014\u0002\u0002\u0013\u0005#Q\u001e\u0005\n\u0005_4\u0013\u0011!C!\u0005cD\u0011Ba='\u0003\u0003%\tE!>\b\u0013\te\b%!A\t\u0002\tmh!\u0003B=A\u0005\u0005\t\u0012\u0001B\u007f\u0011\u001d\t9\"\u000fC\u0001\u0007\u0017A\u0011Ba<:\u0003\u0003%)E!=\t\u0013\r5\u0011(!A\u0005\u0002\u000e=\u0001\"CB\u000bs\u0005\u0005I\u0011QB\f\u0011%\u0019)#OA\u0001\n\u0013\u00199\u0003C\u0004\u0002\u0006\u0002\"\taa\f\t\u000f\ru\u0002\u0005\"\u0001\u0004@!91QH\u000f\u0005B\r-\u0003BCB*;E\u0005I\u0011A%\u0004V!I1QE\u000f\u0002\u0002\u0013%1q\u0005\u0002\u000e\u0019>\u001c\u0017\r\u001c'E\u00036{G-\u001a7\u000b\u0005\u0019;\u0015AC2mkN$XM]5oO*\u0011\u0001*S\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0015.\u000bQa\u001d9be.T!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO\u000e\u00011c\u0001\u0001R+B\u0011!kU\u0007\u0002\u000b&\u0011A+\u0012\u0002\t\u0019\u0012\u000bUj\u001c3fYB\u0011a\u000b\u0019\b\u0003/vs!\u0001W.\u000e\u0003eS!AW(\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0016!B:dC2\f\u0017B\u00010`\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001X\u0005\u0003C\n\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!AX0\u0002\rQ|\u0007/[2t+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015H\u0003\u0019a\u0017N\\1mO&\u0011!n\u001a\u0002\u0007\u001b\u0006$(/\u001b=)\u0007\u0005a'\u000f\u0005\u0002na6\taN\u0003\u0002p\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Et'!B*j]\u000e,\u0017%A:\u0002\u000bEr3G\f\u0019\u0002\u000fQ|\u0007/[2tA!\u001a!\u0001\u001c:\u0002!\u0011|7mQ8oG\u0016tGO]1uS>tW#\u0001=\u0011\u0005\u0019L\u0018B\u0001>h\u0005\u00191Vm\u0019;pe\"\u001a1\u0001\u001c?\"\u0003u\fQ!\r\u00186]A\n\u0011\u0003Z8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8!Q\r!A\u000e`\u0001\u0013i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g.\u0006\u0002\u0002\u0006A!\u0011qAA\u0005\u001b\u0005y\u0016bAA\u0006?\n1Ai\\;cY\u0016D3!\u00027}\u0003M!x\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8!Q\r1A\u000e`\u0001\u000bO\u0006lW.Y*iCB,\u0017aC4b[6\f7\u000b[1qK\u0002\na\u0001P5oSRtDCCA\u000e\u0003;\t\t#!\n\u0002*A\u0011!\u000b\u0001\u0005\u0006G&\u0001\r!\u001a\u0015\u0005\u0003;a'\u000fC\u0003w\u0013\u0001\u0007\u0001\u0010\u000b\u0003\u0002\"1d\bbBA\u0001\u0013\u0001\u0007\u0011Q\u0001\u0015\u0005\u0003KaG\u0010C\u0005\u0002\u0014%\u0001\n\u00111\u0001\u0002\u0006\u0005!1/Z3e+\t\ty\u0003\u0005\u0003\u0002\b\u0005E\u0012bAA\u001a?\n!Aj\u001c8h\u0003!\u0019X-\u001a3`I\u0015\fH\u0003BA\u001d\u0003\u007f\u0001B!a\u0002\u0002<%\u0019\u0011QH0\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0003Z\u0011\u0011!a\u0001\u0003_\t1\u0001\u001f\u00132\u0003\u0015\u0019X-\u001a3!\u0003\u0005YWCAA%!\u0011\t9!a\u0013\n\u0007\u00055sLA\u0002J]RD3!\u00047s\u0003%1xnY1c'&TX\rK\u0002\u000fYJ\fA\u0002^8qS\u000e\u001cX*\u0019;sSbD3a\u00047s\u00039!Wm]2sS\n,Gk\u001c9jGN$B!!\u0018\u0002nA1\u0011qAA0\u0003GJ1!!\u0019`\u0005\u0015\t%O]1z!!\t9!!\u001a\u0002j\u0005-\u0014bAA4?\n1A+\u001e9mKJ\u0002b!a\u0002\u0002`\u0005%\u0003CBA\u0004\u0003?\n)\u0001C\u0004\u0002pA\u0001\r!!\u0013\u0002!5\f\u0007\u0010V3s[N\u0004VM\u001d+pa&\u001c\u0007f\u0001\tme\u00069q-\u001a;TK\u0016$\u0007\u0006B\tm\u0003o\n#!!\u001f\u0002\u000bIrCG\f\u0019\u0002\u000fM,GoU3fIR!\u0011qPAA\u001b\u0005\u0001\u0001bBA\u0016%\u0001\u0007\u0011q\u0006\u0015\u0005%1\f9(\u0001\u0003tCZ,GCBA\u001d\u0003\u0013\u000b)\nC\u0004\u0002\fN\u0001\r!!$\u0002\u0005M\u001c\u0007\u0003BAH\u0003#k\u0011!S\u0005\u0004\u0003'K%\u0001D*qCJ\\7i\u001c8uKb$\bbBAL'\u0001\u0007\u0011\u0011T\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002\u001c\u0006\rf\u0002BAO\u0003?\u0003\"\u0001W0\n\u0007\u0005\u0005v,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\u000b9K\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003C{\u0006fA\nmy\u0006iAn\\4MS.,G.\u001b5p_\u0012$B!!\u0002\u00020\"9\u0011\u0011\u0017\u000bA\u0002\u0005M\u0016!\u00033pGVlWM\u001c;t!\u0019\t),a/\u0002@6\u0011\u0011q\u0017\u0006\u0004\u0003sK\u0015a\u0001:eI&!\u0011QXA\\\u0005\r\u0011F\t\u0012\t\b\u0003\u000f\t)'a\fyQ\r!B\u000e \u000b\u0005\u0003\u000b\t)\rC\u0004\u00022V\u0001\r!a2\u0011\u000f\u0005%\u00171[Alq6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-\u0001\u0003kCZ\f'bAAi\u0013\u0006\u0019\u0011\r]5\n\t\u0005U\u00171\u001a\u0002\f\u0015\u00064\u0018\rU1jeJ#E\t\u0005\u0003\u0002Z\u0006\u0005XBAAn\u0015\u0011\ti.a8\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001bLA!a\r\u0002\\\"\u001aQ\u0003\u001c?\u0002\u001b1|w\rU3sa2,\u00070\u001b;z)\u0011\t)!!;\t\u000f\u0005Ef\u00031\u0001\u00024\"\u001aa\u0003\u001c?\u0015\t\u0005\u0015\u0011q\u001e\u0005\b\u0003c;\u0002\u0019AAdQ\r9B\u000e`\u0001\u0013Y><G*[6fY&Dwn\u001c3C_VtG\r\u0006\t\u0002\u0006\u0005]\u0018\u0011`A\u007f\u0005\u0003\u0011\u0019B!\u0006\u0003\u0018!9\u0011\u0011\u0017\rA\u0002\u0005M\u0006BBA~1\u0001\u0007\u00010A\u0003bYBD\u0017\rC\u0004\u0002\u0000b\u0001\r!!\u0002\u0002\u0007\u0015$\u0018\rC\u0004\u0003\u0004a\u0001\rA!\u0002\u0002\r1\fWN\u00193b!\u0019\u00119Aa\u0004\u0002\u00065\u0011!\u0011\u0002\u0006\u0004Q\n-!B\u0001B\u0007\u0003\u0019\u0011'/Z3{K&!!\u0011\u0003B\u0005\u0005-!UM\\:f\u001b\u0006$(/\u001b=\t\u000f\u0005M\u0001\u00041\u0001\u0002\u0006!9\u0011Q\t\rA\u0002\u0005%\u0003bBA)1\u0001\u0007\u0011qF\u0001\u0013i>\u0004\u0018n\u0019#jgR\u0014\u0018NY;uS>t7\u000f\u0006\u0003\u00024\nu\u0001bBAY3\u0001\u0007\u00111\u0017\u0015\u000431\u0014\u0018!\u0005;pa&\u001cG)[:ue&\u0014W\u000f^5p]R\u0019\u0001P!\n\t\r\t\u001d\"\u00041\u0001y\u0003!!wnY;nK:$\b\u0006\u0002\u000em\u0005W\t#A!\f\u0002\u000bIr\u0003G\f\u0019\u0015\t\u0005\u001d'\u0011\u0007\u0005\b\u0003c[\u0002\u0019AAdQ\u0011YBN!\u000e\"\u0005\t]\u0012!B\u0019/i9\n\u0004f\u0001\u0001me\u0006iAj\\2bY2#\u0015)T8eK2\u0004\"AU\u000f\u0014\u000fu\u0011\tEa\u0012\u0003TA!\u0011q\u0001B\"\u0013\r\u0011)e\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\r\t%#qJA\u000e\u001b\t\u0011YEC\u0002\u0003N\u001d\u000bA!\u001e;jY&!!\u0011\u000bB&\u0005\u0019au.\u00193feB!!Q\u000bB.\u001b\t\u00119F\u0003\u0003\u0003Z\u0005}\u0017AA5p\u0013\r\t'q\u000b\u000b\u0003\u0005{\tAbU1wK2{\u0017\r\u001a,2?B\u00022Aa\u0019!\u001b\u0005i\"\u0001D*bm\u0016du.\u00193Wc}\u00034c\u0001\u0011\u0003BQ\u0011!\u0011M\u0001\u0012i\"L7OR8s[\u0006$h+\u001a:tS>tWC\u0001B8!\u0011\tIN!\u001d\n\t\u0005\u0015\u00161\\\u0001\u0013i\"L7OR8s[\u0006$h+\u001a:tS>t\u0007%A\u0007uQ&\u001c8\t\\1tg:\u000bW.Z\u0001\u000fi\"L7o\u00117bgNt\u0015-\\3!\u0005\u0011!\u0015\r^1\u0014\r\u0019\u0012\tE! V!\u0011\t9Aa \n\u0007\t\u0005uLA\u0004Qe>$Wo\u0019;\u0002\u000bQ|\u0007/[2\u0002\rQ|\u0007/[2!\u0003\u0015Ig\u000eZ3y\u0003\u0019Ig\u000eZ3yAQ1!Q\u0012BI\u0005'\u00032Aa$'\u001b\u0005\u0001\u0003B\u0002BBW\u0001\u0007\u0001\u0010C\u0004\u0003\b.\u0002\r!!\u0013\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005\u001b\u0013IJa'\t\u0011\t\rE\u0006%AA\u0002aD\u0011Ba\"-!\u0003\u0005\r!!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0015\u0016\u0004q\n\r6F\u0001BS!\u0011\u00119Ka,\u000e\u0005\t%&\u0002\u0002BV\u0005[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005=|\u0016\u0002\u0002BY\u0005S\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa.+\t\u0005%#1U\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0019Bd!\u0011\t9Aa1\n\u0007\t\u0015wLA\u0002B]fD\u0011\"!\u00112\u0003\u0003\u0005\r!!\u0013\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!4\u0011\r\t='Q\u001bBa\u001b\t\u0011\tNC\u0002\u0003T~\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119N!5\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005;\u0014\u0019\u000f\u0005\u0003\u0002\b\t}\u0017b\u0001Bq?\n9!i\\8mK\u0006t\u0007\"CA!g\u0005\u0005\t\u0019\u0001Ba\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t=$\u0011\u001e\u0005\n\u0003\u0003\"\u0014\u0011!a\u0001\u0003\u0013\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0013\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005_\na!Z9vC2\u001cH\u0003\u0002Bo\u0005oD\u0011\"!\u00118\u0003\u0003\u0005\rA!1\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005\u001fK4#B\u001d\u0003\u0000\nM\u0003#CB\u0001\u0007\u000fA\u0018\u0011\nBG\u001b\t\u0019\u0019AC\u0002\u0004\u0006}\u000bqA];oi&lW-\u0003\u0003\u0004\n\r\r!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!1`\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005\u001b\u001b\tba\u0005\t\r\t\rE\b1\u0001y\u0011\u001d\u00119\t\u0010a\u0001\u0003\u0013\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u001a\r\u0005\u0002CBA\u0004\u00077\u0019y\"C\u0002\u0004\u001e}\u0013aa\u00149uS>t\u0007cBA\u0004\u0003KB\u0018\u0011\n\u0005\n\u0007Gi\u0014\u0011!a\u0001\u0005\u001b\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019I\u0003\u0005\u0003\u0002Z\u000e-\u0012\u0002BB\u0017\u00037\u0014aa\u00142kK\u000e$HCDA\u001d\u0007c\u0019\u0019d!\u000e\u00048\re21\b\u0005\b\u0003\u0017{\u0004\u0019AAG\u0011\u001d\t9j\u0010a\u0001\u00033Ca!!\u0016@\u0001\u0004)\u0007\"\u0002<@\u0001\u0004A\bbBA\u0001\u007f\u0001\u0007\u0011Q\u0001\u0005\b\u0003'y\u0004\u0019AA\u0003\u0003\u0011aw.\u00193\u0015\u0019\u0005m1\u0011IB\"\u0007\u000b\u001a9e!\u0013\t\u000f\u0005-\u0005\t1\u0001\u0002\u000e\"9\u0011q\u0013!A\u0002\u0005e\u0005\"\u0002<A\u0001\u0004A\bbBA\u0001\u0001\u0002\u0007\u0011Q\u0001\u0005\b\u0003'\u0001\u0005\u0019AA\u0003)\u0019\tYb!\u0014\u0004P!9\u00111R!A\u0002\u00055\u0005bBAL\u0003\u0002\u0007\u0011\u0011\u0014\u0015\u0004\u00032d\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004X)\"\u0011Q\u0001BRQ\riB\u000e \u0015\u000491d\b")
public class LocalLDAModel
extends LDAModel
implements Serializable {
    private final Matrix topics;
    private final Vector docConcentration;
    private final double topicConcentration;
    private final double gammaShape;
    private long seed;

    public static LocalLDAModel load(SparkContext sc, String path) {
        return LocalLDAModel$.MODULE$.load(sc, path);
    }

    public Matrix topics() {
        return this.topics;
    }

    @Override
    public Vector docConcentration() {
        return this.docConcentration;
    }

    @Override
    public double topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public double gammaShape() {
        return this.gammaShape;
    }

    public long seed() {
        return this.seed;
    }

    public void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    @Override
    public int k() {
        return this.topics().numCols();
    }

    @Override
    public int vocabSize() {
        return this.topics().numRows();
    }

    @Override
    public Matrix topicsMatrix() {
        return this.topics();
    }

    @Override
    public Tuple2<int[], double[]>[] describeTopics(int maxTermsPerTopic) {
        DenseMatrix brzTopics = this.topics().asBreeze().toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        return (Tuple2[])package$.MODULE$.Range().apply(0, this.k()).map((Function1 & Serializable)topicIndex -> LocalLDAModel.$anonfun$describeTopics$1(brzTopics, maxTermsPerTopic, BoxesRunTime.unboxToInt((Object)topicIndex))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public long getSeed() {
        return this.seed();
    }

    public LocalLDAModel setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    @Override
    public void save(SparkContext sc, String path) {
        LocalLDAModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.topicsMatrix(), this.docConcentration(), this.topicConcentration(), this.gammaShape());
    }

    public double logLikelihood(RDD<Tuple2<Object, Vector>> documents) {
        return this.logLikelihoodBound(documents, this.docConcentration(), this.topicConcentration(), (DenseMatrix<Object>)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), this.gammaShape(), this.k(), this.vocabSize());
    }

    public double logLikelihood(JavaPairRDD<Long, Vector> documents) {
        return this.logLikelihood((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    public double logPerplexity(RDD<Tuple2<Object, Vector>> documents) {
        double corpusTokenCount = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logPerplexity$1(x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).sum();
        return -this.logLikelihood(documents) / corpusTokenCount;
    }

    public double logPerplexity(JavaPairRDD<Long, Vector> documents) {
        return this.logPerplexity((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private double logLikelihoodBound(RDD<Tuple2<Object, Vector>> documents, Vector alpha, double eta, DenseMatrix<Object> lambda, double gammaShape, int k, long vocabSize) {
        DenseVector brzAlpha = alpha.asBreeze().toDenseVector$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        DenseMatrix Elogbeta = (DenseMatrix)LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)lambda.t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose());
        Broadcast ElogbetaBc = documents.sparkContext().broadcast((Object)Elogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        long gammaSeed = this.seed();
        double corpusPart = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalLDAModel.$anonfun$logLikelihoodBound$1(x$3))).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logLikelihoodBound$2(ElogbetaBc, brzAlpha, gammaShape, k, gammaSeed, x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).sum();
        ElogbetaBc.destroy();
        double sumEta = eta * (double)vocabSize;
        double topicsPart = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)eta))).$minus(lambda, DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())).$times$colon$times((Object)Elogbeta, DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply(lambda, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())))).$minus((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(eta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)), DenseMatrix$.MODULE$.op_DM_S_Double_OpSub()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(sumEta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)))).$minus(package.lgamma$.MODULE$.apply(sum$.MODULE$.apply(lambda.apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows())), sum$.MODULE$.vectorizeCols_Double(sum$.MODULE$.helper_Double())), Transpose$.MODULE$.liftUFunc(package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))), DenseVector$.MODULE$.liftDMOpToDVTransposeOp(DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues())));
        return corpusPart + topicsPart;
    }

    public RDD<Tuple2<Object, Vector>> topicDistributions(RDD<Tuple2<Object, Vector>> documents) {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())));
        Broadcast expElogbetaBc = documents.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return documents.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            long id = tuple22._1$mcJ$sp();
            Vector termCounts = (Vector)tuple22._2();
            if (!true) throw new MatchError((Object)tuple22);
            long l = id;
            if (termCounts == null) throw new MatchError((Object)tuple22);
            Vector vector = termCounts;
            if (vector.numNonzeros() == 0) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.zeros(k));
                return tuple2;
            } else {
                DenseVector gamma;
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)expElogbetaBc.value()), docConcentrationBrz, gammaShape, k, gammaSeed + l);
                if (tuple3 == null) throw new MatchError(tuple3);
                DenseVector denseVector = gamma = (DenseVector)tuple3._1();
                DenseVector gamma2 = denseVector;
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double())));
            }
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Vector topicDistribution(Vector document) {
        Vector vector;
        long gammaSeed = this.seed();
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())));
        if (document.numNonzeros() == 0) {
            vector = Vectors$.MODULE$.zeros(this.k());
        } else {
            DenseVector gamma;
            Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(document, (DenseMatrix<Object>)expElogbeta, this.docConcentration().asBreeze(), this.gammaShape(), this.k(), gammaSeed);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            DenseVector denseVector = gamma = (DenseVector)tuple3._1();
            DenseVector gamma2 = denseVector;
            vector = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double()));
        }
        return vector;
    }

    public JavaPairRDD<Long, Vector> topicDistributions(JavaPairRDD<Long, Vector> documents) {
        RDD<Tuple2<Object, Vector>> distributions = this.topicDistributions((RDD<Tuple2<Object, Vector>>)documents.rdd());
        return JavaPairRDD$.MODULE$.fromRDD(distributions, ClassTag$.MODULE$.apply(Long.class), ClassTag$.MODULE$.apply(Vector.class));
    }

    public static final /* synthetic */ double $anonfun$describeTopics$2(Tuple2 x$1) {
        return -x$1._1$mcD$sp();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeTopics$1(DenseMatrix brzTopics$1, int maxTermsPerTopic$1, int topicIndex) {
        DenseVector topic = (DenseVector)normalize$.MODULE$.apply(brzTopics$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)topicIndex), DenseMatrix$.MODULE$.canSliceCol()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
        Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(topic.toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double())))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$describeTopics$2(x$1)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), maxTermsPerTopic$1)), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Int());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] termWeights = (double[])tuple2._1();
        int[] terms = (int[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)termWeights, (Object)terms);
        Tuple2 tuple23 = tuple22;
        double[] termWeights2 = (double[])tuple23._1();
        int[] terms2 = (int[])tuple23._2();
        return new Tuple2((Object)terms2, (Object)termWeights2);
    }

    public static final /* synthetic */ double $anonfun$logPerplexity$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector termCounts = (Vector)tuple2._2();
        double d = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(termCounts.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$logLikelihoodBound$1(Tuple2 x$3) {
        return ((Vector)x$3._2()).numNonzeros() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ double $anonfun$logLikelihoodBound$2(Broadcast ElogbetaBc$1, DenseVector brzAlpha$1, double gammaShape$1, int k$1, long gammaSeed$1, Tuple2 x0$1) {
        DenseVector denseVector;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        long id = tuple2._1$mcJ$sp();
        Vector termCounts = (Vector)tuple2._2();
        if (!true) throw new MatchError((Object)tuple2);
        long l = id;
        if (termCounts == null) throw new MatchError((Object)tuple2);
        Vector vector = termCounts;
        DenseMatrix localElogbeta = (DenseMatrix)ElogbetaBc$1.value();
        DoubleRef docBound = DoubleRef.create((double)0.0);
        Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)package.exp$.MODULE$.apply((Object)localElogbeta, package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())))), (breeze.linalg.Vector<Object>)brzAlpha$1, gammaShape$1, k$1, gammaSeed$1 + l);
        if (tuple3 == null) throw new MatchError(tuple3);
        DenseVector gammad = (DenseVector)tuple3._1();
        if (gammad == null) throw new MatchError(tuple3);
        DenseVector denseVector2 = denseVector = gammad;
        DenseVector gammad2 = denseVector2;
        DenseVector<Object> Elogthetad = LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad2);
        vector.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(x0$2, x1$1) -> {
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
            if (sp2 != null) {
                int idx = sp2._1$mcI$sp();
                double count = sp2._2$mcD$sp();
                docBound$1.elem += count * LDAUtils$.MODULE$.logSumExp((DenseVector<Object>)((DenseVector)Elogthetad.$plus(((ImmutableNumericOps)localElogbeta.apply((Object)BoxesRunTime.boxToInteger((int)idx), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), DenseVector$.MODULE$.canAddD())));
            } else {
                throw new MatchError((Object)sp2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)brzAlpha$1.$minus((Object)gammad2, DenseVector$.MODULE$.canSubD())).$times$colon$times(Elogthetad, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply((Object)gammad2, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())))).$minus(package.lgamma$.MODULE$.apply((Object)brzAlpha$1, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.canSubD()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        docBound.elem += package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)brzAlpha$1, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$) - package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)gammad2, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$);
        return docBound.elem;
    }

    public LocalLDAModel(Matrix topics, Vector docConcentration, double topicConcentration, double gammaShape) {
        this.topics = topics;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.gammaShape = gammaShape;
        this.seed = Utils$.MODULE$.random().nextLong();
    }
}

