/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix$;
import breeze.linalg.NumericOps;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapView;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u0015*\u0001YB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\tG\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\r\u0001BC\u0002\u0013\u0005a\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003T\u0011!Q\u0007A!b\u0001\n\u00031\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u00119\u0004!\u00111A\u0005\n=D\u0001b\u001d\u0001\u0003\u0002\u0004%I\u0001\u001e\u0005\tu\u0002\u0011\t\u0011)Q\u0005a\"A1\u0010\u0001BA\u0002\u0013%q\u000e\u0003\u0005}\u0001\t\u0005\r\u0011\"\u0003~\u0011!y\bA!A!B\u0013\u0001\bbBA\u0001\u0001\u0011\u0005\u00111A\u0003\u0006\u00033\u0001Aa\u0014\u0005\b\u0003\u0003\u0001A\u0011AA\u000e\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\u000b\u0001\t\u0003\n9\u0003\u0003\u0005\u00020\u0001\u0011\r\u0011\"\u0001g\u0011\u001d\t\u0019\u0004\u0001Q\u0001\nMC\u0001\"a\u000e\u0001\u0005\u0004%\tA\u001a\u0005\b\u0003w\u0001\u0001\u0015!\u0003T\u0011!\ty\u0004\u0001C\u0001[\u0005\u0005\u0003BCA%\u0001!\u0015\r\u0011\"\u0003\u0002L!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA+\u0001\u0011\u0005\u00111\u000b\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005\u0002CAN\u0001\u0011\u0005Q&!(\t\u0011\u0005M\u0006\u0001\"\u0001.\u0003kCq!!3\u0001\t\u0003\tY\rC\u0004\u0002R\u0002!\t!a5\u0006\r\u0005u\u0007\u0001BAp\u0011!\tY\u0010\u0001C\u0001S\u0005u\bb\u0002B\u0007\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u001b\u0001A\u0011\u0001B\u000b\u0005-\u0011En\\2l\u001b\u0006$(/\u001b=\u000b\u0005)Z\u0013a\u00033jgR\u0014\u0018NY;uK\u0012T!\u0001L\u0017\u0002\r1Lg.\u00197h\u0015\tqs&A\u0003nY2L'M\u0003\u00021c\u0005)1\u000f]1sW*\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001c>\u0003B\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\u0004\"AP \u000e\u0003%J!\u0001Q\u0015\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u0007\u0010\u0005\u0002C\u000b6\t1I\u0003\u0002E_\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002G\u0007\n9Aj\\4hS:<\u0017A\u00022m_\u000e\\7/F\u0001J!\rQUjT\u0007\u0002\u0017*\u0011AjL\u0001\u0004e\u0012$\u0017B\u0001(L\u0005\r\u0011F\t\u0012\t\u0005qA\u0013f+\u0003\u0002Rs\t1A+\u001e9mKJ\u0002B\u0001\u000f)T'B\u0011\u0001\bV\u0005\u0003+f\u00121!\u00138u!\t9\u0006,D\u0001,\u0013\tI6F\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0015\u0004\u0003m\u000b\u0007C\u0001/`\u001b\u0005i&B\u000100\u0003)\tgN\\8uCRLwN\\\u0005\u0003Av\u0013QaU5oG\u0016\f\u0013AY\u0001\u0006c9\u001ad\u0006M\u0001\bE2|7m[:!Q\r\u00111,Y\u0001\re><8\u000fU3s\u00052|7m[\u000b\u0002'\"\u001a1aW1\u0002\u001bI|wo\u001d)fe\ncwnY6!Q\r!1,Y\u0001\rG>d7\u000fU3s\u00052|7m\u001b\u0015\u0004\u000bm\u000b\u0017!D2pYN\u0004VM\u001d\"m_\u000e\\\u0007\u0005K\u0002\u00077\u0006\fQA\u001c*poN,\u0012\u0001\u001d\t\u0003qEL!A]\u001d\u0003\t1{gnZ\u0001\n]J{wo]0%KF$\"!\u001e=\u0011\u0005a2\u0018BA<:\u0005\u0011)f.\u001b;\t\u000feD\u0011\u0011!a\u0001a\u0006\u0019\u0001\u0010J\u0019\u0002\r9\u0014vn^:!\u0003\u0015q7i\u001c7t\u0003%q7i\u001c7t?\u0012*\u0017\u000f\u0006\u0002v}\"9\u0011pCA\u0001\u0002\u0004\u0001\u0018A\u00028D_2\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\r\u0003\u000b\t9!a\u0003\u0002\u0010\u0005M\u0011Q\u0003\t\u0003}\u0001AQaR\u0007A\u0002%CC!a\u0002\\C\")Q-\u0004a\u0001'\"\"\u00111B.b\u0011\u0015QW\u00021\u0001TQ\u0011\tyaW1\t\u000b9l\u0001\u0019\u00019\t\u000bml\u0001\u0019\u00019)\u00075Y\u0016MA\u0006NCR\u0014\u0018\u000e\u001f\"m_\u000e\\G\u0003CA\u0003\u0003;\ty\"!\t\t\u000b\u001d{\u0001\u0019A%\t\u000b\u0015|\u0001\u0019A*\t\u000b)|\u0001\u0019A*)\u0007=Y\u0016-A\u0004ok6\u0014vn^:\u0015\u0003AD3\u0001E.b\u0003\u001dqW/\\\"pYND3!E.b\u00031qW/\u001c*po\ncwnY6tQ\r\u00112,Y\u0001\u000e]Vl'k\\<CY>\u001c7n\u001d\u0011)\u0007MY\u0016-\u0001\u0007ok6\u001cu\u000e\u001c\"m_\u000e\\7\u000fK\u0002\u00157\u0006\fQB\\;n\u0007>d'\t\\8dWN\u0004\u0003fA\u000b\\C\u0006\t2M]3bi\u0016\u0004\u0016M\u001d;ji&|g.\u001a:\u0015\u0005\u0005\r\u0003c\u0001 \u0002F%\u0019\u0011qI\u0015\u0003\u001f\u001d\u0013\u0018\u000e\u001a)beRLG/[8oKJ\f\u0011B\u00197pG.LeNZ8\u0016\u0005\u00055\u0003\u0003\u0002&N\u0003\u001f\u0002B\u0001\u000f)S%\u0006YQm\u001d;j[\u0006$X\rR5n)\u0005)\u0018\u0001\u0003<bY&$\u0017\r^3)\u0007eY\u0016-A\u0003dC\u000eDW\r\u0006\u0002\u0002^5\t\u0001\u0001K\u0002\u001b7\u0006\fq\u0001]3sg&\u001cH\u000f\u0006\u0003\u0002^\u0005\u0015\u0004bBA47\u0001\u0007\u0011\u0011N\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN\u0018\u0002\u000fM$xN]1hK&!\u00111OA7\u00051\u0019Fo\u001c:bO\u0016dUM^3mQ\rY2,Y\u0001\u0013i>\u001cun\u001c:eS:\fG/Z'biJL\u0007\u0010\u0006\u0002\u0002|A\u0019a(! \n\u0007\u0005}\u0014F\u0001\tD_>\u0014H-\u001b8bi\u0016l\u0015\r\u001e:jq\"\u001aAdW1\u0002%Q|\u0017J\u001c3fq\u0016$'k\\<NCR\u0014\u0018\u000e\u001f\u000b\u0003\u0003\u000f\u00032APAE\u0013\r\tY)\u000b\u0002\u0011\u0013:$W\r_3e%><X*\u0019;sSbD3!H.b\u00035!x\u000eT8dC2l\u0015\r\u001e:jqR\ta\u000bK\u0002\u001f7\u0006\f\u0011\u0002\u001e:b]N\u0004xn]3\u0016\u0005\u0005\u0015\u0001fA\u0010\\C\u0006AAo\u001c\"sK\u0016TX\r\u0006\u0002\u0002 B1\u0011\u0011UAU\u0003[k!!a)\u000b\u00071\n)K\u0003\u0002\u0002(\u00061!M]3fu\u0016LA!a+\u0002$\nYA)\u001a8tK6\u000bGO]5y!\rA\u0014qV\u0005\u0004\u0003cK$A\u0002#pk\ndW-\u0001\u0005cY>\u001c7.T1q)\u0019\t)!a.\u0002<\"9\u0011\u0011X\u0011A\u0002\u0005\u0015\u0011!B8uQ\u0016\u0014\bbBA_C\u0001\u0007\u0011qX\u0001\u0007E&tW*\u00199\u0011\u0013a\n\t-!2\u0002F\u0006\u0015\u0017bAAbs\tIa)\u001e8di&|gN\r\t\u0007\u0003C\u000b9-!,\n\u0007e\u000b\u0019+A\u0002bI\u0012$B!!\u0002\u0002N\"9\u0011\u0011\u0018\u0012A\u0002\u0005\u0015\u0001f\u0001\u0012\\C\u0006A1/\u001e2ue\u0006\u001cG\u000f\u0006\u0003\u0002\u0006\u0005U\u0007bBA]G\u0001\u0007\u0011Q\u0001\u0015\u0005Gm\u000bI.\t\u0002\u0002\\\u0006)!G\f\u0019/a\t\t\"\t\\8dW\u0012+7\u000f^5oCRLwN\\:\u0011\u000f\u0005\u0005\u0018q\u001e*\u0002v:!\u00111]Av!\r\t)/O\u0007\u0003\u0003OT1!!;6\u0003\u0019a$o\\8u}%\u0019\u0011Q^\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t0a=\u0003\u00075\u000b\u0007OC\u0002\u0002nf\u0002R!!9\u0002xNKA!!?\u0002t\n\u00191+\u001a;\u0002!MLW.\u001e7bi\u0016lU\u000f\u001c;ja2LH\u0003CA\u0000\u0005\u0007\u0011)A!\u0003\u0011\ra\u0002&\u0011\u0001B\u0001!\r\ti\u0006\n\u0005\b\u0003s+\u0003\u0019AA\u0003\u0011\u001d\u00119!\na\u0001\u0003\u0007\n1\u0002]1si&$\u0018n\u001c8fe\"1!1B\u0013A\u0002M\u000ba\"\\5e\t&l7\u000b\u001d7ji:+X.\u0001\u0005nk2$\u0018\u000e\u001d7z)\u0011\t)A!\u0005\t\u000f\u0005ef\u00051\u0001\u0002\u0006!\u001aaeW1\u0015\r\u0005\u0015!q\u0003B\r\u0011\u001d\tIl\na\u0001\u0003\u000bAaAa\u0007(\u0001\u0004\u0019\u0016a\u00048v[6KG\rR5n'Bd\u0017\u000e^:)\t\u001dZ&qD\u0011\u0003\u0005C\tQA\r\u00183]AB3\u0001A.b\u0001")
public class BlockMatrix
implements DistributedMatrix,
Logging {
    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo;
    private final RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks;
    private final int rowsPerBlock;
    private final int colsPerBlock;
    private long nRows;
    private long nCols;
    private final int numRowBlocks;
    private final int numColBlocks;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks() {
        return this.blocks;
    }

    public int rowsPerBlock() {
        return this.rowsPerBlock;
    }

    public int colsPerBlock() {
        return this.colsPerBlock;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private long nCols() {
        return this.nCols;
    }

    private void nCols_$eq(long x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numRows() {
        block0: {
            if (this.nRows() > 0L) break block0;
            this.estimateDim();
        }
        return this.nRows();
    }

    @Override
    public long numCols() {
        block0: {
            if (this.nCols() > 0L) break block0;
            this.estimateDim();
        }
        return this.nCols();
    }

    public int numRowBlocks() {
        return this.numRowBlocks;
    }

    public int numColBlocks() {
        return this.numColBlocks;
    }

    public GridPartitioner createPartitioner() {
        return GridPartitioner$.MODULE$.apply(this.numRowBlocks(), this.numColBlocks(), this.blocks().partitions().length);
    }

    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo$lzycompute() {
        BlockMatrix blockMatrix = this;
        synchronized (blockMatrix) {
            if (!this.bitmap$0) {
                this.blockInfo = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1 & Serializable)block -> new Tuple2.mcII.sp(block.numRows(), block.numCols())).cache();
                this.bitmap$0 = true;
            }
        }
        return this.blockInfo;
    }

    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo() {
        return !this.bitmap$0 ? this.blockInfo$lzycompute() : this.blockInfo;
    }

    private void estimateDim() {
        Tuple2 tuple2 = (Tuple2)this.blockInfo().map((Function1 & Serializable)x0$1 -> {
            int blockColIndex;
            int blockRowIndex;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    blockRowIndex = tuple23._1$mcI$sp();
                    blockColIndex = tuple23._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int m = tuple2._1$mcI$sp();
            int n = tuple2._2$mcI$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)blockRowIndex * (long)this.rowsPerBlock() + (long)m, (long)blockColIndex * (long)this.colsPerBlock() + (long)n);
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2 & Serializable)(x0, x1) -> new Tuple2.mcJJ.sp(package$.MODULE$.max(x0._1$mcJ$sp(), x1._1$mcJ$sp()), package$.MODULE$.max(x0._2$mcJ$sp(), x1._2$mcJ$sp())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long rows = tuple2._1$mcJ$sp();
        long cols = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(rows, cols);
        Tuple2.mcJJ.sp sp3 = sp2;
        long rows2 = sp3._1$mcJ$sp();
        long cols2 = sp3._2$mcJ$sp();
        if (this.nRows() <= 0L) {
            this.nRows_$eq(rows2);
        }
        Predef$.MODULE$.assert(rows2 <= this.nRows(), (Function0 & Serializable)() -> new StringBuilder(42).append("The number of rows ").append(rows2).append(" is more than claimed ").append(this.nRows()).append(".").toString());
        if (this.nCols() <= 0L) {
            this.nCols_$eq(cols2);
        }
        Predef$.MODULE$.assert(cols2 <= this.nCols(), (Function0 & Serializable)() -> new StringBuilder(45).append("The number of columns ").append(cols2).append(" is more than claimed ").append(this.nCols()).append(".").toString());
    }

    public void validate() {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Validating BlockMatrix...");
        this.estimateDim();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "BlockMatrix dimensions are okay...");
        RDD$.MODULE$.rddToPairRDDFunctions(this.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).countByKey().foreach((Function1 & Serializable)x0$1 -> {
            BlockMatrix.$anonfun$validate$3(x0$1);
            return BoxedUnit.UNIT;
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "MatrixBlock indices are okay...");
        String dimensionMsg = new StringBuilder(0).append(new StringBuilder(46).append("dimensions different than rowsPerBlock: ").append(this.rowsPerBlock()).append(", and ").toString()).append(new StringBuilder(70).append("colsPerBlock: ").append(this.colsPerBlock()).append(". Blocks on the right and bottom edges can have smaller ").toString()).append("dimensions. You may use the repartition method to fix this issue.").toString();
        this.blockInfo().foreach((Function1 & Serializable)x0$2 -> {
            BlockMatrix.$anonfun$validate$5(this, dimensionMsg, x0$2);
            return BoxedUnit.UNIT;
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "MatrixBlock dimensions are okay...");
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "BlockMatrix is valid!");
    }

    public BlockMatrix cache() {
        this.blocks().cache();
        return this;
    }

    public BlockMatrix persist(StorageLevel storageLevel) {
        this.blocks().persist(storageLevel);
        return this;
    }

    public CoordinateMatrix toCoordinateMatrix() {
        RDD entryRDD = this.blocks().flatMap((Function1 & Serializable)x0$1 -> {
            Matrix mat;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    mat = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            long rowStart = (long)blockRowIndex * (long)this.rowsPerBlock();
            long colStart = (long)blockColIndex * (long)this.colsPerBlock();
            ArrayBuffer entryValues = new ArrayBuffer();
            mat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(i, j, v) -> {
                BlockMatrix.$anonfun$toCoordinateMatrix$2(entryValues, rowStart, colStart, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                return BoxedUnit.UNIT;
            });
            ArrayBuffer arrayBuffer = entryValues;
            return arrayBuffer;
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)entryRDD, this.numRows(), this.numCols());
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        int cols = (int)this.numCols();
        Predef$.MODULE$.require(cols < Integer.MAX_VALUE, (Function0 & Serializable)() -> new StringBuilder(58).append("The number of columns should be less than Int.MaxValue (").append(cols).append(").").toString());
        RDD rows = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks().flatMap((Function1 & Serializable)x0$1 -> {
            Matrix mat;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    mat = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIdx = tuple2._1$mcI$sp();
            int blockColIdx = tuple2._2$mcI$sp();
            Iterator iterator = mat.rowIter().zipWithIndex().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BlockMatrix.$anonfun$toIndexedRowMatrix$3(x$2))).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector vector = (Vector)tuple2._1();
                int rowIdx = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(blockRowIdx * this.rowsPerBlock() + rowIdx))), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)blockColIdx), (Object)vector));
                return tuple22;
            });
            return iterator;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1 & Serializable)x0$3 -> {
            Vector vector;
            int rowIdx;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                rowIdx = tuple2._1$mcI$sp();
                Iterable vectors = (Iterable)tuple2._2();
                int numberNonZero = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)vectors.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)BlockMatrix.$anonfun$toIndexedRowMatrix$6(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                double numberNonZeroPerRow = (double)numberNonZero / (double)cols;
                if (numberNonZeroPerRow <= 0.1) {
                    ArrayBuffer arrBufferIndices = new ArrayBuffer(numberNonZero);
                    ArrayBuffer arrBufferValues = new ArrayBuffer(numberNonZero);
                    vectors.foreach((Function1 & Serializable)x0$4 -> {
                        BlockMatrix.$anonfun$toIndexedRowMatrix$7(this, arrBufferIndices, arrBufferValues, x0$4);
                        return BoxedUnit.UNIT;
                    });
                    vector = Vectors$.MODULE$.sparse(cols, (int[])arrBufferIndices.toArray((ClassTag)ClassTag$.MODULE$.Int()), (double[])arrBufferValues.toArray((ClassTag)ClassTag$.MODULE$.Double()));
                } else {
                    DenseVector wholeVectorBuf = DenseVector$.MODULE$.zeros$mDc$sp(cols, (ClassTag)ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                    vectors.foreach((Function1 & Serializable)x0$5 -> {
                        int n;
                        Vector vec;
                        block3: {
                            Tuple2 tuple2;
                            block2: {
                                tuple2 = x0$5;
                                if (tuple2 == null) break block2;
                                int blockColIdx = tuple2._1$mcI$sp();
                                vec = (Vector)tuple2._2();
                                if (!true) break block2;
                                n = blockColIdx;
                                if (vec != null) break block3;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        Vector vector = vec;
                        int offset = this.colsPerBlock() * n;
                        DenseVector denseVector = (DenseVector)((NumericOps)wholeVectorBuf.apply((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(offset), Math.min(cols, offset + this.colsPerBlock())), DenseVector$.MODULE$.canSlice())).$colon$eq(vector.asBreeze(), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_InPlaceOp_Double_OpSet());
                        return denseVector;
                    });
                    vector = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)wholeVectorBuf);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Vector wholeVector = vector;
            IndexedRow indexedRow = new IndexedRow(rowIdx, wholeVector);
            return indexedRow;
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)rows);
    }

    public Matrix toLocalMatrix() {
        Predef$.MODULE$.require(this.numRows() < Integer.MAX_VALUE, (Function0 & Serializable)() -> new StringBuilder(54).append("The number of rows of this matrix should be less than ").append(new StringBuilder(33).append("Int.MaxValue. Currently numRows: ").append(this.numRows()).toString()).toString());
        Predef$.MODULE$.require(this.numCols() < Integer.MAX_VALUE, (Function0 & Serializable)() -> new StringBuilder(57).append("The number of columns of this matrix should be less than ").append(new StringBuilder(33).append("Int.MaxValue. Currently numCols: ").append(this.numCols()).toString()).toString());
        Predef$.MODULE$.require(this.numRows() * this.numCols() < Integer.MAX_VALUE, (Function0 & Serializable)() -> new StringBuilder(39).append("The length of the values array must be ").append(new StringBuilder(53).append("less than Int.MaxValue. Currently numRows * numCols: ").append(this.numRows() * this.numCols()).toString()).toString());
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        int mem = m * n / 125000;
        if (mem > 500) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Storing this matrix will require ").append(mem).append(" MiB of memory!").toString());
        }
        Tuple2[] localBlocks = (Tuple2[])this.blocks().collect();
        double[] values = new double[m * n];
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])localBlocks), (Function1 & Serializable)x0$1 -> {
            BlockMatrix.$anonfun$toLocalMatrix$5(this, m, values, x0$1);
            return BoxedUnit.UNIT;
        });
        return new DenseMatrix(m, n, values);
    }

    public BlockMatrix transpose() {
        RDD transposedBlocks = this.blocks().map((Function1 & Serializable)x0$1 -> {
            Matrix mat;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    mat = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(blockColIndex, blockRowIndex), (Object)mat.transpose());
            return tuple23;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)transposedBlocks, this.colsPerBlock(), this.rowsPerBlock(), this.nCols(), this.nRows());
    }

    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        Matrix localMat = this.toLocalMatrix();
        return new DenseMatrix.mcD.sp(localMat.numRows(), localMat.numCols(), localMat.toArray());
    }

    public BlockMatrix blockMap(BlockMatrix other, Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>> binMap) {
        Predef$.MODULE$.require(this.numRows() == other.numRows(), (Function0 & Serializable)() -> new StringBuilder(49).append("Both matrices must have the same number of rows. ").append(new StringBuilder(24).append("A.numRows: ").append(this.numRows()).append(", B.numRows: ").append(other.numRows()).toString()).toString());
        Predef$.MODULE$.require(this.numCols() == other.numCols(), (Function0 & Serializable)() -> new StringBuilder(52).append("Both matrices must have the same number of columns. ").append(new StringBuilder(24).append("A.numCols: ").append(this.numCols()).append(", B.numCols: ").append(other.numCols()).toString()).toString());
        if (this.rowsPerBlock() != other.rowsPerBlock() || this.colsPerBlock() != other.colsPerBlock()) {
            throw new SparkException("Cannot perform on matrices with different block dimensions");
        }
        RDD newBlocks = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).cogroup(other.blocks(), (Partitioner)this.createPartitioner()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            Tuple2 tuple24 = (Tuple2)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            int blockRowIndex = tuple23._1$mcI$sp();
            int blockColIndex = tuple23._2$mcI$sp();
            if (tuple24 == null) throw new MatchError((Object)tuple22);
            Iterable a = (Iterable)tuple24._1();
            Iterable b = (Iterable)tuple24._2();
            if (a.size() > 1) throw new SparkException(new StringBuilder(46).append("There are multiple MatrixBlocks with indices: ").append(new StringBuilder(25).append("(").append(blockRowIndex).append(", ").append(blockColIndex).append("). Please remove them.").toString()).toString());
            if (b.size() > 1) {
                throw new SparkException(new StringBuilder(46).append("There are multiple MatrixBlocks with indices: ").append(new StringBuilder(25).append("(").append(blockRowIndex).append(", ").append(blockColIndex).append("). Please remove them.").toString()).toString());
            }
            if (a.isEmpty()) {
                breeze.linalg.Matrix zeroBlock = Matrix$.MODULE$.zeros$mDc$sp(((Matrix)b.head()).numRows(), ((Matrix)b.head()).numCols(), (ClassTag)ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                breeze.linalg.Matrix result = (breeze.linalg.Matrix)binMap.apply((Object)zeroBlock, ((Matrix)b.head()).asBreeze());
                tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)result));
                return tuple2;
            } else if (b.isEmpty()) {
                tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), a.head());
                return tuple2;
            } else {
                breeze.linalg.Matrix result = (breeze.linalg.Matrix)binMap.apply(((Matrix)a.head()).asBreeze(), ((Matrix)b.head()).asBreeze());
                tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)result));
            }
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)newBlocks, this.rowsPerBlock(), this.colsPerBlock(), this.numRows(), this.numCols());
    }

    public BlockMatrix add(BlockMatrix other) {
        return this.blockMap(other, (Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>>)(Function2 & Serializable)(x, y) -> (breeze.linalg.Matrix)x.$plus(y, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd()));
    }

    public BlockMatrix subtract(BlockMatrix other) {
        return this.blockMap(other, (Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>>)(Function2 & Serializable)(x, y) -> (breeze.linalg.Matrix)x.$minus(y, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpSub()));
    }

    public Tuple2<Map<Tuple2<Object, Object>, Set<Object>>, Map<Tuple2<Object, Object>, Set<Object>>> simulateMultiply(BlockMatrix other, GridPartitioner partitioner, int midDimSplitNum) {
        Tuple2[] leftMatrix = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(this.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).keys().collect();
        Tuple2[] rightMatrix = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(other.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).keys().collect();
        MapView rightCounterpartsHelper = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])rightMatrix), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._1$mcI$sp())).mapValues((Function1 & Serializable)x$5 -> (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$5), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6._2$mcI$sp()), (ClassTag)ClassTag$.MODULE$.Int()));
        Map leftDestinations = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])leftMatrix), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int rowIndex = tuple2._1$mcI$sp();
            int colIndex = tuple2._2$mcI$sp();
            int[] rightCounterparts = (int[])rightCounterpartsHelper.getOrElse((Object)BoxesRunTime.boxToInteger((int)colIndex), (Function0 & Serializable)() -> Array$.MODULE$.emptyIntArray());
            int[] partitions = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(rightCounterparts), (Function1)(JFunction1.mcII.sp & Serializable)b -> partitioner.getPartition(new Tuple2.mcII.sp(rowIndex, b)), (ClassTag)ClassTag$.MODULE$.Int());
            int midDimSplitIndex = colIndex % midDimSplitNum;
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(rowIndex, colIndex), Predef$.MODULE$.wrapIntArray(partitions).toSet().map((Function1)(JFunction1.mcII.sp & Serializable)pid -> pid * midDimSplitNum + midDimSplitIndex));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        MapView leftCounterpartsHelper = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])leftMatrix), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7._2$mcI$sp())).mapValues((Function1 & Serializable)x$8 -> (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$8), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9._1$mcI$sp()), (ClassTag)ClassTag$.MODULE$.Int()));
        Map rightDestinations = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rightMatrix), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int rowIndex = tuple2._1$mcI$sp();
            int colIndex = tuple2._2$mcI$sp();
            int[] leftCounterparts = (int[])leftCounterpartsHelper.getOrElse((Object)BoxesRunTime.boxToInteger((int)rowIndex), (Function0 & Serializable)() -> Array$.MODULE$.emptyIntArray());
            int[] partitions = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(leftCounterparts), (Function1)(JFunction1.mcII.sp & Serializable)b -> partitioner.getPartition(new Tuple2.mcII.sp(b, colIndex)), (ClassTag)ClassTag$.MODULE$.Int());
            int midDimSplitIndex = rowIndex % midDimSplitNum;
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(rowIndex, colIndex), Predef$.MODULE$.wrapIntArray(partitions).toSet().map((Function1)(JFunction1.mcII.sp & Serializable)pid -> pid * midDimSplitNum + midDimSplitIndex));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new Tuple2((Object)leftDestinations, (Object)rightDestinations);
    }

    public BlockMatrix multiply(BlockMatrix other) {
        return this.multiply(other, 1);
    }

    public BlockMatrix multiply(BlockMatrix other, int numMidDimSplits) {
        Tuple2 tuple2;
        GridPartitioner resultPartitioner;
        Predef$.MODULE$.require(this.numCols() == other.numRows(), (Function0 & Serializable)() -> new StringBuilder(151).append("The number of columns of A and the number of rows ").append(new StringBuilder(53).append("of B must be equal. A.numCols: ").append(this.numCols()).append(", B.numRows: ").append(other.numRows()).append(". If you ").toString()).append("think they should be equal, try setting the dimensions of A and B explicitly while ").append("initializing them.").toString());
        Predef$.MODULE$.require(numMidDimSplits > 0, (Function0 & Serializable)() -> "numMidDimSplits should be a positive integer.");
        if (this.colsPerBlock() == other.rowsPerBlock()) {
            resultPartitioner = GridPartitioner$.MODULE$.apply(this.numRowBlocks(), other.numColBlocks(), package$.MODULE$.max(this.blocks().partitions().length, other.blocks().partitions().length));
            Tuple2<Map<Tuple2<Object, Object>, Set<Object>>, Map<Tuple2<Object, Object>, Set<Object>>> tuple22 = this.simulateMultiply(other, resultPartitioner, numMidDimSplits);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Map leftDestinations = (Map)tuple22._1();
            Map rightDestinations = (Map)tuple22._2();
            tuple2 = new Tuple2((Object)leftDestinations, (Object)rightDestinations);
        } else {
            throw new SparkException(new StringBuilder(51).append("colsPerBlock of A doesn't match rowsPerBlock of B. ").append(new StringBuilder(34).append("A.colsPerBlock: ").append(this.colsPerBlock()).append(", B.rowsPerBlock: ").append(other.rowsPerBlock()).toString()).toString());
        }
        Tuple2 tuple23 = tuple2;
        Map leftDestinations = (Map)tuple23._1();
        Map rightDestinations = (Map)tuple23._2();
        RDD flatA = this.blocks().flatMap((Function1 & Serializable)x0$1 -> {
            Matrix block;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    block = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            Set destinations = (Set)leftDestinations.getOrElse((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            Set set = (Set)destinations.map((Function1 & Serializable)j -> BlockMatrix.$anonfun$multiply$5(blockRowIndex, blockColIndex, block, BoxesRunTime.unboxToInt((Object)j)));
            return set;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD flatB = other.blocks().flatMap((Function1 & Serializable)x0$2 -> {
            Matrix block;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    block = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            Set destinations = (Set)rightDestinations.getOrElse((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            Set set = (Set)destinations.map((Function1 & Serializable)j -> BlockMatrix.$anonfun$multiply$8(blockRowIndex, blockColIndex, block, BoxesRunTime.unboxToInt((Object)j)));
            return set;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Partitioner intermediatePartitioner = new Partitioner(null, resultPartitioner, numMidDimSplits){
            private final GridPartitioner resultPartitioner$1;
            private final int numMidDimSplits$1;

            public int numPartitions() {
                return this.resultPartitioner$1.numPartitions() * this.numMidDimSplits$1;
            }

            public int getPartition(Object key) {
                return BoxesRunTime.unboxToInt((Object)key);
            }
            {
                this.resultPartitioner$1 = resultPartitioner$1;
                this.numMidDimSplits$1 = numMidDimSplits$1;
            }
        };
        RDD newBlocks = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(flatA, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Int$.MODULE$).cogroup(flatB, intermediatePartitioner).flatMap((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$3;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            Iterable a = (Iterable)tuple2._1();
            Iterable b = (Iterable)tuple2._2();
            Iterable iterable = (Iterable)a.flatMap((Function1 & Serializable)x0$4 -> {
                Tuple3 tuple3 = x0$4;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                int leftRowIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int leftColIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                Matrix leftBlock = (Matrix)tuple3._3();
                Iterable iterable = (Iterable)((IterableOps)b.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)BlockMatrix.$anonfun$multiply$11(leftColIndex, x$11)))).map((Function1 & Serializable)x0$5 -> {
                    DenseMatrix denseMatrix;
                    Tuple3 tuple3 = x0$5;
                    if (tuple3 == null) throw new MatchError((Object)tuple3);
                    int rightColIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    Matrix rightBlock = (Matrix)tuple3._3();
                    Matrix matrix = rightBlock;
                    if (matrix instanceof DenseMatrix) {
                        DenseMatrix denseMatrix2 = (DenseMatrix)matrix;
                        denseMatrix = leftBlock.multiply(denseMatrix2);
                    } else {
                        if (!(matrix instanceof SparseMatrix)) throw new SparkException(new StringBuilder(26).append("Unrecognized matrix type ").append(rightBlock.getClass()).append(".").toString());
                        SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                        denseMatrix = leftBlock.multiply(sparseMatrix.toDense());
                    }
                    DenseMatrix C = denseMatrix;
                    return new Tuple2((Object)new Tuple2.mcII.sp(leftRowIndex, rightColIndex), C.asBreeze());
                });
                return iterable;
            });
            return iterable;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Partitioner)resultPartitioner, (Function2 & Serializable)(a, b) -> (breeze.linalg.Matrix)a.$plus(b, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd())), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1 & Serializable)breeze -> Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)breeze));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)newBlocks, this.rowsPerBlock(), other.colsPerBlock(), this.numRows(), other.numCols());
    }

    public static final /* synthetic */ void $anonfun$validate$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 key = (Tuple2)tuple2._1();
            long cnt = tuple2._2$mcJ$sp();
            if (cnt > 1L) {
                throw new SparkException(new StringBuilder(37).append(new StringBuilder(54).append("Found multiple MatrixBlocks with the indices ").append(key).append(". Please ").toString()).append("remove blocks with duplicate indices.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$validate$5(BlockMatrix $this, String dimensionMsg$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        Tuple2 tuple23 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        int blockRowIndex = tuple22._1$mcI$sp();
        int blockColIndex = tuple22._2$mcI$sp();
        if (tuple23 == null) throw new MatchError((Object)tuple2);
        int m = tuple23._1$mcI$sp();
        int n = tuple23._2$mcI$sp();
        if (blockRowIndex < $this.numRowBlocks() - 1 && m != $this.rowsPerBlock() || blockRowIndex == $this.numRowBlocks() - 1 && (m <= 0 || m > $this.rowsPerBlock())) {
            throw new SparkException(new StringBuilder(0).append(new StringBuilder(28).append("The MatrixBlock at (").append(blockRowIndex).append(", ").append(blockColIndex).append(") has ").toString()).append(dimensionMsg$1).toString());
        }
        if (blockColIndex < $this.numColBlocks() - 1 && n != $this.colsPerBlock() || blockColIndex == $this.numColBlocks() - 1 && (n <= 0 || n > $this.colsPerBlock())) {
            throw new SparkException(new StringBuilder(0).append(new StringBuilder(28).append("The MatrixBlock at (").append(blockRowIndex).append(", ").append(blockColIndex).append(") has ").toString()).append(dimensionMsg$1).toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$toCoordinateMatrix$2(ArrayBuffer entryValues$1, long rowStart$1, long colStart$1, int i, int j, double v) {
        block0: {
            if (v == 0.0) break block0;
            entryValues$1.$plus$eq((Object)new MatrixEntry(rowStart$1 + (long)i, colStart$1 + (long)j, v));
        }
    }

    public static final /* synthetic */ boolean $anonfun$toIndexedRowMatrix$3(Tuple2 x$2) {
        return ((Vector)x$2._1()).size() > 0;
    }

    public static final /* synthetic */ int $anonfun$toIndexedRowMatrix$6(Tuple2 x$3) {
        return ((Vector)x$3._2()).numActives();
    }

    public static final /* synthetic */ void $anonfun$toIndexedRowMatrix$7(BlockMatrix $this, ArrayBuffer arrBufferIndices$1, ArrayBuffer arrBufferValues$1, Tuple2 x0$4) {
        int n;
        Vector vec;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$4;
                if (tuple2 == null) break block2;
                int blockColIdx = tuple2._1$mcI$sp();
                vec = (Vector)tuple2._2();
                if (!true) break block2;
                n = blockColIdx;
                if (vec != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Vector vector = vec;
        int offset = $this.colsPerBlock() * n;
        vector.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(colIdx, value) -> {
            arrBufferIndices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(offset + colIdx)));
            arrBufferValues$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)value));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$toLocalMatrix$6(int colOffset$1, int m$1, int rowOffset$1, double[] values$1, int i, int j, double v) {
        int indexOffset = (j + colOffset$1) * m$1 + rowOffset$1 + i;
        values$1[indexOffset] = v;
    }

    public static final /* synthetic */ void $anonfun$toLocalMatrix$5(BlockMatrix $this, int m$1, double[] values$1, Tuple2 x0$1) {
        Matrix submat;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$1;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                submat = (Matrix)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int blockRowIndex = tuple2._1$mcI$sp();
        int blockColIndex = tuple2._2$mcI$sp();
        int rowOffset = blockRowIndex * $this.rowsPerBlock();
        int colOffset = blockColIndex * $this.colsPerBlock();
        submat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(i, j, v) -> {
            BlockMatrix.$anonfun$toLocalMatrix$6(colOffset, m$1, rowOffset, values$1, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$multiply$5(int blockRowIndex$1, int blockColIndex$1, Matrix block$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)blockRowIndex$1), (Object)BoxesRunTime.boxToInteger((int)blockColIndex$1), (Object)block$1));
    }

    public static final /* synthetic */ Tuple2 $anonfun$multiply$8(int blockRowIndex$2, int blockColIndex$2, Matrix block$2, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)blockRowIndex$2), (Object)BoxesRunTime.boxToInteger((int)blockColIndex$2), (Object)block$2));
    }

    public static final /* synthetic */ boolean $anonfun$multiply$11(int leftColIndex$1, Tuple3 x$11) {
        return BoxesRunTime.unboxToInt((Object)x$11._1()) == leftColIndex$1;
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock, long nRows, long nCols) {
        this.blocks = blocks;
        this.rowsPerBlock = rowsPerBlock;
        this.colsPerBlock = colsPerBlock;
        this.nRows = nRows;
        this.nCols = nCols;
        Logging.$init$((Logging)this);
        this.numRowBlocks = (int)package$.MODULE$.ceil((double)this.numRows() * 1.0 / (double)rowsPerBlock);
        this.numColBlocks = (int)package$.MODULE$.ceil((double)this.numCols() * 1.0 / (double)colsPerBlock);
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock) {
        this(blocks, rowsPerBlock, colsPerBlock, 0L, 0L);
    }
}

