/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%c\u0001\u0002!B\u00011C\u0001\"\u0019\u0001\u0003\u0006\u0004%\tE\u0019\u0005\ts\u0002\u0011\t\u0011)A\u0005G\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005#\"Q\u0011Q\u0001\u0001\u0003\u0006\u0004%\t!a\u0002\t\u0015\u0005M\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0018\u0001\u0011)\u0019!C\u0001\u0003\u000fA!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011!\ty\u0002\u0001C\u0001\u0007\u0006\u0005\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\t)\u0006\u0001C\u0001\u0003/B!\"!\u0018\u0001\u0011\u000b\u0007I\u0011BA0\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000!9\u0011\u0011\u001a\u0001\u0005B\u0005-\u0007bBAp\u0001\u0011\u0005\u0013\u0011\u001d\u0005\b\u0003k\u0004A\u0011IA|\u0011\u001d\u0011\t\u0001\u0001C!\u0005\u00079qA!\u0003B\u0011\u0003\u0011YA\u0002\u0004A\u0003\"\u0005!Q\u0002\u0005\b\u0003?9B\u0011\u0001B\u0016\u0011\u001d\u0011ic\u0006C!\u0005_AqA!\u000f\u0018\t\u0003\u0012YDB\u0004\u0003D]\u0001qC!\u0012\t\u0013\tM3D!A!\u0002\u00139\u0006bBA\u00107\u0011\u0005!Q\u000b\u0004\u0007\u0005;ZBIa\u0018\t\u0011mt\"Q3A\u0005\u0002qD\u0011\"!\u0001\u001f\u0005#\u0005\u000b\u0011B)\t\u0015\u0005\u0015aD!f\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0014y\u0011\t\u0012)A\u0005\u0003\u0013A!\"a\u0006\u001f\u0005+\u0007I\u0011AA\u0004\u0011)\tYB\bB\tB\u0003%\u0011\u0011\u0002\u0005\b\u0003?qB\u0011\u0001B;\u0011%\tyNHA\u0001\n\u0003\u0011\t\tC\u0005\u0003\nz\t\n\u0011\"\u0001\u0003\f\"I!q\u0014\u0010\u0012\u0002\u0013\u0005!\u0011\u0015\u0005\n\u0005Ks\u0012\u0013!C\u0001\u0005CC\u0011Ba*\u001f\u0003\u0003%\tE!+\t\u0013\tUf$!A\u0005\u0002\u0005U\u0002\"\u0003B\\=\u0005\u0005I\u0011\u0001B]\u0011%\u0011yLHA\u0001\n\u0003\u0012\t\rC\u0005\u0003Pz\t\t\u0011\"\u0001\u0003R\"I!1\u001c\u0010\u0002\u0002\u0013\u0005#Q\u001c\u0005\n\u0005Ct\u0012\u0011!C!\u0005GD\u0011B!\u0001\u001f\u0003\u0003%\tE!:\t\u0013\t\u001dh$!A\u0005B\t%x!\u0003Bw7\u0005\u0005\t\u0012\u0002Bx\r%\u0011ifGA\u0001\u0012\u0013\u0011\t\u0010C\u0004\u0002 Q\"\tAa@\t\u0013\t\u0005A'!A\u0005F\t\u0015\b\"CB\u0001i\u0005\u0005I\u0011QB\u0002\u0011%\u0019Y\u0001NA\u0001\n\u0003\u001bi\u0001C\u0004\u0004 m!\tf!\t\u0007\r\r-r\u0003BB\u0017\u0011\u001d\tyB\u000fC\u0001\u0007_A\u0011ba\r;\u0005\u0004%IA!+\t\u0011\rU\"\b)A\u0005\u0005WCqA!\u000f;\t\u0003\u001a9\u0004C\u0005\u0004<]\t\t\u0011\"\u0003\u0004>\tQ\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fY*\u0011!iQ\u0001\u000be\u0016<'/Z:tS>t'B\u0001#F\u0003\tiGN\u0003\u0002G\u000f\u0006)1\u000f]1sW*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A'Y7B!ajT)X\u001b\u0005\t\u0015B\u0001)B\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+D\u0003\u0019a\u0017N\\1mO&\u0011ak\u0015\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u00059\u0003\u0001C\u0001(Z\u0013\tQ\u0016IA\u000eB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8QCJ\fWn\u001d\t\u00039~k\u0011!\u0018\u0006\u0003=\u000e\u000bA!\u001e;jY&\u0011\u0001-\u0018\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\t1\r\u0005\u0002e[:\u0011Qm\u001b\t\u0003M&l\u0011a\u001a\u0006\u0003Q.\u000ba\u0001\u0010:p_Rt$\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L\u0017A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\\5)\u0007\u0005\tx\u000f\u0005\u0002sk6\t1O\u0003\u0002u\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001c(!B*j]\u000e,\u0017%\u0001=\u0002\u000bErcG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005E<\u0018\u0001D2pK\u001a4\u0017nY5f]R\u001cX#A))\u0007\r\th0I\u0001\u0000\u0003\u0015\u0011d\u0006\r\u00181\u00035\u0019w.\u001a4gS\u000eLWM\u001c;tA!\u001aA!\u001d@\u0002\u0013%tG/\u001a:dKB$XCAA\u0005!\u0011\tY!!\u0004\u000e\u0003%L1!a\u0004j\u0005\u0019!u.\u001e2mK\"\u001aQ!]<\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002\u0007c^\fQa]2bY\u0016D3aB9x\u0003\u0019\u00198-\u00197fA!\u001a\u0001\"]<\u0002\rqJg.\u001b;?)%9\u00161EA\u0014\u0003W\ty\u0003C\u0003b\u0013\u0001\u00071\r\u000b\u0003\u0002$E<\b\"B>\n\u0001\u0004\t\u0006\u0006BA\u0014czDq!!\u0002\n\u0001\u0004\tI\u0001\u000b\u0003\u0002,E<\bbBA\f\u0013\u0001\u0007\u0011\u0011\u0002\u0015\u0005\u0003_\tx/A\u0006ok64U-\u0019;ve\u0016\u001cXCAA\u001c!\u0011\tY!!\u000f\n\u0007\u0005m\u0012NA\u0002J]RDCAC9\u0002@\u0005\u0012\u0011\u0011I\u0001\u0006g9\u0002d\u0006M\u0001\u0019g\u0016$\u0018+^1oi&dW\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cH\u0003BA$\u0003\u0013j\u0011\u0001\u0001\u0005\b\u0003\u0017Z\u0001\u0019AA'\u0003\u00151\u0018\r\\;f!\u0019\tY!a\u0014\u0002\n%\u0019\u0011\u0011K5\u0003\u000b\u0005\u0013(/Y=)\u0007-\tx/A\btKR\fV/\u00198uS2,7oQ8m)\u0011\t9%!\u0017\t\r\u0005-C\u00021\u0001dQ\ra\u0011o^\u0001\u000b?F,\u0018M\u001c;jY\u0016\u001cXCAA1!\u0019\tY!a\u0014\u0002N\u0005\u0001B.Y7cI\u0006\u0014\u0014+^1oi&dWm\u001d\u000b\u0004#\u0006\u001d\u0004bBA5\u001d\u0001\u0007\u0011\u0011B\u0001\u0007Y\u0006l'\rZ1\u0002!A\u0014X\rZ5diF+\u0018M\u001c;jY\u0016\u001cHcA)\u0002p!1\u0011\u0011O\bA\u0002E\u000b\u0001BZ3biV\u0014Xm\u001d\u0015\u0004\u001fEt\u0018a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003\u0013\tI\b\u0003\u0004\u0002rA\u0001\r!\u0015\u0015\u0004!Et\u0018!\u0003;sC:\u001chm\u001c:n)\u0011\t\t)a)\u0011\t\u0005\r\u0015Q\u0014\b\u0005\u0003\u000b\u000b9J\u0004\u0003\u0002\b\u0006Me\u0002BAE\u0003#sA!a#\u0002\u0010:\u0019a-!$\n\u0003)K!\u0001S%\n\u0005\u0019;\u0015bAAK\u000b\u0006\u00191/\u001d7\n\t\u0005e\u00151T\u0001\ba\u0006\u001c7.Y4f\u0015\r\t)*R\u0005\u0005\u0003?\u000b\tKA\u0005ECR\fgI]1nK*!\u0011\u0011TAN\u0011\u001d\t)+\u0005a\u0001\u0003O\u000bq\u0001Z1uCN,G\u000f\r\u0003\u0002*\u0006U\u0006CBAV\u0003[\u000b\t,\u0004\u0002\u0002\u001c&!\u0011qVAN\u0005\u001d!\u0015\r^1tKR\u0004B!a-\u000262\u0001A\u0001DA\\\u0003G\u000b\t\u0011!A\u0003\u0002\u0005e&aA0%eE!\u00111XAa!\u0011\tY!!0\n\u0007\u0005}\u0016NA\u0004O_RD\u0017N\\4\u0011\t\u0005-\u00111Y\u0005\u0004\u0003\u000bL'aA!os\"\u001a\u0011#\u001d@\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!!4\u0002ZB!\u0011qZAk\u001b\t\t\tN\u0003\u0003\u0002T\u0006m\u0015!\u0002;za\u0016\u001c\u0018\u0002BAl\u0003#\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\tYN\u0005a\u0001\u0003\u001b\faa]2iK6\f\u0007f\u0001\nro\u0006!1m\u001c9z)\r9\u00161\u001d\u0005\b\u0003K\u001c\u0002\u0019AAt\u0003\u0015)\u0007\u0010\u001e:b!\u0011\tI/a<\u000e\u0005\u0005-(bAAw\u0007\u0006)\u0001/\u0019:b[&!\u0011\u0011_Av\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bfA\nro\u0006)qO]5uKV\u0011\u0011\u0011 \t\u00049\u0006m\u0018bAA\u007f;\nAQ\nT,sSR,'\u000fK\u0002\u0015c^\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002G\"\"Q#]A Q\r\u0001\u0011o^\u0001\u001b\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003\u001d^\u0019ra\u0006B\b\u0005+\u0011Y\u0002\u0005\u0003\u0002\f\tE\u0011b\u0001B\nS\n1\u0011I\\=SK\u001a\u0004B\u0001\u0018B\f/&\u0019!\u0011D/\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0003\u001e\t\u001dRB\u0001B\u0010\u0015\u0011\u0011\tCa\t\u0002\u0005%|'B\u0001B\u0013\u0003\u0011Q\u0017M^1\n\t\t%\"q\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005\u0017\tAA]3bIV\u0011!\u0011\u0007\t\u00059\nMr+C\u0002\u00036u\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u00043E<\u0018\u0001\u00027pC\u0012$2a\u0016B\u001f\u0011\u0019\u0011yD\u0007a\u0001G\u0006!\u0001/\u0019;iQ\rQ\u0012o\u001e\u0002!\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'oE\u0003\u001c\u0003s\u00149\u0005\u0005\u0003\u0003J\t=SB\u0001B&\u0015\r\u0011i%R\u0001\tS:$XM\u001d8bY&!!\u0011\u000bB&\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005/\u0012Y\u0006E\u0002\u0003Zmi\u0011a\u0006\u0005\u0007\u0005'j\u0002\u0019A,\u0003\t\u0011\u000bG/Y\n\b=\t=!\u0011\rB4!\u0011\tYAa\u0019\n\u0007\t\u0015\u0014NA\u0004Qe>$Wo\u0019;\u0011\t\t%$\u0011\u000f\b\u0005\u0005W\u0012yGD\u0002g\u0005[J\u0011A[\u0005\u0004\u00033K\u0017\u0002\u0002B\u0015\u0005gR1!!'j)!\u00119Ha\u001f\u0003~\t}\u0004c\u0001B==5\t1\u0004C\u0003|K\u0001\u0007\u0011\u000bC\u0004\u0002\u0006\u0015\u0002\r!!\u0003\t\u000f\u0005]Q\u00051\u0001\u0002\nQA!q\u000fBB\u0005\u000b\u00139\tC\u0004|MA\u0005\t\u0019A)\t\u0013\u0005\u0015a\u0005%AA\u0002\u0005%\u0001\"CA\fMA\u0005\t\u0019AA\u0005\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!$+\u0007E\u0013yi\u000b\u0002\u0003\u0012B!!1\u0013BN\u001b\t\u0011)J\u0003\u0003\u0003\u0018\ne\u0015!C;oG\",7m[3e\u0015\t!\u0018.\u0003\u0003\u0003\u001e\nU%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BRU\u0011\tIAa$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa+\u0011\t\t5&1W\u0007\u0003\u0005_SAA!-\u0003$\u0005!A.\u00198h\u0013\rq'qV\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\tMa/\t\u0013\tuF&!AA\u0002\u0005]\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003DB1!Q\u0019Bf\u0003\u0003l!Aa2\u000b\u0007\t%\u0017.\u0001\u0006d_2dWm\u0019;j_:LAA!4\u0003H\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\u0019N!7\u0011\t\u0005-!Q[\u0005\u0004\u0005/L'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005{s\u0013\u0011!a\u0001\u0003\u0003\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1\u0016Bp\u0011%\u0011ilLA\u0001\u0002\u0004\t9$\u0001\u0005iCND7i\u001c3f)\t\t9\u0004\u0006\u0002\u0003,\u00061Q-];bYN$BAa5\u0003l\"I!Q\u0018\u001a\u0002\u0002\u0003\u0007\u0011\u0011Y\u0001\u0005\t\u0006$\u0018\rE\u0002\u0003zQ\u001aR\u0001\u000eBz\u00057\u00012B!>\u0003|F\u000bI!!\u0003\u0003x5\u0011!q\u001f\u0006\u0004\u0005sL\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005{\u00149PA\tBEN$(/Y2u\rVt7\r^5p]N\"\"Aa<\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\t]4QAB\u0004\u0007\u0013AQa_\u001cA\u0002ECq!!\u00028\u0001\u0004\tI\u0001C\u0004\u0002\u0018]\u0002\r!!\u0003\u0002\u000fUt\u0017\r\u001d9msR!1qBB\u000e!\u0019\tYa!\u0005\u0004\u0016%\u001911C5\u0003\r=\u0003H/[8o!%\tYaa\u0006R\u0003\u0013\tI!C\u0002\u0004\u001a%\u0014a\u0001V;qY\u0016\u001c\u0004\"CB\u000fq\u0005\u0005\t\u0019\u0001B<\u0003\rAH\u0005M\u0001\tg\u00064X-S7qYR!11EB\u0015!\u0011\tYa!\n\n\u0007\r\u001d\u0012N\u0001\u0003V]&$\bB\u0002B s\u0001\u00071M\u0001\u0011B\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148c\u0001\u001e\u00032Q\u00111\u0011\u0007\t\u0004\u00053R\u0014!C2mCN\u001ch*Y7f\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u000b\u0004/\u000ee\u0002B\u0002B }\u0001\u00071-\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004@A!!QVB!\u0013\u0011\u0019\u0019Ea,\u0003\r=\u0013'.Z2uQ\r9\u0012o\u001e\u0015\u0004-E<\b")
public class AFTSurvivalRegressionModel
extends RegressionModel<Vector, AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private double[][] _quantiles;
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private Param<String> censorCol;
    private DoubleArrayParam quantileProbabilities;
    private Param<String> quantilesCol;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private BooleanParam fitIntercept;
    private DoubleParam tol;
    private IntParam maxIter;
    private volatile boolean bitmap$0;

    public static AFTSurvivalRegressionModel load(String path) {
        return AFTSurvivalRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.coefficients().size();
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        this.set(this.quantileProbabilities(), value);
        this._quantiles()[0] = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities())), (Function1)(JFunction1.mcDD.sp & Serializable)q -> scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) * this.scale()), (ClassTag)ClassTag$.MODULE$.Double());
        return this;
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    private double[][] _quantiles$lzycompute() {
        AFTSurvivalRegressionModel aFTSurvivalRegressionModel = this;
        synchronized (aFTSurvivalRegressionModel) {
            if (!this.bitmap$0) {
                this._quantiles = (double[][])((Object[])new double[][]{(double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities())), (Function1)(JFunction1.mcDD.sp & Serializable)q -> scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) * this.scale()), (ClassTag)ClassTag$.MODULE$.Double())});
                this.bitmap$0 = true;
            }
        }
        return this._quantiles;
    }

    private double[][] _quantiles() {
        return !this.bitmap$0 ? this._quantiles$lzycompute() : this._quantiles;
    }

    private Vector lambda2Quantiles(double lambda) {
        double[] quantiles = (double[])this._quantiles()[0].clone();
        int i = 0;
        while (i < quantiles.length) {
            int n = i++;
            quantiles[n] = quantiles[n] * lambda;
        }
        return Vectors$.MODULE$.dense(quantiles);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = this.predict(features);
        return this.lambda2Quantiles(lambda);
    }

    @Override
    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)package$.MODULE$.Seq().empty();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            Column predCol = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null))).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predCol.as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (this.hasQuantilesCol()) {
            Column column;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable)lambda -> this.lambda2Quantiles(BoxesRunTime.unboxToDouble((Object)lambda)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double()).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)predictionColumns.head()}));
            } else {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(null))).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column quanCol = column;
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.quantilesCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)quanCol.as(this.$(this.quantilesCol()), outputSchema.apply(this.$(this.quantilesCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append(new StringBuilder(53).append(this.uid()).append(": AFTSurvivalRegressionModel.transform() does nothing").toString()).append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = this.validateAndTransformSchema(schema, false);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.predictionCol()));
            }
            if (!this.isDefined(this.quantilesCol()) || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.quantilesCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.quantilesCol()), this.$(this.quantileProbabilities()).length);
        }
        return var2_2;
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(46).append("AFTSurvivalRegressionModel: uid=").append(this.uid()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
        Statics.releaseFence();
    }

    private static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            double d;
            Vector vector;
            Object scale;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    Some some;
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().parquet(dataPath);
                    row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block2;
                    Object coefficients = ((SeqOps)some.get()).apply(0);
                    Object intercept = ((SeqOps)some.get()).apply(1);
                    scale = ((SeqOps)some.get()).apply(2);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (!(intercept instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (scale instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
            Tuple3 tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
            Tuple3 tuple32 = tuple3;
            Vector coefficients = (Vector)tuple32._1();
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;
        private final AFTSurvivalRegressionModel instance;

        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                }
            }
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "coefficients";
                        break;
                    }
                    case 1: {
                        string = "intercept";
                        break;
                    }
                    case 2: {
                        string = "scale";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

