/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.RankingMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\t\u0012\u0001qA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u001d\u0002\u0011\u0019\u0011)A\u0006\u001f\")Q\u000b\u0001C\u0001-\")A\f\u0001C\u0001;\"Aq\u000e\u0001EC\u0002\u0013\u0005\u0001\u000fC\u0003s\u0001\u0011\u00051\u000fC\u0003y\u0001\u0011%\u0011\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011q\u0004\u0001\u0005\n\u0005\u0005raBA\u0018#!\u0005\u0011\u0011\u0007\u0004\u0007!EA\t!a\r\t\rUcA\u0011AA\"\u0011\u001d\t)\u0005\u0004C\u0001\u0003\u000fB\u0011\"! \r\u0003\u0003%I!a \u0003\u001dI\u000bgn[5oO6+GO]5dg*\u0011!cE\u0001\u000bKZ\fG.^1uS>t'B\u0001\u000b\u0016\u0003\u0015iG\u000e\\5c\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\u000b\u0003;\u0015\u001bB\u0001\u0001\u0010%UA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0015\u000e\u0003\u0019R!aJ\u000b\u0002\u0011%tG/\u001a:oC2L!!\u000b\u0014\u0003\u000f1{wmZ5oOB\u00111f\r\b\u0003YEr!!\f\u0019\u000e\u00039R!aL\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013B\u0001\u001a!\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001N\u001b\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005I\u0002\u0013a\u00059sK\u0012L7\r^5p]\u0006sG\rT1cK2\u001c\bc\u0001\u001d<{5\t\u0011H\u0003\u0002;+\u0005\u0019!\u000f\u001a3\n\u0005qJ$a\u0001*E\tB!qD\u0010!A\u0013\ty\u0004E\u0001\u0004UkBdWM\r\t\u0004?\u0005\u001b\u0015B\u0001\"!\u0005\u0015\t%O]1z!\t!U\t\u0004\u0001\u0005\u000b\u0019\u0003!\u0019A$\u0003\u0003Q\u000b\"\u0001S&\u0011\u0005}I\u0015B\u0001&!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\b'\n\u00055\u0003#aA!os\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007A\u001b6)D\u0001R\u0015\t\u0011\u0006%A\u0004sK\u001adWm\u0019;\n\u0005Q\u000b&\u0001C\"mCN\u001cH+Y4\u0002\rqJg.\u001b;?)\t96\f\u0006\u0002Y5B\u0019\u0011\fA\"\u000e\u0003EAQAT\u0002A\u0004=CQAN\u0002A\u0002]\n1\u0002\u001d:fG&\u001c\u0018n\u001c8BiR\u0011a,\u0019\t\u0003?}K!\u0001\u0019\u0011\u0003\r\u0011{WO\u00197f\u0011\u0015\u0011G\u00011\u0001d\u0003\u0005Y\u0007CA\u0010e\u0013\t)\u0007EA\u0002J]RD3\u0001B4n!\tA7.D\u0001j\u0015\tQW#\u0001\u0006b]:|G/\u0019;j_:L!\u0001\\5\u0003\u000bMKgnY3\"\u00039\fQ!\r\u00183]A\nA#\\3b]\u00063XM]1hKB\u0013XmY5tS>tW#\u00010)\u0007\u00159W.\u0001\fnK\u0006t\u0017I^3sC\u001e,\u0007K]3dSNLwN\\!u)\tqF\u000fC\u0003c\r\u0001\u00071\rK\u0002\u0007OZ\f\u0013a^\u0001\u0006g9\u0002d\u0006M\u0001\u0011CZ,'/Y4f!J,7-[:j_:$RA\u0018>}\u0003\u001bAQa_\u0004A\u0002\u0001\u000bA\u0001\u001d:fI\")Qp\u0002a\u0001}\u0006\u0019A.\u00192\u0011\t}\f9a\u0011\b\u0005\u0003\u0003\t\u0019\u0001\u0005\u0002.A%\u0019\u0011Q\u0001\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\u0003\u0003\u0007M+GOC\u0002\u0002\u0006\u0001BQAY\u0004A\u0002\r\faA\u001c3dO\u0006#Hc\u00010\u0002\u0014!)!\r\u0003a\u0001G\"\u001a\u0001bZ7\u0002\u0011I,7-\u00197m\u0003R$2AXA\u000e\u0011\u0015\u0011\u0017\u00021\u0001dQ\rIqM^\u0001\u0017G>,h\u000e\u001e*fY\u00164\u0018M\u001c;Ji\u0016l'+\u0019;j_RIa,a\t\u0002&\u0005\u001d\u0012\u0011\u0006\u0005\u0006w*\u0001\r\u0001\u0011\u0005\u0006{*\u0001\r\u0001\u0011\u0005\u0006E*\u0001\ra\u0019\u0005\u0007\u0003WQ\u0001\u0019A2\u0002\u0017\u0011,gn\\7j]\u0006$xN\u001d\u0015\u0004\u0001\u001dl\u0017A\u0004*b].LgnZ'fiJL7m\u001d\t\u000332\u0019B\u0001\u0004\u0010\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012AA5p\u0015\t\ty$\u0001\u0003kCZ\f\u0017b\u0001\u001b\u0002:Q\u0011\u0011\u0011G\u0001\u0003_\u001a,b!!\u0013\u0002P\u0005\u001dD\u0003BA&\u0003'\u0002B!\u0017\u0001\u0002NA\u0019A)a\u0014\u0005\r\u0005EcB1\u0001H\u0005\u0005)\u0005B\u0002\u001c\u000f\u0001\u0004\t)\u0006\u0005\u0004\u0002X\u0005}\u00131M\u0007\u0003\u00033RA!a\u0010\u0002\\)\u0019\u0011QL\u000b\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002b\u0005e#a\u0002&bm\u0006\u0014F\t\u0012\t\u0007?y\n)'!\u001a\u0011\u0007\u0011\u000b9\u0007\u0002\u0004G\u001d\t\u0007\u0011\u0011N\t\u0004\u0011\u0006-\u0004CBA7\u0003g\ni%\u0004\u0002\u0002p)!\u0011\u0011OA\u001f\u0003\u0011a\u0017M\\4\n\t\u0005U\u0014q\u000e\u0002\t\u0013R,'/\u00192mK\"\"abZA=C\t\tY(A\u00032]Qr\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002\u0002B!\u0011QNAB\u0013\u0011\t))a\u001c\u0003\r=\u0013'.Z2u\u0001")
public class RankingMetrics<T>
implements Logging,
Serializable {
    private double meanAveragePrecision;
    private final RDD<Tuple2<Object, Object>> predictionAndLabels;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static <E, T extends Iterable<E>> RankingMetrics<E> of(JavaRDD<Tuple2<T, T>> predictionAndLabels) {
        return RankingMetrics$.MODULE$.of(predictionAndLabels);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double precisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$precisionAt$2(this, k, x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
    }

    private double meanAveragePrecision$lzycompute() {
        RankingMetrics rankingMetrics = this;
        synchronized (rankingMetrics) {
            if (!this.bitmap$0) {
                this.meanAveragePrecision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecision$1(this, x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
                this.bitmap$0 = true;
            }
        }
        return this.meanAveragePrecision;
    }

    public double meanAveragePrecision() {
        return !this.bitmap$0 ? this.meanAveragePrecision$lzycompute() : this.meanAveragePrecision;
    }

    public double meanAveragePrecisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecisionAt$2(this, k, x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
    }

    private double averagePrecision(Object pred, Set<T> lab, int k) {
        double d;
        if (lab.nonEmpty()) {
            int cnt = 0;
            double precSum = 0.0;
            int n = package$.MODULE$.min(k, ScalaRunTime$.MODULE$.array_length(pred));
            for (int i = 0; i < n; ++i) {
                if (!lab.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                precSum += (double)(++cnt) / (double)(i + 1);
            }
            d = precSum / (double)package$.MODULE$.min(lab.size(), k);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Empty ground truth set, check input data");
            d = 0.0;
        }
        return d;
    }

    public double ndcgAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$ndcgAt$2(this, k, x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
    }

    public double recallAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$recallAt$2(this, k, x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
    }

    private double countRelevantItemRatio(Object pred, Object lab, int k, int denominator) {
        double d;
        Set labSet = Predef$.MODULE$.genericWrapArray(lab).toSet();
        if (labSet.nonEmpty()) {
            int n = package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(pred), k);
            int cnt = 0;
            for (int i = 0; i < n; ++i) {
                if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                ++cnt;
            }
            d = (double)cnt / (double)denominator;
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Empty ground truth set, check input data");
            d = 0.0;
        }
        return d;
    }

    public static final /* synthetic */ double $anonfun$precisionAt$2(RankingMetrics $this, int k$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object pred = tuple2._1();
        Object lab = tuple2._2();
        double d = $this.countRelevantItemRatio(pred, lab, k$1, k$1);
        return d;
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecision$1(RankingMetrics $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object pred = tuple2._1();
        Object lab = tuple2._2();
        Set labSet = Predef$.MODULE$.genericWrapArray(lab).toSet();
        int k = package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSet.size());
        double d = $this.averagePrecision(pred, labSet, k);
        return d;
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecisionAt$2(RankingMetrics $this, int k$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object pred = tuple2._1();
        Object lab = tuple2._2();
        double d = $this.averagePrecision(pred, Predef$.MODULE$.genericWrapArray(lab).toSet(), k$2);
        return d;
    }

    public static final /* synthetic */ double $anonfun$ndcgAt$2(RankingMetrics $this, int k$3, Tuple2 x0$1) {
        double d;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericWrapArray(lab).toSet();
            if (labSet.nonEmpty()) {
                int labSetSize = labSet.size();
                int n = package$.MODULE$.min(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSetSize), k$3);
                double maxDcg = 0.0;
                double dcg = 0.0;
                for (int i = 0; i < n; ++i) {
                    double gain = 1.0 / package$.MODULE$.log((double)(i + 2));
                    if (i < ScalaRunTime$.MODULE$.array_length(pred) && labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) {
                        dcg += gain;
                    }
                    if (i >= labSetSize) continue;
                    maxDcg += gain;
                }
                d = dcg / maxDcg;
            } else {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Empty ground truth set, check input data");
                d = 0.0;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        double d2 = d;
        return d2;
    }

    public static final /* synthetic */ double $anonfun$recallAt$2(RankingMetrics $this, int k$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object pred = tuple2._1();
        Object lab = tuple2._2();
        double d = $this.countRelevantItemRatio(pred, lab, k$4, Predef$.MODULE$.genericWrapArray(lab).toSet().size());
        return d;
    }

    public RankingMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels, ClassTag<T> evidence$1) {
        this.predictionAndLabels = predictionAndLabels;
        Logging.$init$((Logging)this);
    }
}

