/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\r\u001b\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tu\u0001\u0011\t\u0011)A\u0005]!)A\b\u0001C\u0001{!)A\b\u0001C\u0001\u0007\")q\t\u0001C\u0001\u0011\")q\t\u0001C\u00017\u001e)qM\u0007E\u0005Q\u001a)\u0011D\u0007E\u0005S\")A\b\u0003C\u0001U\u001a!1\u000e\u0003\u0001m\u0011!a#B!b\u0001\n\u0003i\u0003\u0002\u0003\u001e\u000b\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bqRA\u0011A=\t\u000fuT\u0001\u0019!C\u0005}\"I\u0011Q\u0001\u0006A\u0002\u0013%\u0011q\u0001\u0005\b\u0003'Q\u0001\u0015)\u0003\u0000\u0011-\t)B\u0003a\u0001\u0002\u0004%I!a\u0006\t\u0017\u0005\u001d\"\u00021AA\u0002\u0013%\u0011\u0011\u0006\u0005\f\u0003[Q\u0001\u0019!A!B\u0013\tI\u0002\u0003\u0004=\u0015\u0011\u0005\u0011q\u0006\u0005\b\u0003cQA\u0011AA\u001a\u0011\u001d\tYD\u0003C\u0001\u0003{Aq!a\u0011\u000b\t\u0013\t)\u0005C\u0004\u0002N)!\t!a\u0014\u0003\u0007%#eI\u0003\u0002\u001c9\u00059a-Z1ukJ,'BA\u000f\u001f\u0003\u0015iG\u000e\\5c\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017AC7j]\u0012{7M\u0012:fcV\ta\u0006\u0005\u0002(_%\u0011\u0001\u0007\u000b\u0002\u0004\u0013:$\bfA\u00013qA\u00111GN\u0007\u0002i)\u0011QGH\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u001c5\u0005\u0015\u0019\u0016N\\2fC\u0005I\u0014!B\u0019/e9\u0002\u0014aC7j]\u0012{7M\u0012:fc\u0002B3A\u0001\u001a9\u0003\u0019a\u0014N\\5u}Q\u0011a\b\u0011\t\u0003\u007f\u0001i\u0011A\u0007\u0005\u0006Y\r\u0001\rA\f\u0015\u0004\u0001JB\u0004fA\u00023qQ\ta\bK\u0002\u0005e\u0015\u000b\u0013AR\u0001\u0006c9\nd\u0006M\u0001\u0004M&$HCA%M!\ty$*\u0003\u0002L5\tA\u0011\n\u0012$N_\u0012,G\u000eC\u0003N\u000b\u0001\u0007a*A\u0004eCR\f7/\u001a;\u0011\u0007=\u0013F+D\u0001Q\u0015\t\tf$A\u0002sI\u0012L!a\u0015)\u0003\u0007I#E\t\u0005\u0002V16\taK\u0003\u0002X9\u00051A.\u001b8bY\u001eL!!\u0017,\u0003\rY+7\r^8sQ\r)!'\u0012\u000b\u0003\u0013rCQ!\u0014\u0004A\u0002u\u00032AX2U\u001b\u0005y&B\u00011b\u0003\u0011Q\u0017M^1\u000b\u0005\tt\u0012aA1qS&\u0011Am\u0018\u0002\b\u0015\u00064\u0018M\u0015#EQ\r1!'\u0012\u0015\u0004\u0001I*\u0015aA%E\rB\u0011q\bC\n\u0003\u0011\u0019\"\u0012\u0001\u001b\u0002\u001c\t>\u001cW/\\3oi\u001a\u0013X-];f]\u000eL\u0018iZ4sK\u001e\fGo\u001c:\u0014\u0007)1S\u000e\u0005\u0002om:\u0011q\u000e\u001e\b\u0003aNl\u0011!\u001d\u0006\u0003e\u0012\na\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005UD\u0013a\u00029bG.\fw-Z\u0005\u0003ob\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!!\u001e\u0015\u0015\u0005id\bCA>\u000b\u001b\u0005A\u0001\"\u0002\u0017\u000e\u0001\u0004q\u0013!A7\u0016\u0003}\u00042aJA\u0001\u0013\r\t\u0019\u0001\u000b\u0002\u0005\u0019>tw-A\u0003n?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001cA\u0014\u0002\f%\u0019\u0011Q\u0002\u0015\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003#y\u0011\u0011!a\u0001\u007f\u0006\u0019\u0001\u0010J\u0019\u0002\u00055\u0004\u0013A\u00013g+\t\tI\u0002E\u0003\u0002\u001c\u0005\rr0\u0004\u0002\u0002\u001e)\u0019q+a\b\u000b\u0005\u0005\u0005\u0012A\u00022sK\u0016TX-\u0003\u0003\u0002&\u0005u!a\u0003#f]N,g+Z2u_J\fa\u0001\u001a4`I\u0015\fH\u0003BA\u0005\u0003WA\u0011\"!\u0005\u0013\u0003\u0003\u0005\r!!\u0007\u0002\u0007\u00114\u0007\u0005F\u0001{\u0003\r\tG\r\u001a\u000b\u0005\u0003k\t9$D\u0001\u000b\u0011\u0019\tI$\u0006a\u0001)\u0006\u0019Am\\2\u0002\u000b5,'oZ3\u0015\t\u0005U\u0012q\b\u0005\u0007\u0003\u00032\u0002\u0019\u0001>\u0002\u000b=$\b.\u001a:\u0002\u000f%\u001cX)\u001c9usV\u0011\u0011q\t\t\u0004O\u0005%\u0013bAA&Q\t9!i\\8mK\u0006t\u0017aA5eMR\u0011\u0011\u0011\u000b\t\bO\u0005MC+a\u0016\u0000\u0013\r\t)\u0006\u000b\u0002\u0007)V\u0004H.Z\u001a\u0011\t\u001d\nIf`\u0005\u0004\u00037B#!B!se\u0006L\b")
public class IDF {
    private final int minDocFreq;

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public IDFModel fit(RDD<Vector> dataset) {
        long[] lArray;
        Vector vector;
        long numDocs;
        block3: {
            Tuple3<Vector, long[], Object> tuple3;
            block2: {
                int x$4;
                Function2 & Serializable x$3;
                Function2 & Serializable x$2;
                DocumentFrequencyAggregator x$1 = new DocumentFrequencyAggregator(this.minDocFreq());
                tuple3 = ((DocumentFrequencyAggregator)dataset.treeAggregate((Object)x$1, (Function2)(x$2 = (Function2 & Serializable)(df, v) -> df.add((Vector)v)), (Function2)(x$3 = (Function2 & Serializable)(df1, df2) -> df1.merge((DocumentFrequencyAggregator)df2)), x$4 = dataset.treeAggregate$default$4((Object)x$1), ClassTag$.MODULE$.apply(DocumentFrequencyAggregator.class))).idf();
                if (tuple3 == null) break block2;
                Vector idf = (Vector)tuple3._1();
                long[] docFreq = (long[])tuple3._2();
                numDocs = BoxesRunTime.unboxToLong((Object)tuple3._3());
                if (idf == null) break block2;
                vector = idf;
                if (docFreq == null) break block2;
                lArray = docFreq;
                if (true) break block3;
            }
            throw new MatchError(tuple3);
        }
        long l = numDocs;
        Tuple3 tuple3 = new Tuple3((Object)vector, (Object)lArray, (Object)BoxesRunTime.boxToLong((long)l));
        Tuple3 tuple32 = tuple3;
        Vector idf = (Vector)tuple32._1();
        long[] docFreq = (long[])tuple32._2();
        long numDocs2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
        return new IDFModel(idf, docFreq, numDocs2);
    }

    public IDFModel fit(JavaRDD<Vector> dataset) {
        return this.fit((RDD<Vector>)dataset.rdd());
    }

    public IDF(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public IDF() {
        this(0);
    }

    public static class DocumentFrequencyAggregator
    implements Serializable {
        private final int minDocFreq;
        private long m;
        private breeze.linalg.DenseVector<Object> df;

        public int minDocFreq() {
            return this.minDocFreq;
        }

        private long m() {
            return this.m;
        }

        private void m_$eq(long x$1) {
            this.m = x$1;
        }

        private breeze.linalg.DenseVector<Object> df() {
            return this.df;
        }

        private void df_$eq(breeze.linalg.DenseVector<Object> x$1) {
            this.df = x$1;
        }

        public DocumentFrequencyAggregator add(Vector doc) {
            DenseVector denseVector;
            Option<double[]> option;
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option2;
            Vector vector;
            if (this.isEmpty()) {
                this.df_$eq((breeze.linalg.DenseVector<Object>)breeze.linalg.DenseVector$.MODULE$.zeros$mJc$sp(doc.size(), (ClassTag)ClassTag$.MODULE$.Long(), (Zero)Zero.LongZero$.MODULE$));
            }
            if ((vector = doc) instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] values = (double[])((Tuple3)option2.get())._3();
                int nnz = indices.length;
                for (int k = 0; k < nnz; ++k) {
                    if (!(values[k] > 0.0)) continue;
                    breeze.linalg.DenseVector<Object> denseVector2 = this.df();
                    int n = indices[k];
                    denseVector2.update$mcJ$sp(n, denseVector2.apply$mcJ$sp(n) + 1L);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                double[] values = (double[])option.get();
                int n = values.length;
                for (int j = 0; j < n; ++j) {
                    if (!(values[j] > 0.0)) continue;
                    breeze.linalg.DenseVector<Object> denseVector3 = this.df();
                    int n2 = j;
                    denseVector3.update$mcJ$sp(n2, denseVector3.apply$mcJ$sp(n2) + 1L);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(53).append("Only sparse and dense vectors are supported but got ").append(vector.getClass()).append(".").toString());
            }
            this.m_$eq(this.m() + 1L);
            return this;
        }

        public DocumentFrequencyAggregator merge(DocumentFrequencyAggregator other) {
            Object object;
            if (!other.isEmpty()) {
                this.m_$eq(this.m() + other.m());
                if (this.df() == null) {
                    this.df_$eq((breeze.linalg.DenseVector<Object>)other.df().copy$mcJ$sp());
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.df().$plus$eq(other.df(), breeze.linalg.DenseVector$.MODULE$.dv_dv_UpdateOp_Long_OpAdd());
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return this;
        }

        private boolean isEmpty() {
            return this.m() == 0L;
        }

        public Tuple3<Vector, long[], Object> idf() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Haven't seen any document yet.");
            }
            int n = this.df().length();
            double[] inv = new double[n];
            long[] dfv = new long[n];
            for (int j = 0; j < n; ++j) {
                if (this.df().apply$mcJ$sp(j) < (long)this.minDocFreq()) continue;
                inv[j] = package$.MODULE$.log(((double)this.m() + 1.0) / ((double)this.df().apply$mcJ$sp(j) + 1.0));
                dfv[j] = this.df().apply$mcJ$sp(j);
            }
            return new Tuple3((Object)Vectors$.MODULE$.dense(inv), (Object)dfv, (Object)BoxesRunTime.boxToLong((long)this.m()));
        }

        public DocumentFrequencyAggregator(int minDocFreq) {
            this.minDocFreq = minDocFreq;
            this.m = 0L;
        }

        public DocumentFrequencyAggregator() {
            this(0);
        }
    }
}

