/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTClassifierParams;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.ClassificationLoss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUb\u0001\u0002\u001d:\u0001\u0011C\u0001b\u001d\u0001\u0003\u0006\u0004%\t\u0005\u001e\u0005\n\u0003\u001b\u0001!\u0011!Q\u0001\nUD!\"!\u0005\u0001\u0005\u000b\u0007I\u0011BA\n\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003?\u0001!Q1A\u0005\n\u0005\u0005\u0002BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002$!Q\u0011Q\u0006\u0001\u0003\u0006\u0004%\t%a\f\t\u0015\u0005e\u0002A!A!\u0002\u0013\t\t\u0004\u0003\u0006\u0002>\u0001\u0011)\u0019!C!\u0003_A!\"!\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA\u0019\u0011!\tI\u0005\u0001C\u0001w\u0005-\u0003\u0002CA%\u0001\u0011\u00051(!\u0018\t\u000f\u0005%\u0003\u0001\"\u0001\u0002h!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0001\"CA=\u0001\t\u0007I\u0011AA\u0018\u0011!\t\t\t\u0001Q\u0001\n\u0005E\u0002bBAC\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002p\u0002!\t%!=\t\u000f\u0005m\b\u0001\"\u0015\u0002~\"9!1\u0001\u0001\u0005B\t\u0015\u0001b\u0002B\r\u0001\u0011\u0005#1\u0004\u0005\u000b\u0005?\u0001\u0001R1A\u0005\u0002\t\u0005\u0002b\u0002B\u0013\u0001\u0011%!q\u0005\u0005\t\u0005W\u0001A\u0011A\u001e\u0003.!I!\u0011\t\u0001C\u0002\u0013%!1\t\u0005\t\u0005\u001f\u0002\u0001\u0015!\u0003\u0003F!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003b\u0002B4\u0001\u0011\u0005#\u0011N\u0004\b\u0005kJ\u0004\u0012\u0001B<\r\u0019A\u0014\b#\u0001\u0003z!9\u0011\u0011J\u0011\u0005\u0002\tU\u0005\u0002\u0003BLC\t\u0007I\u0011\u0002;\t\u000f\te\u0015\u0005)A\u0005k\"A!1T\u0011C\u0002\u0013%A\u000fC\u0004\u0003\u001e\u0006\u0002\u000b\u0011B;\t\u000f\t}\u0015\u0005\"\u0011\u0003\"\"9!1V\u0011\u0005B\t5fa\u0002B[C\u0001\t#q\u0017\u0005\n\u0005sK#\u0011!Q\u0001\n=Cq!!\u0013*\t\u0003\u0011Y\fC\u0004\u0003D&\"\tF!2\u0007\r\t=\u0017\u0005\u0002Bi\u0011\u001d\tI%\fC\u0001\u0005'D\u0011Ba6.\u0005\u0004%IA!7\t\u0011\t\u0015X\u0006)A\u0005\u00057D\u0011Ba:.\u0005\u0004%IA!7\t\u0011\t%X\u0006)A\u0005\u00057DqAa+.\t\u0003\u0012Y\u000f\u0003\u0005\u0003p\u0006\"\ta\u000fBy\u0011)\u0019y!II\u0001\n\u0003Y4\u0011\u0003\u0005\u000b\u0007K\t\u0013\u0013!C\u0001w\rE\u0001\"CB\u0014C\u0005\u0005I\u0011BB\u0015\u0005Y9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'B\u0001\u001e<\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!\u0001P\u001f\u0002\u00055d'B\u0001 @\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\u0004\u0001M1\u0001!\u0012)W?\u0016\u0004BAR$J\u001f6\t\u0011(\u0003\u0002Is\t\u0001\u0003K]8cC\nLG.[:uS\u000e\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tQU*D\u0001L\u0015\ta5(\u0001\u0004mS:\fGnZ\u0005\u0003\u001d.\u0013aAV3di>\u0014\bC\u0001$\u0001!\t\tF+D\u0001S\u0015\t\u00196(\u0001\u0003ue\u0016,\u0017BA+S\u0005M9%\tV\"mCN\u001c\u0018NZ5feB\u000b'/Y7t!\r\tv+W\u0005\u00031J\u0013\u0011\u0003\u0016:fK\u0016s7/Z7cY\u0016lu\u000eZ3m!\tQV,D\u0001\\\u0015\ta6(\u0001\u0006sK\u001e\u0014Xm]:j_:L!AX.\u00037\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t\u00017-D\u0001b\u0015\t\u00117(\u0001\u0003vi&d\u0017B\u00013b\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\t\u0003MBt!aZ7\u000f\u0005!\\W\"A5\u000b\u0005)\u001c\u0015A\u0002\u001fs_>$h(C\u0001m\u0003\u0015\u00198-\u00197b\u0013\tqw.A\u0004qC\u000e\\\u0017mZ3\u000b\u00031L!!\u001d:\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00059|\u0017aA;jIV\tQ\u000f\u0005\u0002wu:\u0011q\u000f\u001f\t\u0003Q>L!!_8\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003s>DC!\u0001@\u0002\nA\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0006'&t7-Z\u0011\u0003\u0003\u0017\tQ!\r\u00187]A\nA!^5eA!\"!A`A\u0005\u0003\u0019yFO]3fgV\u0011\u0011Q\u0003\t\u0006\u0003/\tI\"W\u0007\u0002_&\u0019\u00111D8\u0003\u000b\u0005\u0013(/Y=\u0002\u000f}#(/Z3tA\u0005aq\f\u001e:fK^+\u0017n\u001a5ugV\u0011\u00111\u0005\t\u0007\u0003/\tI\"!\n\u0011\t\u0005]\u0011qE\u0005\u0004\u0003Sy'A\u0002#pk\ndW-A\u0007`iJ,WmV3jO\"$8\u000fI\u0001\f]Vlg)Z1ukJ,7/\u0006\u0002\u00022A!\u0011qCA\u001a\u0013\r\t)d\u001c\u0002\u0004\u0013:$\b\u0006B\u0004\u007f\u0003\u0013\tAB\\;n\r\u0016\fG/\u001e:fg\u0002BC\u0001\u0003@\u0002\n\u0005Qa.^7DY\u0006\u001c8/Z:)\t%q\u0018\u0011I\u0011\u0003\u0003\u0007\nQA\r\u00183]A\n1B\\;n\u00072\f7o]3tA!\"!B`A!\u0003\u0019a\u0014N\\5u}QYq*!\u0014\u0002R\u0005M\u0013QKA-\u0011\u0015\u00198\u00021\u0001vQ\u0015\tiE`A\u0005\u0011\u001d\t\tb\u0003a\u0001\u0003+Aq!a\b\f\u0001\u0004\t\u0019\u0003C\u0004\u0002.-\u0001\r!!\r)\u000b\u0005Uc0!\u0003\t\u000f\u0005u2\u00021\u0001\u00022!*\u0011\u0011\f@\u0002BQIq*a\u0018\u0002b\u0005\r\u0014Q\r\u0005\u0006g2\u0001\r!\u001e\u0005\b\u0003#a\u0001\u0019AA\u000b\u0011\u001d\ty\u0002\u0004a\u0001\u0003GAq!!\f\r\u0001\u0004\t\t\u0004F\u0004P\u0003S\nY'!\u001c\t\u000bMl\u0001\u0019A;\t\u000f\u0005EQ\u00021\u0001\u0002\u0016!9\u0011qD\u0007A\u0002\u0005\r\u0002\u0006B\u0007\u007f\u0003\u0013\tQ\u0001\u001e:fKNDCA\u0004@\u0002v\u0005\u0012\u0011qO\u0001\u0006c9\"d\u0006M\u0001\fO\u0016$h*^7Ue\u0016,7\u000f\u000b\u0003\u0010}\u0006u\u0014EAA@\u0003\u0015\u0011d\u0006\r\u00181\u000319W\r\u001e(v[R\u0013X-Z:!Q\u0011\u0001b0! \u0002\u0017Q\u0014X-Z,fS\u001eDGo\u001d\u0015\u0005#y\f)(A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\ti)!(\u0011\t\u0005=\u0015\u0011T\u0007\u0003\u0003#SA!a%\u0002\u0016\u0006)A/\u001f9fg*\u0019\u0011qS\u001f\u0002\u0007M\fH.\u0003\u0003\u0002\u001c\u0006E%AC*ueV\u001cG\u000fV=qK\"9\u0011q\u0014\nA\u0002\u00055\u0015AB:dQ\u0016l\u0017\r\u000b\u0003\u0013}\u0006%\u0011!\u0003;sC:\u001chm\u001c:n)\u0011\t9+a1\u0011\t\u0005%\u0016Q\u0018\b\u0005\u0003W\u000bYL\u0004\u0003\u0002.\u0006ef\u0002BAX\u0003osA!!-\u00026:\u0019\u0001.a-\n\u0003\tK!\u0001Q!\n\u0005yz\u0014bAAL{%\u0019a.!&\n\t\u0005}\u0016\u0011\u0019\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1A\\AK\u0011\u001d\t)m\u0005a\u0001\u0003\u000f\fq\u0001Z1uCN,G\u000f\r\u0003\u0002J\u0006U\u0007CBAf\u0003\u001b\f\t.\u0004\u0002\u0002\u0016&!\u0011qZAK\u0005\u001d!\u0015\r^1tKR\u0004B!a5\u0002V2\u0001A\u0001DAl\u0003\u0007\f\t\u0011!A\u0003\u0002\u0005e'aA0%eE!\u00111\\Aq!\u0011\t9\"!8\n\u0007\u0005}wNA\u0004O_RD\u0017N\\4\u0011\t\u0005]\u00111]\u0005\u0004\u0003K|'aA!os\u00069\u0001O]3eS\u000e$H\u0003BA\u0013\u0003WDa!!<\u0015\u0001\u0004I\u0015\u0001\u00034fCR,(/Z:\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002J\u0003gDa!!<\u0016\u0001\u0004I\u0005\u0006B\u000b\u007f\u0003o\f#!!?\u0002\u000bMr\u0003G\f\u0019\u0002-I\fwO\r9s_\n\f'-\u001b7jifLe\u000e\u00157bG\u0016$2!SA\u0000\u0011\u0019\u0011\tA\u0006a\u0001\u0013\u0006i!/Y<Qe\u0016$\u0017n\u0019;j_:\fAaY8qsR\u0019qJa\u0002\t\u000f\t%q\u00031\u0001\u0003\f\u0005)Q\r\u001f;sCB!!Q\u0002B\n\u001b\t\u0011yAC\u0002\u0003\u0012m\nQ\u0001]1sC6LAA!\u0006\u0003\u0010\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0018}\u0006U\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003UDC\u0001\u0007@\u0002v\u0005\u0011b-Z1ukJ,\u0017*\u001c9peR\fgnY3t+\u0005I\u0005\u0006B\r\u007f\u0003{\na!\\1sO&tG\u0003BA\u0013\u0005SAa!!<\u001b\u0001\u0004I\u0015!\u0002;p\u001f2$WC\u0001B\u0018!\u0011\u0011\tD!\u0010\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\tQ!\\8eK2T1a\u0015B\u001d\u0015\r\u0011Y$P\u0001\u0006[2d\u0017NY\u0005\u0005\u0005\u007f\u0011\u0019DA\rHe\u0006$\u0017.\u001a8u\u0005>|7\u000f^3e)J,Wm]'pI\u0016d\u0017\u0001\u00027pgN,\"A!\u0012\u0011\t\t\u001d#1J\u0007\u0003\u0005\u0013RAA!\u0011\u00038%!!Q\nB%\u0005I\u0019E.Y:tS\u001aL7-\u0019;j_:dun]:\u0002\u000b1|7o\u001d\u0011\u0002+\u00154\u0018\r\\;bi\u0016,\u0015m\u00195Ji\u0016\u0014\u0018\r^5p]R!\u00111\u0005B+\u0011\u001d\t)M\ba\u0001\u0005/\u0002DA!\u0017\u0003^A1\u00111ZAg\u00057\u0002B!a5\u0003^\u0011a!q\fB+\u0003\u0003\u0005\tQ!\u0001\u0002Z\n\u0019q\fJ\u001a)\tyq(1M\u0011\u0003\u0005K\nQA\r\u00185]A\nQa\u001e:ji\u0016,\"Aa\u001b\u0011\u0007\u0001\u0014i'C\u0002\u0003p\u0005\u0014\u0001\"\u0014'Xe&$XM\u001d\u0015\u0005?y\fi\b\u000b\u0003\u0001}\u0006%\u0011AF$C)\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005\u0019\u000b3cB\u0011\u0003|\t\u0005%q\u0011\t\u0005\u0003/\u0011i(C\u0002\u0003\u0000=\u0014a!\u00118z%\u00164\u0007\u0003\u00021\u0003\u0004>K1A!\"b\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u0005\u0013\u0013\u0019*\u0004\u0002\u0003\f*!!Q\u0012BH\u0003\tIwN\u0003\u0002\u0003\u0012\u0006!!.\u0019<b\u0013\r\t(1\u0012\u000b\u0003\u0005o\naB\\;n\r\u0016\fG/\u001e:fg.+\u00170A\bok64U-\u0019;ve\u0016\u001c8*Z=!\u0003-qW/\u001c+sK\u0016\u001c8*Z=\u0002\u00199,X\u000e\u0016:fKN\\U-\u001f\u0011\u0002\tI,\u0017\rZ\u000b\u0003\u0005G\u0003B\u0001\u0019BS\u001f&\u0019!qU1\u0003\u00115c%+Z1eKJDCa\n@\u0002~\u0005!An\\1e)\ry%q\u0016\u0005\u0007\u0005cC\u0003\u0019A;\u0002\tA\fG\u000f\u001b\u0015\u0005Qy\fiH\u0001\u000fH\u0005R\u001bE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m/JLG/\u001a:\u0014\u0007%\u0012Y'\u0001\u0005j]N$\u0018M\\2f)\u0011\u0011iL!1\u0011\u0007\t}\u0016&D\u0001\"\u0011\u0019\u0011Il\u000ba\u0001\u001f\u0006A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003H\n5\u0007\u0003BA\f\u0005\u0013L1Aa3p\u0005\u0011)f.\u001b;\t\r\tEF\u00061\u0001v\u0005q9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001c2!\fBR)\t\u0011)\u000eE\u0002\u0003@6\n\u0011b\u00197bgNt\u0015-\\3\u0016\u0005\tm\u0007\u0003\u0002Bo\u0005Gl!Aa8\u000b\t\t\u0005(qR\u0001\u0005Y\u0006tw-C\u0002|\u0005?\f!b\u00197bgNt\u0015-\\3!\u00035!(/Z3DY\u0006\u001c8OT1nK\u0006qAO]3f\u00072\f7o\u001d(b[\u0016\u0004CcA(\u0003n\"1!\u0011W\u001aA\u0002U\fqA\u001a:p[>cG\rF\u0006P\u0005g\u00149p!\u0001\u0004\f\r5\u0001b\u0002B{i\u0001\u0007!qF\u0001\t_2$Wj\u001c3fY\"9!\u0011 \u001bA\u0002\tm\u0018A\u00029be\u0016tG\u000fE\u0002G\u0005{L1Aa@:\u000559%\tV\"mCN\u001c\u0018NZ5fe\"911\u0001\u001bA\u0002\r\u0015\u0011aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\bc\u0002<\u0004\b\u0005E\u0012\u0011G\u0005\u0004\u0007\u0013a(aA'ba\"I\u0011Q\u0006\u001b\u0011\u0002\u0003\u0007\u0011\u0011\u0007\u0005\n\u0003{!\u0004\u0013!a\u0001\u0003c\t\u0011C\u001a:p[>cG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\u0019B\u000b\u0003\u00022\rU1FAB\f!\u0011\u0019Ib!\t\u000e\u0005\rm!\u0002BB\u000f\u0007?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rq.\u0003\u0003\u0004$\rm!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tbM]8n\u001f2$G\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r-\u0002\u0003\u0002Bo\u0007[IAaa\f\u0003`\n1qJ\u00196fGRDC!\t@\u0002~!\"\u0001E`A?\u0001")
public class GBTClassificationModel
extends ProbabilisticClassificationModel<Vector, GBTClassificationModel>
implements GBTClassifierParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int numClasses;
    private final int getNumTrees;
    private final ClassificationLoss loss;
    private int totalNumNodes;
    private Param<String> lossType;
    private Param<String> impurity;
    private DoubleParam validationTol;
    private DoubleParam stepSize;
    private Param<String> validationIndicatorCol;
    private IntParam maxIter;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTClassificationModel load(String path) {
        return GBTClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<GBTClassificationModel> read() {
        return GBTClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public String getLossType() {
        return GBTClassifierParams.getLossType$(this);
    }

    @Override
    public ClassificationLoss getOldLossType() {
        return GBTClassifierParams.getOldLossType$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTClassifierParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(GBTClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(GBTClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(null)));
            return outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        }
        return outputData;
    }

    @Override
    public double predict(Vector features) {
        if (this.isDefined(this.thresholds())) {
            return super.predict(features);
        }
        if (this.margin(features) > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double prediction = this.margin(features);
        return Vectors$.MODULE$.dense(new double[]{-prediction, prediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            denseVector.values()[0] = this.loss().computeProbability(denseVector.values()[0]);
            denseVector.values()[1] = 1.0 - denseVector.values()[0];
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in GBTClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public GBTClassificationModel copy(ParamMap extra) {
        return (GBTClassificationModel)((Model)this.copyValues(new GBTClassificationModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "GBTClassificationModel: uid = " + this.uid() + ", numTrees=" + this.getNumTrees() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    private double margin(Vector features) {
        double[] treePredictions = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$margin$1(features, x$4)), (ClassTag)ClassTag$.MODULE$.Double());
        return BLAS$.MODULE$.nativeBLAS().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$5 -> x$5.toOld(), ClassTag$.MODULE$.apply(DecisionTreeModel.class)), this._treeWeights());
    }

    private ClassificationLoss loss() {
        return this.loss;
    }

    public double[] evaluateEachIteration(Dataset<?> dataset) {
        RDD<Instance> data = DatasetUtils$.MODULE$.extractInstances(this, dataset, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.loss(), Algo$.MODULE$.Classification());
    }

    @Override
    public MLWriter write() {
        return new GBTClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$margin$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "GBTClassificationModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable)() -> "GBTClassificationModel given trees, treeWeights of non-matching lengths (" + this._trees().length + ", " + this._treeWeights().length + ", respectively).");
        this.getNumTrees = this.trees().length;
        this.loss = this.getOldLossType();
        Statics.releaseFence();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this(uid, _trees, _treeWeights, numFeatures, 2);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1, 2);
    }

    private static class GBTClassificationModelReader
    extends MLReader<GBTClassificationModel> {
        private final String className = GBTClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTClassificationModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple3._1();
            Tuple2[] treesData = (Tuple2[])tuple3._2();
            double[] treeWeights2 = (double[])tuple3._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey())), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey())), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "GBTClassificationModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            GBTClassificationModel model = new GBTClassificationModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, (Option<List<String>>)new Some((Object)new .colon.colon((Object)"impurity", (List)Nil$.MODULE$)));
            return model;
        }
    }

    public static class GBTClassificationModelWriter
    extends MLWriter {
        private final GBTClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTClassificationModelWriter(GBTClassificationModel instance) {
            this.instance = instance;
        }
    }
}

