/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.SelectorModel$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SelectorModel$
implements Serializable {
    public static final SelectorModel$ MODULE$ = new SelectorModel$();

    public Dataset<Row> transform(Dataset<?> dataset, int[] selectedFeatures, StructType outputSchema, String outputCol, String featuresCol) {
        int newSize = selectedFeatures.length;
        Function1 & Serializable func = (Function1 & Serializable)vector -> {
            DenseVector denseVector;
            Option option;
            SparseVector sparseVector;
            Option option2;
            Vector vector2 = vector;
            if (vector2 instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector2)).isEmpty()) {
                double[] values;
                int[] indices = (int[])((Tuple3)option2.get())._2();
                Tuple2<int[], double[]> tuple2 = MODULE$.compressSparse(indices, values = (double[])((Tuple3)option2.get())._3(), selectedFeatures);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int[] newIndices = (int[])tuple2._1();
                double[] newValues = (double[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newIndices, (Object)newValues);
                int[] newIndices2 = (int[])tuple22._1();
                double[] newValues2 = (double[])tuple22._2();
                return Vectors$.MODULE$.sparse(newSize, newIndices2, newValues2);
            }
            if (vector2 instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) {
                double[] values = (double[])option.get();
                return Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(selectedFeatures), (Function1)Predef$.MODULE$.wrapDoubleArray(values), (ClassTag)ClassTag$.MODULE$.Double()));
            }
            throw new UnsupportedOperationException("Only sparse and dense vectors are supported but got " + vector2.getClass() + ".");
        };
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_feature_SelectorModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_SelectorModel$$typecreator1$1() {
            }
        }
        public final class Org_apache_spark_ml_feature_SelectorModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_SelectorModel$$typecreator2$1() {
            }
        }
        UserDefinedFunction transformer = functions$.MODULE$.udf((Function1)func, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_SelectorModel$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_SelectorModel$$typecreator2$1()));
        return dataset.withColumn(outputCol, transformer.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol)})), outputSchema.apply(outputCol).metadata());
    }

    public StructField prepOutputField(StructType schema, int[] selectedFeatures, String outputCol, String featuresCol, boolean isNumericAttribute) {
        Set selector = Predef$.MODULE$.wrapIntArray(selectedFeatures).toSet();
        AttributeGroup origAttrGroup = AttributeGroup$.MODULE$.fromStructField(schema.apply(featuresCol));
        Attribute[] featureAttributes = origAttrGroup.attributes().nonEmpty() ? (Attribute[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])origAttrGroup.attributes().get()))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)selector.contains((Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp()))))), (Function1 & Serializable)x$2 -> (Attribute)x$2._1(), ClassTag$.MODULE$.apply(Attribute.class)) : (isNumericAttribute ? (Attribute[])Array$.MODULE$.fill(selector.size(), (Function0 & Serializable)() -> NumericAttribute$.MODULE$.defaultAttr(), ClassTag$.MODULE$.apply(Attribute.class)) : (Attribute[])Array$.MODULE$.fill(selector.size(), (Function0 & Serializable)() -> NominalAttribute$.MODULE$.defaultAttr(), ClassTag$.MODULE$.apply(Attribute.class)));
        AttributeGroup newAttributeGroup = new AttributeGroup(outputCol, featureAttributes);
        return newAttributeGroup.toStructField();
    }

    public Tuple2<int[], double[]> compressSparse(int[] indices, double[] values, int[] selectedFeatures) {
        ArrayBuilder.ofDouble newValues = new ArrayBuilder.ofDouble();
        ArrayBuilder.ofInt newIndices = new ArrayBuilder.ofInt();
        int i = 0;
        int j = 0;
        while (i < indices.length && j < selectedFeatures.length) {
            int indicesIdx = indices[i];
            int filterIndicesIdx = selectedFeatures[j];
            if (indicesIdx == filterIndicesIdx) {
                newIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)j));
                newValues.$plus$eq((Object)BoxesRunTime.boxToDouble((double)values[i]));
                ++j;
                ++i;
                continue;
            }
            if (indicesIdx > filterIndicesIdx) {
                ++j;
                continue;
            }
            ++i;
        }
        return new Tuple2((Object)newIndices.result(), (Object)newValues.result());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SelectorModel$.class);
    }

    private SelectorModel$() {
    }
}

