/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelReader$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelWriter$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.VersionUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rMd\u0001\u0002 @\u0001)C\u0001B\u0017\u0001\u0003\u0006\u0004%\te\u0017\u0005\te\u0002\u0011\t\u0011)A\u00059\"AA\u000f\u0001BC\u0002\u0013%Q\u000f\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003w\u0011!\t)\u0001\u0001C\u0001\u0003\u0006\u001d\u0001BCA\b\u0001!\u0015\r\u0011\"\u0001\u0002\u0012!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBA\u001f\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tY\u0007\u0001C\u0001\u0003\u0017Cq!a%\u0001\t\u0003\t)\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0007bBAt\u0001\u0011\u0005\u0013\u0011\u001e\u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0011\u001d\u0011\t\u0002\u0001C!\u0005'9qA!\b@\u0011\u0003\u0011yB\u0002\u0004?\u007f!\u0005!\u0011\u0005\u0005\b\u0003\u000b\u0019B\u0011\u0001B \r\u001d\u0011\te\u0005!\u0014\u0005\u0007B\u0011\"a\u0011\u0016\u0005+\u0007I\u0011A.\t\u0013\teSC!E!\u0002\u0013a\u0006B\u0003B.+\tU\r\u0011\"\u0001\u0003^!Q!qM\u000b\u0003\u0012\u0003\u0006IAa\u0018\t\u000f\u0005\u0015Q\u0003\"\u0001\u0003j!I\u0011q]\u000b\u0002\u0002\u0013\u0005!1\u000f\u0005\n\u0005s*\u0012\u0013!C\u0001\u0005wB\u0011Ba$\u0016#\u0003%\tA!%\t\u0013\tUU#!A\u0005B\t]\u0005\"\u0003BR+\u0005\u0005I\u0011\u0001BS\u0011%\u00119+FA\u0001\n\u0003\u0011I\u000bC\u0005\u00030V\t\t\u0011\"\u0011\u00032\"I!qX\u000b\u0002\u0002\u0013\u0005!\u0011\u0019\u0005\n\u0005\u0017,\u0012\u0011!C!\u0005\u001bD\u0011B!5\u0016\u0003\u0003%\tEa5\t\u0013\tEQ#!A\u0005B\tU\u0007\"\u0003Bl+\u0005\u0005I\u0011\tBm\u000f)\u0011inEA\u0001\u0012\u0003\u0019\"q\u001c\u0004\u000b\u0005\u0003\u001a\u0012\u0011!E\u0001'\t\u0005\bbBA\u0003Q\u0011\u0005!q\u001e\u0005\n\u0005#A\u0013\u0011!C#\u0005+D\u0011B!=)\u0003\u0003%\tIa=\t\u0013\te\b&!A\u0005\u0002\nm\b\"CB\u0005Q\u0005\u0005I\u0011BB\u0006\r\u001d\u0019\u0019b\u0005\u0001\u0014\u0007+A\u0011ba\u0006/\u0005\u0003\u0005\u000b\u0011B(\t\u000f\u0005\u0015a\u0006\"\u0001\u0004\u001a!91q\u0004\u0018\u0005R\r\u0005r\u0001CB\u0017'!\u0005qha\f\u0007\u0011\rM1\u0003#\u0001@\u0007cAq!!\u00024\t\u0003\u0019\u0019\u0004C\u0004\u00046M\"\taa\u000e\u0007\r\r-3\u0003BB'\u0011\u001d\t)A\u000eC\u0001\u0007+B\u0011b!\u00177\u0005\u0004%IAa&\t\u0011\rmc\u0007)A\u0005\u00053Cqa!\u00187\t\u0003\u001ay\u0006C\u0004\u0004dM!\te!\u001a\t\u000f\ru3\u0003\"\u0011\u0004j!I1\u0011B\n\u0002\u0002\u0013%11\u0002\u0002\u000e/>\u0014HM\r,fG6{G-\u001a7\u000b\u0005\u0001\u000b\u0015a\u00024fCR,(/\u001a\u0006\u0003\u0005\u000e\u000b!!\u001c7\u000b\u0005\u0011+\u0015!B:qCJ\\'B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0017F#\u0006c\u0001'N\u001f6\t\u0011)\u0003\u0002O\u0003\n)Qj\u001c3fYB\u0011\u0001\u000bA\u0007\u0002\u007fA\u0011\u0001KU\u0005\u0003'~\u0012AbV8sIJ2Vm\u0019\"bg\u0016\u0004\"!\u0016-\u000e\u0003YS!aV!\u0002\tU$\u0018\u000e\\\u0005\u00033Z\u0013!\"\u0014'Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u00029B\u0011QL\u001a\b\u0003=\u0012\u0004\"a\u00182\u000e\u0003\u0001T!!Y%\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0017!B:dC2\f\u0017BA3c\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u0014\u0007fA\u0001kaB\u00111N\\\u0007\u0002Y*\u0011QnQ\u0001\u000bC:tw\u000e^1uS>t\u0017BA8m\u0005\u0015\u0019\u0016N\\2fC\u0005\t\u0018!B\u0019/i9\u0002\u0014\u0001B;jI\u0002B3A\u00016q\u0003-9xN\u001d3WK\u000e$xN]:\u0016\u0003Y\u0004\"a^>\u000e\u0003aT!\u0001Q=\u000b\u0005i\u001c\u0015!B7mY&\u0014\u0017B\u0001 y\u000319xN\u001d3WK\u000e$xN]:!Q\t!a\u0010E\u0002\u0000\u0003\u0003i\u0011AY\u0005\u0004\u0003\u0007\u0011'!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0019a\u0014N\\5u}Q)q*!\u0003\u0002\u000e!)!,\u0002a\u00019\"\"\u0011\u0011\u00026q\u0011\u0015!X\u00011\u0001w\u0003)9W\r\u001e,fGR|'o]\u000b\u0003\u0003'\u0001B!!\u0006\u000209!\u0011qCA\u0015\u001d\u0011\tI\"!\n\u000f\t\u0005m\u00111\u0005\b\u0005\u0003;\t\tCD\u0002`\u0003?I\u0011\u0001S\u0005\u0003\r\u001eK!\u0001R#\n\u0007\u0005\u001d2)A\u0002tc2LA!a\u000b\u0002.\u00059\u0001/Y2lC\u001e,'bAA\u0014\u0007&!\u0011\u0011GA\u001a\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002,\u00055\u0002\u0006\u0002\u0004k\u0003o\t#!!\u000f\u0002\u000bErSG\f\u0019)\u0005\u0019q\u0018\u0001\u00044j]\u0012\u001c\u0016P\\8os6\u001cHCBA\n\u0003\u0003\n)\u0005\u0003\u0004\u0002D\u001d\u0001\r\u0001X\u0001\u0005o>\u0014H\rC\u0004\u0002H\u001d\u0001\r!!\u0013\u0002\u00079,X\u000eE\u0002\u0000\u0003\u0017J1!!\u0014c\u0005\rIe\u000e\u001e\u0015\u0005\u000f)\f9\u0004\u0006\u0004\u0002\u0014\u0005M\u00131\r\u0005\b\u0003+B\u0001\u0019AA,\u0003\r1Xm\u0019\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL!\u0002\r1Lg.\u00197h\u0013\u0011\t\t'a\u0017\u0003\rY+7\r^8s\u0011\u001d\t9\u0005\u0003a\u0001\u0003\u0013BC\u0001\u00036\u0002h\u0005\u0012\u0011\u0011N\u0001\u0006e9\u0002d\u0006M\u0001\u0012M&tGmU=o_:LXn]!se\u0006LHCBA8\u0003\u0003\u000b\u0019\tE\u0003\u0000\u0003c\n)(C\u0002\u0002t\t\u0014Q!\u0011:sCf\u0004ba`A<9\u0006m\u0014bAA=E\n1A+\u001e9mKJ\u00022a`A?\u0013\r\tyH\u0019\u0002\u0007\t>,(\r\\3\t\u000f\u0005U\u0013\u00021\u0001\u0002X!9\u0011qI\u0005A\u0002\u0005%\u0003\u0006B\u0005k\u0003\u000f\u000b#!!#\u0002\u000bIr#G\f\u0019\u0015\r\u0005=\u0014QRAH\u0011\u0019\t\u0019E\u0003a\u00019\"9\u0011q\t\u0006A\u0002\u0005%\u0003\u0006\u0002\u0006k\u0003\u000f\u000b1b]3u\u0013:\u0004X\u000f^\"pYR!\u0011qSAM\u001b\u0005\u0001\u0001BBAN\u0017\u0001\u0007A,A\u0003wC2,X\rK\u0002\fUB\fAb]3u\u001fV$\b/\u001e;D_2$B!a&\u0002$\"1\u00111\u0014\u0007A\u0002qC3\u0001\u00046q\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002\u0014\u0005-\u0006bBAW\u001b\u0001\u0007\u0011qV\u0001\bI\u0006$\u0018m]3ua\u0011\t\t,!0\u0011\r\u0005M\u0016QWA]\u001b\t\ti#\u0003\u0003\u00028\u00065\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003w\u000bi\f\u0004\u0001\u0005\u0019\u0005}\u00161VA\u0001\u0002\u0003\u0015\t!!1\u0003\u0007}##'\u0005\u0003\u0002D\u0006%\u0007cA@\u0002F&\u0019\u0011q\u00192\u0003\u000f9{G\u000f[5oOB\u0019q0a3\n\u0007\u00055'MA\u0002B]fDC!\u00046\u0002h\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002V\u0006\u0005\b\u0003BAl\u0003;l!!!7\u000b\t\u0005m\u0017QF\u0001\u0006if\u0004Xm]\u0005\u0005\u0003?\fIN\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a9\u000f\u0001\u0004\t).\u0001\u0004tG\",W.\u0019\u0015\u0004\u001d)\u0004\u0018\u0001B2paf$2aTAv\u0011\u001d\tio\u0004a\u0001\u0003_\fQ!\u001a=ue\u0006\u0004B!!=\u0002x6\u0011\u00111\u001f\u0006\u0004\u0003k\f\u0015!\u00029be\u0006l\u0017\u0002BA}\u0003g\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0005\u001f)\fi0\t\u0002\u0002\u0000\u0006)\u0011G\f\u001b/c\u0005)qO]5uKV\u0011!Q\u0001\t\u0004+\n\u001d\u0011b\u0001B\u0005-\nAQ\nT,sSR,'\u000f\u000b\u0003\u0011U\n5\u0011E\u0001B\b\u0003\u0015\tdF\u000e\u00181\u0003!!xn\u0015;sS:<G#\u0001/)\tEQ'qC\u0011\u0003\u00053\tQa\r\u00181]AB3\u0001\u00016q\u000359vN\u001d33-\u0016\u001cWj\u001c3fYB\u0011\u0001kE\n\b'\t\r\"\u0011\u0006B\u0018!\ry(QE\u0005\u0004\u0005O\u0011'AB!osJ+g\r\u0005\u0003V\u0005Wy\u0015b\u0001B\u0017-\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\tE\"1H\u0007\u0003\u0005gQAA!\u000e\u00038\u0005\u0011\u0011n\u001c\u0006\u0003\u0005s\tAA[1wC&!!Q\bB\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011yB\u0001\u0003ECR\f7cB\u000b\u0003$\t\u0015#1\n\t\u0004\u007f\n\u001d\u0013b\u0001B%E\n9\u0001K]8ek\u000e$\b\u0003\u0002B'\u0005+rAAa\u0014\u0003T9\u0019qL!\u0015\n\u0003\rL1!a\u000bc\u0013\u0011\u0011iDa\u0016\u000b\u0007\u0005-\"-A\u0003x_J$\u0007%\u0001\u0004wK\u000e$xN]\u000b\u0003\u0005?\u0002Ra`A9\u0005C\u00022a B2\u0013\r\u0011)G\u0019\u0002\u0006\r2|\u0017\r^\u0001\bm\u0016\u001cGo\u001c:!)\u0019\u0011YGa\u001c\u0003rA\u0019!QN\u000b\u000e\u0003MAa!a\u0011\u001b\u0001\u0004a\u0006b\u0002B.5\u0001\u0007!q\f\u000b\u0007\u0005W\u0012)Ha\u001e\t\u0011\u0005\r3\u0004%AA\u0002qC\u0011Ba\u0017\u001c!\u0003\u0005\rAa\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0010\u0016\u00049\n}4F\u0001BA!\u0011\u0011\u0019Ia#\u000e\u0005\t\u0015%\u0002\u0002BD\u0005\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00055\u0014\u0017\u0002\u0002BG\u0005\u000b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa%+\t\t}#qP\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\te\u0005\u0003\u0002BN\u0005Ck!A!(\u000b\t\t}%qG\u0001\u0005Y\u0006tw-C\u0002h\u0005;\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0013\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\u001aBV\u0011%\u0011i\u000bIA\u0001\u0002\u0004\tI%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005g\u0003bA!.\u0003<\u0006%WB\u0001B\\\u0015\r\u0011ILY\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B_\u0005o\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0019Be!\ry(QY\u0005\u0004\u0005\u000f\u0014'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005[\u0013\u0013\u0011!a\u0001\u0003\u0013\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\u0014Bh\u0011%\u0011ikIA\u0001\u0002\u0004\tI%\u0001\u0005iCND7i\u001c3f)\t\tI\u0005\u0006\u0002\u0003\u001a\u00061Q-];bYN$BAa1\u0003\\\"I!Q\u0016\u0014\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0005\t\u0006$\u0018\rE\u0002\u0003n!\u001aR\u0001\u000bBr\u0005_\u0001\u0012B!:\u0003lr\u0013yFa\u001b\u000e\u0005\t\u001d(b\u0001BuE\u00069!/\u001e8uS6,\u0017\u0002\u0002Bw\u0005O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011y.A\u0003baBd\u0017\u0010\u0006\u0004\u0003l\tU(q\u001f\u0005\u0007\u0003\u0007Z\u0003\u0019\u0001/\t\u000f\tm3\u00061\u0001\u0003`\u00059QO\\1qa2LH\u0003\u0002B\u007f\u0007\u000b\u0001Ra B\u0000\u0007\u0007I1a!\u0001c\u0005\u0019y\u0005\u000f^5p]B1q0a\u001e]\u0005?B\u0011ba\u0002-\u0003\u0003\u0005\rAa\u001b\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\u000eA!!1TB\b\u0013\u0011\u0019\tB!(\u0003\r=\u0013'.Z2u\u0005M9vN\u001d33-\u0016\u001cWj\u001c3fY^\u0013\u0018\u000e^3s'\rq#QA\u0001\tS:\u001cH/\u00198dKR!11DB\u000f!\r\u0011iG\f\u0005\u0007\u0007/\u0001\u0004\u0019A(\u0002\u0011M\fg/Z%na2$Baa\t\u0004*A\u0019qp!\n\n\u0007\r\u001d\"M\u0001\u0003V]&$\bBBB\u0016c\u0001\u0007A,\u0001\u0003qCRD\u0017aE,pe\u0012\u0014d+Z2N_\u0012,Gn\u0016:ji\u0016\u0014\bc\u0001B7gM\u00191Ga\t\u0015\u0005\r=\u0012aG2bY\u000e,H.\u0019;f\u001dVl'-\u001a:PMB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0002J\re21IB$\u0011\u001d\u0019Y$\u000ea\u0001\u0007{\t\u0011CY;gM\u0016\u00148+\u001b>f\u0013:\u0014\u0015\u0010^3t!\ry8qH\u0005\u0004\u0007\u0003\u0012'\u0001\u0002'p]\u001eDqa!\u00126\u0001\u0004\tI%\u0001\u0005ok6<vN\u001d3t\u0011\u001d\u0019I%\u000ea\u0001\u0003\u0013\n!B^3di>\u00148+\u001b>f\u0005M9vN\u001d33-\u0016\u001cWj\u001c3fYJ+\u0017\rZ3s'\r14q\n\t\u0005+\u000eEs*C\u0002\u0004TY\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u000b\u0003\u0007/\u00022A!\u001c7\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\nA\u0001\\8bIR\u0019qj!\u0019\t\r\r-\"\b1\u0001]\u0003\u0011\u0011X-\u00193\u0016\u0005\r=\u0003\u0006B\u001ek\u0005\u001b!2aTB6\u0011\u0019\u0019Y\u0003\u0010a\u00019\"\"AH\u001bB\u0007Q\u0011\u0019\"N!\u0004)\tIQ'Q\u0002")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase,
MLWritable {
    private transient Dataset<Row> getVectors;
    private final String uid;
    private final transient org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    private IntParam vectorSize;
    private IntParam windowSize;
    private IntParam numPartitions;
    private IntParam minCount;
    private IntParam maxSentenceLength;
    private LongParam seed;
    private DoubleParam stepSize;
    private IntParam maxIter;
    private Param<String> outputCol;
    private Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    public static Word2VecModel load(String path) {
        return Word2VecModel$.MODULE$.load(path);
    }

    public static MLReader<Word2VecModel> read() {
        return Word2VecModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase.getVectorSize$(this);
    }

    @Override
    public int getWindowSize() {
        return Word2VecBase.getWindowSize$(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase.getNumPartitions$(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase.getMinCount$(this);
    }

    @Override
    public int getMaxSentenceLength() {
        return Word2VecBase.getMaxSentenceLength$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam windowSize() {
        return this.windowSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final IntParam maxSentenceLength() {
        return this.maxSentenceLength;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$windowSize_$eq(IntParam x$1) {
        this.windowSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$maxSentenceLength_$eq(IntParam x$1) {
        this.maxSentenceLength = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    }

    private Dataset<Row> getVectors$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if (!this.bitmap$trans$0) {
                SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
                Map wordVec = (Map)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().transform((Function2 & Serializable)(x$2, vec) -> Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.floatArrayOps(vec), (Function1)(JFunction1.mcDF.sp & Serializable)x$3 -> x$3, (ClassTag)ClassTag$.MODULE$.Double())));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(Word2VecModel $outer) {
                    }
                }
                this.getVectors = spark.createDataFrame(wordVec.toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"word", "vector"}));
                this.bitmap$trans$0 = true;
            }
        }
        return this.getVectors;
    }

    public Dataset<Row> getVectors() {
        if (!this.bitmap$trans$0) {
            return this.getVectors$lzycompute();
        }
        return this.getVectors;
    }

    public Dataset<Row> findSynonyms(String word, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(this.findSynonymsArray(word, num)).toImmutableArraySeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Dataset<Row> findSynonyms(Vector vec, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(this.findSynonymsArray(vec, num)).toImmutableArraySeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Tuple2<String, Object>[] findSynonymsArray(Vector vec, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(vec.toArray(), num, (Option<String>)None$.MODULE$);
    }

    public Tuple2<String, Object>[] findSynonymsArray(String word, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(word, num);
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(Word2VecModel $outer) {
            }
        }
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Broadcast bcModel = dataset.sparkSession().sparkContext().broadcast((Object)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.feature.Word2VecModel.class));
        int size = BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize()));
        Vector emptyVec = Vectors$.MODULE$.sparse(size, Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        UserDefinedFunction transformer = functions$.MODULE$.udf((Function1 & Serializable)sentence -> {
            if (sentence.isEmpty()) {
                return emptyVec;
            }
            Map<String, Object> wordIndices = ((org.apache.spark.mllib.feature.Word2VecModel)bcModel.value()).wordIndex();
            float[] wordVectors = ((org.apache.spark.mllib.feature.Word2VecModel)bcModel.value()).wordVectors();
            double[] array = (double[])Array$.MODULE$.ofDim(size, (ClassTag)ClassTag$.MODULE$.Double());
            IntRef count = IntRef.create((int)0);
            sentence.foreach((Function1 & Serializable)word -> {
                Word2VecModel.$anonfun$transform$2(wordIndices, size, array, wordVectors, count, word);
                return BoxedUnit.UNIT;
            });
            Vector vec = Vectors$.MODULE$.dense(array);
            BLAS$.MODULE$.scal(1.0 / (double)count.elem, vec);
            return vec;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(null)));
        return dataset.withColumn(this.$(this.outputCol()), transformer.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})), outputSchema.apply(this.$(this.outputCol())).metadata());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = this.validateAndTransformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.outputCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.outputCol()), BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize())));
        }
        return outputSchema;
    }

    @Override
    public Word2VecModel copy(ParamMap extra) {
        Word2VecModel copied = new Word2VecModel(this.uid(), this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors());
        return (Word2VecModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new Word2VecModelWriter(this);
    }

    @Override
    public String toString() {
        return "Word2VecModel: uid=" + this.uid() + ", numWords=" + this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size() + ", vectorSize=" + this.$(this.vectorSize());
    }

    public static final /* synthetic */ void $anonfun$transform$2(Map wordIndices$1, int size$1, double[] array$1, float[] wordVectors$1, IntRef count$1, String word) {
        wordIndices$1.get((Object)word).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            int offset = index * size$1;
            for (int i = 0; i < size$1; ++i) {
                int n = i;
                array$1[n] = array$1[n] + (double)wordVectors$1[offset + i];
            }
        });
        ++count$1.elem;
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors = wordVectors;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasSeed.$init$(this);
        Word2VecBase.$init$(this);
        MLWritable.$init$(this);
        Statics.releaseFence();
    }

    public static class Data
    implements Product,
    Serializable {
        private final String word;
        private final float[] vector;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String word() {
            return this.word;
        }

        public float[] vector() {
            return this.vector;
        }

        public Data copy(String word, float[] vector) {
            return new Data(word, vector);
        }

        public String copy$default$1() {
            return this.word();
        }

        public float[] copy$default$2() {
            return this.vector();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.word();
                }
                case 1: {
                    return this.vector();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "word";
                }
                case 1: {
                    return "vector";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.word();
            String string2 = data.word();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.vector() != data.vector()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String word, float[] vector) {
            this.word = word;
            this.vector = vector;
            Product.$init$((Product)this);
        }
    }

    private static class Word2VecModelReader
    extends MLReader<Word2VecModel> {
        private final String className = Word2VecModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public Word2VecModel load(String path) {
            org.apache.spark.mllib.feature.Word2VecModel word2VecModel;
            SparkSession spark = this.sparkSession();
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int major = tuple2._1$mcI$sp();
            int minor = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
            int major2 = sp2._1$mcI$sp();
            int minor2 = sp2._2$mcI$sp();
            String dataPath = new Path(path, "data").toString();
            if (major2 < 2 || major2 == 2 && minor2 < 2) {
                Row data = (Row)spark.read().parquet(dataPath).select("wordIndex", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"wordVectors"})).head();
                Map wordIndex = (Map)data.getAs(0);
                float[] wordVectors = (float[])((IterableOnceOps)data.getAs(1)).toArray((ClassTag)ClassTag$.MODULE$.Float());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, Object>)wordIndex, wordVectors);
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator5$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator5$2(Word2VecModelReader $outer) {
                    }
                }
                Map wordVectorsMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])spark.read().parquet(dataPath).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator5$2(null)))).collect()), (Function1 & Serializable)wordVector -> new Tuple2((Object)wordVector.word(), (Object)wordVector.vector()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, float[]>)wordVectorsMap);
            }
            org.apache.spark.mllib.feature.Word2VecModel oldModel = word2VecModel;
            Word2VecModel model = new Word2VecModel(metadata.uid(), oldModel);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class Word2VecModelWriter
    extends MLWriter {
        private final Word2VecModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator10$1(Word2VecModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Map<String, float[]> wordVectors = this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors();
            String dataPath = new Path(path, "data").toString();
            long bufferSizeInBytes = Utils$.MODULE$.byteStringAsBytes(this.sc().conf().get(Kryo$.MODULE$.KRYO_SERIALIZER_MAX_BUFFER_SIZE().key(), "64m"));
            int numPartitions = Word2VecModel$Word2VecModelWriter$.MODULE$.calculateNumberOfPartitions(bufferSizeInBytes, this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size(), this.instance.getVectorSize());
            SparkSession spark = this.sparkSession();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(Word2VecModelWriter $outer) {
                }
            }
            spark.createDataset(wordVectors.toSeq(), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(null)))).repartition(numPartitions).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String word = (String)tuple2._1();
                    float[] vector = (float[])tuple2._2();
                    return new Data(word, vector);
                }
                throw new MatchError((Object)tuple2);
            }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator10$1(null)))).toDF().write().parquet(dataPath);
        }

        public Word2VecModelWriter(Word2VecModel instance) {
            this.instance = instance;
        }
    }
}

