/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.io.Serializable;
import org.apache.spark.ml.linalg.JsonMatrixConverter$;
import org.apache.spark.ml.linalg.JsonVectorConverter$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\u000e\u001d\u0001\u001dB\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005{!Aa\t\u0001BC\u0002\u0013\u0005A\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003>\u0011!A\u0005A!b\u0001\n\u0003a\u0004\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011)\u0003!Q1A\u0005\u0002-C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006=\u0002!\ta\u0018\u0005\u0006=\u0002!\tA\u001a\u0005\u0006=\u0002!\t!\u001d\u0005\u0006=\u0002!\t!\u001e\u0005\u0007s\u0002!\t\u0001\b>\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011!\t\t\u0003\u0001Q\u0001\n\u0005\r\u0002bBA\u0019\u0001\u0011\u0015\u00131\u0007\u0005\b\u0003k\u0001AQIA\u001c\u0011\u001d\ty\u0004\u0001C#\u0003\u0003:\u0001\"a\u0012\u001d\u0011\u0003q\u0012\u0011\n\u0004\b7qA\tAHA&\u0011\u0019qv\u0003\"\u0001\u0002X!9\u0011\u0011D\f\u0005\u0002\u0005e\u0003\"CA2/\u0005\u0005I\u0011BA3\u0005\u0015\u0001\u0016M]1n\u0015\tib$A\u0003qCJ\fWN\u0003\u0002 A\u0005\u0011Q\u000e\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u0001QC\u0001\u0015R'\r\u0001\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ABdBA\u00197\u001d\t\u0011T'D\u00014\u0015\t!d%\u0001\u0004=e>|GOP\u0005\u0002Y%\u0011qgK\u0001\ba\u0006\u001c7.Y4f\u0013\tI$H\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00028W\u00051\u0001/\u0019:f]R,\u0012!\u0010\t\u0003}\ts!a\u0010!\u0011\u0005IZ\u0013BA!,\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005[\u0013a\u00029be\u0016tG\u000fI\u0001\u0005]\u0006lW-A\u0003oC6,\u0007%A\u0002e_\u000e\fA\u0001Z8dA\u00059\u0011n\u001d,bY&$W#\u0001'\u0011\t)juJW\u0005\u0003\u001d.\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005A\u000bF\u0002\u0001\u0003\u0006%\u0002\u0011\ra\u0015\u0002\u0002)F\u0011Ak\u0016\t\u0003UUK!AV\u0016\u0003\u000f9{G\u000f[5oOB\u0011!\u0006W\u0005\u00033.\u00121!\u00118z!\tQ3,\u0003\u0002]W\t9!i\\8mK\u0006t\u0017\u0001C5t-\u0006d\u0017\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\u0015\u0001'm\u00193f!\r\t\u0007aT\u0007\u00029!)1(\u0003a\u0001{!)a)\u0003a\u0001{!)\u0001*\u0003a\u0001{!)!*\u0003a\u0001\u0019R)\u0001m\u001a8pa\")1H\u0003a\u0001QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111NH\u0001\u0005kRLG.\u0003\u0002nU\na\u0011\nZ3oi&4\u0017.\u00192mK\")aI\u0003a\u0001{!)\u0001J\u0003a\u0001{!)!J\u0003a\u0001\u0019R!\u0001M]:u\u0011\u0015Y4\u00021\u0001>\u0011\u001515\u00021\u0001>\u0011\u0015A5\u00021\u0001>)\u0011\u0001go\u001e=\t\u000bmb\u0001\u0019\u00015\t\u000b\u0019c\u0001\u0019A\u001f\t\u000b!c\u0001\u0019A\u001f\u0002\u0011Y\fG.\u001b3bi\u0016$\"a\u001f@\u0011\u0005)b\u0018BA?,\u0005\u0011)f.\u001b;\t\u000b}l\u0001\u0019A(\u0002\u000bY\fG.^3\u0002\u0003]$B!!\u0002\u0002\fA!\u0011-a\u0002P\u0013\r\tI\u0001\b\u0002\n!\u0006\u0014\u0018-\u001c)bSJDQa \bA\u0002=\u000ba\u0002J7j]V\u001cHe\u001a:fCR,'\u000f\u0006\u0003\u0002\u0006\u0005E\u0001\"B@\u0010\u0001\u0004y\u0015A\u00036t_:,enY8eKR\u0019Q(a\u0006\t\u000b}\u0004\u0002\u0019A(\u0002\u0015)\u001cxN\u001c#fG>$W\rF\u0002P\u0003;Aa!a\b\u0012\u0001\u0004i\u0014\u0001\u00026t_:\fAc\u001d;sS:<'+\u001a9sKN,g\u000e^1uS>t\u0007\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\u0005Y\u0006twM\u0003\u0002\u0002.\u0005!!.\u0019<b\u0013\r\u0019\u0015qE\u0001\ti>\u001cFO]5oOR\tQ(\u0001\u0005iCND7i\u001c3f)\t\tI\u0004E\u0002+\u0003wI1!!\u0010,\u0005\rIe\u000e^\u0001\u0007KF,\u0018\r\\:\u0015\u0007i\u000b\u0019\u0005\u0003\u0004\u0002FU\u0001\raV\u0001\u0004_\nT\u0017!\u0002)be\u0006l\u0007CA1\u0018'\u00119\u0012&!\u0014\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#RA!a\u0015\u0002,\u0005\u0011\u0011n\\\u0005\u0004s\u0005ECCAA%+\u0011\tY&a\u0018\u0015\t\u0005u\u0013\u0011\r\t\u0004!\u0006}C!\u0002*\u001a\u0005\u0004\u0019\u0006BBA\u00103\u0001\u0007Q(\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002hA!\u0011QEA5\u0013\u0011\tY'a\n\u0003\r=\u0013'.Z2u\u0001")
public class Param<T>
implements Serializable {
    private final String parent;
    private final String name;
    private final String doc;
    private final Function1<T, Object> isValid;
    private final String stringRepresentation;

    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public String doc() {
        return this.doc;
    }

    public Function1<T, Object> isValid() {
        return this.isValid;
    }

    public void validate(T value) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.isValid().apply(value))) {
            String string;
            T t = value;
            if (ScalaRunTime$.MODULE$.isArray(t, 1)) {
                T t2 = t;
                string = Predef$.MODULE$.genericWrapArray(t2).mkString("[", ",", "]");
            } else {
                string = value.toString();
            }
            String valueToString = string;
            throw new IllegalArgumentException(this.parent() + " parameter " + this.name() + " given invalid value " + valueToString + ".");
        }
    }

    public ParamPair<T> w(T value) {
        return this.$minus$greater(value);
    }

    public ParamPair<T> $minus$greater(T value) {
        return new ParamPair<T>(this, value);
    }

    public String jsonEncode(T value) {
        T t = value;
        if (t instanceof String) {
            String string = (String)t;
            return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)new JString(string), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
        }
        if (t instanceof Vector) {
            Vector vector = (Vector)t;
            return JsonVectorConverter$.MODULE$.toJson(vector);
        }
        if (t instanceof Matrix) {
            Matrix matrix = (Matrix)t;
            return JsonMatrixConverter$.MODULE$.toJson(matrix);
        }
        throw new UnsupportedOperationException("The default jsonEncode only supports string, vector and matrix. " + this.getClass().getName() + " must override jsonEncode for " + value.getClass().getName() + ".");
    }

    public T jsonDecode(String json) {
        return Param$.MODULE$.jsonDecode(json);
    }

    public final String toString() {
        return this.stringRepresentation;
    }

    public final int hashCode() {
        return Statics.anyHash((Object)this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Param)) return false;
        Param param = (Param)object;
        String string = param.parent();
        String string2 = this.parent();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = param.name();
        String string4 = this.name();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public Param(String parent, String name, String doc, Function1<T, Object> isValid) {
        this.parent = parent;
        this.name = name;
        this.doc = doc;
        this.isValid = isValid;
        this.stringRepresentation = parent + "__" + name;
    }

    public Param(Identifiable parent, String name, String doc, Function1<T, Object> isValid) {
        this(parent.uid(), name, doc, isValid);
    }

    public Param(String parent, String name, String doc) {
        this(parent, name, doc, ParamValidators$.MODULE$.alwaysTrue());
    }

    public Param(Identifiable parent, String name, String doc) {
        this(parent.uid(), name, doc);
    }
}

