/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.LearningNode;
import org.apache.spark.ml.tree.LearningNode$;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.impl.BaggedPoint;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.tree.impl.DTStatsAggregator;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.tree.impl.RandomForest;
import org.apache.spark.ml.tree.impl.TimeTracker;
import org.apache.spark.ml.tree.impl.TreePoint;
import org.apache.spark.ml.tree.impl.TreePoint$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.model.ImpurityStats;
import org.apache.spark.mllib.tree.model.ImpurityStats$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.util.PeriodicRDDCheckpointer;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.collection.OpenHashMap;
import org.apache.spark.util.random.SamplingUtils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class RandomForest$
implements Logging,
Serializable {
    public static final RandomForest$ MODULE$ = new RandomForest$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DecisionTreeModel[] run(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, long seed) {
        RDD instances = input.map((Function1 & Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                return new Instance(label, 1.0, features.asML());
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Instance.class));
        return this.run((RDD<Instance>)instances, strategy, numTrees, featureSubsetStrategy, seed, (Option<Instrumentation>)None$.MODULE$, this.run$default$7(), this.run$default$8());
    }

    public DecisionTreeModel[] runBagged(RDD<BaggedPoint<TreePoint>> baggedInput, DecisionTreeMetadata metadata, Broadcast<Split[][]> bcSplits, Strategy strategy, int numTrees, String featureSubsetStrategy, long seed, Option<Instrumentation> instr, boolean prune, Option<String> parentUID) {
        TimeTracker timer = new TimeTracker();
        timer.start("total");
        SparkContext sc = baggedInput.sparkContext();
        Option<Instrumentation> option = instr;
        if (option instanceof Some) {
            Some some = (Some)option;
            Instrumentation instrumentation = (Instrumentation)some.value();
            instrumentation.logNumFeatures(metadata.numFeatures());
            instrumentation.logNumClasses(metadata.numClasses());
            instrumentation.logNumExamples(metadata.numExamples());
            instrumentation.logSumOfWeights(metadata.weightedNumExamples());
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FEATURES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)metadata.numFeatures()))}))));
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numClasses: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_CLASSES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)metadata.numClasses()))}))));
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numExamples: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_EXAMPLES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)metadata.numExamples()))}))));
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"weightedNumExamples: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_WEIGHTED_EXAMPLES$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)metadata.weightedNumExamples()))})))));
        } else {
            throw new MatchError(option);
        }
        timer.start("init");
        int maxDepth = strategy.maxDepth();
        Predef$.MODULE$.require(maxDepth <= 30, (Function0 & Serializable)() -> "DecisionTree currently only supports maxDepth <= 30, but was given maxDepth = " + maxDepth + ".");
        long maxMemoryUsage = (long)strategy.maxMemoryInMB() * 1024L * 1024L;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "max memory usage for aggregates = " + maxMemoryUsage + " bytes.");
        RDD<int[]> nodeIds = null;
        PeriodicRDDCheckpointer nodeIdCheckpointer = null;
        if (strategy.useNodeIdCache()) {
            nodeIds = baggedInput.map((Function1 & Serializable)x$1 -> (int[])Array$.MODULE$.fill(numTrees, (Function0)(JFunction0.mcI.sp & Serializable)() -> 1, (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
            nodeIdCheckpointer = new PeriodicRDDCheckpointer(strategy.getCheckpointInterval(), sc, StorageLevel$.MODULE$.MEMORY_AND_DISK());
            nodeIdCheckpointer.update((Object)nodeIds);
        }
        ListBuffer nodeStack = new ListBuffer();
        Random rng = new Random();
        rng.setSeed(seed);
        LearningNode[] topNodes = (LearningNode[])Array$.MODULE$.fill(numTrees, (Function0 & Serializable)() -> LearningNode$.MODULE$.emptyNode(1), ClassTag$.MODULE$.apply(LearningNode.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTrees).foreach((Function1 & Serializable)treeIndex -> nodeStack.prepend((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)treeIndex)), (Object)topNodes[BoxesRunTime.unboxToInt((Object)treeIndex)])));
        timer.stop("init");
        while (nodeStack.nonEmpty()) {
            Tuple2<scala.collection.immutable.Map<Object, LearningNode[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>> tuple2 = this.selectNodesToSplit((ListBuffer<Tuple2<Object, LearningNode>>)nodeStack, maxMemoryUsage, metadata, rng);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Map nodesForGroup = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map treeToNodeToIndexInfo = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
            scala.collection.immutable.Map nodesForGroup2 = (scala.collection.immutable.Map)tuple22._1();
            scala.collection.immutable.Map treeToNodeToIndexInfo2 = (scala.collection.immutable.Map)tuple22._2();
            Predef$.MODULE$.assert(nodesForGroup2.nonEmpty(), (Function0 & Serializable)() -> "RandomForest selected empty nodesForGroup.  Error for unknown reason.");
            scala.collection.immutable.Map topNodesForGroup = ((IterableOnceOps)nodesForGroup2.keys().map((Function1 & Serializable)treeIdx -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)treeIdx))), (Object)topNodes[BoxesRunTime.unboxToInt((Object)treeIdx)]))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            timer.start("findBestSplits");
            scala.collection.immutable.Map<Object, Split>[] bestSplit = this.findBestSplits(baggedInput, metadata, (scala.collection.immutable.Map<Object, LearningNode>)topNodesForGroup, (scala.collection.immutable.Map<Object, LearningNode[]>)nodesForGroup2, (scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>)treeToNodeToIndexInfo2, bcSplits, (ListBuffer<Tuple2<Object, LearningNode>>)nodeStack, timer, nodeIds, strategy.useNodeIdCache());
            if (strategy.useNodeIdCache()) {
                nodeIds = this.updateNodeIds(baggedInput, nodeIds, bcSplits, bestSplit);
                nodeIdCheckpointer.update(nodeIds);
            }
            timer.stop("findBestSplits");
        }
        timer.stop("total");
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Internal timing for DecisionTree:");
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIMER$.MODULE$, (Object)timer)}))));
        if (strategy.useNodeIdCache()) {
            nodeIdCheckpointer.unpersistDataSet();
            nodeIdCheckpointer.deleteAllCheckpoints();
        }
        int numFeatures = metadata.numFeatures();
        Option<String> option2 = parentUID;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String uid = (String)some.value();
            Enumeration.Value value = strategy.algo();
            Enumeration.Value value2 = Algo$.MODULE$.Classification();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                return (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])topNodes), (Function1 & Serializable)rootNode -> new DecisionTreeClassificationModel(uid, rootNode.toNode(prune), numFeatures, strategy.getNumClasses()), ClassTag$.MODULE$.apply(DecisionTreeModel.class));
            }
            return (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])topNodes), (Function1 & Serializable)rootNode -> new DecisionTreeRegressionModel(uid, rootNode.toNode(prune), numFeatures), ClassTag$.MODULE$.apply(DecisionTreeModel.class));
        }
        if (None$.MODULE$.equals(option2)) {
            Enumeration.Value value = strategy.algo();
            Enumeration.Value value3 = Algo$.MODULE$.Classification();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                return (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])topNodes), (Function1 & Serializable)rootNode -> new DecisionTreeClassificationModel(rootNode.toNode(prune), numFeatures, strategy.getNumClasses()), ClassTag$.MODULE$.apply(DecisionTreeModel.class));
            }
            return (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])topNodes), (Function1 & Serializable)rootNode -> new DecisionTreeRegressionModel(rootNode.toNode(prune), numFeatures), ClassTag$.MODULE$.apply(DecisionTreeModel.class));
        }
        throw new MatchError(option2);
    }

    public DecisionTreeModel[] run(RDD<Instance> input, Strategy strategy, int numTrees, String featureSubsetStrategy, long seed, Option<Instrumentation> instr, boolean prune, Option<String> parentUID) {
        TimeTracker timer = new TimeTracker();
        timer.start("build metadata");
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata((RDD<Instance>)input.retag(Instance.class), strategy, numTrees, featureSubsetStrategy);
        timer.stop("build metadata");
        RDD retaggedInput = input.retag(Instance.class);
        timer.start("findSplits");
        Split[][] splits = this.findSplits((RDD<Instance>)retaggedInput, metadata, seed);
        timer.stop("findSplits");
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "numBins: feature: number of bins");
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> scala.package$.MODULE$.Range().apply(0, metadata.numFeatures()).map((Function1 & Serializable)featureIndex -> RandomForest$.$anonfun$run$4(metadata, BoxesRunTime.unboxToInt((Object)featureIndex))).mkString("\n"));
        RDD<TreePoint> treeInput = TreePoint$.MODULE$.convertToTreeRDD((RDD<Instance>)retaggedInput, splits, metadata);
        Broadcast bcSplits = input.sparkContext().broadcast((Object)splits, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Split.class))));
        RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, strategy.subsamplingRate(), numTrees, strategy.bootstrap(), (Function1 & Serializable)tp -> BoxesRunTime.boxToDouble((double)tp.weight()), seed).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName("bagged tree points");
        DecisionTreeModel[] trees = this.runBagged((RDD<BaggedPoint<TreePoint>>)baggedInput, metadata, (Broadcast<Split[][]>)bcSplits, strategy, numTrees, featureSubsetStrategy, seed, instr, prune, parentUID);
        baggedInput.unpersist(baggedInput.unpersist$default$1());
        bcSplits.destroy();
        return trees;
    }

    public boolean runBagged$default$9() {
        return true;
    }

    public Option<String> runBagged$default$10() {
        return None$.MODULE$;
    }

    public boolean run$default$7() {
        return true;
    }

    public Option<String> run$default$8() {
        return None$.MODULE$;
    }

    private RDD<int[]> updateNodeIds(RDD<BaggedPoint<TreePoint>> input, RDD<int[]> nodeIds, Broadcast<Split[][]> bcSplits, scala.collection.immutable.Map<Object, Split>[] bestSplits) {
        Predef$.MODULE$.require(nodeIds != null && bestSplits != null);
        return input.zip(nodeIds, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BaggedPoint point = (BaggedPoint)tuple2._1();
                int[] ids = (int[])tuple2._2();
                IntRef treeId = IntRef.create((int)0);
                while (treeId.elem < bestSplits.length) {
                    scala.collection.immutable.Map bestSplitsInTree = bestSplits[treeId.elem];
                    if (bestSplitsInTree != null) {
                        int nodeId = ids[treeId.elem];
                        bestSplitsInTree.get((Object)BoxesRunTime.boxToInteger((int)nodeId)).foreach((Function1 & Serializable)bestSplit -> {
                            RandomForest$.$anonfun$updateNodeIds$2(point, bcSplits, nodeId, ids, treeId, bestSplit);
                            return BoxedUnit.UNIT;
                        });
                    }
                    ++treeId.elem;
                }
                return ids;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
    }

    private void mixedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, Split[][] splits, Set<Object> unorderedFeatures, int numSamples, double sampleWeight, Option<int[]> featuresForNode) {
        int numFeaturesPerNode = featuresForNode.nonEmpty() ? ((int[])featuresForNode.get()).length : agg.metadata().numFeatures();
        for (int featureIndexIdx = 0; featureIndexIdx < numFeaturesPerNode; ++featureIndexIdx) {
            int featureIndex;
            int n = featureIndex = featuresForNode.nonEmpty() ? ((int[])featuresForNode.get())[featureIndexIdx] : featureIndexIdx;
            if (unorderedFeatures.contains((Object)BoxesRunTime.boxToInteger((int)featureIndex))) {
                int featureValue = treePoint.binnedFeatures()[featureIndex];
                int leftNodeFeatureOffset = agg.getFeatureOffset(featureIndexIdx);
                int numSplits = agg.metadata().numSplits(featureIndex);
                Split[] featureSplits = splits[featureIndex];
                for (int splitIndex = 0; splitIndex < numSplits; ++splitIndex) {
                    if (!featureSplits[splitIndex].shouldGoLeft(featureValue, featureSplits)) continue;
                    agg.featureUpdate(leftNodeFeatureOffset, splitIndex, treePoint.label(), numSamples, sampleWeight);
                }
                continue;
            }
            int binIndex = treePoint.binnedFeatures()[featureIndex];
            agg.update(featureIndexIdx, binIndex, treePoint.label(), numSamples, sampleWeight);
        }
    }

    private void orderedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, int numSamples, double sampleWeight, Option<int[]> featuresForNode) {
        double label = treePoint.label();
        if (featuresForNode.nonEmpty()) {
            for (int featureIndexIdx = 0; featureIndexIdx < ((int[])featuresForNode.get()).length; ++featureIndexIdx) {
                int binIndex = treePoint.binnedFeatures()[((int[])featuresForNode.get())[featureIndexIdx]];
                agg.update(featureIndexIdx, binIndex, label, numSamples, sampleWeight);
            }
            return;
        }
        int numFeatures = agg.metadata().numFeatures();
        for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
            int binIndex = treePoint.binnedFeatures()[featureIndex];
            agg.update(featureIndex, binIndex, label, numSamples, sampleWeight);
        }
    }

    public scala.collection.immutable.Map<Object, Split>[] findBestSplits(RDD<BaggedPoint<TreePoint>> input, DecisionTreeMetadata metadata, scala.collection.immutable.Map<Object, LearningNode> topNodesForGroup, scala.collection.immutable.Map<Object, LearningNode[]> nodesForGroup, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> treeToNodeToIndexInfo, Broadcast<Split[][]> bcSplits, ListBuffer<Tuple2<Object, LearningNode>> nodeStack, TimeTracker timer, RDD<int[]> nodeIds, boolean outputBestSplits) {
        RDD rDD;
        boolean useNodeIdCache = nodeIds != null;
        int numNodes = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)nodesForGroup.values().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)RandomForest$.$anonfun$findBestSplits$1(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "numNodes = " + numNodes);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "numFeatures = " + metadata.numFeatures());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "numClasses = " + metadata.numClasses());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "isMulticlass = " + metadata.isMulticlass());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "isMulticlassWithCategoricalFeatures = " + metadata.isMulticlassWithCategoricalFeatures());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "using nodeIdCache = " + useNodeIdCache);
        LearningNode[] nodes = new LearningNode[numNodes];
        nodesForGroup.foreach((Function1 & Serializable)x0$1 -> {
            RandomForest$.$anonfun$findBestSplits$14(nodes, treeToNodeToIndexInfo, x0$1);
            return BoxedUnit.UNIT;
        });
        timer.start("chooseSplits");
        Option nodeToFeatures = RandomForest$.getNodeToFeatures$1(treeToNodeToIndexInfo, metadata);
        Broadcast nodeToFeaturesBc = input.sparkContext().broadcast((Object)nodeToFeatures, ClassTag$.MODULE$.apply(Option.class));
        if (useNodeIdCache) {
            RDD qual$1 = input.zip(nodeIds, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
            Function1 & Serializable x$1 = (Function1 & Serializable)points -> {
                DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(numNodes, (Function1 & Serializable)nodeIndex -> RandomForest$.$anonfun$findBestSplits$17(nodeToFeaturesBc, metadata, BoxesRunTime.unboxToInt((Object)nodeIndex)), ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                points.foreach((Function1 & Serializable)x$4 -> this.binSeqOpWithNodeIdCache$1(nodeStatsAggregators, (Tuple2)x$4, (Split[][])bcSplits.value(), treeToNodeToIndexInfo, metadata));
                return ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators)).zipWithIndex().map((Function1 & Serializable)x$5 -> x$5.swap());
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            rDD = input.mapPartitions((Function1 & Serializable)points -> {
                DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(numNodes, (Function1 & Serializable)nodeIndex -> RandomForest$.$anonfun$findBestSplits$22(nodeToFeaturesBc, metadata, BoxesRunTime.unboxToInt((Object)nodeIndex)), ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                points.foreach((Function1 & Serializable)x$6 -> this.binSeqOp$1(nodeStatsAggregators, (BaggedPoint)x$6, (Split[][])bcSplits.value(), treeToNodeToIndexInfo, topNodesForGroup, metadata));
                return ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators)).zipWithIndex().map((Function1 & Serializable)x$7 -> x$7.swap());
            }, input.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        }
        RDD partitionAggregates = rDD;
        Map nodeToBestSplits = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(partitionAggregates, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(DTStatsAggregator.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable)(a, b) -> a.merge((DTStatsAggregator)b)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            block2: {
                Split split;
                ImpurityStats stats;
                int nodeIndex;
                block4: {
                    Tuple2<Split, ImpurityStats> tuple22;
                    block3: {
                        tuple2 = x0$2;
                        if (tuple2 == null) break block2;
                        nodeIndex = tuple2._1$mcI$sp();
                        DTStatsAggregator aggStats = (DTStatsAggregator)tuple2._2();
                        Option featuresForNode = ((Option)nodeToFeaturesBc.value()).flatMap((Function1 & Serializable)nodeToFeatures -> new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex))));
                        tuple22 = MODULE$.binsToBestSplit(aggStats, (Split[][])bcSplits.value(), (Option<int[]>)featuresForNode, nodes[nodeIndex]);
                        if (tuple22 == null) break block3;
                        Split split2 = (Split)tuple22._1();
                        stats = (ImpurityStats)tuple22._2();
                        if (split2 == null) break block3;
                        split = split2;
                        if (stats != null) break block4;
                    }
                    throw new MatchError(tuple22);
                }
                ImpurityStats impurityStats = stats;
                Tuple2 tuple23 = new Tuple2((Object)split, (Object)impurityStats);
                Split split3 = (Split)tuple23._1();
                ImpurityStats stats2 = (ImpurityStats)tuple23._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)new Tuple2((Object)split3, (Object)stats2));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        nodeToFeaturesBc.destroy();
        timer.stop("chooseSplits");
        scala.collection.mutable.Map[] bestSplits = outputBestSplits ? (scala.collection.mutable.Map[])Array$.MODULE$.ofDim(metadata.numTrees(), ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class)) : null;
        nodesForGroup.foreach((Function1 & Serializable)x0$3 -> {
            RandomForest$.$anonfun$findBestSplits$29(treeToNodeToIndexInfo, nodeToBestSplits, metadata, outputBestSplits, bestSplits, nodeStack, x0$3);
            return BoxedUnit.UNIT;
        });
        if (outputBestSplits) {
            return (scala.collection.immutable.Map[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])bestSplits), (Function1 & Serializable)m -> {
                if (m == null) {
                    return null;
                }
                return m.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class));
        }
        return null;
    }

    public TimeTracker findBestSplits$default$8() {
        return new TimeTracker();
    }

    public RDD<int[]> findBestSplits$default$9() {
        return null;
    }

    public boolean findBestSplits$default$10() {
        return false;
    }

    private ImpurityStats calculateImpurityStats(ImpurityStats stats, ImpurityCalculator leftImpurityCalculator, ImpurityCalculator rightImpurityCalculator, DecisionTreeMetadata metadata) {
        double rightImpurity;
        double rightWeight;
        boolean violatesMinWeightPerNode;
        ImpurityCalculator parentImpurityCalculator = stats == null ? leftImpurityCalculator.copy().add(rightImpurityCalculator) : stats.impurityCalculator();
        double impurity = stats == null ? parentImpurityCalculator.calculate() : stats.impurity();
        long leftRawCount = leftImpurityCalculator.rawCount();
        long rightRawCount = rightImpurityCalculator.rawCount();
        double leftCount = leftImpurityCalculator.count();
        double rightCount = rightImpurityCalculator.count();
        double totalCount = leftCount + rightCount;
        boolean violatesMinInstancesPerNode = leftRawCount < (long)metadata.minInstancesPerNode() || rightRawCount < (long)metadata.minInstancesPerNode();
        boolean bl = violatesMinWeightPerNode = leftCount < metadata.minWeightPerNode() || rightCount < metadata.minWeightPerNode();
        if (violatesMinInstancesPerNode || violatesMinWeightPerNode) {
            return ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator);
        }
        double leftWeight = leftCount / totalCount;
        double leftImpurity = leftImpurityCalculator.calculate();
        double gain = impurity - leftWeight * leftImpurity - (rightWeight = rightCount / totalCount) * (rightImpurity = rightImpurityCalculator.calculate());
        if (gain < metadata.minInfoGain()) {
            return ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator);
        }
        return new ImpurityStats(gain, impurity, parentImpurityCalculator, leftImpurityCalculator, rightImpurityCalculator, ImpurityStats$.MODULE$.$lessinit$greater$default$6());
    }

    public Tuple2<Split, ImpurityStats> binsToBestSplit(DTStatsAggregator binAggregates, Split[][] splits, Option<int[]> featuresForNode, LearningNode node) {
        Tuple2 tuple2;
        int level = LearningNode$.MODULE$.indexToLevel(node.id());
        ObjectRef gainAndImpurityStats = ObjectRef.create((Object)(level == 0 ? null : node.stats()));
        Iterator validFeatureSplits = scala.package$.MODULE$.Iterator().range(0, binAggregates.metadata().numFeaturesPerNode()).map((Function1 & Serializable)featureIndexIdx -> RandomForest$.$anonfun$binsToBestSplit$1(featuresForNode, BoxesRunTime.unboxToInt((Object)featureIndexIdx))).withFilter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RandomForest$.$anonfun$binsToBestSplit$4(binAggregates, x0$1)));
        Iterator splitsAndImpurityInfo = validFeatureSplits.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int featureIndexIdx = tuple2._1$mcI$sp();
                int featureIndex = tuple2._2$mcI$sp();
                int numSplits = binAggregates.metadata().numSplits(featureIndex);
                if (binAggregates.metadata().isContinuous(featureIndex)) {
                    int nodeFeatureOffset = binAggregates.getFeatureOffset(featureIndexIdx);
                    for (int splitIndex2 = 0; splitIndex2 < numSplits; ++splitIndex2) {
                        binAggregates.mergeForFeature(nodeFeatureOffset, splitIndex2 + 1, splitIndex2);
                    }
                    Tuple2 tuple22 = (Tuple2)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1 & Serializable)splitIdx -> RandomForest$.$anonfun$binsToBestSplit$6(binAggregates, nodeFeatureOffset, numSplits, gainAndImpurityStats, BoxesRunTime.unboxToInt((Object)splitIdx))).maxBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$7(x$10)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    int bestFeatureSplitIndex = tuple22._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                    int bestFeatureSplitIndex2 = tuple23._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats2 = (ImpurityStats)tuple23._2();
                    return new Tuple2((Object)splits[featureIndex][bestFeatureSplitIndex2], (Object)bestFeatureGainStats2);
                }
                if (binAggregates.metadata().isUnordered(featureIndex)) {
                    int leftChildOffset = binAggregates.getFeatureOffset(featureIndexIdx);
                    Tuple2 tuple24 = (Tuple2)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1 & Serializable)splitIndex -> RandomForest$.$anonfun$binsToBestSplit$8(binAggregates, leftChildOffset, gainAndImpurityStats, BoxesRunTime.unboxToInt((Object)splitIndex))).maxBy((Function1 & Serializable)x$12 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$9(x$12)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    int bestFeatureSplitIndex = tuple24._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                    int bestFeatureSplitIndex3 = tuple25._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats3 = (ImpurityStats)tuple25._2();
                    return new Tuple2((Object)splits[featureIndex][bestFeatureSplitIndex3], (Object)bestFeatureGainStats3);
                }
                int nodeFeatureOffset = binAggregates.getFeatureOffset(featureIndexIdx);
                int numCategories = binAggregates.metadata().numBins()[featureIndex];
                IndexedSeq centroidForCategories = scala.package$.MODULE$.Range().apply(0, numCategories).map((Function1 & Serializable)featureValue -> RandomForest$.$anonfun$binsToBestSplit$10(binAggregates, nodeFeatureOffset, BoxesRunTime.unboxToInt((Object)featureValue)));
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Centroids for categorical variable: " + centroidForCategories.mkString(","));
                List categoriesSortedByCentroid = (List)centroidForCategories.toList().sortBy((Function1 & Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Sorted centroids for categorical variable = " + categoriesSortedByCentroid.mkString(","));
                for (int splitIndex3 = 0; splitIndex3 < numSplits; ++splitIndex3) {
                    int currentCategory = ((Tuple2)categoriesSortedByCentroid.apply(splitIndex3))._1$mcI$sp();
                    int nextCategory = ((Tuple2)categoriesSortedByCentroid.apply(splitIndex3 + 1))._1$mcI$sp();
                    binAggregates.mergeForFeature(nodeFeatureOffset, nextCategory, currentCategory);
                }
                int lastCategory = ((Tuple2)categoriesSortedByCentroid.last())._1$mcI$sp();
                Tuple2 tuple26 = (Tuple2)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1 & Serializable)splitIndex -> RandomForest$.$anonfun$binsToBestSplit$14(categoriesSortedByCentroid, binAggregates, nodeFeatureOffset, lastCategory, gainAndImpurityStats, BoxesRunTime.unboxToInt((Object)splitIndex))).maxBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$15(x$15)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                if (tuple26 == null) {
                    throw new MatchError((Object)tuple26);
                }
                int bestFeatureSplitIndex = tuple26._1$mcI$sp();
                ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple26._2();
                Tuple2 tuple27 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                int bestFeatureSplitIndex4 = tuple27._1$mcI$sp();
                ImpurityStats bestFeatureGainStats4 = (ImpurityStats)tuple27._2();
                List categoriesForSplit = categoriesSortedByCentroid.map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToDouble((double)x$17._1$mcI$sp())).slice(0, bestFeatureSplitIndex4 + 1);
                CategoricalSplit bestFeatureSplit = new CategoricalSplit(featureIndex, (double[])categoriesForSplit.toArray((ClassTag)ClassTag$.MODULE$.Double()), numCategories);
                return new Tuple2((Object)bestFeatureSplit, (Object)bestFeatureGainStats4);
            }
            throw new MatchError((Object)tuple2);
        });
        if (splitsAndImpurityInfo.isEmpty()) {
            int dummyFeatureIndex = BoxesRunTime.unboxToInt((Object)featuresForNode.map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)RandomForest$.$anonfun$binsToBestSplit$17(x$18))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            ImpurityCalculator parentImpurityCalculator = binAggregates.getParentImpurityCalculator();
            if (binAggregates.metadata().isContinuous(dummyFeatureIndex)) {
                v0 = new Tuple2((Object)new ContinuousSplit(dummyFeatureIndex, 0.0), (Object)ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator));
            } else {
                int numCategories = BoxesRunTime.unboxToInt((Object)binAggregates.metadata().featureArity().apply((Object)BoxesRunTime.boxToInteger((int)dummyFeatureIndex)));
                v0 = new Tuple2((Object)new CategoricalSplit(dummyFeatureIndex, (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()), numCategories), (Object)ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator));
            }
        } else {
            v0 = tuple2 = (Tuple2)splitsAndImpurityInfo.maxBy((Function1 & Serializable)x$19 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$19(x$19)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Split bestSplit = (Split)tuple2._1();
        ImpurityStats bestSplitStats = (ImpurityStats)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)bestSplit, (Object)bestSplitStats);
        Split bestSplit2 = (Split)tuple22._1();
        ImpurityStats bestSplitStats2 = (ImpurityStats)tuple22._2();
        return new Tuple2((Object)bestSplit2, (Object)bestSplitStats2);
    }

    public Split[][] findSplits(RDD<Instance> input, DecisionTreeMetadata metadata, long seed) {
        RDD rDD;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "isMulticlass = " + metadata.isMulticlass());
        int numFeatures = metadata.numFeatures();
        IndexedSeq continuousFeatures = (IndexedSeq)scala.package$.MODULE$.Range().apply(0, numFeatures).filter((Function1)(JFunction1.mcZI.sp & Serializable)featureIndex -> metadata.isContinuous(featureIndex));
        if (continuousFeatures.nonEmpty()) {
            double fraction = this.samplesFractionForFindSplits(metadata);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "fraction of data used for calculating quantiles = " + fraction);
            rDD = fraction < 1.0 ? input.sample(false, fraction, (long)new XORShiftRandom(seed).nextInt()) : input;
        } else {
            rDD = input.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Instance.class));
        }
        RDD sampledInput = rDD;
        return this.findSplitsBySorting((RDD<Instance>)sampledInput, metadata, (IndexedSeq<Object>)continuousFeatures);
    }

    private Split[][] findSplitsBySorting(RDD<Instance> input, DecisionTreeMetadata metadata, IndexedSeq<Object> continuousFeatures) {
        scala.collection.immutable.Map map;
        if (continuousFeatures.nonEmpty()) {
            int numPartitions = package$.MODULE$.min(continuousFeatures.length(), input.partitions().length);
            map = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(input.flatMap((Function1 & Serializable)point -> continuousFeatures.iterator().map((Function1 & Serializable)idx -> RandomForest$.$anonfun$findSplitsBySorting$2(point, BoxesRunTime.unboxToInt((Object)idx))).filter((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)RandomForest$.$anonfun$findSplitsBySorting$3(x$21))), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new Tuple2((Object)new OpenHashMap.mcD.sp((ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double()), (Object)BoxesRunTime.boxToLong((long)0L)), numPartitions, (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        OpenHashMap map = (OpenHashMap)tuple22._1();
                        long c = tuple22._2$mcJ$sp();
                        if (tuple23 != null) {
                            double v = tuple23._1$mcD$sp();
                            double w = tuple23._2$mcD$sp();
                            map.changeValue$mcD$sp((Object)BoxesRunTime.boxToDouble((double)v), (Function0)(JFunction0.mcD.sp & Serializable)() -> w, (Function1)(JFunction1.mcDD.sp & Serializable)x$22 -> x$22 + w);
                            return new Tuple2((Object)map, (Object)BoxesRunTime.boxToLong((long)(c + 1L)));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }, (Function2 & Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        OpenHashMap map1 = (OpenHashMap)tuple22._1();
                        long c1 = tuple22._2$mcJ$sp();
                        if (tuple23 != null) {
                            OpenHashMap map2 = (OpenHashMap)tuple23._1();
                            long c2 = tuple23._2$mcJ$sp();
                            map2.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$findSplitsBySorting$8(map1, x0$3)));
                            return new Tuple2((Object)map1, (Object)BoxesRunTime.boxToLong((long)(c1 + c2)));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    int idx = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        OpenHashMap map = (OpenHashMap)tuple22._1();
                        long c = tuple22._2$mcJ$sp();
                        double[] thresholds = MODULE$.findSplitsForContinuousFeature((scala.collection.immutable.Map<Object, Object>)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), c, metadata, idx);
                        Split[] splits = (Split[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(thresholds), (Function1 & Serializable)thresh -> RandomForest$.$anonfun$findSplitsBySorting$12(idx, BoxesRunTime.unboxToDouble((Object)thresh)), ClassTag$.MODULE$.apply(Split.class));
                        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "featureIndex = " + idx + ", numSplits = " + splits.length);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)idx), (Object)splits);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Split.class)), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        scala.collection.immutable.Map continuousSplits = map;
        int numFeatures = metadata.numFeatures();
        Split[][] splits = (Split[][])Array$.MODULE$.tabulate(numFeatures, arg_0 -> RandomForest$.$anonfun$findSplitsBySorting$14$adapted(metadata, (Map)continuousSplits, arg_0), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Split.class)));
        return splits;
    }

    public List<Object> extractMultiClassCategories(int input, int maxFeatureValue) {
        Nil$ categories = Nil$.MODULE$;
        int bitShiftedInput = input;
        for (int j = 0; j < maxFeatureValue; ++j) {
            if (bitShiftedInput % 2 != 0) {
                double d = j;
                categories = categories.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d));
            }
            bitShiftedInput >>= 1;
        }
        return categories;
    }

    public double[] findSplitsForContinuousFeature(Iterable<Tuple2<Object, Object>> featureSamples, DecisionTreeMetadata metadata, int featureIndex) {
        OpenHashMap.mcD.sp valueWeights = new OpenHashMap.mcD.sp((ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double());
        LongRef count = LongRef.create((long)0L);
        featureSamples.foreach(arg_0 -> RandomForest$.$anonfun$findSplitsForContinuousFeature$1$adapted((OpenHashMap)valueWeights, count, arg_0));
        return this.findSplitsForContinuousFeature((scala.collection.immutable.Map<Object, Object>)valueWeights.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), count.elem, metadata, featureIndex);
    }

    public double[] findSplitsForContinuousFeature(scala.collection.immutable.Map<Object, Object> partValueWeights, long count, DecisionTreeMetadata metadata, int featureIndex) {
        double[] dArray;
        Predef$.MODULE$.require(metadata.isContinuous(featureIndex), (Function0 & Serializable)() -> "findSplitsForContinuousFeature can only be used to find splits for a continuous feature.");
        if (partValueWeights.isEmpty()) {
            dArray = Array$.MODULE$.emptyDoubleArray();
        } else {
            double tolerance;
            int numSplits = metadata.numSplits(featureIndex);
            double partNumSamples = BoxesRunTime.unboxToDouble((Object)partValueWeights.values().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double weightedNumSamples = this.samplesFractionForFindSplits(metadata) * metadata.weightedNumExamples();
            scala.collection.immutable.Map valueCountMap = weightedNumSamples - partNumSamples > (tolerance = Utils$.MODULE$.EPSILON() * (double)count * (double)100) ? (scala.collection.immutable.Map)partValueWeights.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToDouble((double)(weightedNumSamples - partNumSamples)))) : partValueWeights;
            Tuple2[] valueCounts = (Tuple2[])((IterableOnceOps)valueCountMap.toSeq().sortBy((Function1 & Serializable)x$25 -> BoxesRunTime.boxToDouble((double)x$25._1$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            int possibleSplits = valueCounts.length - 1;
            if (possibleSplits == 0) {
                dArray = Array$.MODULE$.emptyDoubleArray();
            } else if (possibleSplits <= numSplits) {
                dArray = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), possibleSplits).map((Function1)(JFunction1.mcDI.sp & Serializable)index -> (valueCounts[index - 1]._1$mcD$sp() + valueCounts[index]._1$mcD$sp()) / 2.0).toArray((ClassTag)ClassTag$.MODULE$.Double());
            } else {
                double stride = weightedNumSamples / (double)(numSplits + 1);
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "stride = " + stride);
                ArrayBuilder splitsBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
                double currentCount = valueCounts[0]._2$mcD$sp();
                double targetCount = stride;
                for (int index2 = 1; index2 < valueCounts.length; ++index2) {
                    double currentGap;
                    double previousCount = currentCount;
                    currentCount += valueCounts[index2]._2$mcD$sp();
                    double previousGap = package$.MODULE$.abs(previousCount - targetCount);
                    if (!(previousGap < (currentGap = package$.MODULE$.abs(currentCount - targetCount)))) continue;
                    splitsBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((valueCounts[index2 - 1]._1$mcD$sp() + valueCounts[index2]._1$mcD$sp()) / 2.0)));
                    targetCount += stride;
                }
                dArray = (double[])splitsBuilder.result();
            }
        }
        double[] splits = dArray;
        return splits;
    }

    public Tuple2<scala.collection.immutable.Map<Object, LearningNode[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>> selectNodesToSplit(ListBuffer<Tuple2<Object, LearningNode>> nodeStack, long maxMemoryUsage, DecisionTreeMetadata metadata, Random rng) {
        scala.collection.mutable.HashMap mutableNodesForGroup = new scala.collection.mutable.HashMap();
        scala.collection.mutable.HashMap mutableTreeToNodeToIndexInfo = new scala.collection.mutable.HashMap();
        LongRef memUsage = LongRef.create((long)0L);
        IntRef numNodesInGroup = IntRef.create((int)0);
        boolean groupDone = false;
        while (nodeStack.nonEmpty() && !groupDone) {
            Tuple2 tuple2 = (Tuple2)nodeStack.head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int treeIndex = tuple2._1$mcI$sp();
            LearningNode node = (LearningNode)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)node);
            int treeIndex2 = tuple22._1$mcI$sp();
            LearningNode node2 = (LearningNode)tuple22._2();
            None$ featureSubset = metadata.subsamplingFeatures() ? new Some(SamplingUtils$.MODULE$.reservoirSampleAndCount(scala.package$.MODULE$.Range().apply(0, metadata.numFeatures()).iterator(), metadata.numFeaturesPerNode(), rng.nextLong(), (ClassTag)ClassTag$.MODULE$.Int())._1()) : None$.MODULE$;
            long nodeMemUsage = this.aggregateSizeForNode(metadata, (Option<int[]>)featureSubset) * 8L;
            if (memUsage.elem + nodeMemUsage <= maxMemoryUsage || memUsage.elem == 0L) {
                nodeStack.remove(0);
                ((Growable)mutableNodesForGroup.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0 & Serializable)() -> new ArrayBuffer())).$plus$eq((Object)node2);
                ((scala.collection.mutable.HashMap)mutableTreeToNodeToIndexInfo.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0 & Serializable)() -> new scala.collection.mutable.HashMap())).update((Object)BoxesRunTime.boxToInteger((int)node2.id()), (Object)new RandomForest.NodeIndexInfo(numNodesInGroup.elem, (Option<int[]>)featureSubset));
                ++numNodesInGroup.elem;
                memUsage.elem += nodeMemUsage;
                continue;
            }
            groupDone = true;
        }
        if (memUsage.elem > maxMemoryUsage) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Tree learning is using approximately ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MEMORY_SIZE$.MODULE$, (Object)BoxesRunTime.boxToLong((long)memUsage$1.elem))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bytes per iteration, which exceeds requested limit "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"maxMemoryUsage=", ". This allows splitting "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_MEMORY_SIZE$.MODULE$, (Object)BoxesRunTime.boxToLong((long)maxMemoryUsage))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " nodes in this iteration."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_NODES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)numNodesInGroup$1.elem))})))));
        }
        scala.collection.immutable.Map nodesForGroup = (scala.collection.immutable.Map)mutableNodesForGroup.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).transform((Function2 & Serializable)(x$27, v) -> RandomForest$.$anonfun$selectNodesToSplit$4(BoxesRunTime.unboxToInt((Object)x$27), v));
        scala.collection.immutable.Map treeToNodeToIndexInfo = (scala.collection.immutable.Map)mutableTreeToNodeToIndexInfo.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).transform((Function2 & Serializable)(x$28, v) -> v.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
    }

    private long aggregateSizeForNode(DecisionTreeMetadata metadata, Option<int[]> featureSubset) {
        long totalBins;
        long l = totalBins = featureSubset.nonEmpty() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps((int[])featureSubset.get()), (Function1)(JFunction1.mcJI.sp & Serializable)featureIndex -> metadata.numBins()[featureIndex], (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(metadata.numBins()), (Function1)(JFunction1.mcJI.sp & Serializable)x$29 -> x$29, (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (metadata.isClassification()) {
            return (long)metadata.numClasses() * totalBins;
        }
        return 3L * totalBins;
    }

    private double samplesFractionForFindSplits(DecisionTreeMetadata metadata) {
        int requiredSamples = package$.MODULE$.max(metadata.maxBins() * metadata.maxBins(), 10000);
        if ((long)requiredSamples < metadata.numExamples()) {
            return (double)requiredSamples / (double)metadata.numExamples();
        }
        return 1.0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RandomForest$.class);
    }

    public static final /* synthetic */ String $anonfun$run$4(DecisionTreeMetadata metadata$2, int featureIndex) {
        return "\t" + featureIndex + "\t" + metadata$2.numBins()[featureIndex];
    }

    public static final /* synthetic */ void $anonfun$updateNodeIds$2(BaggedPoint point$1, Broadcast bcSplits$1, int nodeId$1, int[] ids$1, IntRef treeId$1, Split bestSplit) {
        int newNodeId;
        int featureId = bestSplit.featureIndex();
        int bin = ((TreePoint)point$1.datum()).binnedFeatures()[featureId];
        ids$1[treeId$1.elem] = newNodeId = bestSplit.shouldGoLeft(bin, ((Split[][])bcSplits$1.value())[featureId]) ? LearningNode$.MODULE$.leftChildIndex(nodeId$1) : LearningNode$.MODULE$.rightChildIndex(nodeId$1);
    }

    public static final /* synthetic */ int $anonfun$findBestSplits$1(LearningNode[] x$3) {
        return x$3.length;
    }

    private final void nodeBinSeqOp$1(int treeIndex, RandomForest.NodeIndexInfo nodeInfo, DTStatsAggregator[] agg, BaggedPoint baggedPoint, Split[][] splits, DecisionTreeMetadata metadata$3) {
        if (nodeInfo != null) {
            int aggNodeIndex = nodeInfo.nodeIndexInGroup();
            Option<int[]> featuresForNode = nodeInfo.featureSubset();
            int numSamples = baggedPoint.subsampleCounts()[treeIndex];
            double sampleWeight = baggedPoint.sampleWeight();
            if (metadata$3.unorderedFeatures().isEmpty()) {
                this.orderedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), numSamples, sampleWeight, featuresForNode);
            } else {
                this.mixedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), splits, metadata$3.unorderedFeatures(), numSamples, sampleWeight, featuresForNode);
            }
            agg[aggNodeIndex].updateParent(((TreePoint)baggedPoint.datum()).label(), numSamples, sampleWeight);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$8(RandomForest$ $this, scala.collection.immutable.Map topNodesForGroup$1, BaggedPoint baggedPoint$1, Split[][] splits$1, DTStatsAggregator[] agg$1, DecisionTreeMetadata metadata$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int treeIndex = tuple2._1$mcI$sp();
            scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
            int nodeIndex = ((LearningNode)topNodesForGroup$1.apply((Object)BoxesRunTime.boxToInteger((int)treeIndex))).predictImpl(((TreePoint)baggedPoint$1.datum()).binnedFeatures(), splits$1);
            $this.nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0 & Serializable)() -> null), agg$1, baggedPoint$1, splits$1, metadata$3);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final DTStatsAggregator[] binSeqOp$1(DTStatsAggregator[] agg, BaggedPoint baggedPoint, Split[][] splits, scala.collection.immutable.Map treeToNodeToIndexInfo$1, scala.collection.immutable.Map topNodesForGroup$1, DecisionTreeMetadata metadata$3) {
        treeToNodeToIndexInfo$1.foreach((Function1 & Serializable)x0$1 -> {
            RandomForest$.$anonfun$findBestSplits$8(this, topNodesForGroup$1, baggedPoint, splits, agg, metadata$3, x0$1);
            return BoxedUnit.UNIT;
        });
        return agg;
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$10(RandomForest$ $this, Tuple2 dataPoint$1, DTStatsAggregator[] agg$2, Split[][] splits$2, DecisionTreeMetadata metadata$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int treeIndex = tuple2._1$mcI$sp();
            scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
            BaggedPoint baggedPoint = (BaggedPoint)dataPoint$1._1();
            int[] nodeIdCache = (int[])dataPoint$1._2();
            int nodeIndex = nodeIdCache[treeIndex];
            $this.nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0 & Serializable)() -> null), agg$2, baggedPoint, splits$2, metadata$3);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final DTStatsAggregator[] binSeqOpWithNodeIdCache$1(DTStatsAggregator[] agg, Tuple2 dataPoint, Split[][] splits, scala.collection.immutable.Map treeToNodeToIndexInfo$1, DecisionTreeMetadata metadata$3) {
        treeToNodeToIndexInfo$1.foreach((Function1 & Serializable)x0$1 -> {
            RandomForest$.$anonfun$findBestSplits$10(this, dataPoint, agg, splits, metadata$3, x0$1);
            return BoxedUnit.UNIT;
        });
        return agg;
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$13(scala.collection.mutable.HashMap mutableNodeToFeatures$1, RandomForest.NodeIndexInfo nodeIndexInfo) {
        Predef$.MODULE$.assert(nodeIndexInfo.featureSubset().isDefined());
        mutableNodeToFeatures$1.update((Object)BoxesRunTime.boxToInteger((int)nodeIndexInfo.nodeIndexInGroup()), nodeIndexInfo.featureSubset().get());
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$12(scala.collection.mutable.HashMap mutableNodeToFeatures$1, scala.collection.immutable.Map nodeIdToNodeInfo) {
        nodeIdToNodeInfo.values().foreach((Function1 & Serializable)nodeIndexInfo -> {
            RandomForest$.$anonfun$findBestSplits$13(mutableNodeToFeatures$1, nodeIndexInfo);
            return BoxedUnit.UNIT;
        });
    }

    private static final Option getNodeToFeatures$1(scala.collection.immutable.Map treeToNodeToIndexInfo, DecisionTreeMetadata metadata$3) {
        if (!metadata$3.subsamplingFeatures()) {
            return None$.MODULE$;
        }
        scala.collection.mutable.HashMap mutableNodeToFeatures = new scala.collection.mutable.HashMap();
        treeToNodeToIndexInfo.values().foreach((Function1 & Serializable)nodeIdToNodeInfo -> {
            RandomForest$.$anonfun$findBestSplits$12(mutableNodeToFeatures, nodeIdToNodeInfo);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)mutableNodeToFeatures.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$14(LearningNode[] nodes$1, scala.collection.immutable.Map treeToNodeToIndexInfo$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int treeIndex = tuple2._1$mcI$sp();
            LearningNode[] nodesForTree = (LearningNode[])tuple2._2();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])nodesForTree), (Function1 & Serializable)node -> {
                nodes$1[((RandomForest.NodeIndexInfo)((MapOps)treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)treeIndex))).apply((Object)BoxesRunTime.boxToInteger((int)node.id()))).nodeIndexInGroup()] = node;
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ DTStatsAggregator $anonfun$findBestSplits$17(Broadcast nodeToFeaturesBc$1, DecisionTreeMetadata metadata$3, int nodeIndex) {
        Option featuresForNode = ((Option)nodeToFeaturesBc$1.value()).map((Function1 & Serializable)nodeToFeatures -> (int[])nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex)));
        return new DTStatsAggregator(metadata$3, (Option<int[]>)featuresForNode);
    }

    public static final /* synthetic */ DTStatsAggregator $anonfun$findBestSplits$22(Broadcast nodeToFeaturesBc$1, DecisionTreeMetadata metadata$3, int nodeIndex) {
        Option featuresForNode = ((Option)nodeToFeaturesBc$1.value()).flatMap((Function1 & Serializable)nodeToFeatures -> new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex))));
        return new DTStatsAggregator(metadata$3, (Option<int[]>)featuresForNode);
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$30(scala.collection.immutable.Map treeToNodeToIndexInfo$1, int treeIndex$2, Map nodeToBestSplits$1, DecisionTreeMetadata metadata$3, boolean outputBestSplits$1, scala.collection.mutable.Map[] bestSplits$2, ListBuffer nodeStack$2, LearningNode node) {
        Split split;
        ImpurityStats stats;
        int nodeIndex;
        block8: {
            Tuple2 tuple2;
            block7: {
                nodeIndex = node.id();
                RandomForest.NodeIndexInfo nodeInfo = (RandomForest.NodeIndexInfo)((MapOps)treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)treeIndex$2))).apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex));
                int aggNodeIndex = nodeInfo.nodeIndexInGroup();
                tuple2 = (Tuple2)nodeToBestSplits$1.apply((Object)BoxesRunTime.boxToInteger((int)aggNodeIndex));
                if (tuple2 == null) break block7;
                Split split2 = (Split)tuple2._1();
                stats = (ImpurityStats)tuple2._2();
                if (split2 == null) break block7;
                split = split2;
                if (stats != null) break block8;
            }
            throw new MatchError((Object)tuple2);
        }
        ImpurityStats impurityStats = stats;
        Tuple2 tuple2 = new Tuple2((Object)split, (Object)impurityStats);
        Split split3 = (Split)tuple2._1();
        ImpurityStats stats2 = (ImpurityStats)tuple2._2();
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "best split = " + split3);
        boolean isLeaf = stats2.gain() <= 0.0 || LearningNode$.MODULE$.indexToLevel(nodeIndex) == metadata$3.maxDepth();
        node.isLeaf_$eq(isLeaf);
        node.stats_$eq(stats2);
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Node = " + node);
        if (!isLeaf) {
            node.split_$eq((Option<Split>)new Some((Object)split3));
            boolean childIsLeaf = LearningNode$.MODULE$.indexToLevel(nodeIndex) + 1 == metadata$3.maxDepth();
            boolean leftChildIsLeaf = childIsLeaf || package$.MODULE$.abs(stats2.leftImpurity()) < Utils$.MODULE$.EPSILON();
            boolean rightChildIsLeaf = childIsLeaf || package$.MODULE$.abs(stats2.rightImpurity()) < Utils$.MODULE$.EPSILON();
            node.leftChild_$eq((Option<LearningNode>)new Some((Object)LearningNode$.MODULE$.apply(LearningNode$.MODULE$.leftChildIndex(nodeIndex), leftChildIsLeaf, ImpurityStats$.MODULE$.getEmptyImpurityStats(stats2.leftImpurityCalculator()))));
            node.rightChild_$eq((Option<LearningNode>)new Some((Object)LearningNode$.MODULE$.apply(LearningNode$.MODULE$.rightChildIndex(nodeIndex), rightChildIsLeaf, ImpurityStats$.MODULE$.getEmptyImpurityStats(stats2.rightImpurityCalculator()))));
            if (outputBestSplits$1) {
                scala.collection.mutable.Map bestSplitsInTree = bestSplits$2[treeIndex$2];
                if (bestSplitsInTree == null) {
                    bestSplits$2[treeIndex$2] = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)nodeIndex)), (Object)split3)}));
                } else {
                    bestSplitsInTree.update((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)split3);
                }
            }
            Object object = !leftChildIsLeaf ? nodeStack$2.prepend((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex$2), node.leftChild().get())) : BoxedUnit.UNIT;
            Object object2 = !rightChildIsLeaf ? nodeStack$2.prepend((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex$2), node.rightChild().get())) : BoxedUnit.UNIT;
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "leftChildIndex = " + ((LearningNode)node.leftChild().get()).id() + ", impurity = " + stats2.leftImpurity());
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "rightChildIndex = " + ((LearningNode)node.rightChild().get()).id() + ", impurity = " + stats2.rightImpurity());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$29(scala.collection.immutable.Map treeToNodeToIndexInfo$1, Map nodeToBestSplits$1, DecisionTreeMetadata metadata$3, boolean outputBestSplits$1, scala.collection.mutable.Map[] bestSplits$2, ListBuffer nodeStack$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int treeIndex = tuple2._1$mcI$sp();
            LearningNode[] nodesForTree = (LearningNode[])tuple2._2();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])nodesForTree), (Function1 & Serializable)node -> {
                RandomForest$.$anonfun$findBestSplits$30(treeToNodeToIndexInfo$1, treeIndex, nodeToBestSplits$1, metadata$3, outputBestSplits$1, bestSplits$2, nodeStack$2, node);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$1(Option featuresForNode$1, int featureIndexIdx) {
        return (Tuple2)featuresForNode$1.map((Function1 & Serializable)features -> new Tuple2.mcII.sp(featureIndexIdx, features[featureIndexIdx])).getOrElse((Function0 & Serializable)() -> new Tuple2.mcII.sp(featureIndexIdx, featureIndexIdx));
    }

    public static final /* synthetic */ boolean $anonfun$binsToBestSplit$4(DTStatsAggregator binAggregates$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int featureIndex = tuple2._2$mcI$sp();
            return binAggregates$1.metadata().numSplits(featureIndex) != 0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$6(DTStatsAggregator binAggregates$1, int nodeFeatureOffset$1, int numSplits$1, ObjectRef gainAndImpurityStats$1, int splitIdx) {
        ImpurityCalculator leftChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$1, splitIdx);
        ImpurityCalculator rightChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$1, numSplits$1);
        rightChildStats.subtract(leftChildStats);
        gainAndImpurityStats$1.elem = MODULE$.calculateImpurityStats((ImpurityStats)gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, binAggregates$1.metadata());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)splitIdx), (Object)((ImpurityStats)gainAndImpurityStats$1.elem));
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$7(Tuple2 x$10) {
        return ((ImpurityStats)x$10._2()).gain();
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$8(DTStatsAggregator binAggregates$1, int leftChildOffset$1, ObjectRef gainAndImpurityStats$1, int splitIndex) {
        ImpurityCalculator leftChildStats = binAggregates$1.getImpurityCalculator(leftChildOffset$1, splitIndex);
        ImpurityCalculator rightChildStats = binAggregates$1.getParentImpurityCalculator().subtract(leftChildStats);
        gainAndImpurityStats$1.elem = MODULE$.calculateImpurityStats((ImpurityStats)gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, binAggregates$1.metadata());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)splitIndex), (Object)((ImpurityStats)gainAndImpurityStats$1.elem));
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$9(Tuple2 x$12) {
        return ((ImpurityStats)x$12._2()).gain();
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$10(DTStatsAggregator binAggregates$1, int nodeFeatureOffset$2, int featureValue) {
        ImpurityCalculator categoryStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$2, featureValue);
        double centroid = categoryStats.count() != 0.0 ? (binAggregates$1.metadata().isMulticlass() ? categoryStats.calculate() : (binAggregates$1.metadata().isClassification() ? categoryStats.stats()[1] : categoryStats.predict())) : Double.MAX_VALUE;
        return new Tuple2.mcID.sp(featureValue, centroid);
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$14(List categoriesSortedByCentroid$1, DTStatsAggregator binAggregates$1, int nodeFeatureOffset$2, int lastCategory$1, ObjectRef gainAndImpurityStats$1, int splitIndex) {
        int featureValue = ((Tuple2)categoriesSortedByCentroid$1.apply(splitIndex))._1$mcI$sp();
        ImpurityCalculator leftChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$2, featureValue);
        ImpurityCalculator rightChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$2, lastCategory$1);
        rightChildStats.subtract(leftChildStats);
        gainAndImpurityStats$1.elem = MODULE$.calculateImpurityStats((ImpurityStats)gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, binAggregates$1.metadata());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)splitIndex), (Object)((ImpurityStats)gainAndImpurityStats$1.elem));
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$15(Tuple2 x$15) {
        return ((ImpurityStats)x$15._2()).gain();
    }

    public static final /* synthetic */ int $anonfun$binsToBestSplit$17(int[] x$18) {
        return BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(x$18)));
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$19(Tuple2 x$19) {
        return ((ImpurityStats)x$19._2()).gain();
    }

    public static final /* synthetic */ Tuple2 $anonfun$findSplitsBySorting$2(Instance point$2, int idx) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)idx), (Object)new Tuple2.mcDD.sp(point$2.features().apply(idx), point$2.weight()));
    }

    public static final /* synthetic */ boolean $anonfun$findSplitsBySorting$3(Tuple2 x$21) {
        return ((Tuple2)x$21._2())._1$mcD$sp() != 0.0;
    }

    public static final /* synthetic */ double $anonfun$findSplitsBySorting$8(OpenHashMap map1$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            double v = tuple2._1$mcD$sp();
            double w = tuple2._2$mcD$sp();
            return map1$1.changeValue$mcD$sp((Object)BoxesRunTime.boxToDouble((double)v), (Function0)(JFunction0.mcD.sp & Serializable)() -> w, (Function1)(JFunction1.mcDD.sp & Serializable)x$23 -> x$23 + w);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ ContinuousSplit $anonfun$findSplitsBySorting$12(int idx$1, double thresh) {
        return new ContinuousSplit(idx$1, thresh);
    }

    public static final /* synthetic */ CategoricalSplit $anonfun$findSplitsBySorting$16(int featureArity$1, int x1$1, int splitIndex) {
        List<Object> categories = MODULE$.extractMultiClassCategories(splitIndex + 1, featureArity$1);
        return new CategoricalSplit(x1$1, (double[])categories.toArray((ClassTag)ClassTag$.MODULE$.Double()), featureArity$1);
    }

    public static final /* synthetic */ Split[] $anonfun$findSplitsBySorting$14(DecisionTreeMetadata metadata$5, Map continuousSplits$1, int x0$5) {
        int n = x0$5;
        switch (n) {
            default: 
        }
        if (metadata$5.isContinuous(n)) {
            Split[] split = (Split[])continuousSplits$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)n), (Function0 & Serializable)() -> (Split[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Split.class)));
            metadata$5.setNumSplits(n, split.length);
            return split;
        }
        if (metadata$5.isCategorical(n) && metadata$5.isUnordered(n)) {
            int featureArity = BoxesRunTime.unboxToInt((Object)metadata$5.featureArity().apply((Object)BoxesRunTime.boxToInteger((int)n)));
            return (Split[])Array$.MODULE$.tabulate(metadata$5.numSplits(n), (Function1 & Serializable)splitIndex -> RandomForest$.$anonfun$findSplitsBySorting$16(featureArity, n, BoxesRunTime.unboxToInt((Object)splitIndex)), ClassTag$.MODULE$.apply(Split.class));
        }
        if (metadata$5.isCategorical(n)) {
            return (Split[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Split.class));
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static final /* synthetic */ void $anonfun$findSplitsForContinuousFeature$1(OpenHashMap valueWeights$1, LongRef count$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double weight = tuple2._1$mcD$sp();
            double value = tuple2._2$mcD$sp();
            valueWeights$1.changeValue$mcD$sp((Object)BoxesRunTime.boxToDouble((double)value), (Function0)(JFunction0.mcD.sp & Serializable)() -> weight, (Function1)(JFunction1.mcDD.sp & Serializable)x$24 -> x$24 + weight);
            ++count$1.elem;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ LearningNode[] $anonfun$selectNodesToSplit$4(int x$27, ArrayBuffer v) {
        return (LearningNode[])v.toArray(ClassTag$.MODULE$.apply(LearningNode.class));
    }

    private RandomForest$() {
    }

    public static final /* synthetic */ Split[] $anonfun$findSplitsBySorting$14$adapted(DecisionTreeMetadata metadata$5, Map continuousSplits$1, Object x0$5) {
        return RandomForest$.$anonfun$findSplitsBySorting$14(metadata$5, continuousSplits$1, BoxesRunTime.unboxToInt((Object)x0$5));
    }

    public static final /* synthetic */ Object $anonfun$findSplitsForContinuousFeature$1$adapted(OpenHashMap valueWeights$1, LongRef count$1, Tuple2 x0$1) {
        RandomForest$.$anonfun$findSplitsForContinuousFeature$1(valueWeights$1, count$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

