/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.catalyst.util.AttributeNameParser$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$ = new SchemaUtils$();

    public void checkColumnType(StructType schema, String colName, DataType dataType, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? " " + msg : "";
        Predef$.MODULE$.require(actualDataType.equals((Object)dataType), (Function0 & Serializable)() -> "Column " + colName + " must be of type " + dataType.getClass() + ":" + dataType.catalogString() + " but was actually " + actualDataType.getClass() + ":" + actualDataType.catalogString() + "." + message);
    }

    public String checkColumnType$default$4() {
        return "";
    }

    public void checkColumnTypes(StructType schema, String colName, Seq<DataType> dataTypes, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? " " + msg : "";
        Predef$.MODULE$.require(dataTypes.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)actualDataType.equals(x$1))), (Function0 & Serializable)() -> "Column " + colName + " must be of type equal to one of the following types: " + ((IterableOnceOps)dataTypes.map((Function1 & Serializable)x$1 -> x$1.catalogString())).mkString("[", ", ", "]") + " but was actually of type " + actualDataType.catalogString() + "." + message);
    }

    public String checkColumnTypes$default$4() {
        return "";
    }

    public void checkNumericType(StructType schema, String colName, String msg) {
        DataType actualDataType = this.getSchemaFieldType(schema, colName);
        String message = msg != null && msg.trim().length() > 0 ? " " + msg : "";
        Predef$.MODULE$.require(actualDataType instanceof NumericType, (Function0 & Serializable)() -> "Column " + colName + " must be of type " + NumericType$.MODULE$.simpleString() + " but was actually of type " + actualDataType.catalogString() + "." + message);
    }

    public String checkNumericType$default$3() {
        return "";
    }

    public StructType appendColumn(StructType schema, String colName, DataType dataType, boolean nullable) {
        if (colName.isEmpty()) {
            return schema;
        }
        return this.appendColumn(schema, new StructField(colName, dataType, nullable, StructField$.MODULE$.apply$default$4()));
    }

    public StructType appendColumn(StructType schema, StructField col) {
        Predef$.MODULE$.require(!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)col.name()), (Function0 & Serializable)() -> "Column " + col.name() + " already exists.");
        return new StructType((StructField[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Object)col, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public boolean appendColumn$default$4() {
        return false;
    }

    public StructType updateAttributeGroupSize(StructType schema, String colName, int size) {
        Predef$.MODULE$.require(size > 0);
        AttributeGroup attrGroup = new AttributeGroup(colName, size);
        StructField field = attrGroup.toStructField();
        return this.updateField(schema, field, true);
    }

    public StructType updateNumValues(StructType schema, String colName, int numValues) {
        NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr().withName(colName).withNumValues(numValues);
        StructField field = attr.toStructField();
        return this.updateField(schema, field, true);
    }

    public StructType updateNumeric(StructType schema, String colName) {
        NumericAttribute attr = NumericAttribute$.MODULE$.defaultAttr().withName(colName);
        StructField field = attr.toStructField();
        return this.updateField(schema, field, true);
    }

    public StructType updateField(StructType schema, StructField field, boolean overwriteMetadata) {
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)field.name())) {
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)f -> {
                String string = f.name();
                String string2 = field.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (overwriteMetadata) {
                        return field;
                    }
                    Metadata newMeta = new MetadataBuilder().withMetadata(field.metadata()).withMetadata(f.metadata()).build();
                    return new StructField(field.name(), field.dataType(), field.nullable(), newMeta);
                }
                return f;
            }, ClassTag$.MODULE$.apply(StructField.class));
            return new StructType(newFields);
        }
        return this.appendColumn(schema, field);
    }

    public boolean updateField$default$3() {
        return true;
    }

    public void validateVectorCompatibleColumn(StructType schema, String colName) {
        .colon.colon typeCandidates = new .colon.colon((Object)new VectorUDT(), (List)new .colon.colon((Object)new ArrayType((DataType)DoubleType$.MODULE$, false), (List)new .colon.colon((Object)new ArrayType((DataType)FloatType$.MODULE$, false), (List)Nil$.MODULE$)));
        this.checkColumnTypes(schema, colName, (Seq<DataType>)typeCandidates, this.checkColumnTypes$default$4());
    }

    public StructField getSchemaField(StructType schema, String colName) {
        Seq colSplits = AttributeNameParser$.MODULE$.parseAttributeName(colName);
        ObjectRef field = ObjectRef.create((Object)schema.apply((String)colSplits.apply(0)));
        ((IterableOnceOps)colSplits.slice(1, colSplits.length())).foreach((Function1 & Serializable)colSplit -> {
            field.elem = ((StructType)((StructField)field.elem).dataType()).apply(colSplit);
            return BoxedUnit.UNIT;
        });
        return (StructField)field.elem;
    }

    public DataType getSchemaFieldType(StructType schema, String colName) {
        return this.getSchemaField(schema, colName).dataType();
    }

    private SchemaUtils$() {
    }
}

