/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\u000f\u001e\u0001!B\u0001\"\u0011\u0001\u0003\u0002\u0004%IA\u0011\u0005\t\r\u0002\u0011\t\u0019!C\u0005\u000f\"AQ\n\u0001B\u0001B\u0003&1\t\u0003\u0005O\u0001\t\u0005\r\u0011\"\u0003P\u0011!A\u0006A!a\u0001\n\u0013I\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0015\u0002)\t\u000bq\u0003A\u0011B/\t\u000bq\u0003A\u0011\u00012\t\u000bq\u0003A\u0011A7\t\u000bE\u0004A\u0011\u0001:\t\u000bU\u0004A\u0011\u0001\"\t\u000b]\u0004A\u0011\u0001=\t\u000bm\u0004A\u0011A(\t\u000bu\u0004A\u0011\u0001@\b\u000f\u0005\u0015R\u0004#\u0001\u0002(\u00191A$\bE\u0001\u0003SAa\u0001\u0018\t\u0005\u0002\u0005e\u0002\"CA\u001e!\t\u0007I\u0011A\u000fP\u0011\u001d\ti\u0004\u0005Q\u0001\nAC\u0011\"a\u0010\u0011\u0005\u0004%\t!H(\t\u000f\u0005\u0005\u0003\u0003)A\u0005!\"Q\u00111\t\tC\u0002\u0013\u0005Q$!\u0012\t\u0011\u0005]\u0003\u0003)A\u0005\u0003\u000fBq!!\u0017\u0011\t\u0003\tY\u0006C\u0004\u0002ZA!\t!a\u0019\t\u000f\u0005e\u0003\u0003\"\u0001\u0002l!I\u0011Q\u000f\t\u0002\u0002\u0013%\u0011q\u000f\u0002\u000b\u001d\u0006Lg/\u001a\"bs\u0016\u001c(B\u0001\u0010 \u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!\u0001I\u0011\u0002\u000b5dG.\u001b2\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001S=Z\u0004C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021q9\u0011\u0011G\u000e\b\u0003eUj\u0011a\r\u0006\u0003i\u001d\na\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0005]Z\u0013a\u00029bG.\fw-Z\u0005\u0003si\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!aN\u0016\u0011\u0005qzT\"A\u001f\u000b\u0005y\n\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001k$a\u0002'pO\u001eLgnZ\u0001\u0007Y\u0006l'\rZ1\u0016\u0003\r\u0003\"A\u000b#\n\u0005\u0015[#A\u0002#pk\ndW-\u0001\u0006mC6\u0014G-Y0%KF$\"\u0001S&\u0011\u0005)J\u0015B\u0001&,\u0005\u0011)f.\u001b;\t\u000f1\u0013\u0011\u0011!a\u0001\u0007\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1\fWN\u00193bA\u0005IQn\u001c3fYRK\b/Z\u000b\u0002!B\u0011\u0011+\u0016\b\u0003%N\u0003\"AM\u0016\n\u0005Q[\u0013A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V\u0016\u0002\u001b5|G-\u001a7UsB,w\fJ3r)\tA%\fC\u0004M\u000b\u0005\u0005\t\u0019\u0001)\u0002\u00155|G-\u001a7UsB,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004=\u0002\f\u0007CA0\u0001\u001b\u0005i\u0002\"B!\b\u0001\u0004\u0019\u0005\"\u0002(\b\u0001\u0004\u0001FC\u00010d\u0011\u0015\t\u0005\u00021\u0001DQ\rAQm\u001b\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0006\n!\"\u00198o_R\fG/[8o\u0013\tQwMA\u0003TS:\u001cW-I\u0001m\u0003\u0015\td\u0006\u000e\u00181)\u0005q\u0006fA\u0005f_\u0006\n\u0001/A\u00031]er\u0003'A\u0005tKRd\u0015-\u001c2eCR\u0011al\u001d\u0005\u0006\u0003*\u0001\ra\u0011\u0015\u0004\u0015\u0015|\u0017!C4fi2\u000bWN\u00193bQ\rYQm[\u0001\rg\u0016$Xj\u001c3fYRK\b/\u001a\u000b\u0003=fDQA\u0014\u0007A\u0002AC3\u0001D3l\u000319W\r^'pI\u0016dG+\u001f9fQ\riQm[\u0001\u0004eVtGcA@\u0002\u0006A\u0019q,!\u0001\n\u0007\u0005\rQDA\bOC&4XMQ1zKNlu\u000eZ3m\u0011\u001d\t9A\u0004a\u0001\u0003\u0013\tA\u0001Z1uCB1\u00111BA\t\u0003+i!!!\u0004\u000b\u0007\u0005=\u0011%A\u0002sI\u0012LA!a\u0005\u0002\u000e\t\u0019!\u000b\u0012#\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007 \u0003)\u0011Xm\u001a:fgNLwN\\\u0005\u0005\u0003?\tIB\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fK\u0002\u000fK>D3\u0001A3p\u0003)q\u0015-\u001b<f\u0005\u0006LXm\u001d\t\u0003?B\u0019B\u0001E\u0015\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012AA5p\u0015\t\t)$\u0001\u0003kCZ\f\u0017bA\u001d\u00020Q\u0011\u0011qE\u0001\f\u001bVdG/\u001b8p[&\fG.\u0001\u0007Nk2$\u0018N\\8nS\u0006d\u0007%A\u0005CKJtw.\u001e7mS\u0006Q!)\u001a:o_VdG.\u001b\u0011\u0002'M,\b\u000f]8si\u0016$Wj\u001c3fYRK\b/Z:\u0016\u0005\u0005\u001d\u0003#BA%\u0003'\u0002VBAA&\u0015\u0011\ti%a\u0014\u0002\u0013%lW.\u001e;bE2,'bAA)W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00131\n\u0002\u0004'\u0016$\u0018\u0001F:vaB|'\u000f^3e\u001b>$W\r\u001c+za\u0016\u001c\b%A\u0003ue\u0006Lg\u000eF\u0002\u0000\u0003;Bq!a\u0018\u0019\u0001\u0004\tI!A\u0003j]B,H\u000fK\u0002\u0019K>$Ra`A3\u0003OBq!a\u0018\u001a\u0001\u0004\tI\u0001C\u0003B3\u0001\u00071\tK\u0002\u001aK>$ra`A7\u0003_\n\t\bC\u0004\u0002`i\u0001\r!!\u0003\t\u000b\u0005S\u0002\u0019A\"\t\u000b9S\u0002\u0019\u0001))\u0007i)7.\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002zA!\u00111PAA\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005M\u0012\u0001\u00027b]\u001eLA!a!\u0002~\t1qJ\u00196fGRD3\u0001E3pQ\ryQm\u001c")
public class NaiveBayes
implements Serializable,
Logging {
    private double lambda;
    private String modelType;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static NaiveBayesModel train(RDD<LabeledPoint> input, double lambda, String modelType) {
        return NaiveBayes$.MODULE$.train(input, lambda, modelType);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> input, double lambda) {
        return NaiveBayes$.MODULE$.train(input, lambda);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> input) {
        return NaiveBayes$.MODULE$.train(input);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double lambda() {
        return this.lambda;
    }

    private void lambda_$eq(double x$1) {
        this.lambda = x$1;
    }

    private String modelType() {
        return this.modelType;
    }

    private void modelType_$eq(String x$1) {
        this.modelType = x$1;
    }

    public NaiveBayes setLambda(double lambda) {
        Predef$.MODULE$.require(lambda >= 0.0, (Function0 & Serializable)() -> "Smoothing parameter must be nonnegative but got " + lambda);
        this.lambda_$eq(lambda);
        return this;
    }

    public double getLambda() {
        return this.lambda();
    }

    public NaiveBayes setModelType(String modelType) {
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0 & Serializable)() -> "NaiveBayes was created with an unknown modelType: " + modelType + ".");
        this.modelType_$eq(modelType);
        return this;
    }

    public String getModelType() {
        return this.modelType();
    }

    public NaiveBayesModel run(RDD<LabeledPoint> data) {
        public final class Org_apache_spark_mllib_classification_NaiveBayes$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_mllib_classification_NaiveBayes$$typecreator10$1(NaiveBayes $outer) {
            }
        }
        SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(data.context()).getOrCreate();
        org.apache.spark.ml.classification.NaiveBayes nb = new org.apache.spark.ml.classification.NaiveBayes().setModelType(this.modelType()).setSmoothing(this.lambda());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        Dataset dataset = spark.implicits().rddToDatasetHolder(data.map((Function1 & Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)label), (Object)features.asML());
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_classification_NaiveBayes$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"}));
        org.apache.spark.ml.classification.NaiveBayesModel newModel = nb.trainWithLabelCheck(dataset, false);
        double[] pi = newModel.pi().toArray();
        double[][] theta = (double[][])Array$.MODULE$.ofDim(newModel.numClasses(), newModel.numFeatures(), (ClassTag)ClassTag$.MODULE$.Double());
        newModel.theta().foreachActive((Function3 & Serializable)(x0$2, x1$1, x2$1) -> {
            NaiveBayes.$anonfun$run$2(theta, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(newModel.oldLabels() != null, (Function0 & Serializable)() -> "The underlying ML NaiveBayes training does not produce labels.");
        return new NaiveBayesModel(newModel.oldLabels(), pi, theta, this.modelType());
    }

    public static final /* synthetic */ void $anonfun$run$2(double[][] theta$1, int x0$2, int x1$1, double x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 != null) {
            double v;
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            theta$1[i][j] = v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public NaiveBayes(double lambda, String modelType) {
        this.lambda = lambda;
        this.modelType = modelType;
        Logging.$init$((Logging)this);
    }

    public NaiveBayes(double lambda) {
        this(lambda, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayes() {
        this(1.0, NaiveBayes$.MODULE$.Multinomial());
    }
}

