/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.SparkException;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeRDD;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.VertexRDD$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class PowerIterationClustering$
implements Logging,
Serializable {
    public static final PowerIterationClustering$ MODULE$ = new PowerIterationClustering$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Graph<Object, Object> normalize(Graph<Object, Object> graph) {
        VertexRDD vD = graph.aggregateMessages((Function1 & Serializable)ctx -> {
            PowerIterationClustering$.$anonfun$normalize$1(ctx);
            return BoxedUnit.UNIT;
        }, (Function2)(JFunction2.mcDDD.sp & Serializable)(x$2, x$3) -> x$2 + x$3, TripletFields.EdgeOnly, (ClassTag)ClassTag$.MODULE$.Double());
        return Graph$.MODULE$.apply((RDD)vD, (RDD)graph.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double()).mapTriplets((Function1 & Serializable)e -> BoxesRunTime.boxToDouble((double)PowerIterationClustering$.$anonfun$normalize$3(e)), new TripletFields(true, false, true), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public Graph<Object, Object> normalize(RDD<Tuple3<Object, Object, Object>> similarities) {
        RDD edges = similarities.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                long i = BoxesRunTime.unboxToLong((Object)tuple3._1());
                long j = BoxesRunTime.unboxToLong((Object)tuple3._2());
                double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                if (s < 0.0) {
                    throw new SparkException("Similarity must be nonnegative but found s(" + i + ", " + j + ") = " + s + ".");
                }
                if (i != j) {
                    return new .colon.colon((Object)new Edge.mcD.sp(i, j, s), (List)new .colon.colon((Object)new Edge.mcD.sp(j, i, s), (List)Nil$.MODULE$));
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple3);
        }, ClassTag$.MODULE$.apply(Edge.class));
        Graph gA = Graph$.MODULE$.fromEdges(edges, (Object)BoxesRunTime.boxToDouble((double)0.0), Graph$.MODULE$.fromEdges$default$3(), Graph$.MODULE$.fromEdges$default$4(), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double());
        VertexRDD vD = gA.aggregateMessages((Function1 & Serializable)ctx -> {
            ctx.sendToSrc(ctx.attr());
            return BoxedUnit.UNIT;
        }, (Function2)(JFunction2.mcDDD.sp & Serializable)(x$4, x$5) -> x$4 + x$5, TripletFields.EdgeOnly, (ClassTag)ClassTag$.MODULE$.Double());
        Graph graph = Graph$.MODULE$.apply((RDD)vD, (RDD)gA.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double()).mapTriplets((Function1 & Serializable)e -> BoxesRunTime.boxToDouble((double)PowerIterationClustering$.$anonfun$normalize$7(e)), new TripletFields(true, false, true), (ClassTag)ClassTag$.MODULE$.Double());
        this.materialize(graph);
        gA.unpersist(gA.unpersist$default$1());
        return graph;
    }

    public Graph<Object, Object> randomInit(Graph<Object, Object> g) {
        RDD r = g.vertices().mapPartitionsWithIndex((Function2 & Serializable)(part, iter) -> PowerIterationClustering$.$anonfun$randomInit$1(BoxesRunTime.unboxToInt((Object)part), iter), true, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        double sum = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(r, ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values().map((Function1)(JFunction1.mcDD.sp & Serializable)x -> package$.MODULE$.abs(x), (ClassTag)ClassTag$.MODULE$.Double())).sum();
        RDD v0 = RDD$.MODULE$.rddToPairRDDFunctions(r, ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).mapValues((Function1)(JFunction1.mcDD.sp & Serializable)x -> x / sum);
        Graph graph = Graph$.MODULE$.apply((RDD)VertexRDD$.MODULE$.apply(v0, (ClassTag)ClassTag$.MODULE$.Double()), (RDD)g.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double());
        this.materialize(graph);
        r.unpersist(r.unpersist$default$1());
        return graph;
    }

    public Graph<Object, Object> initDegreeVector(Graph<Object, Object> g) {
        double sum = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)g.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum();
        VertexRDD v0 = g.vertices().mapValues((Function1)(JFunction1.mcDD.sp & Serializable)x$6 -> x$6 / sum, (ClassTag)ClassTag$.MODULE$.Double());
        Graph graph = Graph$.MODULE$.apply((RDD)VertexRDD$.MODULE$.apply((RDD)v0, (ClassTag)ClassTag$.MODULE$.Double()), (RDD)g.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double());
        this.materialize(graph);
        return graph;
    }

    public VertexRDD<Object> powerIter(Graph<Object, Object> g, int maxIterations) {
        double tol = package$.MODULE$.max(1.0E-5 / (double)g.vertices().count(), 1.0E-8);
        DoubleRef prevDelta = DoubleRef.create((double)Double.MAX_VALUE);
        DoubleRef diffDelta = DoubleRef.create((double)Double.MAX_VALUE);
        ObjectRef curG = ObjectRef.create(g);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maxIterations).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)iter -> package$.MODULE$.abs(diffDelta$1.elem) > tol).foreach((Function1)(JFunction1.mcVI.sp & Serializable)iter -> {
            double xTx;
            double xTAx;
            double rayleigh;
            MessageWithContext msgPrefix = MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Iteration ", ":"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_ITERATIONS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)iter))}));
            VertexRDD v = (VertexRDD)((Graph)curG$1.elem).aggregateMessages((Function1 & Serializable)ctx -> {
                ctx.sendToSrc((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)ctx.attr()) * BoxesRunTime.unboxToDouble((Object)ctx.dstAttr()))));
                return BoxedUnit.UNIT;
            }, (Function2)(JFunction2.mcDDD.sp & Serializable)(x$7, x$8) -> x$7 + x$8, new TripletFields(false, true, true), (ClassTag)ClassTag$.MODULE$.Double()).cache();
            double norm = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)v, ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values().map((Function1)(JFunction1.mcDD.sp & Serializable)x -> package$.MODULE$.abs(x), (ClassTag)ClassTag$.MODULE$.Double())).sum();
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msgPrefix.$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" norm(v) = ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NORM$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)norm))})))));
            VertexRDD v1 = v.mapValues((Function1)(JFunction1.mcDD.sp & Serializable)x -> x / norm, (ClassTag)ClassTag$.MODULE$.Double());
            double delta = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)Graph$.MODULE$.graphToGraphOps((Graph)curG$1.elem, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double()).joinVertices((RDD)v1, (Function3 & Serializable)(x0$1, x1$1, x2$1) -> BoxesRunTime.boxToDouble((double)PowerIterationClustering$.$anonfun$powerIter$8(BoxesRunTime.unboxToLong((Object)x0$1), BoxesRunTime.unboxToDouble((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1))), (ClassTag)ClassTag$.MODULE$.Double()).vertices(), ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum();
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msgPrefix.$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" delta = ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DELTA$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)delta))})))));
            diffDelta$1.elem = package$.MODULE$.abs(delta - prevDelta$1.elem);
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msgPrefix.$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" diff(delta) = ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DIFF_DELTA$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)diffDelta$1.elem))})))));
            if (package$.MODULE$.abs(diffDelta$1.elem) < tol && package$.MODULE$.abs(norm - package$.MODULE$.abs(rayleigh = (xTAx = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)Graph$.MODULE$.graphToGraphOps((Graph)curG$1.elem, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double()).joinVertices((RDD)v, (Function3 & Serializable)(x0$2, x1$2, x2$2) -> BoxesRunTime.boxToDouble((double)PowerIterationClustering$.$anonfun$powerIter$11(BoxesRunTime.unboxToLong((Object)x0$2), BoxesRunTime.unboxToDouble((Object)x1$2), BoxesRunTime.unboxToDouble((Object)x2$2))), (ClassTag)ClassTag$.MODULE$.Double()).vertices(), ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum()) / (xTx = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)((Graph)curG$1.elem).vertices().mapValues((Function1)(JFunction1.mcDD.sp & Serializable)x -> x * x, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum()))) > tol) {
                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Power Iteration fail to converge. delta = ", ","}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DELTA$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)delta))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" difference delta = ", " and norm = ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DIFF_DELTA$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)diffDelta$1.elem)), new MDC((LogKey)LogKeys.NORM$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)norm))})))));
            }
            VertexRDD qual$1 = ((Graph)curG$1.elem).vertices();
            boolean x$1 = qual$1.unpersist$default$1();
            qual$1.unpersist(x$1);
            EdgeRDD qual$2 = ((Graph)curG$1.elem).edges();
            boolean x$2 = qual$2.unpersist$default$1();
            qual$2.unpersist(x$2);
            curG$1.elem = Graph$.MODULE$.apply((RDD)VertexRDD$.MODULE$.apply((RDD)v1, (ClassTag)ClassTag$.MODULE$.Double()), (RDD)g.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double());
            MODULE$.materialize((Graph)curG$1.elem);
            v.unpersist(v.unpersist$default$1());
            prevDelta$1.elem = delta;
        });
        EdgeRDD qual$3 = ((Graph)curG.elem).edges();
        boolean x$3 = qual$3.unpersist$default$1();
        qual$3.unpersist(x$3);
        return ((Graph)curG.elem).vertices();
    }

    public VertexRDD<Object> kMeans(VertexRDD<Object> v, int k) {
        VertexRDD points = (VertexRDD)v.mapValues((Function1 & Serializable)x$9 -> Vectors$.MODULE$.dense(BoxesRunTime.unboxToDouble((Object)x$9), (Seq<Object>)Nil$.MODULE$), ClassTag$.MODULE$.apply(Vector.class)).cache();
        KMeansModel model = new KMeans().setK(k).setSeed(0L).run((RDD<Vector>)RDD$.MODULE$.rddToPairRDDFunctions((RDD)points, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Long$.MODULE$).values());
        VertexRDD predict = points.mapValues((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)model.predict(x$10)), (ClassTag)ClassTag$.MODULE$.Int());
        points.unpersist(points.unpersist$default$1());
        return predict;
    }

    private void materialize(Graph<?, ?> g) {
        g.edges().foreachPartition((Function1 & Serializable)x$11 -> {
            PowerIterationClustering$.$anonfun$materialize$1(x$11);
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PowerIterationClustering$.class);
    }

    public static final /* synthetic */ void $anonfun$normalize$1(EdgeContext ctx) {
        long i = ctx.srcId();
        long j = ctx.dstId();
        double s = BoxesRunTime.unboxToDouble((Object)ctx.attr());
        if (s < 0.0) {
            throw new SparkException("Similarity must be nonnegative but found s(" + i + ", " + j + ") = " + s + ".");
        }
        if (s > 0.0) {
            ctx.sendToSrc((Object)BoxesRunTime.boxToDouble((double)s));
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$normalize$3(EdgeTriplet e) {
        return e.attr$mcD$sp() / package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)e.srcAttr()), MLUtils$.MODULE$.EPSILON());
    }

    public static final /* synthetic */ double $anonfun$normalize$7(EdgeTriplet e) {
        return e.attr$mcD$sp() / package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)e.srcAttr()), MLUtils$.MODULE$.EPSILON());
    }

    public static final /* synthetic */ Iterator $anonfun$randomInit$1(int part, Iterator iter) {
        XORShiftRandom random = new XORShiftRandom((long)part);
        return iter.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long id = tuple2._1$mcJ$sp();
                return new Tuple2.mcJD.sp(id, random.nextGaussian());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ double $anonfun$powerIter$8(long x0$1, double x1$1, double x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)BoxesRunTime.boxToDouble((double)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 != null) {
            double x = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double y = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            return package$.MODULE$.abs(x - y);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ double $anonfun$powerIter$11(long x0$2, double x1$2, double x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)BoxesRunTime.boxToDouble((double)x1$2), (Object)BoxesRunTime.boxToDouble((double)x2$2));
        if (tuple3 != null) {
            double x = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double y = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            return x * y;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$materialize$1(Iterator x$11) {
    }

    private PowerIterationClustering$() {
    }
}

