/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import dev.ludovic.netlib.blas.BLAS;
import dev.ludovic.netlib.blas.JavaBLAS;
import dev.ludovic.netlib.blas.NativeBLAS;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class BLAS$
implements Serializable,
Logging {
    public static final BLAS$ MODULE$ = new BLAS$();
    private static transient BLAS _javaBLAS;
    private static transient BLAS _nativeBLAS;
    private static final int nativeL1Threshold;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        nativeL1Threshold = 256;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private BLAS _javaBLAS() {
        return _javaBLAS;
    }

    private void _javaBLAS_$eq(BLAS x$1) {
        _javaBLAS = x$1;
    }

    private BLAS _nativeBLAS() {
        return _nativeBLAS;
    }

    private void _nativeBLAS_$eq(BLAS x$1) {
        _nativeBLAS = x$1;
    }

    private int nativeL1Threshold() {
        return nativeL1Threshold;
    }

    public BLAS javaBLAS() {
        block0: {
            if (this._javaBLAS() != null) break block0;
            this._javaBLAS_$eq((BLAS)JavaBLAS.getInstance());
        }
        return this._javaBLAS();
    }

    public BLAS nativeBLAS() {
        block0: {
            if (this._nativeBLAS() != null) break block0;
            this._nativeBLAS_$eq(this.liftedTree1$1());
        }
        return this._nativeBLAS();
    }

    public BLAS getBLAS(int vectorSize) {
        if (vectorSize < this.nativeL1Threshold()) {
            return this.javaBLAS();
        }
        return this.nativeBLAS();
    }

    public void axpy(double a, Vector x, Vector y) {
        Predef$.MODULE$.require(x.size() == y.size());
        Vector vector = y;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            Vector vector2 = x;
            if (vector2 instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)vector2;
                this.axpy(a, sparseVector, denseVector);
            } else if (vector2 instanceof DenseVector) {
                DenseVector denseVector2 = (DenseVector)vector2;
                this.axpy(a, denseVector2, denseVector);
            } else {
                throw new UnsupportedOperationException("axpy doesn't support x type " + x.getClass() + ".");
            }
            return;
        }
        throw new IllegalArgumentException("axpy only supports adding to a dense vector but got type " + y.getClass() + ".");
    }

    private void axpy(double a, DenseVector x, DenseVector y) {
        int n = x.size();
        this.getBLAS(n).daxpy(n, a, x.values(), 1, y.values(), 1);
    }

    private void axpy(double a, SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = xIndices.length;
        if (a == 1.0) {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + xValues[k];
            }
            return;
        }
        for (int k = 0; k < nnz; ++k) {
            int n = xIndices[k];
            yValues[n] = yValues[n] + a * xValues[k];
        }
    }

    public void axpy(double a, DenseMatrix X, DenseMatrix Y) {
        Predef$.MODULE$.require(X.numRows() == Y.numRows() && X.numCols() == Y.numCols(), (Function0 & Serializable)() -> "Dimension mismatch: size(X) = " + new Tuple2.mcII.sp(X.numRows(), X.numCols()) + " but size(Y) = " + new Tuple2.mcII.sp(Y.numRows(), Y.numCols()) + ".");
        this.getBLAS(X.values().length).daxpy(X.numRows() * X.numCols(), a, X.values(), 1, Y.values(), 1);
    }

    public double dot(Vector x, Vector y) {
        Predef$.MODULE$.require(x.size() == y.size(), (Function0 & Serializable)() -> "BLAS.dot(x: Vector, y:Vector) was given Vectors with non-matching sizes: x.size = " + x.size() + ", y.size = " + y.size());
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            Vector dx = (Vector)tuple2._1();
            Vector dy = (Vector)tuple2._2();
            if (dx instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)dx;
                if (dy instanceof DenseVector) {
                    DenseVector denseVector2 = (DenseVector)dy;
                    return this.dot(denseVector, denseVector2);
                }
            }
        }
        if (tuple2 != null) {
            Vector sx = (Vector)tuple2._1();
            Vector dy = (Vector)tuple2._2();
            if (sx instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)sx;
                if (dy instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)dy;
                    return this.dot(sparseVector, denseVector);
                }
            }
        }
        if (tuple2 != null) {
            Vector dx = (Vector)tuple2._1();
            Vector sy = (Vector)tuple2._2();
            if (dx instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)dx;
                if (sy instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)sy;
                    return this.dot(sparseVector, denseVector);
                }
            }
        }
        if (tuple2 != null) {
            Vector sx = (Vector)tuple2._1();
            Vector sy = (Vector)tuple2._2();
            if (sx instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)sx;
                if (sy instanceof SparseVector) {
                    SparseVector sparseVector2 = (SparseVector)sy;
                    return this.dot(sparseVector, sparseVector2);
                }
            }
        }
        throw new IllegalArgumentException("dot doesn't support (" + x.getClass() + ", " + y.getClass() + ").");
    }

    private double dot(DenseVector x, DenseVector y) {
        int n = x.size();
        return this.getBLAS(n).ddot(n, x.values(), 1, y.values(), 1);
    }

    private double dot(SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = xIndices.length;
        double sum = 0.0;
        for (int k = 0; k < nnz; ++k) {
            sum += xValues[k] * yValues[xIndices[k]];
        }
        return sum;
    }

    private double dot(SparseVector x, SparseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int[] yIndices = y.indices();
        int nnzx = xIndices.length;
        int nnzy = yIndices.length;
        int ky = 0;
        double sum = 0.0;
        for (int kx = 0; kx < nnzx && ky < nnzy; ++kx) {
            int ix = xIndices[kx];
            while (ky < nnzy && yIndices[ky] < ix) {
                ++ky;
            }
            if (ky >= nnzy || yIndices[ky] != ix) continue;
            sum += xValues[kx] * yValues[ky];
            ++ky;
        }
        return sum;
    }

    public void copy(Vector x, Vector y) {
        int n = y.size();
        Predef$.MODULE$.require(x.size() == n);
        Vector vector = y;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            Vector vector2 = x;
            if (vector2 instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)vector2;
                int[] sxIndices = sparseVector.indices();
                double[] sxValues = sparseVector.values();
                double[] dyValues = denseVector.values();
                int nnz = sxIndices.length;
                int i = 0;
                for (int k = 0; k < nnz; ++k) {
                    int j = sxIndices[k];
                    while (i < j) {
                        dyValues[i] = 0.0;
                        ++i;
                    }
                    dyValues[i] = sxValues[k];
                    ++i;
                }
                while (i < n) {
                    dyValues[i] = 0.0;
                    ++i;
                }
            } else if (vector2 instanceof DenseVector) {
                DenseVector denseVector2 = (DenseVector)vector2;
                Array$.MODULE$.copy((Object)denseVector2.values(), 0, (Object)denseVector.values(), 0, n);
            } else {
                throw new MatchError((Object)vector2);
            }
            return;
        }
        throw new IllegalArgumentException("y must be dense in copy but got " + y.getClass());
    }

    public void scal(double a, Vector x) {
        Vector vector = x;
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            this.getBLAS(sparseVector.values().length).dscal(sparseVector.values().length, a, sparseVector.values(), 1);
            return;
        }
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            this.getBLAS(denseVector.size()).dscal(denseVector.values().length, a, denseVector.values(), 1);
            return;
        }
        throw new IllegalArgumentException("scal doesn't support vector type " + x.getClass() + ".");
    }

    public void spr(double alpha, Vector v, DenseVector U) {
        this.spr(alpha, v, U.values());
    }

    public void spr(double alpha, Vector v, double[] U) {
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option;
        DenseVector denseVector;
        Option<double[]> option2;
        int n = v.size();
        Vector vector = v;
        if (vector instanceof DenseVector && !(option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
            double[] values = (double[])option2.get();
            this.nativeBLAS().dspr("U", n, alpha, values, 1, U);
            return;
        }
        if (vector instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
            int[] indices = (int[])((Tuple3)option.get())._2();
            double[] values = (double[])((Tuple3)option.get())._3();
            int nnz = indices.length;
            int colStartIdx = 0;
            int prevCol = 0;
            int col = 0;
            int i = 0;
            double av = 0.0;
            for (int j = 0; j < nnz; ++j) {
                col = indices[j];
                colStartIdx += (col - prevCol) * (col + prevCol + 1) / 2;
                av = alpha * values[j];
                for (i = 0; i <= j; ++i) {
                    int n2 = colStartIdx + indices[i];
                    U[n2] = U[n2] + av * values[i];
                }
                prevCol = col;
            }
            return;
        }
        throw new IllegalArgumentException("Unknown vector type " + v.getClass() + ".");
    }

    public void syr(double alpha, Vector x, DenseMatrix A) {
        int nA;
        int mA = A.numRows();
        Predef$.MODULE$.require(mA == (nA = A.numCols()), (Function0 & Serializable)() -> "A is not a square matrix (and hence is not symmetric). A: " + mA + " x " + nA);
        Predef$.MODULE$.require(mA == x.size(), (Function0 & Serializable)() -> "The size of x doesn't match the rank of A. A: " + mA + " x " + nA + ", x: " + x.size());
        Vector vector = x;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            this.syr(alpha, denseVector, A);
            return;
        }
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            this.syr(alpha, sparseVector, A);
            return;
        }
        throw new IllegalArgumentException("syr doesn't support vector type " + x.getClass() + ".");
    }

    private void syr(double alpha, DenseVector x, DenseMatrix A) {
        int nA = A.numRows();
        int mA = A.numCols();
        this.nativeBLAS().dsyr("U", x.size(), alpha, x.values(), 1, A.values(), nA);
        for (int i = 0; i < mA; ++i) {
            for (int j = i + 1; j < nA; ++j) {
                A.update(j, i, A.apply(i, j));
            }
        }
    }

    private void syr(double alpha, SparseVector x, DenseMatrix A) {
        int mA = A.numCols();
        int[] xIndices = x.indices();
        double[] xValues = x.values();
        int nnz = xValues.length;
        double[] Avalues = A.values();
        for (int i = 0; i < nnz; ++i) {
            double multiplier = alpha * xValues[i];
            int offset = xIndices[i] * mA;
            for (int j = 0; j < nnz; ++j) {
                int n = xIndices[j] + offset;
                Avalues[n] = Avalues[n] + multiplier * xValues[j];
            }
        }
    }

    public void gemm(double alpha, Matrix A, DenseMatrix B, double beta, DenseMatrix C) {
        Predef$.MODULE$.require(!C.isTransposed(), (Function0 & Serializable)() -> "The matrix C cannot be the product of a transpose() call. C.isTransposed must be false.");
        if (alpha == 0.0 && beta == 1.0) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "gemm: alpha is equal to 0 and beta is equal to 1. Returning C.");
            return;
        }
        if (alpha == 0.0) {
            this.getBLAS(C.values().length).dscal(C.values().length, beta, C.values(), 1);
            return;
        }
        Matrix matrix = A;
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            this.gemm(alpha, sparseMatrix, B, beta, C);
            return;
        }
        if (matrix instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix;
            this.gemm(alpha, denseMatrix, B, beta, C);
            return;
        }
        throw new IllegalArgumentException("gemm doesn't support matrix type " + A.getClass() + ".");
    }

    private void gemm(double alpha, DenseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        String tAstr = A.isTransposed() ? "T" : "N";
        String tBstr = B.isTransposed() ? "T" : "N";
        int lda = !A.isTransposed() ? A.numRows() : A.numCols();
        int ldb = !B.isTransposed() ? B.numRows() : B.numCols();
        Predef$.MODULE$.require(A.numCols() == B.numRows(), (Function0 & Serializable)() -> "The columns of A don't match the rows of B. A: " + A.numCols() + ", B: " + B.numRows());
        Predef$.MODULE$.require(A.numRows() == C.numRows(), (Function0 & Serializable)() -> "The rows of C don't match the rows of A. C: " + C.numRows() + ", A: " + A.numRows());
        Predef$.MODULE$.require(B.numCols() == C.numCols(), (Function0 & Serializable)() -> "The columns of C don't match the columns of B. C: " + C.numCols() + ", A: " + B.numCols());
        this.nativeBLAS().dgemm(tAstr, tBstr, A.numRows(), B.numCols(), A.numCols(), alpha, A.values(), lda, B.values(), ldb, beta, C.values(), C.numRows());
    }

    private void gemm(double alpha, SparseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        int colCounterForB;
        int kB;
        int mA = A.numRows();
        int nB = B.numCols();
        int kA = A.numCols();
        Predef$.MODULE$.require(kA == (kB = B.numRows()), (Function0 & Serializable)() -> "The columns of A don't match the rows of B. A: " + kA + ", B: " + kB);
        Predef$.MODULE$.require(mA == C.numRows(), (Function0 & Serializable)() -> "The rows of C don't match the rows of A. C: " + C.numRows() + ", A: " + mA);
        Predef$.MODULE$.require(nB == C.numCols(), (Function0 & Serializable)() -> "The columns of C don't match the columns of B. C: " + C.numCols() + ", A: " + nB);
        double[] Avals = A.values();
        double[] Bvals = B.values();
        double[] Cvals = C.values();
        int[] ArowIndices = A.rowIndices();
        int[] AcolPtrs = A.colPtrs();
        if (A.isTransposed()) {
            int colCounterForB2;
            if (!B.isTransposed()) {
                for (colCounterForB2 = 0; colCounterForB2 < nB; ++colCounterForB2) {
                    int Cstart = colCounterForB2 * mA;
                    int Bstart = colCounterForB2 * kA;
                    for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                        int indEnd = AcolPtrs[rowCounterForA + 1];
                        double sum = 0.0;
                        for (int i = AcolPtrs[rowCounterForA]; i < indEnd; ++i) {
                            sum += Avals[i] * Bvals[Bstart + ArowIndices[i]];
                        }
                        int Cindex = Cstart + rowCounterForA;
                        Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                    }
                }
                return;
            }
            while (colCounterForB2 < nB) {
                int Cstart = colCounterForB2 * mA;
                for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                    int indEnd = AcolPtrs[rowCounterForA + 1];
                    double sum = 0.0;
                    for (int i = AcolPtrs[rowCounterForA]; i < indEnd; ++i) {
                        sum += Avals[i] * Bvals[colCounterForB2 + nB * ArowIndices[i]];
                    }
                    int Cindex = Cstart + rowCounterForA;
                    Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                }
                ++colCounterForB2;
            }
            return;
        }
        if (beta != 1.0) {
            this.getBLAS(C.values().length).dscal(C.values().length, beta, C.values(), 1);
        }
        if (!B.isTransposed()) {
            for (colCounterForB = 0; colCounterForB < nB; ++colCounterForB) {
                int Bstart = colCounterForB * kB;
                int Cstart = colCounterForB * mA;
                for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                    int indEnd = AcolPtrs[colCounterForA + 1];
                    double Bval = Bvals[Bstart + colCounterForA] * alpha;
                    for (int i = AcolPtrs[colCounterForA]; i < indEnd; ++i) {
                        int n = Cstart + ArowIndices[i];
                        Cvals[n] = Cvals[n] + Avals[i] * Bval;
                    }
                }
            }
            return;
        }
        while (colCounterForB < nB) {
            int Cstart = colCounterForB * mA;
            for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                int indEnd = AcolPtrs[colCounterForA + 1];
                double Bval = Bvals[colCounterForB + nB * colCounterForA] * alpha;
                for (int i = AcolPtrs[colCounterForA]; i < indEnd; ++i) {
                    int n = Cstart + ArowIndices[i];
                    Cvals[n] = Cvals[n] + Avals[i] * Bval;
                }
            }
            ++colCounterForB;
        }
    }

    public void gemv(double alpha, Matrix A, Vector x, double beta, DenseVector y) {
        Predef$.MODULE$.require(A.numCols() == x.size(), (Function0 & Serializable)() -> "The columns of A don't match the number of elements of x. A: " + A.numCols() + ", x: " + x.size());
        Predef$.MODULE$.require(A.numRows() == y.size(), (Function0 & Serializable)() -> "The rows of A don't match the number of elements of y. A: " + A.numRows() + ", y:" + y.size());
        if (alpha == 0.0 && beta == 1.0) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "gemv: alpha is equal to 0 and beta is equal to 1. Returning y.");
            return;
        }
        if (alpha == 0.0) {
            this.scal(beta, y);
            return;
        }
        Tuple2 tuple2 = new Tuple2((Object)A, (Object)x);
        if (tuple2 != null) {
            Matrix smA = (Matrix)tuple2._1();
            Vector dvx = (Vector)tuple2._2();
            if (smA instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)smA;
                if (dvx instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)dvx;
                    this.gemv(alpha, sparseMatrix, denseVector, beta, y);
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Matrix smA = (Matrix)tuple2._1();
            Vector svx = (Vector)tuple2._2();
            if (smA instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)smA;
                if (svx instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)svx;
                    this.gemv(alpha, sparseMatrix, sparseVector, beta, y);
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Matrix dmA = (Matrix)tuple2._1();
            Vector dvx = (Vector)tuple2._2();
            if (dmA instanceof DenseMatrix) {
                DenseMatrix denseMatrix = (DenseMatrix)dmA;
                if (dvx instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)dvx;
                    this.gemv(alpha, denseMatrix, denseVector, beta, y);
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Matrix dmA = (Matrix)tuple2._1();
            Vector svx = (Vector)tuple2._2();
            if (dmA instanceof DenseMatrix) {
                DenseMatrix denseMatrix = (DenseMatrix)dmA;
                if (svx instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)svx;
                    this.gemv(alpha, denseMatrix, sparseVector, beta, y);
                    return;
                }
            }
        }
        throw new IllegalArgumentException("gemv doesn't support running on matrix type " + A.getClass() + " and vector type " + x.getClass() + ".");
    }

    private void gemv(double alpha, DenseMatrix A, DenseVector x, double beta, DenseVector y) {
        String tStrA = A.isTransposed() ? "T" : "N";
        int mA = !A.isTransposed() ? A.numRows() : A.numCols();
        int nA = !A.isTransposed() ? A.numCols() : A.numRows();
        this.nativeBLAS().dgemv(tStrA, mA, nA, alpha, A.values(), mA, x.values(), 1, beta, y.values(), 1);
    }

    private void gemv(double alpha, DenseMatrix A, SparseVector x, double beta, DenseVector y) {
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] xIndices = x.indices();
        int xNnz = xIndices.length;
        double[] xValues = x.values();
        double[] yValues = y.values();
        if (A.isTransposed()) {
            for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                double sum = 0.0;
                for (int k = 0; k < xNnz; ++k) {
                    sum += xValues[k] * Avals[xIndices[k] + rowCounterForA * nA];
                }
                yValues[rowCounterForA] = sum * alpha + beta * yValues[rowCounterForA];
            }
            return;
        }
        for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
            double sum = 0.0;
            for (int k = 0; k < xNnz; ++k) {
                sum += xValues[k] * Avals[xIndices[k] * mA + rowCounterForA];
            }
            yValues[rowCounterForA] = sum * alpha + beta * yValues[rowCounterForA];
        }
    }

    private void gemv(double alpha, SparseMatrix A, SparseVector x, double beta, DenseVector y) {
        int[] Acols;
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        int xNnz = xIndices.length;
        double[] yValues = y.values();
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] Arows = !A.isTransposed() ? A.rowIndices() : A.colPtrs();
        int[] nArray = Acols = !A.isTransposed() ? A.colPtrs() : A.rowIndices();
        if (A.isTransposed()) {
            for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                int i = Arows[rowCounter];
                int indEnd = Arows[rowCounter + 1];
                double sum = 0.0;
                int k = 0;
                while (i < indEnd && k < xNnz) {
                    if (xIndices[k] == Acols[i]) {
                        sum += Avals[i] * xValues[k];
                        ++k;
                        ++i;
                        continue;
                    }
                    if (xIndices[k] < Acols[i]) {
                        ++k;
                        continue;
                    }
                    ++i;
                }
                yValues[rowCounter] = sum * alpha + beta * yValues[rowCounter];
            }
            return;
        }
        if (beta != 1.0) {
            this.scal(beta, y);
        }
        int k = 0;
        for (int colCounterForA = 0; colCounterForA < nA && k < xNnz; ++colCounterForA) {
            if (xIndices[k] != colCounterForA) continue;
            int indEnd = Acols[colCounterForA + 1];
            double xTemp = xValues[k] * alpha;
            for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                int n = Arows[i];
                yValues[n] = yValues[n] + Avals[i] * xTemp;
            }
            ++k;
        }
    }

    private void gemv(double alpha, SparseMatrix A, DenseVector x, double beta, DenseVector y) {
        int[] Acols;
        double[] xValues = x.values();
        double[] yValues = y.values();
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] Arows = !A.isTransposed() ? A.rowIndices() : A.colPtrs();
        int[] nArray = Acols = !A.isTransposed() ? A.colPtrs() : A.rowIndices();
        if (A.isTransposed()) {
            for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                int indEnd = Arows[rowCounter + 1];
                double sum = 0.0;
                for (int i = Arows[rowCounter]; i < indEnd; ++i) {
                    sum += Avals[i] * xValues[Acols[i]];
                }
                yValues[rowCounter] = beta * yValues[rowCounter] + sum * alpha;
            }
            return;
        }
        if (beta != 1.0) {
            this.scal(beta, y);
        }
        for (int colCounterForA = 0; colCounterForA < nA; ++colCounterForA) {
            int indEnd = Acols[colCounterForA + 1];
            double xVal = xValues[colCounterForA] * alpha;
            for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                int n = Arows[i];
                yValues[n] = yValues[n] + Avals[i] * xVal;
            }
        }
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BLAS$.class);
    }

    private final /* synthetic */ BLAS liftedTree1$1() {
        NativeBLAS nativeBLAS;
        try {
            nativeBLAS = NativeBLAS.getInstance();
        }
        catch (Throwable throwable) {
            nativeBLAS = this.javaBLAS();
        }
        return nativeBLAS;
    }

    private BLAS$() {
    }
}

