/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.test.ChiSqTest;
import org.apache.spark.mllib.stat.test.ChiSqTest$NullHypothesis$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.collection.OpenHashMap;
import org.apache.spark.util.collection.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class ChiSqTest$
implements Logging {
    public static final ChiSqTest$ MODULE$ = new ChiSqTest$();
    private static final ChiSqTest.Method PEARSON;
    private static final int maxCategories;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        PEARSON = new ChiSqTest.Method("pearson", (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(observed, expected) -> {
            double dev = observed - expected;
            return dev * dev / expected;
        });
        maxCategories = 10000;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ChiSqTest.Method PEARSON() {
        return PEARSON;
    }

    private ChiSqTest.Method methodFromString(String methodName) {
        String string = methodName;
        String string2 = this.PEARSON().name();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.PEARSON();
        }
        throw new IllegalArgumentException("Unrecognized method for Chi squared test.");
    }

    public int maxCategories() {
        return maxCategories;
    }

    public ChiSqTestResult[] chiSquaredFeatures(RDD<LabeledPoint> data, String methodName) {
        return (ChiSqTestResult[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.computeChiSquared((RDD<Tuple2<Object, Vector>>)data.map((Function1 & Serializable)l -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)l.label()), (Object)l.features()), ClassTag$.MODULE$.apply(Tuple2.class)), methodName).collect()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ChiSqTest$.$anonfun$chiSquaredFeatures$2(x$1)), (Ordering)Ordering.Int$.MODULE$)), (Function1 & Serializable)x0$1 -> {
            Tuple5 tuple5 = x0$1;
            if (tuple5 != null) {
                double pValue = BoxesRunTime.unboxToDouble((Object)tuple5._2());
                int degreesOfFreedom = BoxesRunTime.unboxToInt((Object)tuple5._3());
                double statistic = BoxesRunTime.unboxToDouble((Object)tuple5._4());
                String nullHypothesis = (String)tuple5._5();
                return new ChiSqTestResult(pValue, degreesOfFreedom, statistic, methodName, nullHypothesis);
            }
            throw new MatchError((Object)tuple5);
        }, ClassTag$.MODULE$.apply(ChiSqTestResult.class));
    }

    public RDD<Tuple5<Object, Object, Object, Object, String>> computeChiSquared(RDD<Tuple2<Object, Vector>> data, String methodName) {
        Vector vector = (Vector)((Tuple2)data.first())._2();
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            return this.chiSquaredDenseFeatures(data, denseVector.size(), methodName);
        }
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            return this.chiSquaredSparseFeatures(data, sparseVector.size(), methodName);
        }
        throw new MatchError((Object)vector);
    }

    private RDD<Tuple5<Object, Object, Object, Object, String>> chiSquaredDenseFeatures(RDD<Tuple2<Object, Vector>> data, int numFeatures, String methodName) {
        return RDD$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double label = tuple2._1$mcD$sp();
                Vector features = (Vector)tuple2._2();
                Predef$.MODULE$.require(features.size() == numFeatures, (Function0 & Serializable)() -> "Number of features must be " + numFeatures + " but got " + features.size());
                return features.iterator().map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int col = tuple2._1$mcI$sp();
                        double value = tuple2._2$mcD$sp();
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), (Object)new Tuple2.mcDD.sp(label, value));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Long()), (Function2 & Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
            if (tuple2 != null) {
                OpenHashMap counts = (OpenHashMap)tuple2._1();
                Tuple2 t = (Tuple2)tuple2._2();
                counts.changeValue$mcJ$sp((Object)t, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, (Function1)(JFunction1.mcJJ.sp & Serializable)x$2 -> x$2 + 1L);
                return counts;
            }
            throw new MatchError((Object)tuple2);
        }, (Function2 & Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$2);
            if (tuple2 != null) {
                OpenHashMap counts1 = (OpenHashMap)tuple2._1();
                OpenHashMap counts2 = (OpenHashMap)tuple2._2();
                counts2.foreach((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToLong((long)ChiSqTest$.$anonfun$chiSquaredDenseFeatures$8(counts1, x0$5)));
                return counts1;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(OpenHashMap.class)).map((Function1 & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                int col = tuple2._1$mcI$sp();
                OpenHashMap counts = (OpenHashMap)tuple2._2();
                ChiSqTestResult result = MODULE$.computeChiSq((Map<Tuple2<Object, Object>, Object>)counts.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), methodName, col);
                return new Tuple5((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToDouble((double)result.pValue()), (Object)BoxesRunTime.boxToInteger((int)result.degreesOfFreedom()), (Object)BoxesRunTime.boxToDouble((double)result.statistic()), (Object)result.nullHypothesis());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple5.class));
    }

    private RDD<Tuple5<Object, Object, Object, Object, String>> chiSquaredSparseFeatures(RDD<Tuple2<Object, Vector>> data, int numFeatures, String methodName) {
        Map labelCounts = data.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4._1$mcD$sp()), (ClassTag)ClassTag$.MODULE$.Double()).countByValue((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        long numInstances = BoxesRunTime.unboxToLong((Object)labelCounts.valuesIterator().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        int numLabels = labelCounts.size();
        if (numLabels > this.maxCategories()) {
            throw new SparkException("Chi-square test expect factors (categorical values) but found more than " + this.maxCategories() + " distinct label values.");
        }
        int numParts = data.getNumPartitions();
        return RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitionsWithIndex((Function2 & Serializable)(x0$1, x1$1) -> ChiSqTest$.$anonfun$chiSquaredSparseFeatures$2(numFeatures, numParts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), data.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Long()), (Function2 & Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$2);
            if (tuple2 != null) {
                OpenHashMap counts = (OpenHashMap)tuple2._1();
                Tuple2 labelAndValue = (Tuple2)tuple2._2();
                Object object = labelAndValue != null ? BoxesRunTime.boxToLong((long)counts.changeValue$mcJ$sp((Object)labelAndValue, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, (Function1)(JFunction1.mcJJ.sp & Serializable)x$5 -> x$5 + 1L)) : BoxedUnit.UNIT;
                return counts;
            }
            throw new MatchError((Object)tuple2);
        }, (Function2 & Serializable)(x0$5, x1$3) -> {
            Tuple2 tuple2 = new Tuple2(x0$5, x1$3);
            if (tuple2 != null) {
                OpenHashMap counts1 = (OpenHashMap)tuple2._1();
                OpenHashMap counts2 = (OpenHashMap)tuple2._2();
                counts2.foreach((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToLong((long)ChiSqTest$.$anonfun$chiSquaredSparseFeatures$12(counts1, x0$6)));
                return counts1;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(OpenHashMap.class)).map((Function1 & Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 != null) {
                int col = tuple2._1$mcI$sp();
                OpenHashMap counts = (OpenHashMap)tuple2._2();
                long nnz = BoxesRunTime.unboxToLong((Object)counts.iterator().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                Predef$.MODULE$.require(numInstances >= nnz);
                if (numInstances > nnz) {
                    Map labelNNZ = (Map)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])counts.iterator().map((Function1 & Serializable)x0$8 -> {
                        Tuple2 tuple2 = x0$8;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            long c = tuple2._2$mcJ$sp();
                            if (tuple22 != null) {
                                double label = tuple22._1$mcD$sp();
                                return new Tuple2.mcDJ.sp(label, c);
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }).toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8._1$mcD$sp())).transform((Function2 & Serializable)(x$9, v) -> BoxesRunTime.boxToLong((long)ChiSqTest$.$anonfun$chiSquaredSparseFeatures$19(BoxesRunTime.unboxToDouble((Object)x$9), v)));
                    labelCounts.foreach((Function1 & Serializable)x0$9 -> {
                        ChiSqTest$.$anonfun$chiSquaredSparseFeatures$21(labelNNZ, counts, x0$9);
                        return BoxedUnit.UNIT;
                    });
                }
                ChiSqTestResult result = MODULE$.computeChiSq((Map<Tuple2<Object, Object>, Object>)counts.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), methodName, col);
                return new Tuple5((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToDouble((double)result.pValue()), (Object)BoxesRunTime.boxToInteger((int)result.degreesOfFreedom()), (Object)BoxesRunTime.boxToDouble((double)result.statistic()), (Object)result.nullHypothesis());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple5.class));
    }

    private ChiSqTestResult computeChiSq(Map<Tuple2<Object, Object>, Object> counts, String methodName, int col) {
        Map label2Index = Utils$.MODULE$.toMapWithIndex((Iterable)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.doubleArrayOps((double[])counts.iterator().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToDouble((double)ChiSqTest$.$anonfun$computeChiSq$1(x$11))).toArray((ClassTag)ClassTag$.MODULE$.Double())))), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        int numLabels = label2Index.size();
        if (numLabels > this.maxCategories()) {
            throw new SparkException("Chi-square test expect factors (categorical values) but found more than " + this.maxCategories() + " distinct label values.");
        }
        Map value2Index = Utils$.MODULE$.toMapWithIndex((Iterable)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.doubleArrayOps((double[])counts.iterator().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToDouble((double)ChiSqTest$.$anonfun$computeChiSq$2(x$12))).toArray((ClassTag)ClassTag$.MODULE$.Double())))), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        int numValues = value2Index.size();
        if (numValues > this.maxCategories()) {
            throw new SparkException("Chi-square test expect factors (categorical values) but found more than " + this.maxCategories() + " distinct values in column " + col + ".");
        }
        DenseMatrix contingency = new DenseMatrix(numValues, numLabels, (double[])Array$.MODULE$.ofDim(numValues * numLabels, (ClassTag)ClassTag$.MODULE$.Double()));
        counts.foreach((Function1 & Serializable)x0$1 -> {
            ChiSqTest$.$anonfun$computeChiSq$3(value2Index, label2Index, contingency, x0$1);
            return BoxedUnit.UNIT;
        });
        return this.chiSquaredMatrix(contingency, methodName);
    }

    public String computeChiSquared$default$2() {
        return this.PEARSON().name();
    }

    public ChiSqTestResult chiSquared(Vector observed, Vector expected, String methodName) {
        ChiSqTestResult chiSqTestResult;
        Object object = new Object();
        try {
            double[] expArr;
            ChiSqTest.Method method = this.methodFromString(methodName);
            if (expected.size() != 0 && observed.size() != expected.size()) {
                throw new IllegalArgumentException("observed and expected must be of the same size.");
            }
            int size = observed.size();
            if (size > 1000) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Chi-squared approximation may not be accurate due to low expected "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"frequencies as a result of a large number of categories: "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_CATEGORIES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)size))})))));
            }
            double[] obsArr = observed.toArray();
            double[] dArray = expArr = expected.size() == 0 ? (double[])Array$.MODULE$.tabulate(size, (Function1)(JFunction1.mcDI.sp & Serializable)x$13 -> 1.0 / (double)size, (ClassTag)ClassTag$.MODULE$.Double()) : expected.toArray();
            if (!ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(obsArr), (Function1)(JFunction1.mcZD.sp & Serializable)x$14 -> x$14 >= 0.0)) {
                throw new IllegalArgumentException("Negative entries disallowed in the observed vector.");
            }
            if (expected.size() != 0 && !ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(expArr), (Function1)(JFunction1.mcZD.sp & Serializable)x$15 -> x$15 >= 0.0)) {
                throw new IllegalArgumentException("Negative entries disallowed in the expected vector.");
            }
            double obsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(obsArr).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double expSum = (double)expected.size() == 0.0 ? 1.0 : BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(expArr).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double scale = scala.math.package$.MODULE$.abs(obsSum - expSum) < 1.0E-7 ? 1.0 : obsSum / expSum;
            double statistic = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(obsArr), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(expArr))), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToDouble((double)ChiSqTest$.$anonfun$chiSquared$5(object, size, scale, method, BoxesRunTime.unboxToDouble((Object)x0$1), x1$1))));
            int df = size - 1;
            double pValue = 1.0 - new ChiSquaredDistribution((double)df).cumulativeProbability(statistic);
            chiSqTestResult = new ChiSqTestResult(pValue, df, statistic, this.PEARSON().name(), ChiSqTest$NullHypothesis$.MODULE$.goodnessOfFit().toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                chiSqTestResult = (ChiSqTestResult)ex.value();
            }
            throw ex;
        }
        return chiSqTestResult;
    }

    public String chiSquaredFeatures$default$2() {
        return this.PEARSON().name();
    }

    private String chiSquaredDenseFeatures$default$3() {
        return this.PEARSON().name();
    }

    private String chiSquaredSparseFeatures$default$3() {
        return this.PEARSON().name();
    }

    public Vector chiSquared$default$2() {
        return Vectors$.MODULE$.dense(Array$.MODULE$.emptyDoubleArray());
    }

    public String chiSquared$default$3() {
        return this.PEARSON().name();
    }

    public ChiSqTestResult chiSquaredMatrix(Matrix counts, String methodName) {
        ChiSqTest.Method method = this.methodFromString(methodName);
        int numRows = counts.numRows();
        int numCols = counts.numCols();
        double[] colSums = new double[numCols];
        double[] rowSums = new double[numRows];
        double[] colMajorArr = counts.toArray();
        int colMajorArrLen = colMajorArr.length;
        for (int i = 0; i < colMajorArrLen; ++i) {
            double elem = colMajorArr[i];
            if (elem < 0.0) {
                throw new IllegalArgumentException("Contingency table cannot contain negative entries.");
            }
            int n = i / numRows;
            colSums[n] = colSums[n] + elem;
            int n2 = i % numRows;
            rowSums[n2] = rowSums[n2] + elem;
        }
        double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(colSums).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double statistic = 0.0;
        for (int j = 0; j < colMajorArrLen; ++j) {
            int col = j / numRows;
            double colSum = colSums[col];
            if (colSum == 0.0) {
                throw new IllegalArgumentException("Chi-squared statistic undefined for input matrix due to0 sum in column [" + col + "].");
            }
            int row = j % numRows;
            double rowSum = rowSums[row];
            if (rowSum == 0.0) {
                throw new IllegalArgumentException("Chi-squared statistic undefined for input matrix due to0 sum in row [" + row + "].");
            }
            double expected = colSum * rowSum / total;
            statistic += method.chiSqFunc().apply$mcDDD$sp(colMajorArr[j], expected);
        }
        int df = (numCols - 1) * (numRows - 1);
        if (df == 0) {
            return new ChiSqTestResult(1.0, 0, 0.0, methodName, ChiSqTest$NullHypothesis$.MODULE$.independence().toString());
        }
        double pValue = 1.0 - new ChiSquaredDistribution((double)df).cumulativeProbability(statistic);
        return new ChiSqTestResult(pValue, df, statistic, methodName, ChiSqTest$NullHypothesis$.MODULE$.independence().toString());
    }

    public String chiSquaredMatrix$default$2() {
        return this.PEARSON().name();
    }

    public static final /* synthetic */ int $anonfun$chiSquaredFeatures$2(Tuple5 x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1._1());
    }

    public static final /* synthetic */ long $anonfun$chiSquaredDenseFeatures$8(OpenHashMap counts1$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            Tuple2 t = (Tuple2)tuple2._1();
            long c = tuple2._2$mcJ$sp();
            return counts1$1.changeValue$mcJ$sp((Object)t, (Function0)(JFunction0.mcJ.sp & Serializable)() -> c, (Function1)(JFunction1.mcJJ.sp & Serializable)x$3 -> x$3 + c);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$chiSquaredSparseFeatures$7(int col) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), null);
    }

    public static final /* synthetic */ Iterator $anonfun$chiSquaredSparseFeatures$2(int numFeatures$2, int numParts$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int pid = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            return iter.flatMap((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    double label = tuple2._1$mcD$sp();
                    Vector features = (Vector)tuple2._2();
                    Predef$.MODULE$.require(features.size() == numFeatures$2, (Function0 & Serializable)() -> "Number of features must be " + numFeatures$2 + " but got " + features.size());
                    return features.nonZeroIterator().map((Function1 & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            int col = tuple2._1$mcI$sp();
                            double value = tuple2._2$mcD$sp();
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), (Object)new Tuple2.mcDD.sp(label, value));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            }).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().range(pid, numFeatures$2, numParts$1).map((Function1 & Serializable)col -> ChiSqTest$.$anonfun$chiSquaredSparseFeatures$7(BoxesRunTime.unboxToInt((Object)col))));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$chiSquaredSparseFeatures$12(OpenHashMap counts1$2, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            Tuple2 t = (Tuple2)tuple2._1();
            long c = tuple2._2$mcJ$sp();
            return counts1$2.changeValue$mcJ$sp((Object)t, (Function0)(JFunction0.mcJ.sp & Serializable)() -> c, (Function1)(JFunction1.mcJJ.sp & Serializable)x$6 -> x$6 + c);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$chiSquaredSparseFeatures$19(double x$9, Tuple2[] v) {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])v), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10._2$mcJ$sp()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$chiSquaredSparseFeatures$21(Map labelNNZ$1, OpenHashMap counts$1, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            long nnzByLabel;
            double label = tuple2._1$mcD$sp();
            long countByLabel = tuple2._2$mcJ$sp();
            long nzByLabel = countByLabel - (nnzByLabel = BoxesRunTime.unboxToLong((Object)labelNNZ$1.getOrElse((Object)BoxesRunTime.boxToDouble((double)label), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
            if (nzByLabel > 0L) {
                counts$1.update$mcJ$sp((Object)new Tuple2.mcDD.sp(label, 0.0), nzByLabel);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$computeChiSq$1(Tuple2 x$11) {
        return ((Tuple2)x$11._1())._1$mcD$sp();
    }

    public static final /* synthetic */ double $anonfun$computeChiSq$2(Tuple2 x$12) {
        return ((Tuple2)x$12._1())._2$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$computeChiSq$3(Map value2Index$1, Map label2Index$1, DenseMatrix contingency$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            long c = tuple2._2$mcJ$sp();
            if (tuple22 != null) {
                double label = tuple22._1$mcD$sp();
                double value = tuple22._2$mcD$sp();
                int i = BoxesRunTime.unboxToInt((Object)value2Index$1.apply((Object)BoxesRunTime.boxToDouble((double)value)));
                int j = BoxesRunTime.unboxToInt((Object)label2Index$1.apply((Object)BoxesRunTime.boxToDouble((double)label)));
                contingency$1.update(i, j, c);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$chiSquared$5(Object nonLocalReturnKey1$1, int size$1, double scale$1, ChiSqTest.Method method$1, double x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            double stat = tuple2._1$mcD$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                double obs = tuple22._1$mcD$sp();
                double exp = tuple22._2$mcD$sp();
                if (exp == 0.0) {
                    if (obs == 0.0) {
                        throw new IllegalArgumentException("Chi-squared statistic undefined for input vectors due to 0.0 values in both observed and expected.");
                    }
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new ChiSqTestResult(0.0, size$1 - 1, Double.POSITIVE_INFINITY, MODULE$.PEARSON().name(), ChiSqTest$NullHypothesis$.MODULE$.goodnessOfFit().toString()));
                }
                if (scale$1 == 1.0) {
                    return stat + method$1.chiSqFunc().apply$mcDDD$sp(obs, exp);
                }
                return stat + method$1.chiSqFunc().apply$mcDDD$sp(obs, exp * scale$1);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private ChiSqTest$() {
    }
}

