/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.logging;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public final class EventHelpers$ {
    public static final EventHelpers$ MODULE$ = new EventHelpers$();
    private static final String timestampFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSXX";
    private static final ZoneId zoneId = ZoneId.of("UTC");
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(MODULE$.timestampFormat()).withZone(MODULE$.zoneId());

    private String timestampFormat() {
        return timestampFormat;
    }

    private ZoneId zoneId() {
        return zoneId;
    }

    private DateTimeFormatter formatter() {
        return formatter;
    }

    public String formatTimestamp(Timestamp ts) {
        Instant instant = Instant.ofEpochMilli(ts.getTime());
        return this.formatter().format(instant);
    }

    public Timestamp parseTimestamp(String timeString) {
        if (timeString.isEmpty()) {
            return new Timestamp(0L);
        }
        Instant instant = Instant.from(this.formatter().parse(timeString));
        return new Timestamp(instant.toEpochMilli());
    }

    private EventHelpers$() {
    }
}

